/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.qstar;

import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TreeSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.qstar.QStarUtils;
import org.dcm4che3.qstar.WSFileExtentInfo;
import org.dcm4che3.qstar.WSGetFileInfoResponse;
import org.dcm4che3.qstar.WSUserLoginResponse;
import org.dcm4che3.qstar.WSWebServiceSoapPort;
import org.dcm4che3.tool.common.CLIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QStar {
    private static final Logger LOG = LoggerFactory.getLogger(QStar.class);
    private static final ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.qstar.messages");
    private final WSWebServiceSoapPort port;
    private WSUserLoginResponse userLogin;

    private QStar(String url) {
        this.port = QStarUtils.getWSWebServiceSoapPort((String)url);
    }

    public static void main(String[] args) {
        block26: {
            try {
                CommandLine cl = QStar.parseComandLine(args);
                String[] user = cl.getOptionValues("u");
                if (user == null) {
                    throw new MissingOptionException(rb.getString("missing-user-opt"));
                }
                String url = cl.getOptionValue("U");
                if (url == null) {
                    throw new MissingOptionException(rb.getString("missing-url-opt"));
                }
                QStar qstar = new QStar(url);
                List fileList = cl.getArgList();
                if (!qstar.login(user[0], user[1])) break block26;
                if (cl.hasOption("r")) {
                    BigInteger jobId;
                    if (cl.hasOption("s")) {
                        TreeSet<FilePosition> filePositions = new TreeSet<FilePosition>();
                        for (String filePath : fileList) {
                            filePositions.add(new FilePosition(filePath, qstar.getFileInfo(filePath)));
                        }
                        fileList.clear();
                        for (FilePosition filePosition : filePositions) {
                            fileList.add(filePosition.filePath);
                        }
                    }
                    if ((jobId = qstar.batchFileRetrieve(((Number)cl.getParsedOptionValue("r")).longValue(), fileList, cl.getOptionValue("D", ""))) != null && cl.hasOption("p")) {
                        Number delay = (Number)cl.getParsedOptionValue("p");
                        while (!fileList.isEmpty()) {
                            Iterator iterator = fileList.iterator();
                            block9: while (iterator.hasNext()) {
                                if (delay != null) {
                                    Thread.sleep(delay.longValue());
                                }
                                switch (qstar.batchJobObjectStatus(jobId, (String)iterator.next())) {
                                    case 1: 
                                    case 2: {
                                        continue block9;
                                    }
                                }
                                iterator.remove();
                            }
                        }
                        qstar.batchJobStatus(jobId);
                    }
                } else if (cl.hasOption("j")) {
                    BigInteger jobId = BigInteger.valueOf(((Number)cl.getParsedOptionValue("j")).longValue());
                    if (fileList.isEmpty()) {
                        qstar.batchJobStatus(jobId);
                    } else {
                        for (String file : fileList) {
                            qstar.batchJobObjectStatus(jobId, file);
                        }
                    }
                } else if (cl.hasOption("P")) {
                    for (String file : fileList) {
                        qstar.purgeFile(file);
                    }
                } else {
                    for (String file : fileList) {
                        qstar.getFileInfo(file);
                    }
                }
                qstar.logout();
            }
            catch (ParseException e) {
                System.err.println("qstar: " + e.getMessage());
                System.err.println(rb.getString("try"));
                System.exit(2);
            }
            catch (Exception e) {
                System.err.println("qstar: " + e.getMessage());
                e.printStackTrace();
                System.exit(2);
            }
        }
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        CLIUtils.addCommonOptions((Options)opts);
        opts.addOption(Option.builder((String)"u").longOpt("user").numberOfArgs(2).valueSeparator(':').argName("user:password").desc(rb.getString("user")).build());
        opts.addOption(Option.builder((String)"U").longOpt("url").hasArg().argName("url").desc(rb.getString("url")).build());
        OptionGroup group = new OptionGroup();
        group.addOption(Option.builder((String)"r").longOpt("retrieve").hasArg().type(Number.class).argName("priority").desc(rb.getString("retrieve")).build());
        group.addOption(Option.builder((String)"j").longOpt("job").hasArg().type(Number.class).argName("jobId").desc(rb.getString("job")).build());
        group.addOption(Option.builder((String)"P").longOpt("purge").desc(rb.getString("purge")).build());
        opts.addOption(Option.builder((String)"D").longOpt("target-dir").hasArg().argName("path").desc(rb.getString("target-dir")).build());
        opts.addOption(Option.builder((String)"p").longOpt("progress").hasArg().optionalArg(true).type(Number.class).argName("ms").desc(rb.getString("progress")).build());
        opts.addOption(Option.builder((String)"s").longOpt("sort").desc(rb.getString("sort")).build());
        opts.addOptionGroup(group);
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, QStar.class);
    }

    private boolean login(String userName, String userPassword) {
        try {
            this.userLogin = QStarUtils.login((WSWebServiceSoapPort)this.port, (String)userName, (String)userPassword);
            return true;
        }
        catch (Exception e) {
            LOG.info("Login Failed: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    private void logout() {
        try {
            QStarUtils.logout((WSWebServiceSoapPort)this.port, (WSUserLoginResponse)this.userLogin);
        }
        catch (Exception e) {
            LOG.info("Logout Failed: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private WSGetFileInfoResponse getFileInfo(String filePath) {
        try {
            return QStarUtils.getFileInfo((WSWebServiceSoapPort)this.port, (WSUserLoginResponse)this.userLogin, (String)filePath);
        }
        catch (Exception e) {
            LOG.info("GetFileInfo Failed: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private BigInteger batchFileRetrieve(long jobPriority, List<String> fileList, String targetDir) {
        try {
            return QStarUtils.batchFileRetrieve((WSWebServiceSoapPort)this.port, (WSUserLoginResponse)this.userLogin, (long)jobPriority, fileList, (String)targetDir).getJobId();
        }
        catch (Exception e) {
            LOG.info("BatchFileRetrieve Failed: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private int batchJobStatus(BigInteger jobId) {
        try {
            return (int)QStarUtils.batchJobStatus((WSWebServiceSoapPort)this.port, (WSUserLoginResponse)this.userLogin, (BigInteger)jobId).getJobStatus();
        }
        catch (Exception e) {
            LOG.info("BatchJobStatus Failed: {}", (Object)e.getMessage(), (Object)e);
            return 0;
        }
    }

    private int batchJobObjectStatus(BigInteger jobId, String file) {
        try {
            return (int)QStarUtils.batchJobObjectStatus((WSWebServiceSoapPort)this.port, (WSUserLoginResponse)this.userLogin, (BigInteger)jobId, (String)file).getJobObjectStatus();
        }
        catch (Exception e) {
            LOG.info("BatchJobObjectStatus Failed: {}", (Object)e.getMessage(), (Object)e);
            return 0;
        }
    }

    private void purgeFile(String filePath) {
        try {
            QStarUtils.purgeFile((WSWebServiceSoapPort)this.port, (WSUserLoginResponse)this.userLogin, (String)filePath);
        }
        catch (Exception e) {
            LOG.info("GetFileInfo Failed: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private static class FilePosition
    implements Comparable<FilePosition> {
        private final String filePath;
        private long vol;
        private long pos;

        public FilePosition(String filePath, WSGetFileInfoResponse fileInfo) {
            this.filePath = filePath;
            if (fileInfo == null) {
                return;
            }
            List extent = fileInfo.getInfo().getFlocExtents().getExtent();
            if (extent.isEmpty()) {
                return;
            }
            WSFileExtentInfo wsFileExtentInfo = (WSFileExtentInfo)extent.get(0);
            this.vol = wsFileExtentInfo.getVol();
            this.pos = wsFileExtentInfo.getPos();
        }

        @Override
        public int compareTo(FilePosition o) {
            return this.vol < o.vol ? -1 : (this.vol > o.vol ? 1 : (this.pos < o.pos ? -1 : (this.pos > o.pos ? 1 : this.filePath.compareTo(o.filePath))));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilePosition that = (FilePosition)o;
            return this.filePath.equals(that.filePath);
        }

        public int hashCode() {
            return this.filePath.hashCode();
        }
    }
}

