/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.stgcmtscu;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.io.DicomOutputStream;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.AssociationStateException;
import org.dcm4che3.net.Commands;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.net.DimseRQHandler;
import org.dcm4che3.net.DimseRSPHandler;
import org.dcm4che3.net.IncompatibleConnectionException;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.net.pdu.AAssociateRQ;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.service.AbstractDicomService;
import org.dcm4che3.net.service.BasicCEchoSCP;
import org.dcm4che3.net.service.DicomService;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.net.service.DicomServiceRegistry;
import org.dcm4che3.tool.common.CLIUtils;
import org.dcm4che3.tool.common.DicomFiles;
import org.dcm4che3.util.SafeClose;
import org.dcm4che3.util.UIDUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StgCmtSCU {
    private static ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.stgcmtscu.messages");
    private static final Logger LOG = LoggerFactory.getLogger(StgCmtSCU.class);
    private final ApplicationEntity ae;
    private final Connection remote;
    private final AAssociateRQ rq = new AAssociateRQ();
    private Attributes attrs;
    private String uidSuffix;
    private File storageDir;
    private boolean keepAlive;
    private int splitTag;
    private int status;
    private HashMap<String, List<String>> map = new HashMap();
    private Association as;
    private final HashSet<String> outstandingResults = new HashSet(2);
    private final DicomService stgcmtResultHandler = new AbstractDicomService(new String[]{"1.2.840.10008.1.20.1"}){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDimseRQ(Association as, PresentationContext pc, Dimse dimse, Attributes cmd, Attributes data) throws IOException {
            if (dimse != Dimse.N_EVENT_REPORT_RQ) {
                throw new DicomServiceException(529);
            }
            int eventTypeID = cmd.getInt(4098, 0);
            if (eventTypeID != 1 && eventTypeID != 2) {
                throw new DicomServiceException(275).setEventTypeID(eventTypeID);
            }
            String tuid = data.getString(528789);
            try {
                Attributes rsp = Commands.mkNEventReportRSP((Attributes)cmd, (int)StgCmtSCU.this.status);
                Attributes rspAttrs = StgCmtSCU.this.eventRecord(as, cmd, data);
                as.writeDimseRSP(pc, rsp, rspAttrs);
            }
            catch (AssociationStateException e) {
                LOG.warn("{} << N-EVENT-RECORD-RSP failed: {}", (Object)as, (Object)e.getMessage());
            }
            finally {
                StgCmtSCU.this.removeOutstandingResult(tuid);
            }
        }
    };

    public StgCmtSCU(ApplicationEntity ae) throws IOException {
        this.remote = new Connection();
        this.ae = ae;
        DicomServiceRegistry serviceRegistry = new DicomServiceRegistry();
        serviceRegistry.addDicomService((DicomService)new BasicCEchoSCP());
        serviceRegistry.addDicomService(this.stgcmtResultHandler);
        ae.setDimseRQHandler((DimseRQHandler)serviceRegistry);
    }

    public Connection getRemoteConnection() {
        return this.remote;
    }

    public AAssociateRQ getAAssociateRQ() {
        return this.rq;
    }

    public void setStorageDirectory(File storageDir) {
        if (storageDir != null) {
            storageDir.mkdirs();
        }
        this.storageDir = storageDir;
    }

    public File getStorageDirectory() {
        return this.storageDir;
    }

    public final void setUIDSuffix(String uidSuffix) {
        this.uidSuffix = uidSuffix;
    }

    public void setAttributes(Attributes attrs) {
        this.attrs = attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            CommandLine cl = StgCmtSCU.parseComandLine(args);
            Device device = new Device("stgcmtscu");
            Connection conn = new Connection();
            device.addConnection(conn);
            ApplicationEntity ae = new ApplicationEntity("STGCMTSCU");
            device.addApplicationEntity(ae);
            ae.addConnection(conn);
            final StgCmtSCU stgcmtscu = new StgCmtSCU(ae);
            CLIUtils.configureConnect((Connection)stgcmtscu.remote, (AAssociateRQ)stgcmtscu.rq, (CommandLine)cl);
            CLIUtils.configureBind((Connection)conn, (ApplicationEntity)stgcmtscu.ae, (CommandLine)cl);
            CLIUtils.configure((Connection)conn, (CommandLine)cl);
            stgcmtscu.remote.setTlsProtocols(conn.getTlsProtocols());
            stgcmtscu.remote.setTlsCipherSuites(conn.getTlsCipherSuites());
            stgcmtscu.setTransferSyntaxes(CLIUtils.transferSyntaxesOf((CommandLine)cl));
            stgcmtscu.setStatus(CLIUtils.getIntOption((CommandLine)cl, (String)"status", (int)0));
            stgcmtscu.setSplitTag(StgCmtSCU.getSplitTag(cl));
            stgcmtscu.setKeepAlive(cl.hasOption("keep-alive"));
            stgcmtscu.setStorageDirectory(StgCmtSCU.getStorageDirectory(cl));
            stgcmtscu.setAttributes(new Attributes());
            CLIUtils.addAttributes((Attributes)stgcmtscu.attrs, (String[])cl.getOptionValues("s"));
            stgcmtscu.setUIDSuffix(cl.getOptionValue("uid-suffix"));
            List argList = cl.getArgList();
            boolean echo = argList.isEmpty();
            if (!echo) {
                LOG.info(rb.getString("scanning"));
                DicomFiles.scan((List)argList, (DicomFiles.Callback)new DicomFiles.Callback(){

                    public boolean dicomFile(File f, Attributes fmi, long dsPos, Attributes ds) {
                        return stgcmtscu.addInstance(ds);
                    }
                });
            }
            ExecutorService executorService = Executors.newCachedThreadPool();
            ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
            device.setExecutor((Executor)executorService);
            device.setScheduledExecutor(scheduledExecutorService);
            device.bindConnections();
            try {
                stgcmtscu.open();
                if (echo) {
                    stgcmtscu.echo();
                } else {
                    stgcmtscu.sendRequests();
                }
            }
            finally {
                stgcmtscu.close();
                if (conn.isListening()) {
                    device.waitForNoOpenConnections();
                    device.unbindConnections();
                }
                executorService.shutdown();
                scheduledExecutorService.shutdown();
            }
        }
        catch (ParseException e) {
            System.err.println("stgcmtscu: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("stgcmtscu: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    public static File getStorageDirectory(CommandLine cl) {
        return cl.hasOption("ignore") ? null : new File(cl.getOptionValue("directory", "."));
    }

    public static int getSplitTag(CommandLine cl) {
        return cl.hasOption("one-per-study") ? 0x20000D : (cl.hasOption("one-per-series") ? 0x20000E : 0);
    }

    public void setSplitTag(int splitTag) {
        this.splitTag = splitTag;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setTransferSyntaxes(String[] tss) {
        this.rq.addPresentationContext(new PresentationContext(1, "1.2.840.10008.1.1", new String[]{"1.2.840.10008.1.2"}));
        this.rq.addPresentationContext(new PresentationContext(2, "1.2.840.10008.1.20.1", tss));
        this.ae.addTransferCapability(new TransferCapability(null, "1.2.840.10008.1.1", TransferCapability.Role.SCP, new String[]{"1.2.840.10008.1.2"}));
        this.ae.addTransferCapability(new TransferCapability(null, "1.2.840.10008.1.20.1", TransferCapability.Role.SCU, tss));
    }

    public boolean addInstance(Attributes inst) {
        String splitkey;
        CLIUtils.updateAttributes((Attributes)inst, (Attributes)this.attrs, (String)this.uidSuffix);
        String cuid = inst.getString(524310);
        String iuid = inst.getString(524312);
        String string = splitkey = this.splitTag != 0 ? inst.getString(this.splitTag) : "";
        if (cuid == null || iuid == null || splitkey == null) {
            return false;
        }
        List<String> refSOPs = this.map.get(splitkey);
        if (refSOPs == null) {
            refSOPs = new ArrayList<String>();
            this.map.put(splitkey, refSOPs);
        }
        refSOPs.add(cuid);
        refSOPs.add(iuid);
        return true;
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        CLIUtils.addTransferSyntaxOptions((Options)opts);
        CLIUtils.addConnectOption((Options)opts);
        CLIUtils.addBindOption((Options)opts, (String)"STGCMTSCU");
        CLIUtils.addRequestTimeoutOption((Options)opts);
        CLIUtils.addAEOptions((Options)opts);
        CLIUtils.addSendTimeoutOption((Options)opts);
        CLIUtils.addResponseTimeoutOption((Options)opts);
        CLIUtils.addCommonOptions((Options)opts);
        StgCmtSCU.addStgCmtOptions(opts);
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, StgCmtSCU.class);
    }

    public static void addStgCmtOptions(Options opts) {
        opts.addOption(null, "ignore", false, rb.getString("ignore"));
        opts.addOption(Option.builder().hasArg().argName("path").desc(rb.getString("directory")).longOpt("directory").build());
        opts.addOption(Option.builder().hasArg().argName("code").desc(rb.getString("status")).longOpt("status").build());
        opts.addOption(null, "keep-alive", false, rb.getString("keep-alive"));
        opts.addOption(null, "one-per-study", false, rb.getString("one-per-study"));
        opts.addOption(null, "one-per-series", false, rb.getString("one-per-series"));
        opts.addOption(Option.builder((String)"s").hasArgs().argName("[seq.]attr=value").desc(rb.getString("set")).build());
        opts.addOption(Option.builder().hasArg().argName("suffix").desc(rb.getString("uid-suffix")).longOpt("uid-suffix").build());
    }

    public void open() throws IOException, InterruptedException, IncompatibleConnectionException, GeneralSecurityException {
        this.as = this.ae.connect(this.remote, this.rq);
    }

    public void echo() throws IOException, InterruptedException {
        this.as.cecho().next();
    }

    public void close() throws IOException, InterruptedException {
        if (this.as != null) {
            if (this.as.isReadyForDataTransfer()) {
                this.as.waitForOutstandingRSP();
                if (this.keepAlive) {
                    this.waitForOutstandingResults();
                }
                this.as.release();
            }
            this.as.waitForSocketClose();
        }
        this.waitForOutstandingResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOutstandingResult(String tuid) {
        HashSet<String> hashSet = this.outstandingResults;
        synchronized (hashSet) {
            this.outstandingResults.add(tuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOutstandingResult(String tuid) {
        HashSet<String> hashSet = this.outstandingResults;
        synchronized (hashSet) {
            this.outstandingResults.remove(tuid);
            this.outstandingResults.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForOutstandingResults() throws InterruptedException {
        HashSet<String> hashSet = this.outstandingResults;
        synchronized (hashSet) {
            while (!this.outstandingResults.isEmpty()) {
                System.out.println(MessageFormat.format(rb.getString("wait-for-results"), this.outstandingResults.size()));
                this.outstandingResults.wait();
            }
        }
    }

    public Attributes makeActionInfo(List<String> refSOPs) {
        Attributes actionInfo = new Attributes(2);
        actionInfo.setString(528789, VR.UI, UIDUtils.createUID());
        int n = refSOPs.size() / 2;
        Sequence refSOPSeq = actionInfo.newSequence(528793, n);
        int i = 0;
        for (int j = 0; j < n; ++j) {
            Attributes refSOP = new Attributes(2);
            refSOP.setString(528720, VR.UI, refSOPs.get(i++));
            refSOP.setString(528725, VR.UI, refSOPs.get(i++));
            refSOPSeq.add(refSOP);
        }
        return actionInfo;
    }

    public void sendRequests() throws IOException, InterruptedException {
        for (List<String> refSOPs : this.map.values()) {
            this.sendRequest(this.makeActionInfo(refSOPs));
        }
    }

    private void sendRequest(Attributes actionInfo) throws IOException, InterruptedException {
        final String tuid = actionInfo.getString(528789);
        DimseRSPHandler rspHandler = new DimseRSPHandler(this.as.nextMessageID()){

            public void onDimseRSP(Association as, Attributes cmd, Attributes data) {
                if (cmd.getInt(2304, -1) != 0) {
                    StgCmtSCU.this.removeOutstandingResult(tuid);
                }
                super.onDimseRSP(as, cmd, data);
            }
        };
        this.as.naction("1.2.840.10008.1.20.1", "1.2.840.10008.1.20.1.1", 1, actionInfo, null, rspHandler);
        this.addOutstandingResult(tuid);
    }

    private Attributes eventRecord(Association as, Attributes cmd, Attributes eventInfo) throws DicomServiceException {
        if (this.storageDir == null) {
            return null;
        }
        String cuid = cmd.getString(2);
        String iuid = cmd.getString(4096);
        String tuid = eventInfo.getString(528789);
        File file = new File(this.storageDir, tuid);
        DicomOutputStream out = null;
        LOG.info("{}: M-WRITE {}", (Object)as, (Object)file);
        try {
            out = new DicomOutputStream(file);
            out.writeDataset(Attributes.createFileMetaInformation((String)iuid, (String)cuid, (String)"1.2.840.10008.1.2.1"), eventInfo);
        }
        catch (IOException e) {
            try {
                LOG.warn(as + ": Failed to store Storage Commitment Result:", (Throwable)e);
                throw new DicomServiceException(272, (Throwable)e);
            }
            catch (Throwable throwable) {
                SafeClose.close(out);
                throw throwable;
            }
        }
        SafeClose.close((Closeable)out);
        return null;
    }
}

