/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.stowrs;

import jakarta.json.Json;
import jakarta.json.stream.JsonGenerator;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.BulkData;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.VR;
import org.dcm4che3.imageio.codec.XPEGParser;
import org.dcm4che3.imageio.codec.jpeg.JPEGParser;
import org.dcm4che3.imageio.codec.mp4.MP4Parser;
import org.dcm4che3.imageio.codec.mpeg.MPEG2Parser;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.io.DicomOutputStream;
import org.dcm4che3.io.SAXReader;
import org.dcm4che3.io.SAXTransformer;
import org.dcm4che3.json.JSONWriter;
import org.dcm4che3.tool.common.CLIUtils;
import org.dcm4che3.util.Base64;
import org.dcm4che3.util.StreamUtils;
import org.dcm4che3.util.UIDUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StowRS {
    private static final Logger LOG = LoggerFactory.getLogger(StowRS.class);
    private static final ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.stowrs.messages");
    private static String url;
    private boolean noApp;
    private boolean pixelHeader;
    private static boolean vlPhotographicImage;
    private static boolean videoPhotographicImage;
    private static String requestAccept;
    private static String requestContentType;
    private static String metadataFilePathStr;
    private static File metadataFile;
    private static boolean allowAnyHost;
    private static boolean disableTM;
    private static boolean encapsulatedDocLength;
    private static String authorization;
    private boolean tsuid;
    private final Attributes attrs = new Attributes();
    private String uidSuffix;
    private String tmpPrefix;
    private String tmpSuffix;
    private File tmpDir;
    private final List<StowChunk> stowChunks = new ArrayList<StowChunk>();
    private static int limit;
    private int filesScanned;
    private int filesSent;
    private long totalSize;
    private Map<String, String> requestProperties;
    private static final String boundary = "myboundary";
    private static final AtomicInteger fileCount;
    private static FileContentType fileContentTypeFromCL;
    private static FileContentType firstBulkdataFileContentType;
    private static FileContentType bulkdataFileContentType;
    private static final Map<String, StowRSBulkdata> contentLocBulkdata;
    private static final int[] IUIDS_TAGS;
    private static final int[] TYPE2_TAGS;
    private static final ElementDictionary DICT;

    private static CommandLine parseCommandLine(String[] args) throws ParseException {
        Options opts = new Options();
        opts.addOption(Option.builder((String)"s").numberOfArgs(2).argName("[seq.]attr=value").desc(rb.getString("set")).build());
        opts.addOption(Option.builder((String)"f").hasArg().argName("file").longOpt("file").desc(rb.getString("file")).build());
        opts.addOption(Option.builder().hasArg().argName("contentType").longOpt("contentType").desc(rb.getString("contentType")).build());
        opts.addOption(Option.builder().hasArg().argName("url").longOpt("url").desc(rb.getString("url")).build());
        opts.addOption(Option.builder((String)"t").hasArg().argName("type").longOpt("type").desc(rb.getString("type")).build());
        opts.addOption(Option.builder().argName("tsuid").longOpt("tsuid").desc(rb.getString("tsuid")).build());
        opts.addOption(Option.builder().longOpt("pixel-header").desc(rb.getString("pixel-header")).build());
        opts.addOption(Option.builder().longOpt("no-app").desc(rb.getString("no-app")).build());
        opts.addOption(Option.builder().longOpt("xc").desc(rb.getString("xc")).build());
        opts.addOption(Option.builder().longOpt("video").desc(rb.getString("video")).build());
        opts.addOption(Option.builder((String)"a").longOpt("accept").hasArg().desc(rb.getString("accept")).build());
        opts.addOption(Option.builder().longOpt("allowAnyHost").desc(rb.getString("allowAnyHost")).build());
        opts.addOption(Option.builder().longOpt("disableTM").desc(rb.getString("disableTM")).build());
        opts.addOption(Option.builder().longOpt("encapsulatedDocLength").desc(rb.getString("encapsulatedDocLength")).build());
        opts.addOption(Option.builder((String)"l").longOpt("limit").hasArg().desc(rb.getString("limit")).build());
        opts.addOption(Option.builder((String)"H").hasArg().argName("httpHeader:value").desc(rb.getString("httpHeader")).build());
        opts.addOption(Option.builder().hasArg().argName("suffix").desc(rb.getString("uid-suffix")).longOpt("uid-suffix").build());
        OptionGroup group = new OptionGroup();
        group.addOption(Option.builder((String)"u").hasArg().argName("user:password").longOpt("user").desc(rb.getString("user")).build());
        group.addOption(Option.builder().hasArg().argName("bearer").longOpt("bearer").desc(rb.getString("bearer")).build());
        opts.addOptionGroup(group);
        StowRS.addTmpFileOptions(opts);
        CLIUtils.addCommonOptions((Options)opts);
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, StowRS.class);
    }

    public static void addTmpFileOptions(Options opts) {
        opts.addOption(Option.builder().hasArg().argName("directory").desc(rb.getString("tmp-file-dir")).longOpt("tmp-file-dir").build());
        opts.addOption(Option.builder().hasArg().argName("prefix").desc(rb.getString("tmp-file-prefix")).longOpt("tmp-file-prefix").build());
        opts.addOption(Option.builder().hasArg().argName("suffix").desc(rb.getString("tmp-file-suffix")).longOpt("tmp-file-suffix").build());
    }

    public final void setRequestProperties(Map<String, String> requestProperties) {
        this.requestProperties = requestProperties;
    }

    public final void setTmpFilePrefix(String prefix) {
        this.tmpPrefix = prefix;
    }

    public final void setTmpFileSuffix(String suffix) {
        this.tmpSuffix = suffix;
    }

    public final void setTmpFileDirectory(File tmpDir) {
        this.tmpDir = tmpDir;
    }

    public static void main(String[] args) {
        try {
            CommandLine cl = StowRS.parseCommandLine(args);
            List files = cl.getArgList();
            StowRS stowRS = new StowRS();
            stowRS.doNecessaryChecks(cl, files);
            stowRS.scan(files);
            long t1 = System.currentTimeMillis();
            if (url.startsWith("https")) {
                for (StowChunk stowChunk : stowRS.stowChunks) {
                    HttpsURLConnection connection = stowRS.openTLS();
                    long stowChunkStart = System.currentTimeMillis();
                    stowRS.stowHttps(connection, stowChunk);
                    StowRS.logSentPerChunk(stowChunk, stowChunkStart);
                }
            } else {
                for (StowChunk stowChunk : stowRS.stowChunks) {
                    HttpURLConnection connection = stowRS.open();
                    long stowChunkStart = System.currentTimeMillis();
                    stowRS.stow(connection, stowChunk);
                    StowRS.logSentPerChunk(stowChunk, stowChunkStart);
                }
            }
            StowRS.logSent(stowRS, t1);
        }
        catch (ParseException e) {
            System.err.println("stowrs: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("stowrs: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    private static void logSentPerChunk(StowChunk stowChunk, long t1) {
        if (stowChunk.sent == 0) {
            return;
        }
        long t2 = System.currentTimeMillis();
        float s = (float)(t2 - t1) / 1000.0f;
        float mb = (float)stowChunk.getSize() / 1048576.0f;
        System.out.println(MessageFormat.format(rb.getString(limit == 0 ? "sentNoLimit" : "sent"), stowChunk.sent, Float.valueOf(mb), Float.valueOf(s), Float.valueOf(mb / s)));
    }

    private static void logSent(StowRS stowRS, long t1) {
        if (stowRS.filesSent == 0 || limit == 0) {
            return;
        }
        long t2 = System.currentTimeMillis();
        float s = (float)(t2 - t1) / 1000.0f;
        float mb = (float)stowRS.totalSize / 1048576.0f;
        System.out.println(MessageFormat.format(rb.getString("sentAll"), stowRS.filesSent, Float.valueOf(mb), Float.valueOf(s), Float.valueOf(mb / s)));
    }

    private void scan(List<String> files) {
        System.out.println(rb.getString("scanning"));
        long t1 = System.currentTimeMillis();
        this.scanFiles(files);
        long t2 = System.currentTimeMillis();
        System.out.println("..");
        if (this.filesScanned == 0) {
            return;
        }
        System.out.println(MessageFormat.format(rb.getString("scanned"), this.filesScanned, Float.valueOf((float)(t2 - t1) / 1000.0f), (t2 - t1) / (long)this.filesScanned));
    }

    private void doNecessaryChecks(CommandLine cl, List<String> files) throws Exception {
        if (files.isEmpty() && !cl.hasOption("f")) {
            throw new MissingArgumentException("Neither bulk data / dicom files specified nor metadata file specified for non bulk data type of objects");
        }
        url = cl.getOptionValue("url");
        if (url == null) {
            throw new MissingOptionException("Missing url.");
        }
        if (cl.hasOption("f")) {
            metadataFilePathStr = cl.getOptionValue("f");
            Path metadataFilePath = Paths.get(metadataFilePathStr, new String[0]);
            if (!Files.probeContentType(metadataFilePath).endsWith("xml")) {
                throw new IllegalArgumentException("Metadata file extension not supported. Read -f option in stowrs help");
            }
            metadataFile = metadataFilePath.toFile();
        }
        this.tsuid = cl.hasOption("tsuid");
        this.pixelHeader = cl.hasOption("pixel-header");
        this.noApp = cl.hasOption("no-appn");
        CLIUtils.addAttributes((Attributes)this.attrs, (String[])cl.getOptionValues("s"));
        this.uidSuffix = cl.getOptionValue("uid-suffix");
        authorization = cl.hasOption("u") ? this.basicAuth(cl.getOptionValue("u")) : (cl.hasOption("bearer") ? "Bearer " + cl.getOptionValue("bearer") : null);
        vlPhotographicImage = cl.hasOption("xc");
        videoPhotographicImage = cl.hasOption("video");
        allowAnyHost = cl.hasOption("allowAnyHost");
        disableTM = cl.hasOption("disableTM");
        encapsulatedDocLength = cl.hasOption("encapsulatedDocLength");
        if (cl.hasOption("contentType")) {
            fileContentTypeFromCL = StowRS.fileContentType(cl.getOptionValue("contentType"));
        }
        limit = Integer.parseInt(cl.getOptionValue("limit", "0"));
        this.configureTmpFile(cl);
        this.processFirstFile(cl);
        this.setRequestProperties(this.requestProperties(cl.getOptionValues("H")));
    }

    private void configureTmpFile(CommandLine cl) {
        if (cl.hasOption("tmp-file-dir")) {
            this.setTmpFileDirectory(new File(cl.getOptionValue("tmp-file-dir")));
        }
        this.setTmpFilePrefix(cl.getOptionValue("tmp-file-prefix", "stowrs-"));
        this.setTmpFileSuffix(cl.getOptionValue("tmp-file-suffix"));
    }

    private void processFirstFile(CommandLine cl) throws Exception {
        if (cl.getArgList().isEmpty()) {
            StowRS.setRequestContentAndAcceptTypes(cl, false);
            return;
        }
        if (fileContentTypeFromCL == null) {
            this.applyFunctionToFile((String)cl.getArgList().get(0), false, path -> {
                String contentType = Files.probeContentType(path);
                StowRS.setRequestContentAndAcceptTypes(cl, contentType != null && contentType.equals("application/dicom"));
                if (contentType == null || !contentType.equals("application/dicom")) {
                    firstBulkdataFileContentType = bulkdataFileContentType = FileContentType.valueOf(contentType, path);
                }
            });
        } else {
            LOG.info("Ignoring checking of content type of first file");
            firstBulkdataFileContentType = bulkdataFileContentType = fileContentTypeFromCL;
            StowRS.setRequestContentAndAcceptTypes(cl, false);
        }
    }

    private static FileContentType fileContentType(String s) {
        switch (s.toLowerCase(Locale.ENGLISH)) {
            case "stl": 
            case "model/stl": {
                return FileContentType.STL;
            }
            case "model/x.stl-binary": {
                return FileContentType.STL_BINARY;
            }
            case "application/sla": {
                return FileContentType.SLA;
            }
            case "pdf": 
            case "application/pdf": {
                return FileContentType.PDF;
            }
            case "xml": 
            case "application/xml": {
                return FileContentType.CDA;
            }
            case "mtl": 
            case "model/mtl": {
                return FileContentType.MTL;
            }
            case "obj": 
            case "model/obj": {
                return FileContentType.OBJ;
            }
            case "genozip": 
            case "application/vnd.genozip": {
                return FileContentType.GENOZIP;
            }
            case "vcf.bz2": 
            case "vcfbzip2": 
            case "vcfbz2": 
            case "application/prs.vcfbzip2": {
                return FileContentType.VCF_BZIP2;
            }
            case "boz": 
            case "bz2": 
            case "application/x-bzip2": {
                return FileContentType.DOC_BZIP2;
            }
            case "jhc": 
            case "image/jphc": {
                return FileContentType.JPHC;
            }
            case "jph": 
            case "image/jph": {
                return FileContentType.JPH;
            }
            case "jpg": 
            case "jpeg": 
            case "image/jpeg": {
                return FileContentType.JPEG;
            }
            case "j2c": 
            case "j2k": 
            case "image/j2c": {
                return FileContentType.J2C;
            }
            case "jp2": 
            case "image/jp2": {
                return FileContentType.JP2;
            }
            case "png": 
            case "image/png": {
                return FileContentType.PNG;
            }
            case "gif": 
            case "image/gif": {
                return FileContentType.GIF;
            }
            case "mpeg": 
            case "video/mpeg": {
                return FileContentType.MPEG;
            }
            case "mp4": 
            case "video/mp4": {
                return FileContentType.MP4;
            }
            case "mov": 
            case "video/quicktime": {
                return FileContentType.QUICKTIME;
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(rb.getString("bulkdata-file-not-supported"), s));
    }

    private static void setRequestContentAndAcceptTypes(CommandLine cl, boolean dicom) {
        if (dicom) {
            requestContentType = "application/dicom";
            requestAccept = cl.hasOption("a") ? StowRS.getOptionValue("a", cl) : "application/dicom+xml";
            return;
        }
        requestContentType = cl.hasOption("t") ? StowRS.getOptionValue("t", cl) : "application/dicom+xml";
        requestAccept = cl.hasOption("a") ? StowRS.getOptionValue("a", cl) : requestContentType;
    }

    private static String getOptionValue(String option, CommandLine cl) {
        String optionValue = cl.getOptionValue(option);
        if (optionValue.equalsIgnoreCase("xml") || optionValue.equalsIgnoreCase("json")) {
            return "application/dicom+" + optionValue;
        }
        throw new IllegalArgumentException("Unsupported type. Read -" + option + " option in stowrs help");
    }

    private Attributes createMetadata(Attributes staticMetadata) {
        Attributes metadata = new Attributes(staticMetadata);
        StowRS.supplementMissingUID(metadata, 524312);
        StowRS.supplementType2Tags(metadata);
        return metadata;
    }

    private Attributes supplementMetadataFromFile(Path bulkdataFilePath, Attributes metadata) {
        LOG.info(MessageFormat.format(rb.getString("supplement-metadata-from-file"), bulkdataFilePath));
        String contentLoc = "bulk" + UIDUtils.createUID();
        metadata.setValue(bulkdataFileContentType.getBulkdataTypeTag(), VR.OB, (Object)new BulkData(null, contentLoc, false));
        StowRSBulkdata stowRSBulkdata = new StowRSBulkdata(bulkdataFilePath);
        switch (bulkdataFileContentType) {
            case SLA: 
            case STL: 
            case STL_BINARY: 
            case OBJ: {
                StowRS.supplementMissingUID(metadata, 0x200052);
            }
            case PDF: 
            case CDA: 
            case MTL: 
            case GENOZIP: 
            case VCF_BZIP2: 
            case DOC_BZIP2: {
                StowRS.supplementEncapsulatedDocAttrs(metadata, stowRSBulkdata);
                contentLocBulkdata.put(contentLoc, stowRSBulkdata);
                break;
            }
            case JPH: 
            case JPHC: 
            case JPEG: 
            case JP2: 
            case J2C: 
            case PNG: 
            case GIF: 
            case MPEG: 
            case MP4: 
            case QUICKTIME: {
                this.pixelMetadata(contentLoc, stowRSBulkdata, metadata);
            }
        }
        return metadata;
    }

    private void pixelMetadata(String contentLoc, StowRSBulkdata stowRSBulkdata, Attributes metadata) {
        File bulkdataFile = stowRSBulkdata.getBulkdataFile();
        if (this.pixelHeader || this.tsuid || this.noApp) {
            CompressedPixelData compressedPixelData = CompressedPixelData.valueOf();
            try (FileInputStream fis = new FileInputStream(bulkdataFile);){
                compressedPixelData.parse(fis.getChannel());
                XPEGParser parser = compressedPixelData.getParser();
                if (this.pixelHeader) {
                    parser.getAttributes(metadata);
                }
                stowRSBulkdata.setParser(parser);
            }
            catch (IOException e) {
                LOG.info("Exception caught getting pixel data from file {}: {}", (Object)bulkdataFile, (Object)e.getMessage());
            }
        }
        contentLocBulkdata.put(contentLoc, stowRSBulkdata);
    }

    private Attributes createStaticMetadata() throws Exception {
        LOG.info("Creating static metadata. Set defaults, if essential attributes are not present.");
        Attributes metadata = SAXReader.parse((InputStream)StreamUtils.openFileOrURL((String)firstBulkdataFileContentType.getSampleMetadataResourceURL()));
        StowRS.addAttributesFromFile(metadata);
        StowRS.supplementSOPClass(metadata, firstBulkdataFileContentType.getSOPClassUID());
        metadata.addAll(this.attrs);
        if (!url.endsWith("studies")) {
            metadata.setString(0x20000D, VR.UI, url.substring(url.lastIndexOf("/") + 1));
        }
        StowRS.supplementMissingUIDs(metadata);
        return metadata;
    }

    private static void addAttributesFromFile(Attributes metadata) throws Exception {
        if (metadataFilePathStr == null) {
            return;
        }
        metadata.addAll(SAXReader.parse((String)metadataFilePathStr, (Attributes)metadata));
    }

    private static void supplementMissingUIDs(Attributes metadata) {
        for (int tag : IUIDS_TAGS) {
            if (metadata.containsValue(tag)) continue;
            metadata.setString(tag, VR.UI, UIDUtils.createUID());
        }
    }

    private static void supplementMissingUID(Attributes metadata, int tag) {
        if (!metadata.containsValue(tag)) {
            metadata.setString(tag, VR.UI, UIDUtils.createUID());
        }
    }

    private static void supplementSOPClass(Attributes metadata, String value) {
        if (!metadata.containsValue(524310)) {
            metadata.setString(524310, VR.UI, value);
        }
    }

    private static void supplementType2Tags(Attributes metadata) {
        for (int tag : TYPE2_TAGS) {
            if (metadata.contains(tag)) continue;
            metadata.setNull(tag, DICT.vrOf(tag));
        }
    }

    private static void supplementEncapsulatedDocAttrs(Attributes metadata, StowRSBulkdata stowRSBulkdata) {
        if (!metadata.contains(524330)) {
            metadata.setNull(524330, VR.DT);
        }
        if (encapsulatedDocLength) {
            metadata.setLong(4325397, VR.UL, new long[]{stowRSBulkdata.getFileLength()});
        }
    }

    private void scanFiles(List<String> files) {
        if (limit == 0) {
            this.scanFilesNoLimit(files);
            return;
        }
        AtomicInteger counter = new AtomicInteger();
        files.stream().collect(Collectors.groupingBy(it -> counter.getAndIncrement() / limit)).values().forEach(fPR -> {
            ArrayList<String> filePaths = new ArrayList<String>();
            for (String f : fPR) {
                try {
                    Path path = Paths.get(f, new String[0]);
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        List<String> dirPaths = Files.list(path).map(Path::toString).collect(Collectors.toList());
                        System.out.println(MessageFormat.format(rb.getString("directory-files"), f, dirPaths.size()));
                        this.scanFiles(dirPaths);
                        continue;
                    }
                    filePaths.add(f);
                }
                catch (Exception e) {
                    LOG.info("Failed to list files of directory : {}\n", (Object)f, (Object)e);
                }
            }
            this.processFilesPerRequest(filePaths.equals(fPR) ? fPR : filePaths);
        });
    }

    private void scanFilesNoLimit(List<String> files) {
        try {
            File tmpFile = File.createTempFile("stowrs-", null, null);
            tmpFile.deleteOnExit();
            StowChunk stowChunk = new StowChunk(tmpFile);
            try (FileOutputStream out = new FileOutputStream(tmpFile);){
                if (requestContentType.equals("application/dicom")) {
                    for (String file : files) {
                        this.applyFunctionToFile(file, true, path -> this.writeDicomFile(out, (Path)path, stowChunk));
                    }
                } else {
                    this.writeMetadataAndBulkData(out, files, this.createStaticMetadata(), stowChunk);
                }
            }
            this.stowChunks.add(stowChunk);
        }
        catch (Exception e) {
            LOG.info("Failed to scan files in tmp file\n", (Throwable)e);
        }
    }

    private void processFilesPerRequest(List<String> fPR) {
        if (fPR.isEmpty()) {
            return;
        }
        try {
            File tmpFile = File.createTempFile(this.tmpPrefix, this.tmpSuffix, this.tmpDir);
            tmpFile.deleteOnExit();
            StowChunk stowChunk = new StowChunk(tmpFile);
            try (FileOutputStream out = new FileOutputStream(tmpFile);){
                if (requestContentType.equals("application/dicom")) {
                    fPR.forEach(f -> {
                        try {
                            this.applyFunctionToFile((String)f, true, path -> this.writeDicomFile(out, (Path)path, stowChunk));
                        }
                        catch (Exception e) {
                            LOG.info("Failed to scan : {}\n", f, (Object)e);
                        }
                    });
                } else {
                    this.writeMetadataAndBulkData(out, fPR, this.createStaticMetadata(), stowChunk);
                }
            }
            this.filesScanned += stowChunk.getScanned().get();
            this.stowChunks.add(stowChunk);
        }
        catch (Exception e) {
            LOG.info("Failed to scan {} in tmp file\n", fPR, (Object)e);
        }
    }

    private Map<String, String> requestProperties(String[] httpHeaders) {
        HashMap<String, String> requestProperties = new HashMap<String, String>();
        requestProperties.put("Content-Type", "multipart/related; type=\"" + requestContentType + "\"; boundary=" + boundary);
        requestProperties.put("Accept", requestAccept);
        requestProperties.put("Connection", "keep-alive");
        if (authorization != null) {
            requestProperties.put("Authorization", authorization);
        }
        if (httpHeaders != null) {
            for (String httpHeader : httpHeaders) {
                int delim = httpHeader.indexOf(58);
                requestProperties.put(httpHeader.substring(0, delim), httpHeader.substring(delim + 1));
            }
        }
        return requestProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stow(HttpURLConnection connection, StowChunk stowChunk) throws Exception {
        File tmpFile = stowChunk.getTmpFile();
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Length", String.valueOf(tmpFile.length()));
        this.requestProperties.forEach(connection::setRequestProperty);
        this.logOutgoing(connection.getURL(), connection.getRequestProperties());
        try (OutputStream out = connection.getOutputStream();){
            StreamUtils.copy((InputStream)new FileInputStream(tmpFile), (OutputStream)out);
            out.write("\r\n--myboundary--\r\n".getBytes());
            out.flush();
            this.logIncoming(connection.getResponseCode(), connection.getResponseMessage(), connection.getHeaderFields(), connection.getInputStream());
            connection.disconnect();
            this.filesSent += stowChunk.sent();
            this.totalSize += stowChunk.getSize();
        }
    }

    private HttpURLConnection open() throws Exception {
        long t1 = System.currentTimeMillis();
        URLConnection urlConnection = new URL(url).openConnection();
        HttpURLConnection connection = (HttpURLConnection)urlConnection;
        long t2 = System.currentTimeMillis();
        System.out.println("..");
        System.out.println(MessageFormat.format(rb.getString("connected"), url, t2 - t1));
        return connection;
    }

    private HttpsURLConnection openTLS() throws Exception {
        long t1 = System.currentTimeMillis();
        HttpsURLConnection connection = (HttpsURLConnection)new URL(url).openConnection();
        long t2 = System.currentTimeMillis();
        System.out.println("..");
        System.out.println(MessageFormat.format(rb.getString("connected"), url, t2 - t1));
        return connection;
    }

    private void stowHttps(HttpsURLConnection connection, StowChunk stowChunk) throws Exception {
        File tmpFile = stowChunk.getTmpFile();
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestMethod("POST");
        if (disableTM) {
            connection.setSSLSocketFactory(this.sslContext().getSocketFactory());
        }
        connection.setRequestProperty("Content-Length", String.valueOf(tmpFile.length()));
        this.requestProperties.forEach(connection::setRequestProperty);
        connection.setHostnameVerifier((hostname, session) -> allowAnyHost);
        this.logOutgoing(connection.getURL(), connection.getRequestProperties());
        try (OutputStream out = connection.getOutputStream();){
            StreamUtils.copy((InputStream)new FileInputStream(tmpFile), (OutputStream)out);
            out.write("\r\n--myboundary--\r\n".getBytes());
            out.flush();
            this.logIncoming(connection.getResponseCode(), connection.getResponseMessage(), connection.getHeaderFields(), connection.getInputStream());
            connection.disconnect();
            this.filesSent += stowChunk.sent();
            this.totalSize += stowChunk.getSize();
        }
    }

    SSLContext sslContext() throws GeneralSecurityException {
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(null, this.trustManagers(), new SecureRandom());
        return ctx;
    }

    TrustManager[] trustManagers() {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
    }

    private String basicAuth(String user) {
        byte[] userPswdBytes = user.getBytes();
        int len = userPswdBytes.length * 4 / 3 + 3 & 0xFFFFFFFC;
        char[] ch = new char[len];
        Base64.encode((byte[])userPswdBytes, (int)0, (int)userPswdBytes.length, (char[])ch, (int)0);
        return "Basic " + new String(ch);
    }

    private void logOutgoing(URL url, Map<String, List<String>> headerFields) {
        LOG.info("> POST " + url.toString());
        headerFields.forEach((k, v) -> LOG.info("> " + k + " : " + String.join((CharSequence)",", v)));
    }

    private void logIncoming(int respCode, String respMsg, Map<String, List<String>> headerFields, InputStream is) {
        LOG.info("< HTTP/1.1 Response: " + respCode + " " + respMsg);
        for (Map.Entry<String, List<String>> header : headerFields.entrySet()) {
            if (header.getKey() == null) continue;
            LOG.info("< " + header.getKey() + " : " + String.join((CharSequence)";", (Iterable<? extends CharSequence>)header.getValue()));
        }
        LOG.info("< Response Content: ");
        try {
            LOG.debug(StowRS.readFullyAsString(is));
            is.close();
        }
        catch (Exception e) {
            LOG.info("Exception caught on reading response body \n", (Throwable)e);
        }
    }

    private static String readFullyAsString(InputStream inputStream) throws IOException {
        return StowRS.readFully(inputStream).toString("UTF-8");
    }

    private static ByteArrayOutputStream readFully(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            int length;
            byte[] buffer = new byte[16384];
            while ((length = inputStream.read(buffer)) != -1) {
                baos.write(buffer, 0, length);
            }
            ByteArrayOutputStream byteArrayOutputStream = baos;
            return byteArrayOutputStream;
        }
    }

    private void writeDicomFile(OutputStream out, Path path, StowChunk stowChunk) throws IOException {
        if (Files.probeContentType(path) == null) {
            LOG.info(MessageFormat.format(rb.getString("not-dicom-file"), path));
            return;
        }
        StowRS.writePartHeaders(out, requestContentType, null);
        Files.copy(this.updateAttrs(path), out);
        stowChunk.setAttributes(path.toFile().length());
    }

    private Path updateAttrs(Path path) {
        if (this.attrs.isEmpty() && this.uidSuffix == null) {
            return path;
        }
        try {
            DicomInputStream in = new DicomInputStream(path.toFile());
            File tmpFile = File.createTempFile("stowrs-", null, null);
            tmpFile.deleteOnExit();
            Attributes fmi = in.readFileMetaInformation();
            Attributes data = in.readDataset();
            CLIUtils.updateAttributes((Attributes)data, (Attributes)this.attrs, (String)this.uidSuffix);
            String tsuid = in.getTransferSyntax();
            try (DicomOutputStream dos = new DicomOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(tmpFile)), fmi != null ? "1.2.840.10008.1.2.1" : (tsuid != null ? tsuid : "1.2.840.10008.1.2"));){
                dos.writeDataset(fmi, data);
                dos.finish();
                dos.flush();
            }
            return tmpFile.toPath();
        }
        catch (Exception e) {
            LOG.info("Failed to update attributes for file {}\n", (Object)path, (Object)e);
            return path;
        }
    }

    private void writeMetadataAndBulkData(OutputStream out, List<String> files, Attributes staticMetadata, StowChunk stowChunk) throws Exception {
        if (requestContentType.equals("application/dicom+xml")) {
            this.writeXMLMetadataAndBulkdata(out, files, staticMetadata, stowChunk);
        } else {
            try (ByteArrayOutputStream bOut = new ByteArrayOutputStream();){
                try (JsonGenerator gen = Json.createGenerator((OutputStream)bOut);){
                    gen.writeStartArray();
                    if (files.isEmpty()) {
                        new JSONWriter(gen).write(this.createMetadata(staticMetadata));
                        stowChunk.setAttributes(metadataFile.length());
                    }
                    for (String file : files) {
                        this.applyFunctionToFile(file, true, path -> {
                            if (!this.ignoreNonMatchingFileContentTypes((Path)path)) {
                                new JSONWriter(gen).write(this.supplementMetadataFromFile((Path)path, this.createMetadata(staticMetadata)));
                            }
                        });
                    }
                    gen.writeEnd();
                    gen.flush();
                }
                this.writeMetadata(out, bOut);
                for (String contentLocation : contentLocBulkdata.keySet()) {
                    this.writeFile(contentLocation, out, stowChunk);
                }
            }
        }
        contentLocBulkdata.clear();
    }

    private void writeXMLMetadataAndBulkdata(OutputStream out, List<String> files, Attributes staticMetadata, StowChunk stowChunk) throws Exception {
        if (files.isEmpty()) {
            this.writeXMLMetadata(out, staticMetadata);
            stowChunk.setAttributes(metadataFile.length());
        }
        for (String file : files) {
            this.applyFunctionToFile(file, true, path -> this.writeXMLMetadataAndBulkdata(out, staticMetadata, (Path)path, stowChunk));
        }
    }

    private void writeXMLMetadataAndBulkdata(OutputStream out, Attributes staticMetadata, Path bulkdataFilePath, StowChunk stowChunk) {
        try {
            if (this.ignoreNonMatchingFileContentTypes(bulkdataFilePath)) {
                return;
            }
            Attributes metadata = this.supplementMetadataFromFile(bulkdataFilePath, this.createMetadata(staticMetadata));
            try (ByteArrayOutputStream bOut = new ByteArrayOutputStream();){
                SAXTransformer.getSAXWriter((Result)new StreamResult(bOut)).write(metadata);
                this.writeMetadata(out, bOut);
            }
            this.writeFile(((BulkData)metadata.getValue(bulkdataFileContentType.getBulkdataTypeTag())).getURI(), out, stowChunk);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean ignoreNonMatchingFileContentTypes(Path path) throws IOException {
        if (fileCount.incrementAndGet() > 1) {
            if (fileContentTypeFromCL == null) {
                bulkdataFileContentType = FileContentType.valueOf(Files.probeContentType(path), path);
                if (!firstBulkdataFileContentType.equals((Object)bulkdataFileContentType)) {
                    LOG.info(MessageFormat.format(rb.getString("ignore-non-matching-file-content-type"), new Object[]{path, bulkdataFileContentType, firstBulkdataFileContentType}));
                    return true;
                }
            } else {
                LOG.info("Ignoring checking of content type of subsequent file {}", (Object)path);
            }
        }
        return false;
    }

    private void writeXMLMetadata(OutputStream out, Attributes staticMetadata) {
        Attributes metadata = this.createMetadata(staticMetadata);
        try (ByteArrayOutputStream bOut = new ByteArrayOutputStream();){
            SAXTransformer.getSAXWriter((Result)new StreamResult(bOut)).write(metadata);
            this.writeMetadata(out, bOut);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeMetadata(OutputStream out, ByteArrayOutputStream bOut) throws IOException {
        LOG.info("> Metadata Content Type: " + requestContentType);
        StowRS.writePartHeaders(out, requestContentType, null);
        LOG.debug("Metadata being sent is : " + bOut.toString());
        out.write(bOut.toByteArray());
    }

    private static void writePartHeaders(OutputStream out, String contentType, String contentLocation) throws IOException {
        out.write("\r\n--myboundary\r\n".getBytes());
        out.write(("Content-Type: " + contentType + "\r\n").getBytes());
        if (contentLocation != null) {
            out.write(("Content-Location: " + contentLocation + "\r\n").getBytes());
        }
        out.write("\r\n".getBytes());
    }

    private void writeFile(String contentLocation, OutputStream out, StowChunk stowChunk) throws Exception {
        long positionAfterAPPSegments;
        String bulkdataContentType1 = bulkdataFileContentType.getMediaType();
        StowRSBulkdata stowRSBulkdata = contentLocBulkdata.get(contentLocation);
        XPEGParser parser = stowRSBulkdata.getParser();
        if (bulkdataFileContentType.getBulkdataTypeTag() == 2145386512 && this.tsuid) {
            bulkdataContentType1 = bulkdataContentType1 + "; transfer-syntax=" + parser.getTransferSyntaxUID(false);
        }
        LOG.info("> Bulkdata Content Type: " + bulkdataContentType1);
        StowRS.writePartHeaders(out, bulkdataContentType1, contentLocation);
        int offset = 0;
        int length = (int)stowRSBulkdata.getFileLength();
        long l = positionAfterAPPSegments = parser != null ? parser.getPositionAfterAPPSegments() : -1L;
        if (this.noApp && positionAfterAPPSegments != -1L) {
            offset = (int)positionAfterAPPSegments;
            out.write(-1);
            out.write(-40);
        }
        out.write(Files.readAllBytes(stowRSBulkdata.getBulkdataFilePath()), offset, length -= offset);
        stowChunk.setAttributes(stowRSBulkdata.bulkdataFile.length());
    }

    private void applyFunctionToFile(String file, boolean continueVisit, StowRSFileFunction<Path> function) throws IOException {
        Path path = Paths.get(file, new String[0]);
        if (Files.isDirectory(path, new LinkOption[0])) {
            Files.walkFileTree(path, new StowRSFileVisitor(function::apply, continueVisit));
        } else {
            function.apply(path);
        }
    }

    static /* synthetic */ boolean access$100() {
        return vlPhotographicImage;
    }

    static /* synthetic */ boolean access$200() {
        return videoPhotographicImage;
    }

    static {
        fileCount = new AtomicInteger();
        contentLocBulkdata = new HashMap<String, StowRSBulkdata>();
        IUIDS_TAGS = new int[]{0x20000D, 0x20000E};
        TYPE2_TAGS = new int[]{524323, 524339};
        DICT = ElementDictionary.getStandardElementDictionary();
    }

    static enum FileContentType {
        PDF("1.2.840.10008.5.1.4.1.1.104.1", 4325393, "application/pdf", "encapsulatedPDFMetadata.xml"),
        CDA("1.2.840.10008.5.1.4.1.1.104.2", 4325393, "text/xml", "encapsulatedCDAMetadata.xml"),
        SLA("1.2.840.10008.5.1.4.1.1.104.3", 4325393, "application/sla", "encapsulatedSTLMetadata.xml"),
        STL("1.2.840.10008.5.1.4.1.1.104.3", 4325393, "model/stl", "encapsulatedSTLMetadata.xml"),
        STL_BINARY("1.2.840.10008.5.1.4.1.1.104.3", 4325393, "model/x.stl-binary", "encapsulatedSTLMetadata.xml"),
        MTL("1.2.840.10008.5.1.4.1.1.104.5", 4325393, "model/mtl", "encapsulatedMTLMetadata.xml"),
        OBJ("1.2.840.10008.5.1.4.1.1.104.4", 4325393, "model/obj", "encapsulatedOBJMetadata.xml"),
        GENOZIP("1.2.40.0.13.1.5.1.4.1.1.104.1", 4325393, "application/vnd.genozip", "encapsulatedGenozipMetadata.xml"),
        VCF_BZIP2("1.2.40.0.13.1.5.1.4.1.1.104.2", 4325393, "application/prs.vcfbzip2", "encapsulatedVCFBzip2Metadata.xml"),
        DOC_BZIP2("1.2.40.0.13.1.5.1.4.1.1.104.3", 4325393, "application/x-bzip2", "encapsulatedDocumentBzip2Metadata.xml"),
        JPHC(StowRS.access$100() ? "1.2.840.10008.5.1.4.1.1.77.1.4" : "1.2.840.10008.5.1.4.1.1.7", 2145386512, "image/jphc", StowRS.access$100() ? "vlPhotographicImageMetadata.xml" : "secondaryCaptureImageMetadata.xml"),
        JPEG(StowRS.access$100() ? "1.2.840.10008.5.1.4.1.1.77.1.4" : "1.2.840.10008.5.1.4.1.1.7", 2145386512, "image/jpeg", StowRS.access$100() ? "vlPhotographicImageMetadata.xml" : "secondaryCaptureImageMetadata.xml"),
        JP2(StowRS.access$100() ? "1.2.840.10008.5.1.4.1.1.77.1.4" : "1.2.840.10008.5.1.4.1.1.7", 2145386512, "image/jp2", StowRS.access$100() ? "vlPhotographicImageMetadata.xml" : "secondaryCaptureImageMetadata.xml"),
        J2C(StowRS.access$100() ? "1.2.840.10008.5.1.4.1.1.77.1.4" : "1.2.840.10008.5.1.4.1.1.7", 2145386512, "image/j2c", StowRS.access$100() ? "vlPhotographicImageMetadata.xml" : "secondaryCaptureImageMetadata.xml"),
        JPH(StowRS.access$100() ? "1.2.840.10008.5.1.4.1.1.77.1.4" : "1.2.840.10008.5.1.4.1.1.7", 2145386512, "image/jph", StowRS.access$100() ? "vlPhotographicImageMetadata.xml" : "secondaryCaptureImageMetadata.xml"),
        PNG(StowRS.access$100() ? "1.2.840.10008.5.1.4.1.1.77.1.4" : "1.2.840.10008.5.1.4.1.1.7", 2145386512, "image/png", StowRS.access$100() ? "vlPhotographicImageMetadata.xml" : "secondaryCaptureImageMetadata.xml"),
        GIF(StowRS.access$200() ? "1.2.840.10008.5.1.4.1.1.77.1.4.1" : (StowRS.access$100() ? "1.2.840.10008.5.1.4.1.1.77.1.4" : "1.2.840.10008.5.1.4.1.1.7"), 2145386512, "image/gif", StowRS.access$100() || StowRS.access$200() ? "vlPhotographicImageMetadata.xml" : "secondaryCaptureImageMetadata.xml"),
        MPEG("1.2.840.10008.5.1.4.1.1.77.1.4.1", 2145386512, "video/mpeg", "vlPhotographicImageMetadata.xml"),
        MP4("1.2.840.10008.5.1.4.1.1.77.1.4.1", 2145386512, "video/mp4", "vlPhotographicImageMetadata.xml"),
        QUICKTIME("1.2.840.10008.5.1.4.1.1.77.1.4.1", 2145386512, "video/quicktime", "vlPhotographicImageMetadata.xml");

        private final String cuid;
        private final int bulkdataTypeTag;
        private final String mediaType;
        private final String sampleMetadataFile;

        public String getSOPClassUID() {
            return this.cuid;
        }

        public String getSampleMetadataResourceURL() {
            return "resource:" + this.sampleMetadataFile;
        }

        public int getBulkdataTypeTag() {
            return this.bulkdataTypeTag;
        }

        public String getMediaType() {
            return this.mediaType;
        }

        private FileContentType(String cuid, int bulkdataTypeTag, String mediaType, String sampleMetadataFile) {
            this.cuid = cuid;
            this.bulkdataTypeTag = bulkdataTypeTag;
            this.sampleMetadataFile = sampleMetadataFile;
            this.mediaType = mediaType;
        }

        static FileContentType valueOf(String contentType, Path path) {
            String fileName = path.toFile().getName();
            String ext = fileName.substring(fileName.lastIndexOf(46) + 1);
            return StowRS.fileContentType(contentType != null ? contentType : ext);
        }
    }

    static class StowChunk {
        private final File tmpFile;
        private final AtomicInteger scanned = new AtomicInteger();
        private int sent;
        private long size;

        StowChunk(File tmpFile) {
            this.tmpFile = tmpFile;
        }

        void setAttributes(long length) {
            this.scanned.getAndIncrement();
            this.size += length;
        }

        AtomicInteger getScanned() {
            return this.scanned;
        }

        File getTmpFile() {
            return this.tmpFile;
        }

        long getSize() {
            return this.size;
        }

        int sent() {
            this.sent = this.scanned.get();
            return this.sent;
        }
    }

    static interface StowRSFileFunction<Path> {
        public void apply(Path var1) throws IOException;
    }

    static class StowRSBulkdata {
        Path bulkdataFilePath;
        File bulkdataFile;
        XPEGParser parser;
        long fileLength;

        StowRSBulkdata(Path bulkdataFilePath) {
            this.bulkdataFilePath = bulkdataFilePath;
            this.bulkdataFile = bulkdataFilePath.toFile();
            this.fileLength = this.bulkdataFile.length();
        }

        Path getBulkdataFilePath() {
            return this.bulkdataFilePath;
        }

        File getBulkdataFile() {
            return this.bulkdataFile;
        }

        long getFileLength() {
            return this.fileLength;
        }

        XPEGParser getParser() {
            return this.parser;
        }

        void setParser(XPEGParser parser) {
            this.parser = parser;
        }
    }

    private static enum CompressedPixelData {
        JPEG{

            @Override
            void parse(SeekableByteChannel channel) throws IOException {
                this.setParser((XPEGParser)new JPEGParser(channel));
            }
        }
        ,
        MPEG{

            @Override
            void parse(SeekableByteChannel channel) throws IOException {
                this.setParser((XPEGParser)new MPEG2Parser(channel));
            }
        }
        ,
        MP4{

            @Override
            void parse(SeekableByteChannel channel) throws IOException {
                this.setParser((XPEGParser)new MP4Parser(channel));
            }
        };

        private XPEGParser parser;

        abstract void parse(SeekableByteChannel var1) throws IOException;

        public XPEGParser getParser() {
            return this.parser;
        }

        void setParser(XPEGParser parser) {
            this.parser = parser;
        }

        static CompressedPixelData valueOf() {
            return bulkdataFileContentType == FileContentType.JP2 || bulkdataFileContentType == FileContentType.J2C || bulkdataFileContentType == FileContentType.JPH || bulkdataFileContentType == FileContentType.JPHC ? JPEG : (bulkdataFileContentType == FileContentType.QUICKTIME ? MP4 : CompressedPixelData.valueOf(bulkdataFileContentType.name()));
        }
    }

    static class StowRSFileVisitor
    extends SimpleFileVisitor<Path> {
        private final StowRSFileConsumer<Path> consumer;
        private final boolean continueVisit;

        StowRSFileVisitor(StowRSFileConsumer<Path> consumer, boolean continueVisit) {
            this.consumer = consumer;
            this.continueVisit = continueVisit;
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
            this.consumer.accept(path);
            return this.continueVisit ? FileVisitResult.CONTINUE : FileVisitResult.TERMINATE;
        }
    }

    static interface StowRSFileConsumer<Path> {
        public void accept(Path var1) throws IOException;
    }
}

