/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.swappxdata;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.BulkData;
import org.dcm4che3.data.VR;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.tool.common.CLIUtils;
import org.dcm4che3.util.AttributesFormat;
import org.dcm4che3.util.ByteUtils;

public class SwapPxData
implements Closeable {
    private static ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.swappxdata.messages");
    private final boolean ifBigEndian;
    private final boolean testAll;
    private final AttributesFormat logPattern;
    private final File logFile;
    private String skipDir;
    private PrintWriter uidslog;
    private char skipChar;
    private int updated;
    private int skipped;
    private int failed;

    public SwapPxData(boolean ifBigEndian, boolean testAll, AttributesFormat logPattern, File logFile) {
        this.ifBigEndian = ifBigEndian;
        this.testAll = testAll;
        this.logPattern = logPattern;
        this.logFile = logFile;
    }

    public static void main(String[] args) {
        try {
            CommandLine cl = SwapPxData.parseComandLine(args);
            List argList = cl.getArgList();
            if (argList.isEmpty()) {
                throw new ParseException(rb.getString("missing"));
            }
            AttributesFormat logPattern = SwapPxData.toAttributesFormat(cl);
            File logFile = new File(cl.getOptionValue("log-file", "uids.log"));
            if (logPattern != null && logFile.exists()) {
                throw new IOException(logFile + " already exists");
            }
            try (SwapPxData inst = new SwapPxData(cl.hasOption("if-big-endian"), cl.hasOption("test-all"), logPattern, logFile);){
                long start = System.currentTimeMillis();
                for (String arg : argList) {
                    inst.processFileOrDirectory(new File(arg));
                }
                long stop = System.currentTimeMillis();
                System.out.println();
                SwapPxData.log(inst.updated, " files updated");
                SwapPxData.log(inst.skipped, " files skipped");
                SwapPxData.log(inst.failed, " files failed to update");
                System.out.println("in " + (stop - start) + " ms");
                if (inst.uidslog != null) {
                    System.out.println("created " + logFile);
                }
            }
        }
        catch (ParseException e) {
            System.err.println("swappxdata: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("swappxdata: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    private static AttributesFormat toAttributesFormat(CommandLine cl) {
        String pattern = cl.hasOption("uids") ? "{00080018}" : cl.getOptionValue("log");
        return pattern != null ? new AttributesFormat(pattern) : null;
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        opts.addOption(null, "if-big-endian", false, rb.getString("if-big-endian"));
        opts.addOption(null, "test-all", false, rb.getString("test-all"));
        opts.addOption(null, "uids", false, rb.getString("uids"));
        opts.addOption(Option.builder().hasArg().argName("pattern").desc(rb.getString("log")).longOpt("log").build());
        opts.addOption(Option.builder().hasArg().argName("path").desc(rb.getString("log-file")).longOpt("log-file").build());
        CLIUtils.addCommonOptions((Options)opts);
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, SwapPxData.class);
    }

    private static void log(int n, String suffix) {
        if (n > 0) {
            System.out.println(n + suffix);
        }
    }

    private void processFileOrDirectory(File fileOrDir) {
        if (fileOrDir.isDirectory()) {
            for (File fileOrSubDir : fileOrDir.listFiles()) {
                this.processFileOrDirectory(fileOrSubDir);
            }
        } else {
            System.out.print(this.processFile(fileOrDir));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private char processFile(File file) {
        if (this.skipDir != null && this.skipDir.equals(file.getParent())) {
            ++this.skipped;
            return this.skipChar;
        }
        try {
            Attributes dataset;
            try (DicomInputStream is = new DicomInputStream(file);){
                is.setIncludeBulkData(DicomInputStream.IncludeBulkData.URI);
                dataset = is.readDataset();
            }
            VR.Holder vr = new VR.Holder();
            Object value = dataset.getValue(2145386512, vr);
            if (value instanceof BulkData && vr.vr == VR.OW) {
                if (this.ifBigEndian && dataset.getInt(2621696, 8) != 16) {
                    ++this.skipped;
                    if (!this.testAll) {
                        this.skipDir = file.getParent();
                    }
                    this.skipChar = '8';
                    return '8';
                }
                try (RandomAccessFile raf = new RandomAccessFile(file, "rw");){
                    if (!this.toggleEndian(raf, (BulkData)value, dataset.getInt(2621697, 16))) {
                        ++this.skipped;
                        if (!this.testAll) {
                            this.skipDir = file.getParent();
                        }
                        this.skipChar = 'l';
                        char c = 'l';
                        return c;
                    }
                }
                if (this.logPattern != null) {
                    this.uidslog().println(this.logPattern.format((Object)dataset));
                }
                ++this.updated;
                return '.';
            }
            ++this.skipped;
            if (value == null) {
                return (char)112;
            }
            if (!(value instanceof BulkData)) return (char)99;
            return (char)98;
        }
        catch (IOException e) {
            System.err.println("Failed to update " + file + ':');
            e.printStackTrace(System.err);
            ++this.failed;
            return 'E';
        }
    }

    private PrintWriter uidslog() throws IOException {
        if (this.uidslog == null) {
            this.uidslog = new PrintWriter(this.logFile);
        }
        return this.uidslog;
    }

    private boolean toggleEndian(RandomAccessFile raf, BulkData bulkData, int bitsStored) throws IOException {
        int mask = (1 << bitsStored) - 1;
        byte[] b = new byte[bulkData.length()];
        raf.seek(bulkData.offset());
        raf.readFully(b);
        if (this.ifBigEndian) {
            int prevBE = ByteUtils.bytesToShortBE((byte[])b, (int)0) & mask;
            int prevLE = ByteUtils.bytesToShortLE((byte[])b, (int)0) & mask;
            long diff = 0L;
            int end = b.length - 1;
            for (int off = 2; off < end; ++off) {
                int valBE = ByteUtils.bytesToShortBE((byte[])b, (int)off) & mask;
                diff += (long)SwapPxData.diff(valBE, prevBE, mask);
                prevBE = valBE;
                int valLE = ByteUtils.bytesToShortLE((byte[])b, (int)off) & mask;
                diff -= (long)SwapPxData.diff(valLE, prevLE, mask);
                prevLE = valLE;
                ++off;
            }
            if (diff > 0L) {
                return false;
            }
        }
        raf.seek(bulkData.offset());
        raf.write(ByteUtils.swapShorts((byte[])b, (int)0, (int)b.length));
        return true;
    }

    private static int diff(int val, int prev, int mask) {
        int diff = Math.abs(val - prev);
        return diff != mask ? diff : 0;
    }

    @Override
    public void close() throws IOException {
        if (this.uidslog != null) {
            this.uidslog.close();
        }
    }
}

