/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.syslogd;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.util.ResourceBundle;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DeviceExtension;
import org.dcm4che3.net.audit.AuditRecordHandler;
import org.dcm4che3.net.audit.AuditRecordRepository;
import org.dcm4che3.tool.common.CLIUtils;
import org.dcm4che3.util.StringUtils;

public class Syslogd {
    private static final ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.syslogd.messages");
    private final Device device = new Device("syslogd");
    private final AuditRecordRepository arr = new AuditRecordRepository();
    private final Connection conn = new Connection();
    private File storageDir;
    private final AuditRecordHandler handler = new AuditRecordHandler(){

        public void onMessage(byte[] data, int xmlOffset, int xmlLength, Connection conn, InetAddress from) {
            Syslogd.this.onMessage(data, xmlOffset, xmlLength, conn, from);
        }
    };

    public Syslogd() {
        this.device.addDeviceExtension((DeviceExtension)this.arr);
        this.device.addConnection(this.conn);
        this.arr.setAuditRecordHandler(this.handler);
    }

    public void setStorageDirectory(String storageDir) {
        this.storageDir = storageDir != null ? new File(storageDir) : null;
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        Syslogd.addOptions(opts);
        CLIUtils.addSocketOptions((Options)opts);
        CLIUtils.addTLSOptions((Options)opts);
        CLIUtils.addCommonOptions((Options)opts);
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, Syslogd.class);
    }

    public static void addOptions(Options opts) {
        opts.addOption(null, "ignore", false, rb.getString("ignore"));
        opts.addOption(Option.builder().hasArg().argName("path").desc(rb.getString("directory")).longOpt("directory").build());
        opts.addOption(Option.builder((String)"b").hasArg().argName("[ip:]port").desc(rb.getString("bind-server")).longOpt("bind").build());
        opts.addOption(Option.builder().hasArg().argName("ms").desc(rb.getString("idle-timeout")).longOpt("idle-timeout").build());
        opts.addOption(null, "udp", false, rb.getString("udp"));
    }

    public static void main(String[] args) {
        try {
            CommandLine cl = Syslogd.parseComandLine(args);
            Syslogd main = new Syslogd();
            Syslogd.configure(main, cl);
            ExecutorService executorService = Executors.newCachedThreadPool();
            ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
            main.device.setScheduledExecutor(scheduledExecutorService);
            main.device.setExecutor((Executor)executorService);
            main.device.bindConnections();
        }
        catch (ParseException e) {
            System.err.println("syslogd: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("syslogd: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    private static void configure(Syslogd main, CommandLine cl) throws Exception, MalformedURLException, ParseException, IOException {
        if (!cl.hasOption("ignore")) {
            main.setStorageDirectory(cl.getOptionValue("directory", "."));
        }
        Syslogd.configureBindServer(main.conn, cl);
        main.setProtocol(Syslogd.toProtocol(cl));
        main.arr.addConnection(main.conn);
        CLIUtils.configure((Connection)main.conn, (CommandLine)cl);
    }

    private void setProtocol(Connection.Protocol protocol) {
        this.conn.setProtocol(protocol);
        this.arr.addConnection(this.conn);
    }

    private static void configureBindServer(Connection conn, CommandLine cl) throws ParseException {
        if (!cl.hasOption("b")) {
            throw new MissingOptionException(CLIUtils.rb.getString("missing-bind-opt"));
        }
        String aeAtHostPort = cl.getOptionValue("b");
        String[] hostAndPort = StringUtils.split((String)aeAtHostPort, (char)':');
        int portIndex = hostAndPort.length - 1;
        conn.setPort(Integer.parseInt(hostAndPort[portIndex]));
        if (portIndex > 0) {
            conn.setHostname(hostAndPort[0]);
        }
    }

    private static Connection.Protocol toProtocol(CommandLine cl) {
        return cl.hasOption("udp") ? Connection.Protocol.SYSLOG_UDP : Connection.Protocol.SYSLOG_TLS;
    }

    private void onMessage(byte[] data, int off, int len, Connection conn, InetAddress from) {
        if (this.storageDir != null) {
            try {
                this.storeToFile(data, off, len, File.createTempFile("syslog", ".xml", this.storageDir));
            }
            catch (IOException e) {
                Connection.LOG.warn("Failed to store received message", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeToFile(byte[] data, int off, int len, File f) throws IOException {
        Connection.LOG.info("M-WRITE {}", (Object)f);
        f.getParentFile().mkdirs();
        try (FileOutputStream out = new FileOutputStream(f);){
            out.write(data, off, len);
        }
    }
}

