/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.upsscu;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Code;
import org.dcm4che3.data.VR;
import org.dcm4che3.io.SAXReader;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.AssociationStateException;
import org.dcm4che3.net.Commands;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.net.DimseRQHandler;
import org.dcm4che3.net.DimseRSPHandler;
import org.dcm4che3.net.IncompatibleConnectionException;
import org.dcm4che3.net.PDVInputStream;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.net.pdu.AAssociateRQ;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.service.AbstractDicomService;
import org.dcm4che3.net.service.BasicCEchoSCP;
import org.dcm4che3.net.service.DicomService;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.net.service.DicomServiceRegistry;
import org.dcm4che3.tool.common.CLIUtils;
import org.dcm4che3.util.DateUtils;
import org.dcm4che3.util.StreamUtils;
import org.dcm4che3.util.TagUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpsSCU {
    private static ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.upsscu.messages");
    private static final Logger LOG = LoggerFactory.getLogger(UpsSCU.class);
    private static final DicomService upsscuNEventRqHandler = new AbstractDicomService(new String[]{"1.2.840.10008.5.1.4.34.6.1"}){

        public void onDimseRQ(Association as, PresentationContext pc, Dimse dimse, Attributes cmd, PDVInputStream data) throws IOException {
            if (dimse != Dimse.N_EVENT_REPORT_RQ) {
                throw new DicomServiceException(529);
            }
            int eventTypeID = cmd.getInt(4098, 0);
            if (eventTypeID == 0 || eventTypeID > 5) {
                throw new DicomServiceException(275).setEventTypeID(eventTypeID);
            }
            try {
                as.writeDimseRSP(pc, Commands.mkNEventReportRSP((Attributes)cmd, (int)status));
            }
            catch (AssociationStateException e) {
                LOG.warn("{} << N-EVENT-RECORD-RSP failed: {}", (Object)as, (Object)e.getMessage());
            }
        }

        protected void onDimseRQ(Association as, PresentationContext pc, Dimse dimse, Attributes cmd, Attributes data) {
            throw new UnsupportedOperationException();
        }
    };
    private RSPHandlerFactory rspHandlerFactory = new RSPHandlerFactory(){

        @Override
        public DimseRSPHandler createDimseRSPHandlerForCFind() {
            return new DimseRSPHandler(UpsSCU.this.as.nextMessageID()){

                public void onDimseRSP(Association as, Attributes cmd, Attributes data) {
                }
            };
        }

        @Override
        public DimseRSPHandler createDimseRSPHandlerForNCreate() {
            return new DimseRSPHandler(UpsSCU.this.as.nextMessageID()){

                public void onDimseRSP(Association as, Attributes cmd, Attributes data) {
                    super.onDimseRSP(as, cmd, data);
                }
            };
        }

        @Override
        public DimseRSPHandler createDimseRSPHandlerForNSet() {
            return new DimseRSPHandler(UpsSCU.this.as.nextMessageID()){

                public void onDimseRSP(Association as, Attributes cmd, Attributes data) {
                    super.onDimseRSP(as, cmd, data);
                }
            };
        }

        @Override
        public DimseRSPHandler createDimseRSPHandlerForNGet() {
            return new DimseRSPHandler(UpsSCU.this.as.nextMessageID()){

                public void onDimseRSP(Association as, Attributes cmd, Attributes data) {
                    super.onDimseRSP(as, cmd, data);
                }
            };
        }

        @Override
        public DimseRSPHandler createDimseRSPHandlerForNAction() {
            return new DimseRSPHandler(UpsSCU.this.as.nextMessageID()){

                public void onDimseRSP(Association as, Attributes cmd, Attributes data) {
                    super.onDimseRSP(as, cmd, data);
                }
            };
        }
    };
    private final ApplicationEntity ae;
    private final Connection remote;
    private final AAssociateRQ rq = new AAssociateRQ();
    private Association as;
    private String xmlFile;
    private String[] keys;
    private int[] tags;
    private static int status;
    private String upsiuid;
    private Operation operation;
    private Attributes requestCancel;
    private Attributes changeState;
    private Attributes subscriptionAction;

    public UpsSCU(ApplicationEntity ae) {
        this.remote = new Connection();
        this.ae = ae;
    }

    public void addVerificationPresentationContext() {
        this.rq.addPresentationContext(new PresentationContext(1, "1.2.840.10008.1.1", new String[]{"1.2.840.10008.1.2"}));
    }

    public final void setUPSIUID(String upsiuid) {
        this.upsiuid = upsiuid;
    }

    public final void setKeys(String[] keys) {
        this.keys = keys;
    }

    public final void setType(Operation operation, String[] tss) {
        this.operation = operation;
        this.rq.addPresentationContext(new PresentationContext(3, operation.negotiatingSOPClassUID, tss));
    }

    public final void setXmlFile(String xmlFile) {
        this.xmlFile = xmlFile;
    }

    public void setTags(int[] tags) {
        this.tags = tags;
    }

    public void setChangeState(Attributes changeState) {
        this.changeState = changeState;
    }

    public void setRequestCancel(Attributes requestCancel) {
        this.requestCancel = requestCancel;
    }

    public void setSubscriptionAction(Attributes subscriptionAction) {
        this.subscriptionAction = subscriptionAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            CommandLine cl = UpsSCU.parseComandLine(args);
            Device device = new Device("upsscu");
            Connection conn = new Connection();
            device.addConnection(conn);
            ApplicationEntity ae = new ApplicationEntity("UPSSCU");
            device.addApplicationEntity(ae);
            ae.addConnection(conn);
            UpsSCU main = new UpsSCU(ae);
            UpsSCU.configureUps(main, cl);
            CLIUtils.configureConnect((Connection)main.remote, (AAssociateRQ)main.rq, (CommandLine)cl);
            CLIUtils.configureBind((Connection)conn, (ApplicationEntity)main.ae, (CommandLine)cl);
            CLIUtils.configure((Connection)conn, (CommandLine)cl);
            main.remote.setTlsProtocols(conn.getTlsProtocols());
            main.remote.setTlsCipherSuites(conn.getTlsCipherSuites());
            main.addVerificationPresentationContext();
            ExecutorService executorService = Executors.newCachedThreadPool();
            ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
            device.setExecutor((Executor)executorService);
            device.setScheduledExecutor(scheduledExecutorService);
            device.bindConnections();
            try {
                main.open();
                main.process();
            }
            finally {
                main.close();
                if (main.operation != Operation.receive) {
                    executorService.shutdown();
                    scheduledExecutorService.shutdown();
                }
            }
        }
        catch (ParseException e) {
            System.err.println("upsscu: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("upsscu: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        CLIUtils.addTransferSyntaxOptions((Options)opts);
        CLIUtils.addConnectOption((Options)opts);
        CLIUtils.addBindOption((Options)opts, (String)"UPSSCU");
        CLIUtils.addAEOptions((Options)opts);
        CLIUtils.addSendTimeoutOption((Options)opts);
        CLIUtils.addResponseTimeoutOption((Options)opts);
        CLIUtils.addCommonOptions((Options)opts);
        UpsSCU.addUPSOptions(opts);
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, UpsSCU.class);
    }

    private static void addUPSOptions(Options opts) {
        OptionGroup changeState = new OptionGroup();
        changeState.addOption(Option.builder((String)"P").hasArg().argName("transaction-uid").longOpt("process").desc(rb.getString("process")).build());
        changeState.addOption(Option.builder((String)"C").hasArg().argName("transaction-uid").longOpt("complete").desc(rb.getString("complete")).build());
        changeState.addOption(Option.builder((String)"D").hasArg().argName("transaction-uid").longOpt("cancel").desc(rb.getString("cancel")).build());
        opts.addOptionGroup(changeState);
        opts.addOption(Option.builder().hasArg().longOpt("contact").argName("name").desc(rb.getString("contact")).build());
        opts.addOption(Option.builder().hasArg().longOpt("contact-uri").argName("uri").desc(rb.getString("contact-uri")).build());
        opts.addOption(Option.builder().longOpt("filtered-global").desc(rb.getString("filtered-global")).build());
        opts.addOption(Option.builder((String)"l").longOpt("lock").desc(rb.getString("lock")).build());
        opts.addOption(Option.builder((String)"m").hasArgs().argName("[seq.]attr=value").desc(rb.getString("match")).build());
        opts.addOption(Option.builder((String)"O").hasArg().longOpt("operation").argName("name").desc(rb.getString("operation")).build());
        opts.addOption(Option.builder((String)"r").hasArgs().argName("attr").desc(rb.getString("return")).build());
        opts.addOption(Option.builder().hasArg().longOpt("reason").argName("reason").desc(rb.getString("reason")).build());
        opts.addOption(Option.builder().hasArg().longOpt("reason-code").argName("code").desc(rb.getString("reason-code")).build());
        opts.addOption(Option.builder().hasArg().longOpt("receiving-ae").argName("aet").desc(rb.getString("receiving-ae")).build());
        opts.addOption(Option.builder((String)"s").hasArgs().argName("[seq.]attr=value").desc(rb.getString("set")).build());
        opts.addOption(Option.builder().hasArg().longOpt("status").argName("code").desc(rb.getString("status")).build());
        OptionGroup serviceClassGroup = new OptionGroup();
        serviceClassGroup.addOption(Option.builder((String)"p").longOpt("pull").desc(rb.getString("pull")).build());
        serviceClassGroup.addOption(Option.builder((String)"w").longOpt("watch").desc(rb.getString("watch")).build());
        opts.addOptionGroup(serviceClassGroup);
        opts.addOption(Option.builder((String)"u").hasArg().longOpt("upsiuid").argName("uid").desc(rb.getString("upsiuid")).build());
    }

    public void open() throws IOException, InterruptedException, IncompatibleConnectionException, GeneralSecurityException {
        this.as = this.ae.connect(this.remote, this.rq);
    }

    public void close() throws IOException, InterruptedException {
        if (this.as != null) {
            this.as.waitForOutstandingRSP();
            this.as.release();
            this.as.waitForSocketClose();
        }
    }

    private static void configureUps(UpsSCU main, CommandLine cl) throws ParseException {
        if (!cl.getArgList().isEmpty()) {
            if (cl.getArgList().size() > 1) {
                throw new IllegalArgumentException(rb.getString("too-many-xml-files"));
            }
            main.setXmlFile((String)cl.getArgList().get(0));
        }
        main.setUPSIUID(cl.getOptionValue("u"));
        main.setKeys(cl.getOptionValues("s"));
        if (cl.hasOption("r")) {
            main.setTags(UpsSCU.toTags(cl.getOptionValues("r")));
        }
        UpsSCU.configureOperation(main, cl);
        if (main.upsiuid == null && main.operation.checkUPSIUID) {
            throw new MissingOptionException(rb.getString("missing-ups-iuid"));
        }
    }

    private static void configureOperation(UpsSCU main, CommandLine cl) throws MissingOptionException {
        Operation operation = Operation.valueOf(cl);
        String[] tss = CLIUtils.transferSyntaxesOf((CommandLine)cl);
        main.setType(operation, tss);
        if (operation == Operation.changeState) {
            UpsSCU.configureChangeState(main, cl);
        }
        if (operation == Operation.requestCancel) {
            UpsSCU.configureRequestCancel(main, cl);
        }
        if (operation == Operation.subscriptionAction) {
            UpsSCU.configureSubscribeUnsubscribe(main, cl);
        }
        if (operation == Operation.receive) {
            UpsSCU.configureReceive(main, tss, cl);
        }
    }

    private static void configureChangeState(UpsSCU main, CommandLine cl) throws MissingOptionException {
        if (cl.hasOption("P")) {
            main.setChangeState(UpsSCU.state(cl.getOptionValue("P"), "IN PROGRESS"));
        } else if (cl.hasOption("C")) {
            main.setChangeState(UpsSCU.state(cl.getOptionValue("C"), "COMPLETED"));
        } else if (cl.hasOption("D")) {
            main.setChangeState(UpsSCU.state(cl.getOptionValue("D"), "CANCELED"));
        } else {
            throw new MissingOptionException(rb.getString("missing-change-state"));
        }
    }

    private static void configureRequestCancel(UpsSCU main, CommandLine cl) {
        Attributes attrs = new Attributes();
        if (cl.hasOption("reason")) {
            attrs.setString(7606840, VR.LT, cl.getOptionValue("reason"));
        }
        if (cl.hasOption("reason-code")) {
            attrs.newSequence(7606286, 1).add(new Code(cl.getOptionValue("reason-code")).toItem());
        }
        if (cl.hasOption("contact-uri")) {
            attrs.setString(7606282, VR.UR, cl.getOptionValue("contact-uri"));
        }
        if (cl.hasOption("contact")) {
            attrs.setString(7606284, VR.LO, cl.getOptionValue("contact"));
        }
        main.setRequestCancel(attrs);
    }

    private static void configureSubscribeUnsubscribe(UpsSCU main, CommandLine cl) throws MissingOptionException {
        Attributes attrs = new Attributes();
        attrs.setString(7606836, VR.AE, cl.hasOption("receiving-ae") ? cl.getOptionValue("receiving-ae") : main.ae.getAETitle());
        if (main.operation.getActionTypeID() == 3) {
            attrs.setString(7606832, VR.LO, cl.hasOption("l") ? "TRUE" : "FALSE");
            if (cl.hasOption("filtered-global")) {
                if (!cl.hasOption("m")) {
                    throw new MissingOptionException(rb.getString("missing-matching-keys"));
                }
                CLIUtils.addAttributes((Attributes)attrs, (String[])cl.getOptionValues("m"));
                main.setUPSIUID("1.2.840.10008.5.1.4.34.5.1");
            }
        }
        if (main.upsiuid == null) {
            main.setUPSIUID("1.2.840.10008.5.1.4.34.5");
        }
        main.setSubscriptionAction(attrs);
    }

    private static void configureReceive(UpsSCU main, String[] tss, CommandLine cl) {
        DicomServiceRegistry serviceRegistry = new DicomServiceRegistry();
        serviceRegistry.addDicomService((DicomService)new BasicCEchoSCP());
        serviceRegistry.addDicomService(upsscuNEventRqHandler);
        main.ae.setDimseRQHandler((DimseRQHandler)serviceRegistry);
        main.ae.addTransferCapability(new TransferCapability(null, "1.2.840.10008.1.1", TransferCapability.Role.SCP, new String[]{"1.2.840.10008.1.2"}));
        main.ae.addTransferCapability(new TransferCapability(null, main.operation.negotiatingSOPClassUID, TransferCapability.Role.SCU, tss));
        status = CLIUtils.getIntOption((CommandLine)cl, (String)"status", (int)0);
    }

    private static int[] toTags(String[] tagsAsStr) {
        int[] tags = new int[tagsAsStr.length];
        for (int i = 0; i < tagsAsStr.length; ++i) {
            tags[i] = TagUtils.forName((String)tagsAsStr[i]);
        }
        return tags;
    }

    public void process() throws Exception {
        switch (this.operation) {
            case create: {
                this.createUps();
                break;
            }
            case update: {
                this.updateUps();
                break;
            }
            case get: {
                this.getUps();
                break;
            }
            case changeState: {
                this.actionOnUps(this.changeState, 1);
                break;
            }
            case requestCancel: {
                this.actionOnUps(this.requestCancel, 2);
                break;
            }
            case subscriptionAction: {
                this.actionOnUps(this.subscriptionAction, this.operation.getActionTypeID());
            }
        }
    }

    private void createUps() throws Exception {
        this.as.ncreate(this.operation.getNegotiatingSOPClassUID(), this.upsiuid, this.ensureSPSStartDateTime(this.workItem(this.xmlFile == null ? "resource:create.xml" : this.xmlFile)), null, this.rspHandlerFactory.createDimseRSPHandlerForNCreate());
        this.as.waitForOutstandingRSP();
    }

    private void updateUps() throws Exception {
        this.as.nset(this.operation.getNegotiatingSOPClassUID(), "1.2.840.10008.5.1.4.34.6.1", this.upsiuid, this.workItem(this.xmlFile == null || this.xmlFile.equals("update") ? null : this.xmlFile), null, this.rspHandlerFactory.createDimseRSPHandlerForNSet());
    }

    private void getUps() throws IOException, InterruptedException {
        this.as.nget(this.operation.getNegotiatingSOPClassUID(), "1.2.840.10008.5.1.4.34.6.1", this.upsiuid, this.tags, this.rspHandlerFactory.createDimseRSPHandlerForNGet());
    }

    private Attributes workItem(String xmlFile) throws Exception {
        Attributes attrs = new Attributes();
        if (xmlFile != null) {
            try (InputStream is = StreamUtils.openFileOrURL((String)xmlFile);){
                SAXReader.parse((InputStream)is, (Attributes)attrs);
            }
        }
        CLIUtils.addAttributes((Attributes)attrs, (String[])this.keys);
        return attrs;
    }

    private Attributes ensureSPSStartDateTime(Attributes ups) {
        if (!ups.containsValue(0x404005)) {
            ups.setString(0x404005, VR.DT, DateUtils.formatDT(null, (Date)new Date()));
        }
        return ups;
    }

    private static Attributes state(String uid, String code) {
        Attributes attrs = new Attributes();
        attrs.setString(528789, VR.UI, uid);
        attrs.setString(7606272, VR.CS, code);
        return attrs;
    }

    private void actionOnUps(Attributes data, int actionTypeId) throws IOException, InterruptedException {
        this.as.naction(this.operation.negotiatingSOPClassUID, "1.2.840.10008.5.1.4.34.6.1", this.upsiuid, actionTypeId, data, null, this.rspHandlerFactory.createDimseRSPHandlerForNAction());
    }

    public static interface RSPHandlerFactory {
        public DimseRSPHandler createDimseRSPHandlerForCFind();

        public DimseRSPHandler createDimseRSPHandlerForNCreate();

        public DimseRSPHandler createDimseRSPHandlerForNSet();

        public DimseRSPHandler createDimseRSPHandlerForNGet();

        public DimseRSPHandler createDimseRSPHandlerForNAction();
    }

    static enum Operation {
        create("1.2.840.10008.5.1.4.34.6.1", false),
        update("1.2.840.10008.5.1.4.34.6.3", true),
        get("1.2.840.10008.5.1.4.34.6.1", true),
        changeState("1.2.840.10008.5.1.4.34.6.3", true),
        requestCancel("1.2.840.10008.5.1.4.34.6.1", true),
        subscriptionAction("1.2.840.10008.5.1.4.34.6.2", false),
        receive("1.2.840.10008.5.1.4.34.6.4", false);

        private String negotiatingSOPClassUID;
        private boolean checkUPSIUID;
        private int actionTypeID;

        private Operation(String negotiatingSOPClassUID, boolean checkUPSIUID) {
            this.negotiatingSOPClassUID = negotiatingSOPClassUID;
            this.checkUPSIUID = checkUPSIUID;
        }

        String getNegotiatingSOPClassUID() {
            return this.negotiatingSOPClassUID;
        }

        Operation setNegotiatingSOPClassUID(String val) {
            this.negotiatingSOPClassUID = val;
            return this;
        }

        int getActionTypeID() {
            return this.actionTypeID;
        }

        Operation setActionTypeID(int val) {
            this.actionTypeID = val;
            return this;
        }

        static Operation valueOf(CommandLine cl) {
            switch (cl.getOptionValue("O")) {
                case "update": {
                    return update;
                }
                case "get": {
                    return cl.hasOption("p") ? get.setNegotiatingSOPClassUID("1.2.840.10008.5.1.4.34.6.3") : (cl.hasOption("w") ? get.setNegotiatingSOPClassUID("1.2.840.10008.5.1.4.34.6.2") : get);
                }
                case "changeState": {
                    return changeState;
                }
                case "requestCancel": {
                    return cl.hasOption("w") ? requestCancel.setNegotiatingSOPClassUID("1.2.840.10008.5.1.4.34.6.2") : requestCancel;
                }
                case "subscribe": {
                    return subscriptionAction.setActionTypeID(3);
                }
                case "unsubscribe": {
                    return subscriptionAction.setActionTypeID(4);
                }
                case "suspendGlobal": {
                    return subscriptionAction.setActionTypeID(5);
                }
                case "receive": {
                    return receive;
                }
            }
            return create;
        }
    }
}

