/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.wadors;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.mime.MultipartInputStream;
import org.dcm4che3.mime.MultipartParser;
import org.dcm4che3.tool.common.CLIUtils;
import org.dcm4che3.util.Base64;
import org.dcm4che3.util.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WadoRS {
    private static final Logger LOG = LoggerFactory.getLogger(WadoRS.class);
    private static final ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.wadors.messages");
    private static boolean header;
    private static boolean allowAnyHost;
    private static boolean disableTM;
    private static String accept;
    private static String outDir;
    private static String authorization;
    private static Map<String, String> requestProperties;

    public static void main(String[] args) {
        try {
            WadoRS wadoRS = new WadoRS();
            CommandLine cl = WadoRS.parseComandLine(args);
            WadoRS.init(cl, wadoRS);
            for (String url : cl.getArgList()) {
                wadoRS.wado(url);
            }
        }
        catch (ParseException e) {
            System.err.println("wadors: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("wadors: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    private void setAccept(String ... accept) {
        StringBuilder sb = new StringBuilder();
        sb.append(!header ? accept[0].replace("+", "%2B") : accept[0]);
        for (int i = 1; i < accept.length; ++i) {
            sb.append(",").append(!header ? accept[i].replace("+", "%2B") : accept[i]);
        }
        WadoRS.accept = sb.toString();
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        CLIUtils.addCommonOptions((Options)opts);
        opts.addOption(Option.builder((String)"a").longOpt("accept").hasArg().desc(rb.getString("accept")).build());
        opts.addOption(Option.builder((String)"H").hasArg().argName("httpHeader:value").desc(rb.getString("httpHeader")).build());
        opts.addOption(Option.builder().longOpt("header").desc(rb.getString("header")).build());
        opts.addOption(Option.builder().longOpt("out-dir").hasArg().argName("directory").desc(rb.getString("out-dir")).build());
        opts.addOption(Option.builder().longOpt("allowAnyHost").desc(rb.getString("allowAnyHost")).build());
        opts.addOption(Option.builder().longOpt("disableTM").desc(rb.getString("disableTM")).build());
        OptionGroup group = new OptionGroup();
        group.addOption(Option.builder((String)"u").hasArg().argName("user:password").longOpt("user").desc(rb.getString("user")).build());
        group.addOption(Option.builder().hasArg().argName("bearer").longOpt("bearer").desc(rb.getString("bearer")).build());
        opts.addOptionGroup(group);
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, WadoRS.class);
    }

    private static void init(CommandLine cl, WadoRS wadoRS) throws Exception {
        if (cl.getArgList().isEmpty()) {
            throw new MissingArgumentException("Missing url");
        }
        header = cl.hasOption("header");
        allowAnyHost = cl.hasOption("allowAnyHost");
        disableTM = cl.hasOption("disableTM");
        if (cl.hasOption("a")) {
            wadoRS.setAccept(cl.getOptionValues("a"));
        }
        outDir = cl.getOptionValue("out-dir");
        authorization = cl.hasOption("u") ? WadoRS.basicAuth(cl.getOptionValue("u")) : (cl.hasOption("bearer") ? "Bearer " + cl.getOptionValue("bearer") : null);
        requestProperties = WadoRS.requestProperties(cl.getOptionValues("H"));
    }

    private void wado(String url) throws Exception {
        String uid = this.uidFrom(url);
        if (!header) {
            url = this.appendAcceptToURL(url);
        }
        if (url.startsWith("https")) {
            this.wadoHttps(new URL(url), uid);
        } else {
            this.wado(new URL(url), uid);
        }
    }

    private static Map<String, String> requestProperties(String[] httpHeaders) {
        HashMap<String, String> requestProperties = new HashMap<String, String>();
        if (header) {
            requestProperties.put("Accept", accept);
        }
        if (authorization != null) {
            requestProperties.put("Authorization", authorization);
        }
        if (httpHeaders != null) {
            for (String httpHeader : httpHeaders) {
                int delim = httpHeader.indexOf(58);
                requestProperties.put(httpHeader.substring(0, delim), httpHeader.substring(delim + 1));
            }
        }
        return requestProperties;
    }

    private void wado(URL url, String uid) throws Exception {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestMethod("GET");
        requestProperties.forEach(connection::setRequestProperty);
        this.logOutgoing(url, connection.getRequestProperties());
        this.processWadoResp(connection, uid);
        connection.disconnect();
    }

    private void wadoHttps(URL url, String uid) throws Exception {
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestMethod("GET");
        requestProperties.forEach(connection::setRequestProperty);
        if (disableTM) {
            connection.setSSLSocketFactory(this.sslContext().getSocketFactory());
        }
        connection.setHostnameVerifier((hostname, session) -> allowAnyHost);
        this.logOutgoing(url, connection.getRequestProperties());
        this.processWadoHttpsResp(connection, uid);
        connection.disconnect();
    }

    SSLContext sslContext() throws GeneralSecurityException {
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(null, this.trustManagers(), new SecureRandom());
        return ctx;
    }

    TrustManager[] trustManagers() {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
    }

    private static String basicAuth(String user) {
        byte[] userPswdBytes = user.getBytes();
        int len = userPswdBytes.length * 4 / 3 + 3 & 0xFFFFFFFC;
        char[] ch = new char[len];
        Base64.encode((byte[])userPswdBytes, (int)0, (int)userPswdBytes.length, (char[])ch, (int)0);
        return "Basic " + new String(ch);
    }

    private String appendAcceptToURL(String url) {
        return url + (url.indexOf(63) != -1 ? "&" : "?") + "accept=" + accept;
    }

    private String uidFrom(String url) {
        return url.contains("metadata") ? url.substring(url.substring(0, url.lastIndexOf(47)).lastIndexOf(47) + 1, url.lastIndexOf(47)) : (url.contains("?") ? url.substring(url.substring(0, url.indexOf(63)).lastIndexOf(47) + 1, url.indexOf(63)) : url.substring(url.lastIndexOf(47) + 1));
    }

    private void logOutgoing(URL url, Map<String, List<String>> headerFields) {
        LOG.info("> GET " + url.toString());
        headerFields.forEach((k, v) -> LOG.info("> " + k + " : " + String.join((CharSequence)",", v)));
    }

    private void processWadoResp(HttpURLConnection connection, String uid) throws Exception {
        int respCode = connection.getResponseCode();
        this.logIncoming(respCode, connection.getResponseMessage(), connection.getHeaderFields());
        if (respCode != 200 && respCode != 206) {
            return;
        }
        this.unpack(connection.getInputStream(), connection.getContentType(), uid);
    }

    private void processWadoHttpsResp(HttpsURLConnection connection, String uid) throws Exception {
        int respCode = connection.getResponseCode();
        this.logIncoming(respCode, connection.getResponseMessage(), connection.getHeaderFields());
        if (respCode != 200 && respCode != 206) {
            return;
        }
        this.unpack(connection.getInputStream(), connection.getContentType(), uid);
    }

    private void logIncoming(int respCode, String respMsg, Map<String, List<String>> headerFields) {
        LOG.info("< HTTP/1.1 Response: " + respCode + " " + respMsg);
        for (Map.Entry<String, List<String>> header : headerFields.entrySet()) {
            if (header.getKey() == null) continue;
            LOG.info("< " + header.getKey() + " : " + String.join((CharSequence)";", (Iterable<? extends CharSequence>)header.getValue()));
        }
    }

    private void unpack(InputStream is, String contentType, final String uid) {
        try {
            if (!contentType.contains("multipart/related")) {
                this.write(uid, this.partExtension(contentType), is);
                return;
            }
            String boundary = this.boundary(contentType);
            if (boundary == null) {
                LOG.warn("Invalid response. Unpacking of parts not possible.");
                return;
            }
            new MultipartParser(boundary).parse((InputStream)new BufferedInputStream(is), new MultipartParser.Handler(){

                public void bodyPart(int partNumber, MultipartInputStream multipartInputStream) throws IOException {
                    Map headerParams = multipartInputStream.readHeaderParams();
                    try {
                        String fileName = WadoRS.this.fileName(partNumber, uid, WadoRS.this.partExtension((String)((List)headerParams.get("content-type")).get(0)));
                        LOG.info("Extract Part #{} {} \n{}", new Object[]{partNumber, fileName, headerParams});
                        WadoRS.write((InputStream)multipartInputStream, fileName);
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to process Part #" + partNumber + headerParams, (Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            LOG.info("Exception caught on unpacking response \n", (Throwable)e);
        }
    }

    private void write(String uid, String ext, InputStream is) throws IOException {
        String fileName = this.fileName(1, uid, ext);
        LOG.info("Extract {} to {}", (Object)ext, (Object)fileName);
        WadoRS.write(is, fileName);
    }

    private String partExtension(String partContentType) {
        String contentType = partContentType.split(";")[0].replaceAll("[-+/]", "_");
        return contentType.substring(contentType.lastIndexOf("_") + 1);
    }

    private String boundary(String contentType) {
        String[] respContentTypeParams;
        for (String respContentTypeParam : respContentTypeParams = contentType.split(";")) {
            if (!respContentTypeParam.replace(" ", "").startsWith("boundary=")) continue;
            return respContentTypeParam.substring(respContentTypeParam.indexOf("=") + 1).replaceAll("\"", "");
        }
        return null;
    }

    private String fileName(int partNumber, String uid, String ext) {
        return uid + "-" + String.format("%03d", partNumber) + "." + ext;
    }

    private static void write(InputStream in, String fileName) throws IOException {
        Path path = outDir != null ? Files.createDirectories(Paths.get(outDir, new String[0]), new FileAttribute[0]).resolve(fileName) : Paths.get(fileName, new String[0]);
        try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
            StreamUtils.copy((InputStream)in, (OutputStream)out);
        }
    }

    static {
        accept = "*";
    }
}

