/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.wadows;

import jakarta.activation.DataHandler;
import jakarta.xml.ws.WebServiceFeature;
import jakarta.xml.ws.soap.AddressingFeature;
import jakarta.xml.ws.soap.MTOMFeature;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.tool.common.CLIUtils;
import org.dcm4che3.util.StreamUtils;
import org.dcm4che3.xdsi.ImagingDocumentSource;
import org.dcm4che3.xdsi.ImagingDocumentSourcePortType;
import org.dcm4che3.xdsi.RetrieveDocumentSetRequestType;
import org.dcm4che3.xdsi.RetrieveDocumentSetResponseType;
import org.dcm4che3.xdsi.RetrieveImagingDocumentSetRequestType;
import org.dcm4che3.xdsi.RetrieveRenderedImagingDocumentSetRequestType;
import org.dcm4che3.xdsi.RetrieveRenderedImagingDocumentSetResponseType;
import org.dcm4che3.xdsi.XDSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WadoWS {
    private static final Logger LOG = LoggerFactory.getLogger(WadoWS.class);
    private static final ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.wadows.messages");
    private static final String DEFAULT_CONTENT_TYPE = "image/jpeg";
    private static final String DEFAULT_TRANSFER_SYNTAX_UID = "1.2.840.10008.1.2.1";
    private static final String DEFAULT_REPOSITORY_UNIQUE_ID = "1.3.6.1.4.1.21367.13.80.110";
    private static ImagingDocumentSource service;
    private static String url;
    private static boolean rendered;
    private static String rows;
    private static String columns;
    private static String windowWidth;
    private static String windowCenter;
    private static String imageQuality;
    private static String frameNo;
    private static Attributes kosAttr;
    private static String[] tsuids;
    private static String[] contentTypes;
    private static String repositoryUniqueID;
    private static File outDir;
    private static int count;

    public static void main(String[] args) {
        try {
            WadoWS wadoWS = new WadoWS();
            WadoWS.init(WadoWS.parseComandLine(args), wadoWS);
            wadoWS.wado();
        }
        catch (ParseException e) {
            System.err.println("wadows: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (StringIndexOutOfBoundsException e) {
            System.err.println("wadows: " + e.getMessage());
            System.err.println(rb.getString("study"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("wadows: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    private void setOutputDirectory(File dir) {
        dir.mkdirs();
        outDir = dir;
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        CLIUtils.addCommonOptions((Options)opts);
        opts.addOption(Option.builder().longOpt("out-dir").hasArg().argName("directory").desc(rb.getString("out-dir")).build());
        opts.addOption(Option.builder().hasArg().argName("url").longOpt("url").desc(rb.getString("url")).build());
        opts.addOption(Option.builder().hasArg().argName("uid").longOpt("repository-unique-id").desc(rb.getString("repository-unique-id")).build());
        opts.addOption(Option.builder().longOpt("rendered").hasArg(false).desc(rb.getString("rendered")).build());
        opts.addOption(Option.builder().hasArg().longOpt("rows").desc(rb.getString("rows")).build());
        opts.addOption(Option.builder().hasArg().longOpt("columns").desc(rb.getString("columns")).build());
        opts.addOption(Option.builder().hasArg().longOpt("window-width").desc(rb.getString("window-width")).build());
        opts.addOption(Option.builder().hasArg().longOpt("window-center").desc(rb.getString("window-center")).build());
        opts.addOption(Option.builder().hasArg().longOpt("image-quality").desc(rb.getString("image-quality")).build());
        opts.addOption(Option.builder().hasArg().longOpt("frame-number").desc(rb.getString("frame-number")).build());
        OptionGroup group = new OptionGroup();
        group.addOption(Option.builder().longOpt("tsuid").hasArgs().desc(rb.getString("tsuid")).build());
        group.addOption(Option.builder((String)"t").longOpt("contentType").hasArgs().desc(rb.getString("contentType")).build());
        opts.addOptionGroup(group);
        OptionGroup reqGroup = new OptionGroup();
        reqGroup.addOption(Option.builder((String)"f").hasArg().longOpt("file").argName("file").desc(rb.getString("file")).build());
        reqGroup.addOption(Option.builder().hasArg().longOpt("study").desc(rb.getString("study")).build());
        opts.addOptionGroup(reqGroup);
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, WadoWS.class);
    }

    private static void init(CommandLine cl, WadoWS wadoWS) throws Exception {
        url = cl.getOptionValue("url");
        if (url == null) {
            throw new MissingOptionException("Missing url.");
        }
        if (!cl.hasOption("study") && !cl.hasOption("f")) {
            throw new MissingOptionException("Specify either -f or --study option");
        }
        rendered = cl.hasOption("rendered");
        service = new ImagingDocumentSource();
        rows = cl.getOptionValue("rows");
        columns = cl.getOptionValue("columns");
        windowWidth = cl.getOptionValue("window-width");
        windowCenter = cl.getOptionValue("window-center");
        imageQuality = cl.getOptionValue("image-quality");
        frameNo = cl.getOptionValue("frame-number");
        if (cl.hasOption("tsuid")) {
            tsuids = cl.getOptionValues("tsuid");
        }
        if (cl.hasOption("t")) {
            contentTypes = cl.getOptionValues("t");
        }
        String string = repositoryUniqueID = cl.hasOption("repositoryUniqueID") ? cl.getOptionValue("repositoryUniqueID") : DEFAULT_REPOSITORY_UNIQUE_ID;
        if (cl.hasOption("out-dir")) {
            wadoWS.setOutputDirectory(new File(cl.getOptionValue("out-dir")));
        }
        kosAttr = cl.hasOption("f") ? new DicomInputStream((InputStream)new FileInputStream(new File(cl.getOptionValue("f")))).readDataset() : WadoWS.toAttributes(cl.getOptionValue("study"));
    }

    private void wado() throws Exception {
        ImagingDocumentSourcePortType port = this.port();
        if (rendered) {
            RetrieveRenderedImagingDocumentSetResponseType retrieveRenderedImagingDocumentSetResponseType = port.imagingDocumentSourceRetrieveRenderedImagingDocumentSet(this.createRetrieveRenderedImagingDocumentSetRequest());
            List renderedDocumentResponse = retrieveRenderedImagingDocumentSetResponseType.getRenderedDocumentResponse();
            LOG.info("<< RetrieveRenderedImagingDocumentSetResponse:");
            for (RetrieveRenderedImagingDocumentSetResponseType.RenderedDocumentResponse rsp : renderedDocumentResponse) {
                this.logIncoming(rsp);
                WadoWS.write(rsp.getDocument().getInputStream());
            }
            return;
        }
        RetrieveDocumentSetResponseType retrieveDocumentSetResponseType = port.imagingDocumentSourceRetrieveImagingDocumentSet(this.createRetrieveImagingDocumentSetRequest());
        List documentResponse = retrieveDocumentSetResponseType.getDocumentResponse();
        LOG.info("<< RetrieveDocumentSetResponse:");
        for (RetrieveDocumentSetResponseType.DocumentResponse rsp : documentResponse) {
            this.logIncoming(rsp);
            WadoWS.write(rsp.getDocument().getInputStream());
        }
    }

    private static void write(InputStream in) throws IOException {
        Path path = outDir != null ? new File(outDir.toPath().toString(), "part" + count).toPath() : Paths.get("part" + count, new String[0]);
        try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
            StreamUtils.copy((InputStream)in, (OutputStream)out);
        }
        System.out.println(MessageFormat.format(rb.getString("unpacked"), path));
        ++count;
    }

    private ImagingDocumentSourcePortType port() throws Exception {
        ImagingDocumentSourcePortType port = service.getImagingDocumentSourcePortSoap12(new WebServiceFeature[]{new AddressingFeature(true, true), new MTOMFeature()});
        XDSUtils.ensureMustUnderstandHandler((Object)port);
        XDSUtils.setEndpointAddress((Object)port, (String)url);
        return port;
    }

    private RetrieveImagingDocumentSetRequestType createRetrieveImagingDocumentSetRequest() {
        RetrieveImagingDocumentSetRequestType req = new RetrieveImagingDocumentSetRequestType();
        for (Attributes refStudy : kosAttr.getSequence(4236149)) {
            req.getStudyRequest().add(this.createStudyReq(refStudy));
        }
        RetrieveImagingDocumentSetRequestType.TransferSyntaxUIDList tsuidList = new RetrieveImagingDocumentSetRequestType.TransferSyntaxUIDList();
        for (String tsuid : tsuids) {
            tsuidList.getTransferSyntaxUID().add(tsuid);
        }
        req.setTransferSyntaxUIDList(tsuidList);
        this.logOutgoing(req);
        return req;
    }

    private void logOutgoing(RetrieveImagingDocumentSetRequestType req) {
        LOG.info(">> RetrieveImagingDocumentSetRequest:");
        for (RetrieveImagingDocumentSetRequestType.StudyRequest studyReq : req.getStudyRequest()) {
            LOG.info("  Study[uid=" + studyReq.getStudyInstanceUID() + "]");
            for (RetrieveImagingDocumentSetRequestType.StudyRequest.SeriesRequest seriesReq : studyReq.getSeriesRequest()) {
                LOG.info("   Series[uid=" + seriesReq.getSeriesInstanceUID() + "]");
                for (RetrieveDocumentSetRequestType.DocumentRequest docReq : seriesReq.getDocumentRequest()) {
                    LOG.info("    Document[uid=" + docReq.getDocumentUniqueId() + "]");
                    LOG.info("    Repository[uid=" + docReq.getRepositoryUniqueId() + "]");
                }
            }
        }
        for (String tsuid : req.getTransferSyntaxUIDList().getTransferSyntaxUID()) {
            LOG.info("  Transfer Syntax[uid=" + tsuid + "]");
        }
    }

    private void logOutgoing(RetrieveRenderedImagingDocumentSetRequestType req) {
        LOG.info(">> RetrieveRenderedImagingDocumentSetRequest:");
        for (RetrieveRenderedImagingDocumentSetRequestType.StudyRequest studyReq : req.getStudyRequest()) {
            LOG.info("  Study[uid=" + studyReq.getStudyInstanceUID() + "]");
            for (RetrieveRenderedImagingDocumentSetRequestType.StudyRequest.SeriesRequest seriesReq : studyReq.getSeriesRequest()) {
                LOG.info("   Series[uid=" + seriesReq.getSeriesInstanceUID() + "]");
                for (RetrieveRenderedImagingDocumentSetRequestType.StudyRequest.SeriesRequest.RenderedDocumentRequest docReq : seriesReq.getRenderedDocumentRequest()) {
                    LOG.info("    Document[uid=" + docReq.getDocumentUniqueId() + "]");
                    LOG.info("    Repository[uid=" + docReq.getRepositoryUniqueId() + "]");
                }
            }
        }
    }

    private void logIncoming(RetrieveDocumentSetResponseType.DocumentResponse rsp) {
        DataHandler document = rsp.getDocument();
        LOG.info("< Document[uid=" + rsp.getDocumentUniqueId() + ", name=" + document.getName() + ", contentType=" + document.getContentType() + "]");
        LOG.info("< Home Community ID: " + rsp.getHomeCommunityId());
        LOG.info("< Mime Type: " + rsp.getMimeType());
        LOG.info("< Repository Unique ID: " + rsp.getRepositoryUniqueId());
    }

    private void logIncoming(RetrieveRenderedImagingDocumentSetResponseType.RenderedDocumentResponse rsp) {
        DataHandler document = rsp.getDocument();
        LOG.info("< Document[uid=" + rsp.getSourceDocumentUniqueId() + ", Name=" + document.getName() + ", ContentType=" + document.getContentType() + ", Rows=" + rsp.getRows() + ", Columns=" + rsp.getColumns() + ", Region=" + rsp.getRegion() + ", WindowWidth=" + rsp.getWindowWidth() + ", WindowCenter=" + rsp.getWindowCenter() + ", ImageQuality=" + rsp.getImageQuality() + ", PresentationUID=" + rsp.getPresentationUID() + ", PresentationSeriesUID=" + rsp.getPresentationSeriesUID() + ", Annotation=" + rsp.getAnnotation() + ", Anonymize=" + rsp.getAnonymize() + ", FrameNumber=" + rsp.getFrameNumber() + "]");
        LOG.info("< Home Community ID: " + rsp.getHomeCommunityId());
        LOG.info("< Mime Type: " + rsp.getMimeType());
        LOG.info("< Repository Unique ID: " + rsp.getRepositoryUniqueId());
    }

    private RetrieveImagingDocumentSetRequestType.StudyRequest createStudyReq(Attributes refStudy) {
        RetrieveImagingDocumentSetRequestType.StudyRequest studyReq = new RetrieveImagingDocumentSetRequestType.StudyRequest();
        studyReq.setStudyInstanceUID(refStudy.getString(0x20000D));
        for (Attributes refSeries : refStudy.getSequence(528661)) {
            studyReq.getSeriesRequest().add(this.createSeriesReq(refSeries));
        }
        return studyReq;
    }

    private RetrieveImagingDocumentSetRequestType.StudyRequest.SeriesRequest createSeriesReq(Attributes refSeries) {
        RetrieveImagingDocumentSetRequestType.StudyRequest.SeriesRequest seriesReq = new RetrieveImagingDocumentSetRequestType.StudyRequest.SeriesRequest();
        seriesReq.setSeriesInstanceUID(refSeries.getString(0x20000E));
        for (Attributes refSOP : refSeries.getSequence(528793)) {
            seriesReq.getDocumentRequest().add(this.createInstanceReq(refSOP));
        }
        return seriesReq;
    }

    private RetrieveDocumentSetRequestType.DocumentRequest createInstanceReq(Attributes refSOP) {
        RetrieveDocumentSetRequestType.DocumentRequest sopReq = new RetrieveDocumentSetRequestType.DocumentRequest();
        sopReq.setDocumentUniqueId(refSOP.getString(528725));
        sopReq.setRepositoryUniqueId(repositoryUniqueID);
        return sopReq;
    }

    private RetrieveRenderedImagingDocumentSetRequestType createRetrieveRenderedImagingDocumentSetRequest() {
        RetrieveRenderedImagingDocumentSetRequestType req = new RetrieveRenderedImagingDocumentSetRequestType();
        for (Attributes refStudy : kosAttr.getSequence(4236149)) {
            req.getStudyRequest().add(this.createRenderedStudyReq(refStudy));
        }
        this.logOutgoing(req);
        return req;
    }

    private RetrieveRenderedImagingDocumentSetRequestType.StudyRequest createRenderedStudyReq(Attributes refStudy) {
        RetrieveRenderedImagingDocumentSetRequestType.StudyRequest studyReq = new RetrieveRenderedImagingDocumentSetRequestType.StudyRequest();
        studyReq.setStudyInstanceUID(refStudy.getString(0x20000D));
        for (Attributes refSeries : refStudy.getSequence(528661)) {
            studyReq.getSeriesRequest().add(this.createRenderedSeriesReq(refSeries));
        }
        return studyReq;
    }

    private RetrieveRenderedImagingDocumentSetRequestType.StudyRequest.SeriesRequest createRenderedSeriesReq(Attributes refSeries) {
        RetrieveRenderedImagingDocumentSetRequestType.StudyRequest.SeriesRequest seriesReq = new RetrieveRenderedImagingDocumentSetRequestType.StudyRequest.SeriesRequest();
        seriesReq.setSeriesInstanceUID(refSeries.getString(0x20000E));
        for (Attributes refSOP : refSeries.getSequence(528793)) {
            seriesReq.getRenderedDocumentRequest().add(this.createRenderedDocReq(refSOP));
        }
        return seriesReq;
    }

    private RetrieveRenderedImagingDocumentSetRequestType.StudyRequest.SeriesRequest.RenderedDocumentRequest createRenderedDocReq(Attributes refSOP) {
        RetrieveRenderedImagingDocumentSetRequestType.StudyRequest.SeriesRequest.RenderedDocumentRequest sopReq = new RetrieveRenderedImagingDocumentSetRequestType.StudyRequest.SeriesRequest.RenderedDocumentRequest();
        sopReq.setDocumentUniqueId(refSOP.getString(528725));
        sopReq.setRepositoryUniqueId(repositoryUniqueID);
        if (rows != null) {
            sopReq.setRows(rows);
        }
        if (columns != null) {
            sopReq.setColumns(columns);
        }
        if (windowWidth != null) {
            sopReq.setWindowWidth(windowWidth);
        }
        if (windowCenter != null) {
            sopReq.setWindowCenter(windowCenter);
        }
        if (imageQuality != null) {
            sopReq.setImageQuality(imageQuality);
        }
        if (frameNo != null) {
            sopReq.setFrameNumber(frameNo);
        }
        RetrieveRenderedImagingDocumentSetRequestType.StudyRequest.SeriesRequest.RenderedDocumentRequest.ContentTypeList contentTypeList = new RetrieveRenderedImagingDocumentSetRequestType.StudyRequest.SeriesRequest.RenderedDocumentRequest.ContentTypeList();
        for (String contentType : contentTypes) {
            contentTypeList.getContentType().add(contentType);
        }
        sopReq.setContentTypeList(contentTypeList);
        return sopReq;
    }

    private static Attributes toAttributes(String study) {
        String instanceSeparator = ",";
        int beginReferencedObj = 91;
        String seriesSplitterRegex = "(],)";
        Attributes attrs = new Attributes();
        Attributes refStudy = new Attributes();
        int seriesListStart = study.indexOf(beginReferencedObj);
        refStudy.setString(0x20000D, VR.UI, study.substring(0, seriesListStart));
        String[] seriesList = study.substring(seriesListStart + 1, study.length() - 1).split(seriesSplitterRegex);
        Sequence refSeriesSequence = refStudy.newSequence(528661, seriesList.length);
        for (String series : seriesList) {
            int instanceListStart = series.indexOf(beginReferencedObj);
            Attributes refSeries = new Attributes();
            refSeries.setString(0x20000E, VR.UI, series.substring(0, instanceListStart));
            String[] instances = series.substring(instanceListStart + 1).replace(']', ' ').split(instanceSeparator);
            Sequence refSopSequence = refSeries.newSequence(528793, instances.length);
            for (String instance : instances) {
                Attributes refSop = new Attributes();
                refSop.setString(528725, VR.UI, instance);
                refSopSequence.add(refSop);
            }
            refSeriesSequence.add(refSeries);
        }
        attrs.newSequence(4236149, 1).add(refStudy);
        return attrs;
    }

    static {
        tsuids = new String[]{DEFAULT_TRANSFER_SYNTAX_UID};
        contentTypes = new String[]{DEFAULT_CONTENT_TYPE};
    }
}

