/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.xml2dcm;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.io.BasicBulkDataDescriptor;
import org.dcm4che3.io.BulkDataDescriptor;
import org.dcm4che3.io.ContentHandlerAdapter;
import org.dcm4che3.io.DicomEncodingOptions;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.io.DicomOutputStream;
import org.dcm4che3.tool.common.CLIUtils;
import org.xml.sax.helpers.DefaultHandler;

public class Xml2Dcm {
    private static ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.xml2dcm.messages");
    private boolean lenient = false;
    private DicomInputStream.IncludeBulkData includeBulkData = DicomInputStream.IncludeBulkData.URI;
    private boolean catBlkFiles = false;
    private String blkFilePrefix = "blk";
    private String blkFileSuffix;
    private File blkDirectory;
    private BasicBulkDataDescriptor bulkDataDescriptor = new BasicBulkDataDescriptor();
    private String tsuid;
    private boolean withfmi;
    private boolean nofmi;
    private DicomEncodingOptions encOpts = DicomEncodingOptions.DEFAULT;
    private List<File> bulkDataFiles;
    private Attributes fmi;
    private Attributes dataset;

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public final void setIncludeBulkData(DicomInputStream.IncludeBulkData includeBulkData) {
        this.includeBulkData = includeBulkData;
    }

    public final void setConcatenateBulkDataFiles(boolean catBlkFiles) {
        this.catBlkFiles = catBlkFiles;
    }

    public final void setBulkDataFilePrefix(String blkFilePrefix) {
        this.blkFilePrefix = blkFilePrefix;
    }

    public final void setBulkDataFileSuffix(String blkFileSuffix) {
        this.blkFileSuffix = blkFileSuffix;
    }

    public final void setBulkDataDirectory(File blkDirectory) {
        this.blkDirectory = blkDirectory;
    }

    public void setBulkDataNoDefaults(boolean excludeDefaults) {
        this.bulkDataDescriptor.excludeDefaults(excludeDefaults);
    }

    public void setBulkDataLengthsThresholdsFromStrings(String[] thresholds) {
        this.bulkDataDescriptor.setLengthsThresholdsFromStrings(thresholds);
    }

    public final void setTransferSyntax(String uid) {
        this.tsuid = uid;
    }

    public final void setWithFileMetaInformation(boolean withfmi) {
        this.withfmi = withfmi;
    }

    public final void setNoFileMetaInformation(boolean nofmi) {
        this.nofmi = nofmi;
    }

    public final void setEncodingOptions(DicomEncodingOptions encOpts) {
        this.encOpts = encOpts;
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        CLIUtils.addCommonOptions((Options)opts);
        Xml2Dcm.addLenientOption(opts);
        Xml2Dcm.addIOFileNameOptions(opts);
        Xml2Dcm.addBulkdataOptions(opts);
        Xml2Dcm.addFileEncodingOptions(opts);
        CommandLine cl = CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, Xml2Dcm.class);
        if (!cl.hasOption("x") && !cl.hasOption("i")) {
            throw new ParseException(rb.getString("missing-i-x"));
        }
        return cl;
    }

    private static void addLenientOption(Options opts) {
        opts.addOption(Option.builder().longOpt("lenient").desc(rb.getString("lenient")).build());
    }

    private static void addIOFileNameOptions(Options opts) {
        opts.addOption(Option.builder((String)"x").hasArg().argName("xml-file").desc(rb.getString("x-file")).build());
        opts.addOption(Option.builder((String)"i").hasArg().argName("dicom-file").desc(rb.getString("i-file")).build());
        opts.addOption(Option.builder((String)"o").hasArg().argName("dicom-file").desc(rb.getString("o-file")).build());
    }

    private static void addBulkdataOptions(Options opts) {
        OptionGroup blkGroup = new OptionGroup();
        blkGroup.addOption(Option.builder((String)"B").longOpt("no-bulkdata").desc(rb.getString("no-bulkdata")).build());
        blkGroup.addOption(Option.builder((String)"b").longOpt("alloc-bulkdata").desc(rb.getString("alloc-bulkdata")).build());
        opts.addOptionGroup(blkGroup);
        opts.addOption(Option.builder((String)"d").longOpt("blk-file-dir").hasArg().argName("directory").desc(rb.getString("blk-file-dir")).build());
        opts.addOption(Option.builder().longOpt("blk-file-prefix").hasArg().argName("prefix").desc(rb.getString("blk-file-prefix")).build());
        opts.addOption(Option.builder().longOpt("blk-file-suffix").hasArg().argName("suffix").desc(rb.getString("blk-file-suffix")).build());
        opts.addOption("c", "cat-blk-files", false, rb.getString("cat-blk-files"));
        opts.addOption(null, "keep-blk-files", false, rb.getString("keep-blk-files"));
        opts.addOption(null, "blk-nodefs", false, rb.getString("blk-nodefs"));
        opts.addOption(Option.builder(null).longOpt("blk").hasArgs().argName("[seq.]attr").desc(rb.getString("blk")).build());
        opts.addOption(Option.builder(null).longOpt("blk-vr").hasArgs().argName("vr[,...]=length").desc(rb.getString("blk-vr")).build());
    }

    private static void addFileEncodingOptions(Options opts) {
        opts.addOption(Option.builder((String)"t").longOpt("transfer-syntax").hasArg().argName("uid").desc(rb.getString("transfer-syntax")).build());
        OptionGroup fmiGroup = new OptionGroup();
        fmiGroup.addOption(Option.builder((String)"F").longOpt("no-fmi").desc(rb.getString("no-fmi")).build());
        fmiGroup.addOption(Option.builder((String)"f").longOpt("fmi").desc(rb.getString("fmi")).build());
        opts.addOptionGroup(fmiGroup);
        CLIUtils.addEncodingOptions((Options)opts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            CommandLine cl = Xml2Dcm.parseComandLine(args);
            Xml2Dcm main = new Xml2Dcm();
            Xml2Dcm.configureBulkdata(main, cl);
            main.setLenient(cl.hasOption("lenient"));
            if (cl.hasOption("t")) {
                main.setTransferSyntax(cl.getOptionValue("t"));
            }
            main.setWithFileMetaInformation(cl.hasOption("f"));
            main.setNoFileMetaInformation(cl.hasOption("F"));
            main.setEncodingOptions(CLIUtils.encodingOptionsOf((CommandLine)cl));
            try {
                if (cl.hasOption("i")) {
                    String fname = cl.getOptionValue("i");
                    if (fname.equals("-")) {
                        main.parse(new DicomInputStream(System.in));
                    } else {
                        try (DicomInputStream dis = new DicomInputStream(new File(fname));){
                            main.parse(dis);
                        }
                    }
                }
                if (cl.hasOption("x")) {
                    main.mergeXML(cl.getOptionValue("x"));
                }
                try (FileOutputStream out = cl.hasOption("o") ? new FileOutputStream(cl.getOptionValue("o")) : new FileOutputStream(FileDescriptor.out);){
                    main.writeTo(out);
                }
            }
            finally {
                if (!cl.hasOption("keep-blk-files")) {
                    main.delBulkDataFiles();
                }
            }
        }
        catch (ParseException e) {
            System.err.println("xml2dcm: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("xml2dcm: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    private static void configureBulkdata(Xml2Dcm xml2dcm, CommandLine cl) throws Exception {
        if (cl.hasOption("b")) {
            xml2dcm.setIncludeBulkData(DicomInputStream.IncludeBulkData.YES);
        }
        if (cl.hasOption("B")) {
            xml2dcm.setIncludeBulkData(DicomInputStream.IncludeBulkData.NO);
        }
        if (cl.hasOption("blk-file-prefix")) {
            xml2dcm.setBulkDataFilePrefix(cl.getOptionValue("blk-file-prefix"));
        }
        if (cl.hasOption("blk-file-suffix")) {
            xml2dcm.setBulkDataFileSuffix(cl.getOptionValue("blk-file-suffix"));
        }
        if (cl.hasOption("d")) {
            File tempDir = new File(cl.getOptionValue("d"));
            xml2dcm.setBulkDataDirectory(tempDir);
        }
        xml2dcm.setConcatenateBulkDataFiles(cl.hasOption("c"));
        xml2dcm.setBulkDataNoDefaults(cl.hasOption("blk-nodefs"));
        if (cl.hasOption("blk")) {
            CLIUtils.addTagPaths((BasicBulkDataDescriptor)xml2dcm.bulkDataDescriptor, (String[])cl.getOptionValues("blk"));
        }
        if (cl.hasOption("blk-vr")) {
            xml2dcm.setBulkDataLengthsThresholdsFromStrings(cl.getOptionValues("blk-vr"));
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        if (this.nofmi) {
            this.fmi = null;
        } else if (this.fmi == null ? this.withfmi : this.tsuid != null && !this.tsuid.equals(this.fmi.getString(131088, null))) {
            this.fmi = this.dataset.createFileMetaInformation(this.tsuid);
        }
        DicomOutputStream dos = new DicomOutputStream((OutputStream)new BufferedOutputStream(out), this.fmi != null ? "1.2.840.10008.1.2.1" : (this.tsuid != null ? this.tsuid : "1.2.840.10008.1.2"));
        dos.setEncodingOptions(this.encOpts);
        dos.writeDataset(this.fmi, this.dataset);
        dos.finish();
        dos.flush();
    }

    public void delBulkDataFiles() {
        if (this.bulkDataFiles != null) {
            for (File f : this.bulkDataFiles) {
                f.delete();
            }
        }
    }

    public void parse(DicomInputStream dis) throws IOException {
        dis.setIncludeBulkData(this.includeBulkData);
        dis.setBulkDataDescriptor((BulkDataDescriptor)this.bulkDataDescriptor);
        dis.setBulkDataDirectory(this.blkDirectory);
        dis.setBulkDataFilePrefix(this.blkFilePrefix);
        dis.setBulkDataFileSuffix(this.blkFileSuffix);
        dis.setConcatenateBulkDataFiles(this.catBlkFiles);
        this.dataset = dis.readDataset();
        this.fmi = dis.getFileMetaInformation();
        this.bulkDataFiles = dis.getBulkDataFiles();
    }

    public void mergeXML(String fname) throws Exception {
        ContentHandlerAdapter ch = new ContentHandlerAdapter(this.dataset, this.lenient);
        Xml2Dcm.parseXML(fname, ch);
        this.dataset = ch.getDataset();
        Attributes fmi2 = ch.getFileMetaInformation();
        if (fmi2 != null) {
            this.fmi = fmi2;
        }
    }

    public static Attributes parseXML(String fname) throws Exception {
        Attributes attrs = new Attributes();
        ContentHandlerAdapter ch = new ContentHandlerAdapter(attrs);
        Xml2Dcm.parseXML(fname, ch);
        return attrs;
    }

    private static void parseXML(String fname, ContentHandlerAdapter ch) throws Exception {
        SAXParserFactory f = SAXParserFactory.newInstance();
        SAXParser p = f.newSAXParser();
        if (fname.equals("-")) {
            p.parse(System.in, (DefaultHandler)ch);
        } else {
            p.parse(new File(fname), (DefaultHandler)ch);
        }
    }
}

