/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.xml2hl7;

import java.io.File;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.dcm4che3.hl7.HL7ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

public class Xml2HL7 {
    private static ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.xml2hl7.messages");

    public static void main(String[] args) {
        try {
            Xml2HL7.parseXML(Xml2HL7.fname(args));
        }
        catch (Exception e) {
            System.err.println("xml2hl7: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    private static void parseXML(String fname) throws Exception {
        SAXParserFactory f = SAXParserFactory.newInstance();
        SAXParser p = f.newSAXParser();
        HL7ContentHandler ch = new HL7ContentHandler((Writer)new OutputStreamWriter(System.out));
        if (fname.equals("-")) {
            p.parse(System.in, (DefaultHandler)ch);
        } else {
            p.parse(new File(fname), (DefaultHandler)ch);
        }
    }

    private static String fname(String[] args) {
        String arg0;
        if (args.length == 0) {
            System.err.println(rb.getString("missing"));
            System.err.println(rb.getString("usage"));
            System.exit(2);
        }
        if (args.length > 1) {
            System.err.println(rb.getString("too-many"));
            System.err.println(rb.getString("usage"));
            System.exit(2);
        }
        if ((arg0 = args[0]).equals("-h") || arg0.equals("--help")) {
            System.out.println(rb.getString("usage"));
            System.exit(0);
        }
        if (arg0.equals("-V") || arg0.equals("--version")) {
            Package p = Xml2HL7.class.getPackage();
            String s = p.getName();
            System.out.println(s.substring(s.lastIndexOf(46) + 1) + ": " + p.getImplementationVersion());
            System.exit(0);
        }
        if (arg0.startsWith("-") && arg0.length() > 1) {
            System.err.println(MessageFormat.format(rb.getString("unrecognized-option"), arg0));
            System.err.println(rb.getString("usage"));
            System.exit(2);
        }
        return arg0;
    }
}

