/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.xroad;

import jakarta.xml.ws.Holder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.tool.common.CLIUtils;
import org.dcm4che3.xroad.RR441RequestType;
import org.dcm4che3.xroad.RR441ResponseType;
import org.dcm4che3.xroad.XRoadAdapterPortType;
import org.dcm4che3.xroad.XRoadClientIdentifierType;
import org.dcm4che3.xroad.XRoadObjectType;
import org.dcm4che3.xroad.XRoadService;
import org.dcm4che3.xroad.XRoadServiceIdentifierType;
import org.dcm4che3.xroad.XRoadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XRoad
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(XRoad.class);
    private static final ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.xroad.messages");
    private static final String[] HEADERS = new String[]{"#", "cIsikukoodid", "cValjad", "cIsikukood", "cPerenimi", "cEesnimi", "cMPerenimed", "cMEesnimed", "cRiikKood", "cRiik", "cIsanimi", "cSugu", "cSynniaeg", "cSurmKpv", "cTeoVoime", "cIsStaatus", "cKirjeStaatus", "cEKRiik", "cEKMaak", "cEKVald", "cEKAsula", "cEKTanav", "cEKIndeks", "cEKAlgKpv", "cEKVallaKpv", "cEKAadress", "cSynniRiik", "cSaabusEestiKpv", "faultCode", "faultString"};
    private final XRoadAdapterPortType port = new XRoadService().getXRoadServicePort();
    private final String cValjad;
    private final XRoadClientIdentifierType clientIdentifierType;
    private final XRoadServiceIdentifierType serviceIdentifierType;
    private final String userID;
    private final String id;
    private final String protocolVersion;
    private final BufferedWriter csvWriter;
    private final boolean csvHeader;
    private final char csvDelim;
    private final Character csvQuote;
    private final boolean continueOnError;

    private XRoad(String userID, String url, CommandLine cl) throws IOException {
        XRoadUtils.setEndpointAddress((Object)this.port, (String)url);
        this.cValjad = cl.getOptionValue("rr441.cValjad", "1,2,6,7,9,10");
        this.clientIdentifierType = XRoadUtils.createXRoadClientIdentifierType((String)cl.getOptionValue("client.objectType", XRoadObjectType.SUBSYSTEM.name()), (String)cl.getOptionValue("client.xRoadInstance", "EE"), (String)cl.getOptionValue("client.memberClass", "NGO"), (String)cl.getOptionValue("client.memberCode", "90007945"), (String)cl.getOptionValue("client.subsystemCode", "mia"));
        this.serviceIdentifierType = XRoadUtils.createXRoadServiceIdentifierType((String)cl.getOptionValue("service.serviceCode", "RR441"), (String)cl.getOptionValue("service.objectType", XRoadObjectType.SERVICE.name()), (String)cl.getOptionValue("service.xRoadInstance", "EE"), (String)cl.getOptionValue("service.memberClass", "GOV"), (String)cl.getOptionValue("service.memberCode", "70008440"), (String)cl.getOptionValue("service.subsystemCode", "rr"), (String)cl.getOptionValue("service.serviceVersion", "v1"));
        this.userID = userID;
        this.id = cl.getOptionValue("id", "");
        this.protocolVersion = cl.getOptionValue("protocolVersion", "4.0");
        this.csvWriter = this.newBufferedWriter(cl.getOptionValue("csv"));
        this.csvHeader = !cl.hasOption("csv-no-header");
        this.csvDelim = this.csvDelim(cl.getOptionValue("csv-delim"));
        this.csvQuote = this.csvQuote(cl.getOptionValue("csv-quote"));
        this.continueOnError = cl.hasOption("c");
    }

    private BufferedWriter newBufferedWriter(String pathName) throws IOException {
        if (pathName == null) {
            return null;
        }
        Path path = Paths.get(pathName, new String[0]);
        Path parent = path.getParent();
        if (parent != null) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        return Files.newBufferedWriter(path, new OpenOption[0]);
    }

    private char csvDelim(String delim) {
        return delim != null && delim.length() == 1 ? delim.charAt(0) : (char)',';
    }

    private Character csvQuote(String quote) {
        return quote != null && quote.length() == 1 ? Character.valueOf(quote.charAt(0)) : null;
    }

    @Override
    public void close() throws IOException {
        if (this.csvWriter != null) {
            this.csvWriter.close();
        }
    }

    public static void main(String[] args) {
        try {
            CommandLine cl = XRoad.parseComandLine(args);
            String userID = cl.getOptionValue("u");
            if (userID == null) {
                throw new MissingOptionException(rb.getString("missing-user-opt"));
            }
            String url = cl.getOptionValue("U");
            if (url == null) {
                throw new MissingOptionException(rb.getString("missing-url-opt"));
            }
            List pids = cl.getArgList();
            if (pids.isEmpty()) {
                throw new MissingOptionException(rb.getString("missing-pid"));
            }
            try (XRoad xRoad = new XRoad(userID, url, cl);){
                xRoad.writeCsvHeaders();
                for (String pid : pids) {
                    if (pid.startsWith("@")) {
                        for (String pid2 : XRoad.readLines(pid.substring(1))) {
                            xRoad.rr441(pid2);
                        }
                        continue;
                    }
                    xRoad.rr441(pid);
                }
            }
        }
        catch (ParseException e) {
            System.err.println("XRoad: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("XRoad: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    private static List<String> readLines(String pathName) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(Paths.get(pathName, new String[0]));){
            List<String> list = reader.lines().collect(Collectors.toList());
            return list;
        }
    }

    private void rr441(String pid) throws Exception {
        block4: {
            RR441RequestType rq = XRoadUtils.createRR441RequestType((String)this.cValjad, (String)pid);
            LOG.info("<< RR441Request{cIsikukoodid={}, cValjad={}}", (Object)pid, (Object)this.cValjad);
            try {
                final RR441ResponseType rsp = this.rr441(rq);
                LOG.info(">> RR441Response{{}}", new Object(){

                    public String toString() {
                        return XRoad.this.toString(rsp);
                    }
                });
                if (this.csvWriter != null) {
                    this.writeCsvRows(rq, rsp);
                }
            }
            catch (Exception e) {
                LOG.warn("Failed to receive RR441Response for RR441Request{cIsikukoodid={}, cValjad={}}:\n", new Object[]{pid, this.cValjad, e});
                if (!this.continueOnError) {
                    throw e;
                }
                if (this.csvWriter == null) break block4;
                this.writeCsvRow(rq, e);
            }
        }
    }

    private String toString(RR441ResponseType rsp) {
        StringBuffer sb = new StringBuffer(256);
        List ttIsikudList = rsp.getTtIsikuid().getTtIsikud();
        if (!ttIsikudList.isEmpty()) {
            sb.append('[');
            for (RR441ResponseType.TtIsikuid.TtIsikud ttIsikud : ttIsikudList) {
                sb.append('(');
                this.appendTo(sb, 1, ttIsikud.getTtIsikudCIsikukood());
                this.appendTo(sb, 2, ttIsikud.getTtIsikudCPerenimi());
                this.appendTo(sb, 3, ttIsikud.getTtIsikudCEesnimi());
                this.appendTo(sb, 4, ttIsikud.getTtIsikudCMPerenimed());
                this.appendTo(sb, 5, ttIsikud.getTtIsikudCMEesnimed());
                this.appendTo(sb, 6, ttIsikud.getTtIsikudCRiikKood());
                this.appendTo(sb, 7, ttIsikud.getTtIsikudCRiik());
                this.appendTo(sb, 8, ttIsikud.getTtIsikudCIsanimi());
                this.appendTo(sb, 9, ttIsikud.getTtIsikudCSugu());
                this.appendTo(sb, 10, ttIsikud.getTtIsikudCSynniaeg());
                this.appendTo(sb, 11, ttIsikud.getTtIsikudCSurmKpv());
                this.appendTo(sb, 12, ttIsikud.getTtIsikudCTeoVoime());
                this.appendTo(sb, 13, ttIsikud.getTtIsikudCIsStaatus());
                this.appendTo(sb, 14, ttIsikud.getTtIsikudCKirjeStaatus());
                this.appendTo(sb, 15, ttIsikud.getTtIsikudCEKRiik());
                this.appendTo(sb, 16, ttIsikud.getTtIsikudCEKMaak());
                this.appendTo(sb, 17, ttIsikud.getTtIsikudCEKVald());
                this.appendTo(sb, 18, ttIsikud.getTtIsikudCEKAsula());
                this.appendTo(sb, 19, ttIsikud.getTtIsikudCEKTanav());
                this.appendTo(sb, 20, ttIsikud.getTtIsikudCEKIndeks());
                this.appendTo(sb, 21, ttIsikud.getTtIsikudCEKAlgKpv());
                this.appendTo(sb, 22, ttIsikud.getTtIsikudCEKVallaKpv());
                this.appendTo(sb, 23, ttIsikud.getTtIsikudCEKAadress());
                this.appendTo(sb, 24, ttIsikud.getTtIsikudCSynniRiik());
                this.appendTo(sb, 25, ttIsikud.getTtIsikudCSaabusEestiKpv());
                sb.setLength(sb.length() - 2);
                sb.append(')').append(',').append(' ');
            }
            sb.setLength(sb.length() - 2);
            sb.append(']').append(',').append(' ');
        }
        this.appendTo(sb, 26, rsp.getFaultCode());
        this.appendTo(sb, 27, rsp.getFaultString());
        sb.setLength(Math.max(0, sb.length() - 2));
        return sb.toString();
    }

    private void appendTo(StringBuffer sb, int index, String value) {
        if (value != null && !value.isEmpty()) {
            sb.append(HEADERS[index]).append('=').append(value).append(',').append(' ');
        }
    }

    private void writeCsvRows(RR441RequestType rq, RR441ResponseType rsp) throws IOException {
        int size = rsp.getTtIsikuid().getTtIsikud().size();
        if (size == 0) {
            this.writeCsvRow(rq, rsp, -1);
        } else {
            for (int i = 0; i < size; ++i) {
                this.writeCsvRow(rq, rsp, i);
            }
        }
    }

    private void writeCsvRow(RR441RequestType rq, Exception e) throws IOException {
        this.writeCsvValue("-1");
        this.writeCsvDelimiterAndValue(rq.getCIsikukoodid());
        this.writeCsvDelimiterAndValue(rq.getCValjad());
        for (int i = 0; i < HEADERS.length - 3; ++i) {
            this.csvWriter.write(this.csvDelim);
        }
        this.writeCsvDelimiterAndValue(e.getMessage());
        this.csvWriter.write("\r\n");
    }

    private void writeCsvRow(RR441RequestType rq, RR441ResponseType rsp, int index) throws IOException {
        this.writeCsvValue(Integer.toString(index + 1));
        this.writeCsvDelimiterAndValue(rq.getCIsikukoodid());
        this.writeCsvDelimiterAndValue(rq.getCValjad());
        if (index < 0) {
            for (int i = 0; i < HEADERS.length - 4; ++i) {
                this.csvWriter.write(this.csvDelim);
            }
        } else {
            RR441ResponseType.TtIsikuid.TtIsikud ttIsikud = (RR441ResponseType.TtIsikuid.TtIsikud)rsp.getTtIsikuid().getTtIsikud().get(index);
            this.writeCsvDelimiterAndValue(ttIsikud.getTtIsikudCIsikukood());
            this.writeCsvDelimiterAndValue(ttIsikud.getTtIsikudCPerenimi());
            this.writeCsvDelimiterAndValue(ttIsikud.getTtIsikudCEesnimi());
            this.writeCsvDelimiterAndValue(ttIsikud.getTtIsikudCMPerenimed());
            this.writeCsvDelimiterAndValue(ttIsikud.getTtIsikudCMEesnimed());
            this.writeCsvDelimiterAndValue(ttIsikud.getTtIsikudCRiikKood());
            this.writeCsvDelimiterAndValue(ttIsikud.getTtIsikudCRiik());
            this.writeCsvDelimiterAndValue(ttIsikud.getTtIsikudCIsanimi());
            this.writeCsvDelimiterAndValue(ttIsikud.getTtIsikudCSugu());
            this.writeCsvDelimiterAndValue(ttIsikud.getTtIsikudCSynniaeg());
            this.writeCsvDelimiterAndValue(ttIsikud.getTtIsikudCSurmKpv());
            this.writeCsvDelimiterAndValue(ttIsikud.getTtIsikudCTeoVoime());
            this.writeCsvDelimiterAndValue(ttIsikud.getTtIsikudCIsStaatus());
            this.writeCsvDelimiterAndValue(ttIsikud.getTtIsikudCKirjeStaatus());
            this.writeCsvDelimiterAndValue(ttIsikud.getTtIsikudCEKRiik());
            this.writeCsvDelimiterAndValue(ttIsikud.getTtIsikudCEKMaak());
            this.writeCsvDelimiterAndValue(ttIsikud.getTtIsikudCEKVald());
            this.writeCsvDelimiterAndValue(ttIsikud.getTtIsikudCEKAsula());
            this.writeCsvDelimiterAndValue(ttIsikud.getTtIsikudCEKTanav());
            this.writeCsvDelimiterAndValue(ttIsikud.getTtIsikudCEKIndeks());
            this.writeCsvDelimiterAndValue(ttIsikud.getTtIsikudCEKAlgKpv());
            this.writeCsvDelimiterAndValue(ttIsikud.getTtIsikudCEKVallaKpv());
            this.writeCsvDelimiterAndValue(ttIsikud.getTtIsikudCEKAadress());
            this.writeCsvDelimiterAndValue(ttIsikud.getTtIsikudCSynniRiik());
            this.writeCsvDelimiterAndValue(ttIsikud.getTtIsikudCSaabusEestiKpv());
        }
        this.writeCsvDelimiterAndValue(rsp.getFaultCode());
        this.writeCsvDelimiterAndValue(rsp.getFaultString());
        this.csvWriter.write("\r\n");
    }

    private void writeCsvDelimiterAndValue(String value) throws IOException {
        this.csvWriter.write(this.csvDelim);
        if (value != null && !value.isEmpty()) {
            this.writeCsvValue(value);
        }
    }

    private void writeCsvValue(String value) throws IOException {
        if (this.csvQuote != null || this.mustBeQuoted(value)) {
            this.writeCsvValueQuoted(value, this.csvQuote != null ? this.csvQuote.charValue() : (char)'\"');
        } else {
            this.csvWriter.write(value);
        }
    }

    private boolean mustBeQuoted(String value) {
        int l = value.length();
        for (int i = 0; i < l; ++i) {
            char c = value.charAt(i);
            if (c != this.csvDelim && c != '\"' && c != '\r' && c != '\n') continue;
            return true;
        }
        return false;
    }

    private void writeCsvValueQuoted(String value, char quote) throws IOException {
        this.csvWriter.write(quote);
        int l = value.length();
        for (int i = 0; i < l; ++i) {
            char ch = value.charAt(i);
            this.csvWriter.write(ch);
            if (ch != quote) continue;
            this.csvWriter.write(quote);
        }
        this.csvWriter.write(quote);
    }

    private void writeCsvHeaders() throws IOException {
        if (this.csvWriter != null && this.csvHeader) {
            for (int i = 0; i < HEADERS.length; ++i) {
                if (i > 0) {
                    this.csvWriter.write(this.csvDelim);
                }
                if (this.csvQuote != null) {
                    this.csvWriter.write(this.csvQuote.charValue());
                }
                this.csvWriter.write(HEADERS[i]);
                if (this.csvQuote == null) continue;
                this.csvWriter.write(this.csvQuote.charValue());
            }
            this.csvWriter.write("\r\n");
        }
    }

    private RR441ResponseType rr441(RR441RequestType rq) {
        return XRoadUtils.rr441((XRoadAdapterPortType)this.port, (RR441RequestType)rq, (XRoadClientIdentifierType)this.clientIdentifierType, (XRoadServiceIdentifierType)this.serviceIdentifierType, (String)this.userID, (String)this.id, (String)this.protocolVersion, (Holder)new Holder());
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        CLIUtils.addCommonOptions((Options)opts);
        opts.addOption(Option.builder((String)"U").longOpt("url").hasArg().argName("url").desc(rb.getString("url")).build());
        opts.addOption(Option.builder().longOpt("rr441.cValjad").hasArg().argName("value").desc(rb.getString("rr441.cValjad")).build());
        opts.addOption(Option.builder().longOpt("client.objectType").hasArg().argName("value").desc(rb.getString("client.objectType")).build());
        opts.addOption(Option.builder().longOpt("client.xRoadInstance").hasArg().argName("value").desc(rb.getString("client.xRoadInstance")).build());
        opts.addOption(Option.builder().longOpt("client.memberClass").hasArg().argName("value").desc(rb.getString("client.memberClass")).build());
        opts.addOption(Option.builder().longOpt("client.memberCode").hasArg().argName("value").desc(rb.getString("client.memberCode")).build());
        opts.addOption(Option.builder().longOpt("client.subsystemCode").hasArg().argName("value").desc(rb.getString("client.subsystemCode")).build());
        opts.addOption(Option.builder().longOpt("service.objectType").hasArg().argName("value").desc(rb.getString("service.objectType")).build());
        opts.addOption(Option.builder().longOpt("service.xRoadInstance").hasArg().argName("value").desc(rb.getString("service.xRoadInstance")).build());
        opts.addOption(Option.builder().longOpt("service.memberClass").hasArg().argName("value").desc(rb.getString("service.memberClass")).build());
        opts.addOption(Option.builder().longOpt("service.memberCode").hasArg().argName("value").desc(rb.getString("service.memberCode")).build());
        opts.addOption(Option.builder().longOpt("service.subsystemCode").hasArg().argName("value").desc(rb.getString("service.subsystemCode")).build());
        opts.addOption(Option.builder().longOpt("service.serviceVersion").hasArg().argName("value").desc(rb.getString("service.serviceVersion")).build());
        opts.addOption(Option.builder().longOpt("service.serviceCode").hasArg().argName("value").desc(rb.getString("service.serviceCode")).build());
        opts.addOption(Option.builder((String)"u").longOpt("user").hasArg().argName("id").desc(rb.getString("user")).build());
        opts.addOption(Option.builder().longOpt("id").hasArg().argName("value").desc(rb.getString("id")).build());
        opts.addOption(Option.builder().longOpt("protocolVersion").hasArg().argName("value").desc(rb.getString("protocolVersion")).build());
        opts.addOption(Option.builder().longOpt("csv").hasArg().argName("csv-file").desc(rb.getString("csv")).build());
        opts.addOption(Option.builder().longOpt("csv-no-header").desc(rb.getString("csv-no-header")).build());
        opts.addOption(Option.builder().longOpt("csv-delim").hasArg().argName("char").desc(rb.getString("csv-delim")).build());
        opts.addOption(Option.builder().longOpt("csv-quote").hasArg().argName("char").desc(rb.getString("csv-quote")).build());
        opts.addOption(Option.builder((String)"c").desc(rb.getString("continue-on-error")).build());
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, XRoad.class);
    }
}

