/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.clib;

import com.sun.media.imageioimpl.plugins.clib.I18N;
import com.sun.media.imageioimpl.plugins.clib.InputStreamAdapter;
import com.sun.medialib.codec.jiio.mediaLibImage;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public abstract class CLibImageReader
extends ImageReader {
    private int currIndex = -1;
    private long highWaterMark = Long.MIN_VALUE;
    private ArrayList imageStartPosition = new ArrayList();
    private int numImages = -1;
    private mediaLibImage mlibImage = null;
    private int mlibImageIndex = -1;

    private static boolean subBandsMatch(int[] sourceBands, int[] destinationBands) {
        if (sourceBands == null && destinationBands == null) {
            return true;
        }
        if (sourceBands != null && destinationBands != null) {
            if (sourceBands.length != destinationBands.length) {
                return false;
            }
            int i = 0;
            while (i < sourceBands.length) {
                if (sourceBands[i] != destinationBands[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    protected static final ImageTypeSpecifier createImageType(mediaLibImage mlImage, ColorSpace colorSpace, int bitDepth, byte[] redPalette, byte[] greenPalette, byte[] bluePalette, byte[] alphaPalette) throws IOException {
        int dataType;
        int mlibType = mlImage.getType();
        int mlibWidth = mlImage.getWidth();
        int mlibHeight = mlImage.getHeight();
        int mlibBands = mlImage.getChannels();
        int mlibStride = mlImage.getStride();
        switch (mlibType) {
            case 0: 
            case 1: {
                dataType = 0;
                break;
            }
            case 2: 
            case 6: {
                dataType = 1;
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.valueOf(I18N.getString("Generic0")) + " " + mlibType);
            }
        }
        SampleModel sampleModel = null;
        if (mlibType == 0) {
            sampleModel = new MultiPixelPackedSampleModel(dataType, mlibWidth, mlibHeight, 1, mlibStride, mlImage.getBitOffset());
        } else {
            int[] bandOffsets = new int[mlibBands];
            int i = 0;
            while (i < mlibBands) {
                bandOffsets[i] = i;
                ++i;
            }
            sampleModel = new PixelInterleavedSampleModel(dataType, mlibWidth, mlibHeight, mlibBands, mlibStride, bandOffsets);
        }
        ColorModel colorModel = null;
        if (mlibBands == 1 && redPalette != null && greenPalette != null && bluePalette != null && redPalette.length == greenPalette.length && redPalette.length == bluePalette.length) {
            int paletteLength = redPalette.length;
            if (alphaPalette != null) {
                if (alphaPalette.length != paletteLength) {
                    byte[] alphaTmp = new byte[paletteLength];
                    if (alphaPalette.length > paletteLength) {
                        System.arraycopy(alphaPalette, 0, alphaTmp, 0, paletteLength);
                    } else {
                        System.arraycopy(alphaPalette, 0, alphaTmp, 0, alphaPalette.length);
                        int i = alphaPalette.length;
                        while (i < paletteLength) {
                            alphaTmp[i] = -1;
                            ++i;
                        }
                    }
                    alphaPalette = alphaTmp;
                }
                colorModel = new IndexColorModel(bitDepth, paletteLength, redPalette, greenPalette, bluePalette, alphaPalette);
            } else {
                colorModel = new IndexColorModel(bitDepth, paletteLength, redPalette, greenPalette, bluePalette);
            }
        } else if (mlibType == 0) {
            byte[] byArray = new byte[2];
            byArray[1] = -1;
            byte[] cmap = byArray;
            colorModel = new IndexColorModel(1, 2, cmap, cmap, cmap);
        } else {
            boolean hasAlpha;
            ColorSpace cs;
            if (colorSpace != null && (colorSpace.getNumComponents() == mlibBands || colorSpace.getNumComponents() == mlibBands - 1)) {
                cs = colorSpace;
                hasAlpha = colorSpace.getNumComponents() != mlibBands;
            } else {
                cs = ColorSpace.getInstance(mlibBands < 3 ? 1003 : 1000);
                hasAlpha = mlibBands % 2 == 0;
            }
            int[] bits = new int[mlibBands];
            int i = 0;
            while (i < mlibBands) {
                bits[i] = bitDepth;
                ++i;
            }
            colorModel = new ComponentColorModel(cs, bits, hasAlpha, false, hasAlpha ? 3 : 1, dataType);
        }
        return new ImageTypeSpecifier(colorModel, sampleModel);
    }

    private static final void subsample(Raster src, int subX, int subY, WritableRaster dst) {
        int sx0 = src.getMinX();
        int sy0 = src.getMinY();
        int sw = src.getWidth();
        int syUB = sy0 + src.getHeight();
        int dx0 = dst.getMinX();
        int dy0 = dst.getMinY();
        int dw = dst.getWidth();
        int b = src.getSampleModel().getNumBands();
        int t = src.getSampleModel().getDataType();
        int numSubSamples = (sw + subX - 1) / subX;
        if (t == 4 || t == 5) {
            float[] fsamples = new float[sw];
            float[] fsubsamples = new float[numSubSamples];
            int k = 0;
            while (k < b) {
                int sy = sy0;
                int dy = dy0;
                while (sy < syUB) {
                    src.getSamples(sx0, sy, sw, 1, k, fsamples);
                    int i = 0;
                    int s = 0;
                    while (i < sw) {
                        fsubsamples[s] = fsamples[i];
                        ++s;
                        i += subX;
                    }
                    dst.setSamples(dx0, dy, dw, 1, k, fsubsamples);
                    sy += subY;
                    ++dy;
                }
                ++k;
            }
        } else {
            int[] samples = new int[sw];
            int[] subsamples = new int[numSubSamples];
            int k = 0;
            while (k < b) {
                int sy = sy0;
                int dy = dy0;
                while (sy < syUB) {
                    src.getSamples(sx0, sy, sw, 1, k, samples);
                    int i = 0;
                    int s = 0;
                    while (i < sw) {
                        subsamples[s] = samples[i];
                        ++s;
                        i += subX;
                    }
                    dst.setSamples(dx0, dy, dw, 1, k, subsamples);
                    sy += subY;
                    ++dy;
                }
                ++k;
            }
        }
    }

    protected CLibImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    /*
     * Exception decompiling
     */
    private int locateImage(int imageIndex) throws IIOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[DOLOOP]], but top level block is 10[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void seekToImage(int imageIndex) throws IIOException {
        int index;
        if (imageIndex < this.minIndex) {
            throw new IndexOutOfBoundsException("imageIndex < minIndex!");
        }
        if (this.seekForwardOnly) {
            this.minIndex = imageIndex;
        }
        if ((index = this.locateImage(imageIndex)) != imageIndex) {
            throw new IndexOutOfBoundsException("imageIndex out of bounds!");
        }
    }

    protected boolean skipImage() throws IOException {
        long pos;
        boolean retval = false;
        if (this.input == null) {
            throw new IllegalStateException("input == null");
        }
        InputStreamAdapter stream = null;
        if (!(this.input instanceof ImageInputStream)) {
            throw new IllegalArgumentException("!(input instanceof ImageInputStream)");
        }
        stream = new InputStreamAdapter((ImageInputStream)this.input);
        boolean bl = retval = this.decode(stream) != null;
        if (retval && (pos = ((ImageInputStream)this.input).getStreamPosition()) > this.highWaterMark) {
            this.highWaterMark = pos;
        }
        return retval;
    }

    protected abstract mediaLibImage decode(InputStream var1) throws IOException;

    protected synchronized mediaLibImage getImage(int imageIndex) throws IOException {
        if (this.mlibImage == null || imageIndex != this.mlibImageIndex) {
            if (this.input == null) {
                throw new IllegalStateException("input == null");
            }
            this.seekToImage(imageIndex);
            InputStreamAdapter stream = null;
            if (!(this.input instanceof ImageInputStream)) {
                throw new IllegalArgumentException("!(input instanceof ImageInputStream)");
            }
            stream = new InputStreamAdapter((ImageInputStream)this.input);
            this.mlibImage = this.decode(stream);
            if (this.mlibImage != null) {
                this.mlibImageIndex = imageIndex;
                long pos = ((ImageInputStream)this.input).getStreamPosition();
                if (pos > this.highWaterMark) {
                    this.highWaterMark = pos;
                }
            } else {
                this.mlibImageIndex = -1;
            }
        }
        return this.mlibImage;
    }

    protected int getImageIndex() {
        return this.mlibImageIndex;
    }

    public int getNumImages(boolean allowSearch) throws IOException {
        if (this.input == null) {
            throw new IllegalStateException("input == null");
        }
        if (this.seekForwardOnly && allowSearch) {
            throw new IllegalStateException("seekForwardOnly && allowSearch!");
        }
        if (this.numImages > 0) {
            return this.numImages;
        }
        if (allowSearch) {
            this.numImages = this.locateImage(Integer.MAX_VALUE) + 1;
        }
        return this.numImages;
    }

    public int getWidth(int imageIndex) throws IOException {
        this.seekToImage(imageIndex);
        return this.getImage(imageIndex).getWidth();
    }

    public int getHeight(int imageIndex) throws IOException {
        this.seekToImage(imageIndex);
        return this.getImage(imageIndex).getHeight();
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        this.seekToImage(imageIndex);
        return null;
    }

    public synchronized BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        DataBuffer db;
        this.processImageStarted(imageIndex);
        this.seekToImage(imageIndex);
        this.processImageProgress(0.0f);
        this.processImageProgress(0.5f);
        ImageTypeSpecifier rawImageType = this.getRawImageType(imageIndex);
        this.processImageProgress(0.95f);
        mediaLibImage mlImage = this.getImage(imageIndex);
        int dataOffset = mlImage.getOffset();
        SampleModel rawSampleModel = rawImageType.getSampleModel();
        int smType = rawSampleModel.getDataType();
        switch (smType) {
            case 0: {
                byte[] byteData = mlImage.getType() == 0 ? mlImage.getBitData() : mlImage.getByteData();
                db = new DataBufferByte(byteData, byteData.length - dataOffset, dataOffset);
                break;
            }
            case 1: {
                short[] shortData = mlImage.getShortData();
                if (shortData == null) {
                    shortData = mlImage.getUShortData();
                }
                db = new DataBufferUShort(shortData, shortData.length - dataOffset, dataOffset);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.valueOf(I18N.getString("Generic0")) + " " + smType);
            }
        }
        WritableRaster rawRaster = Raster.createWritableRaster(rawSampleModel, db, null);
        ColorModel rawColorModel = rawImageType.getColorModel();
        BufferedImage image = new BufferedImage(rawColorModel, rawRaster, rawColorModel.isAlphaPremultiplied(), null);
        Rectangle destRegion = new Rectangle(image.getWidth(), image.getHeight());
        int[] destinationBands = null;
        int subX = 1;
        int subY = 1;
        if (param != null) {
            boolean isNominal;
            BufferedImage destination = param.getDestination();
            destinationBands = param.getDestinationBands();
            Point destinationOffset = param.getDestinationOffset();
            int[] sourceBands = param.getSourceBands();
            Rectangle sourceRegion = param.getSourceRegion();
            subX = param.getSourceXSubsampling();
            subY = param.getSourceYSubsampling();
            boolean bl = destination == null && destinationBands == null & destinationOffset.x == 0 && destinationOffset.y == 0 && sourceBands == null && sourceRegion == null && subX == 1 && subY == 1 ? true : (isNominal = false);
            if (!isNominal) {
                int srcWidth = image.getWidth();
                int srcHeight = image.getHeight();
                if (destination == null) {
                    destination = CLibImageReader.getDestination(param, this.getImageTypes(imageIndex), srcWidth, srcHeight);
                }
                CLibImageReader.checkReadParamBandSettings(param, image.getSampleModel().getNumBands(), destination.getSampleModel().getNumBands());
                Rectangle srcRegion = new Rectangle();
                CLibImageReader.computeRegions(param, srcWidth, srcHeight, destination, srcRegion, destRegion);
                WritableRaster dst = destination.getWritableTile(0, 0).createWritableChild(destRegion.x, destRegion.y, destRegion.width, destRegion.height, destRegion.x, destRegion.y, destinationBands);
                if (subX != 1 || subY != 1) {
                    WritableRaster src = image.getWritableTile(0, 0).createWritableChild(srcRegion.x, srcRegion.y, srcRegion.width, srcRegion.height, srcRegion.x, srcRegion.y, sourceBands);
                    CLibImageReader.subsample(src, subX, subY, dst);
                } else {
                    WritableRaster src = image.getWritableTile(0, 0).createWritableChild(srcRegion.x, srcRegion.y, srcRegion.width, srcRegion.height, destRegion.x, destRegion.y, sourceBands);
                    dst.setRect(src);
                }
                image = destination;
            } else if (param.getDestinationType() != null) {
                ImageTypeSpecifier destImageType = param.getDestinationType();
                ColorSpace rawColorSpace = rawColorModel.getColorSpace();
                ColorSpace destColorSpace = destImageType.getColorModel().getColorSpace();
                if (!destColorSpace.equals(rawColorSpace) || !destImageType.equals(rawImageType)) {
                    Iterator<ImageTypeSpecifier> imageTypes = this.getImageTypes(imageIndex);
                    boolean isLegalType = false;
                    while (imageTypes.hasNext()) {
                        ImageTypeSpecifier imageType = imageTypes.next();
                        if (!imageType.equals(destImageType)) continue;
                        isLegalType = true;
                        break;
                    }
                    if (isLegalType) {
                        WritableRaster raster;
                        if (rawSampleModel.equals(destImageType.getSampleModel())) {
                            raster = rawRaster;
                        } else {
                            SampleModel sm = destImageType.getSampleModel();
                            raster = Raster.createWritableRaster(sm, null);
                            raster.setRect(rawRaster);
                        }
                        ColorModel cm = destImageType.getColorModel();
                        image = new BufferedImage(cm, raster, cm.isAlphaPremultiplied(), null);
                    }
                }
            }
        }
        this.processImageUpdate(image, destRegion.x, destRegion.y, destRegion.width, destRegion.height, subX, subY, destinationBands);
        this.processImageProgress(1.0f);
        this.processImageComplete();
        return image;
    }

    public void reset() {
        this.resetLocal();
        super.reset();
    }

    protected void resetLocal() {
        this.currIndex = -1;
        this.highWaterMark = Long.MIN_VALUE;
        this.imageStartPosition.clear();
        this.numImages = -1;
        this.mlibImage = null;
        this.mlibImageIndex = -1;
    }

    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        if (input != null && !(input instanceof ImageInputStream)) {
            throw new IllegalArgumentException("!(input instanceof ImageInputStream)");
        }
        this.resetLocal();
    }

    private class SoloIterator
    implements Iterator {
        Object theObject;

        SoloIterator(Object o) {
            if (o == null) {
                new IllegalArgumentException(I18N.getString("CLibImageReader0"));
            }
            this.theObject = o;
        }

        public boolean hasNext() {
            return this.theObject != null;
        }

        public Object next() {
            if (this.theObject == null) {
                throw new NoSuchElementException();
            }
            Object theNextObject = this.theObject;
            this.theObject = null;
            return theNextObject;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

