/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FileTypeBox
extends Box {
    private static String[] elementNames = new String[]{"Brand", "MinorVersion", "CompatibilityList"};
    private int brand;
    private int minorVersion;
    private int[] compatibility;

    public static String[] getElementNames() {
        return elementNames;
    }

    public FileTypeBox(int br, int minorVersion, int[] comp) {
        super(16 + (comp == null ? 0 : comp.length << 2), 1718909296, null);
        this.brand = br;
        this.minorVersion = minorVersion;
        this.compatibility = comp;
    }

    public FileTypeBox(byte[] data) {
        super(8 + data.length, 1718909296, data);
    }

    public FileTypeBox(Node node) throws IIOInvalidTreeException {
        super(node);
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if ("Brand".equals(name)) {
                this.brand = Box.getIntElementValue(child);
            }
            if ("MinorVersion".equals(name)) {
                this.minorVersion = Box.getIntElementValue(child);
            }
            if ("CompatibilityList".equals(name)) {
                this.compatibility = Box.getIntArrayElementValue(child);
            }
            ++i;
        }
    }

    public int getBrand() {
        return this.brand;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int[] getCompatibilityList() {
        return this.compatibility;
    }

    public IIOMetadataNode getNativeNode() {
        return this.getNativeNodeForSimpleBox();
    }

    protected void parse(byte[] data) {
        if (data == null) {
            return;
        }
        this.brand = (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
        this.minorVersion = (data[4] & 0xFF) << 24 | (data[5] & 0xFF) << 16 | (data[6] & 0xFF) << 8 | data[7] & 0xFF;
        int len = (data.length - 8) / 4;
        if (len > 0) {
            this.compatibility = new int[len];
            int i = 0;
            int j = 8;
            while (i < len) {
                this.compatibility[i] = (data[j] & 0xFF) << 24 | (data[j + 1] & 0xFF) << 16 | (data[j + 2] & 0xFF) << 8 | data[j + 3] & 0xFF;
                ++i;
                j += 4;
            }
        }
    }

    protected void compose() {
        if (this.data != null) {
            return;
        }
        this.data = new byte[8 + (this.compatibility != null ? this.compatibility.length << 2 : 0)];
        FileTypeBox.copyInt(this.data, 0, this.brand);
        FileTypeBox.copyInt(this.data, 4, this.minorVersion);
        if (this.compatibility != null) {
            int i = 0;
            int j = 8;
            while (i < this.compatibility.length) {
                FileTypeBox.copyInt(this.data, j, this.compatibility[i]);
                ++i;
                j += 4;
            }
        }
    }
}

