/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageio.plugins.jpeg2000.J2KImageReadParam;
import com.sun.media.imageioimpl.common.SimpleRenderedImage;
import com.sun.media.imageioimpl.plugins.jpeg2000.I18N;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReader;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KMetadata;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KRenderedImageCodecLib;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class J2KImageReaderCodecLib
extends ImageReader {
    private ImageInputStream iis = null;
    private long streamPosition0;
    private boolean gotHeader = false;
    private int width = -1;
    private int height = -1;
    private int tileWidth = -1;
    private int tileHeight = -1;
    private int tileGridXOffset = 0;
    private int tileGridYOffset = 0;
    private J2KMetadata imageMetadata = null;
    SimpleRenderedImage image = null;

    public void processImageUpdateWrapper(BufferedImage theImage, int minX, int minY, int width, int height, int periodX, int periodY, int[] bands) {
        this.processImageUpdate(theImage, minX, minY, width, height, periodX, periodY, bands);
    }

    public void processImageProgressWrapper(float percentageDone) {
        this.processImageProgress(percentageDone);
    }

    public J2KImageReaderCodecLib(ImageReaderSpi originator) {
        super(originator);
    }

    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        this.iis = (ImageInputStream)input;
        this.imageMetadata = null;
        if (input != null) {
            this.iis.mark();
            try {
                this.streamPosition0 = this.iis.getStreamPosition();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public ImageReadParam getDefaultReadParam() {
        return new J2KImageReadParam();
    }

    public int getNumImages(boolean allowSearch) throws IOException {
        if (this.input == null) {
            throw new IllegalStateException(I18N.getString("J2KImageReader6"));
        }
        if (this.seekForwardOnly) {
            throw new IllegalStateException(I18N.getString("J2KImageReader7"));
        }
        return 1;
    }

    public Iterator getImageTypes(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        this.readHeader();
        if (this.image != null) {
            ArrayList<ImageTypeSpecifier> list = new ArrayList<ImageTypeSpecifier>();
            list.add(new ImageTypeSpecifier(this.image.getColorModel(), this.image.getSampleModel()));
            return list.iterator();
        }
        return null;
    }

    public int getWidth(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        this.readHeader();
        return this.width;
    }

    public int getHeight(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        this.readHeader();
        return this.height;
    }

    public int getTileGridXOffset(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        this.readHeader();
        return this.tileGridXOffset;
    }

    public int getTileGridYOffset(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        this.readHeader();
        return this.tileGridYOffset;
    }

    public int getTileWidth(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        this.readHeader();
        return this.tileWidth;
    }

    public int getTileHeight(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        this.readHeader();
        return this.tileHeight;
    }

    public boolean isImageTiled(int imageIndex) throws IOException {
        int w = this.getWidth(imageIndex);
        int tw = this.getTileWidth(imageIndex);
        if (tw > 0 && (w + tw - 1) / tw > 1) {
            return true;
        }
        int h = this.getHeight(imageIndex);
        int th = this.getTileHeight(imageIndex);
        return th > 0 && (h + th - 1) / th > 1;
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        if (this.ignoreMetadata) {
            return null;
        }
        this.checkIndex(imageIndex);
        if (this.imageMetadata == null) {
            try {
                try {
                    this.iis.reset();
                    this.iis.mark();
                    if (this.image == null || !(this.image instanceof J2KRenderedImageCodecLib)) {
                        this.image = new J2KRenderedImageCodecLib(this.iis, this, null);
                    }
                    this.imageMetadata = ((J2KRenderedImageCodecLib)this.image).readImageMetadata();
                }
                catch (IOException ioe) {
                    throw ioe;
                }
                catch (RuntimeException re) {
                    throw re;
                }
            }
            finally {
                this.iis.reset();
                this.iis.mark();
            }
        }
        return this.imageMetadata;
    }

    public boolean isRandomAccessEasy(int imageIndex) throws IOException {
        return true;
    }

    public RenderedImage readAsRenderedImage(int imageIndex, ImageReadParam param) throws IOException {
        this.checkIndex(imageIndex);
        if (param == null) {
            param = this.getDefaultReadParam();
        }
        this.clearAbortRequest();
        this.processImageStarted(0);
        if (param instanceof J2KImageReadParam && ((J2KImageReadParam)param).getResolution() >= 0) {
            J2KImageReader jreader = new J2KImageReader(null);
            this.iis.seek(this.streamPosition0);
            jreader.setInput(this.iis);
            this.image = (SimpleRenderedImage)((ImageReader)jreader).readAsRenderedImage(imageIndex, param);
        } else {
            this.image = new J2KRenderedImageCodecLib(this.iis, this, param);
        }
        if (this.abortRequested()) {
            this.processReadAborted();
        } else {
            this.processImageComplete();
        }
        return this.image;
    }

    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        WritableRaster raster;
        this.checkIndex(imageIndex);
        this.clearAbortRequest();
        if (param == null) {
            param = this.getDefaultReadParam();
        }
        this.processImageStarted(imageIndex);
        if (param instanceof J2KImageReadParam && ((J2KImageReadParam)param).getResolution() >= 0) {
            J2KImageReader jreader = new J2KImageReader(null);
            this.iis.seek(this.streamPosition0);
            jreader.setInput(this.iis);
            if (this.abortRequested()) {
                this.processReadAborted();
            } else {
                this.processImageComplete();
            }
            return ((ImageReader)jreader).read(imageIndex, param);
        }
        BufferedImage bi = param.getDestination();
        this.iis.reset();
        this.iis.mark();
        this.image = new J2KRenderedImageCodecLib(this.iis, this, param);
        J2KRenderedImageCodecLib jclibImage = (J2KRenderedImageCodecLib)this.image;
        Point offset = param.getDestinationOffset();
        if (bi == null) {
            ColorModel colorModel = jclibImage.getColorModel();
            SampleModel sampleModel = jclibImage.getSampleModel();
            ImageTypeSpecifier type = param.getDestinationType();
            if (type != null) {
                colorModel = type.getColorModel();
            }
            raster = Raster.createWritableRaster(sampleModel.createCompatibleSampleModel(jclibImage.getMinX() + jclibImage.getWidth(), jclibImage.getMinY() + jclibImage.getHeight()), new Point(0, 0));
            bi = new BufferedImage(colorModel, raster, colorModel != null ? colorModel.isAlphaPremultiplied() : false, new Hashtable());
        } else {
            raster = bi.getWritableTile(0, 0);
        }
        jclibImage.setDestImage(bi);
        jclibImage.readAsRaster(raster);
        jclibImage.clearDestImage();
        if (this.abortRequested()) {
            this.processReadAborted();
        } else {
            this.processImageComplete();
        }
        return bi;
    }

    public Raster readRaster(int imageIndex, ImageReadParam param) throws IOException {
        BufferedImage bi = this.read(imageIndex, param);
        return bi.getWritableTile(0, 0);
    }

    public void readHeader() throws IOException {
        if (this.gotHeader) {
            return;
        }
        try {
            try {
                this.iis.reset();
                this.iis.mark();
                if (this.image == null) {
                    this.image = new J2KRenderedImageCodecLib(this.iis, this, null);
                }
                this.width = this.image.getWidth();
                this.height = this.image.getHeight();
                this.tileWidth = this.image.getTileWidth();
                this.tileHeight = this.image.getTileHeight();
                this.tileGridXOffset = this.image.getTileGridXOffset();
                this.tileGridYOffset = this.image.getTileGridYOffset();
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (RuntimeException re) {
                throw re;
            }
        }
        finally {
            this.iis.reset();
            this.iis.mark();
        }
        this.gotHeader = true;
    }

    private void checkIndex(int imageIndex) {
        if (this.input == null) {
            throw new IllegalStateException(I18N.getString("J2KImageReader6"));
        }
        if (imageIndex != 0) {
            throw new IndexOutOfBoundsException(I18N.getString("J2KImageReader4"));
        }
    }

    public boolean getAbortRequest() {
        return this.abortRequested();
    }

    public void reset() {
        super.reset();
        this.iis = null;
        this.gotHeader = false;
        this.width = -1;
        this.height = -1;
        this.tileWidth = -1;
        this.tileHeight = -1;
        this.tileGridXOffset = 0;
        this.tileGridYOffset = 0;
        this.imageMetadata = null;
        this.image = null;
    }
}

