/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFDecompressor;
import com.sun.media.imageioimpl.plugins.tiff.I18N;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.imageio.IIOException;

public class TIFFDeflateDecompressor
extends TIFFDecompressor {
    private static final boolean DEBUG = false;
    Inflater inflater = new Inflater();
    int predictor;

    public TIFFDeflateDecompressor(int predictor) throws IIOException {
        if (predictor != 1 && predictor != 2) {
            throw new IIOException("Illegal value for Predictor in TIFF file");
        }
        this.predictor = predictor;
    }

    public synchronized void decodeRaw(byte[] b, int dstOffset, int bitsPerPixel, int scanlineStride) throws IOException {
        int bufOffset;
        byte[] buf;
        if (this.predictor == 2) {
            int len = this.bitsPerSample.length;
            int i = 0;
            while (i < len) {
                if (this.bitsPerSample[i] != 8) {
                    throw new IIOException(String.valueOf(this.bitsPerSample[i]) + "-bit samples " + "are not supported for Horizontal " + "differencing Predictor");
                }
                ++i;
            }
        }
        this.stream.seek(this.offset);
        byte[] srcData = new byte[this.byteCount];
        this.stream.readFully(srcData);
        int bytesPerRow = (this.srcWidth * bitsPerPixel + 7) / 8;
        if (bytesPerRow == scanlineStride) {
            buf = b;
            bufOffset = dstOffset;
        } else {
            buf = new byte[bytesPerRow * this.srcHeight];
            bufOffset = 0;
        }
        this.inflater.setInput(srcData);
        try {
            this.inflater.inflate(buf, bufOffset, bytesPerRow * this.srcHeight);
        }
        catch (DataFormatException dfe) {
            throw new IIOException(I18N.getString("TIFFDeflateDecompressor0"), dfe);
        }
        this.inflater.reset();
        if (this.predictor == 2) {
            int j = 0;
            while (j < this.srcHeight) {
                int count = bufOffset + this.samplesPerPixel * (j * this.srcWidth + 1);
                int i = this.samplesPerPixel;
                while (i < this.srcWidth * this.samplesPerPixel) {
                    int n = count;
                    buf[n] = (byte)(buf[n] + buf[count - this.samplesPerPixel]);
                    ++count;
                    ++i;
                }
                ++j;
            }
        }
        if (bytesPerRow != scanlineStride) {
            int off = 0;
            int y = 0;
            while (y < this.srcHeight) {
                System.arraycopy(buf, off, b, dstOffset, bytesPerRow);
                off += bytesPerRow;
                dstOffset += scanlineStride;
                ++y;
            }
        }
    }
}

