/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.BaselineTIFFTagSet;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageioimpl.plugins.tiff.TIFFBaseJPEGCompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFIFD;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageMetadata;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Iterator;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public class TIFFJPEGCompressor
extends TIFFBaseJPEGCompressor {
    private static final boolean DEBUG = false;
    static final int CHROMA_SUBSAMPLING = 2;

    private static ImageReader getJPEGTablesReader() {
        ImageReader jpegReader = null;
        try {
            IIORegistry registry = IIORegistry.getDefaultInstance();
            Class<?> imageReaderClass = Class.forName("javax.imageio.spi.ImageReaderSpi");
            Iterator<?> readerSPIs = registry.getServiceProviders(imageReaderClass, new JPEGSPIFilter(), true);
            if (readerSPIs.hasNext()) {
                ImageReaderSpi jpegReaderSPI = (ImageReaderSpi)readerSPIs.next();
                jpegReader = jpegReaderSPI.createReaderInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jpegReader;
    }

    public TIFFJPEGCompressor(ImageWriteParam param) {
        super("JPEG", 7, false, param);
    }

    public void setMetadata(IIOMetadata metadata) {
        super.setMetadata(metadata);
        if (metadata instanceof TIFFImageMetadata) {
            TIFFImageMetadata tim = (TIFFImageMetadata)metadata;
            TIFFIFD rootIFD = tim.getRootIFD();
            BaselineTIFFTagSet base = BaselineTIFFTagSet.getInstance();
            TIFFField f = tim.getTIFFField(277);
            int numBands = f.getAsInt(0);
            if (numBands == 1) {
                rootIFD.removeTIFFField(530);
                rootIFD.removeTIFFField(531);
                rootIFD.removeTIFFField(532);
            } else {
                TIFFField YCbCrSubSamplingField = new TIFFField(base.getTag(530), 3, 2, new char[]{'\u0002', '\u0002'});
                rootIFD.addTIFFField(YCbCrSubSamplingField);
                TIFFField YCbCrPositioningField = new TIFFField(base.getTag(531), 3, 1, new char[]{'\u0001'});
                rootIFD.addTIFFField(YCbCrPositioningField);
                long[][] lArrayArray = new long[6][];
                long[] lArray = new long[2];
                lArray[1] = 1L;
                lArrayArray[0] = lArray;
                lArrayArray[1] = new long[]{255L, 1L};
                lArrayArray[2] = new long[]{128L, 1L};
                lArrayArray[3] = new long[]{255L, 1L};
                lArrayArray[4] = new long[]{128L, 1L};
                lArrayArray[5] = new long[]{255L, 1L};
                TIFFField referenceBlackWhiteField = new TIFFField(base.getTag(532), 5, 6, lArrayArray);
                rootIFD.addTIFFField(referenceBlackWhiteField);
            }
            TIFFField JPEGTablesField = tim.getTIFFField(347);
            if (JPEGTablesField != null) {
                this.initJPEGWriter(true, false);
            }
            if (JPEGTablesField != null && this.JPEGWriter != null) {
                block15: {
                    this.writeAbbreviatedStream = true;
                    if (JPEGTablesField.getCount() > 0) {
                        byte[] tables = JPEGTablesField.getAsBytes();
                        ByteArrayInputStream bais = new ByteArrayInputStream(tables);
                        MemoryCacheImageInputStream iis = new MemoryCacheImageInputStream(bais);
                        ImageReader jpegReader = TIFFJPEGCompressor.getJPEGTablesReader();
                        jpegReader.setInput(iis);
                        try {
                            try {
                                this.JPEGStreamMetadata = jpegReader.getStreamMetadata();
                            }
                            catch (Exception e) {
                                this.JPEGStreamMetadata = null;
                                jpegReader.reset();
                                break block15;
                            }
                        }
                        catch (Throwable throwable) {
                            jpegReader.reset();
                            throw throwable;
                        }
                        jpegReader.reset();
                    }
                }
                if (this.JPEGStreamMetadata == null) {
                    this.JPEGStreamMetadata = this.JPEGWriter.getDefaultStreamMetadata(this.JPEGParam);
                    ByteArrayOutputStream tableByteStream = new ByteArrayOutputStream();
                    MemoryCacheImageOutputStream tableStream = new MemoryCacheImageOutputStream(tableByteStream);
                    this.JPEGWriter.setOutput(tableStream);
                    try {
                        this.JPEGWriter.prepareWriteSequence(this.JPEGStreamMetadata);
                        tableStream.flush();
                        this.JPEGWriter.endWriteSequence();
                        byte[] tables = tableByteStream.toByteArray();
                        JPEGTablesField = new TIFFField(base.getTag(347), 7, tables.length, tables);
                        rootIFD.addTIFFField(JPEGTablesField);
                    }
                    catch (Exception e) {
                        rootIFD.removeTIFFField(347);
                        this.writeAbbreviatedStream = false;
                    }
                }
            } else {
                rootIFD.removeTIFFField(347);
                this.initJPEGWriter(false, false);
            }
        }
    }

    private static class JPEGSPIFilter
    implements ServiceRegistry.Filter {
        JPEGSPIFilter() {
        }

        public boolean filter(Object provider) {
            ImageReaderSpi readerSPI = (ImageReaderSpi)provider;
            if (readerSPI != null) {
                String streamMetadataName = readerSPI.getNativeStreamMetadataFormatName();
                if (streamMetadataName != null) {
                    return streamMetadataName.equals("javax_imageio_jpeg_stream_1.0");
                }
                return false;
            }
            return false;
        }
    }
}

