/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.util;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.Supplier;
import org.weasis.core.util.StringUtil;

public class LangUtil {
    private LangUtil() {
    }

    public static <T> Iterable<T> emptyIfNull(Iterable<T> iterable) {
        return iterable == null ? Collections.emptyList() : iterable;
    }

    public static <T> Supplier<T> memoize(final Supplier<T> original) {
        return new Supplier<T>(){
            Supplier<T> delegate = this::firstTime;
            boolean initialized;

            @Override
            public T get() {
                return this.delegate.get();
            }

            private synchronized T firstTime() {
                if (!this.initialized) {
                    Object value = original.get();
                    this.delegate = () -> value;
                    this.initialized = true;
                }
                return this.delegate.get();
            }
        };
    }

    public static boolean getNULLtoFalse(Boolean val) {
        if (val != null) {
            return val;
        }
        return false;
    }

    public static boolean getNULLtoTrue(Boolean val) {
        if (val != null) {
            return val;
        }
        return true;
    }

    public static boolean getEmptytoFalse(String val) {
        if (StringUtil.hasText(val)) {
            return LangUtil.getBoolean(val);
        }
        return false;
    }

    public static boolean geEmptytoTrue(String val) {
        if (StringUtil.hasText(val)) {
            return LangUtil.getBoolean(val);
        }
        return true;
    }

    private static boolean getBoolean(String val) {
        return Boolean.TRUE.toString().equalsIgnoreCase(val);
    }

    public static OptionalDouble getOptionalDouble(Double val) {
        return val == null ? OptionalDouble.empty() : OptionalDouble.of(val);
    }

    public static OptionalInt getOptionalInteger(Integer val) {
        return val == null ? OptionalInt.empty() : OptionalInt.of(val);
    }

    public static Buffer safeBufferType(ByteBuffer buf) {
        return buf;
    }
}

