/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.util;

import java.awt.geom.Point2D;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class MathUtil {
    public static final double DOUBLE_EPSILON = 1.0E-6;
    public static final double FLOAT_EPSILON = 1.0E-5;

    private MathUtil() {
    }

    public static boolean isEqualToZero(float val) {
        return Math.copySign((double)val, 1.0) < 1.0E-5;
    }

    public static boolean isDifferentFromZero(float val) {
        return Math.copySign((double)val, 1.0) > 1.0E-5;
    }

    public static boolean isEqual(float a, float b) {
        return Math.copySign((double)(a - b), 1.0) <= 1.0E-5 || a == b || Float.isNaN(a) && Float.isNaN(b);
    }

    public static boolean isDifferent(float a, float b) {
        return Math.copySign((double)(a - b), 1.0) >= 1.0E-5;
    }

    public static boolean isEqualToZero(double val) {
        return Math.copySign(val, 1.0) < 1.0E-6;
    }

    public static boolean isDifferentFromZero(double val) {
        return Math.copySign(val, 1.0) > 1.0E-6;
    }

    public static boolean isEqual(double a, double b) {
        return Math.copySign(a - b, 1.0) <= 1.0E-6 || a == b || Double.isNaN(a) && Double.isNaN(b);
    }

    public static boolean isDifferent(double a, double b) {
        return Math.copySign(a - b, 1.0) >= 1.0E-6;
    }

    public static Double getOrientation(Point2D p1, Point2D p2) {
        return p1 != null && p2 != null ? Double.valueOf(MathUtil.getOrientation(p1.getX(), p1.getY(), p2.getX(), p2.getY())) : null;
    }

    public static double getOrientation(double x1, double y1, double x2, double y2) {
        double teta = Math.atan2(y1 - y2, x1 - x2);
        double angle = Math.toDegrees(teta);
        angle = angle < 0.0 ? -angle : 180.0 - angle;
        return angle;
    }

    public static Double getAzimuth(Point2D p1, Point2D p2) {
        return p1 != null && p2 != null ? Double.valueOf(MathUtil.getAzimuth(p1.getX(), p1.getY(), p2.getX(), p2.getY())) : null;
    }

    public static double getAzimuth(double x1, double y1, double x2, double y2) {
        double angle = Math.toDegrees(Math.atan2(y2 - y1, x2 - x1));
        angle = (angle + 450.0) % 360.0;
        return angle;
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = BigDecimal.valueOf(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }
}

