/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.util;

public class NativeLibrary {
    private NativeLibrary() {
    }

    public static String getNativeLibSpecification() {
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = System.getProperty("os.arch").toLowerCase();
        if (osName.startsWith("win")) {
            osName = "windows";
        } else if (osName.startsWith("mac")) {
            osName = "macosx";
        } else if (osName.startsWith("linux")) {
            osName = "linux";
        } else {
            switch (osName) {
                case "symbianos": {
                    osName = "epoc32";
                    break;
                }
                case "hp-ux": {
                    osName = "hpux";
                    break;
                }
                case "os/2": {
                    osName = "os2";
                    break;
                }
                case "procnto": {
                    osName = "qnx";
                    break;
                }
                default: {
                    osName = osName.toLowerCase();
                }
            }
        }
        osArch = switch (osArch) {
            case "x86-64", "amd64", "em64t", "x86_64" -> "x86-64";
            case "aarch64", "arm64" -> "aarch64";
            case "arm" -> "armv7a";
            case "pentium", "i386", "i486", "i586", "i686" -> "x86";
            case "power ppc" -> "powerpc";
            case "psc1k" -> "ignite";
            default -> osArch;
        };
        return osName + "-" + osArch;
    }

    public static void main(String[] args) {
        System.out.println(NativeLibrary.getNativeLibSpecification());
    }
}

