/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.opencv.data;

import org.opencv.core.Mat;
import org.opencv.core.Range;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.weasis.opencv.data.PlanarImage;

public class ImageCV
extends Mat
implements PlanarImage {
    private boolean releasedAfterProcessing;
    private boolean hasBeenReleased = false;

    public ImageCV() {
    }

    public ImageCV(int rows, int cols, int type) {
        super(rows, cols, type);
    }

    public ImageCV(Size size, int type, Scalar s) {
        super(size, type, s);
    }

    public ImageCV(int rows, int cols, int type, Scalar s) {
        super(rows, cols, type, s);
    }

    public ImageCV(Mat m, Range rowRange, Range colRange) {
        super(m, rowRange, colRange);
    }

    public ImageCV(Mat m, Range rowRange) {
        super(m, rowRange);
    }

    public ImageCV(Mat m, Rect roi) {
        super(m, roi);
    }

    public ImageCV(Size size, int type) {
        super(size, type);
    }

    @Override
    public long physicalBytes() {
        return this.total() * this.elemSize();
    }

    public static Mat toMat(PlanarImage source) {
        if (source instanceof Mat) {
            Mat mat = (Mat)((Object)source);
            return mat;
        }
        throw new IllegalAccessError("Not implemented yet");
    }

    public static ImageCV toImageCV(Mat source) {
        if (source instanceof ImageCV) {
            ImageCV img = (ImageCV)source;
            return img;
        }
        ImageCV dstImg = new ImageCV();
        source.assignTo(dstImg);
        return dstImg;
    }

    @Override
    public void release() {
        if (!this.hasBeenReleased) {
            super.release();
            this.hasBeenReleased = true;
        }
    }

    @Override
    public boolean isHasBeenReleased() {
        return this.hasBeenReleased;
    }

    @Override
    public boolean isReleasedAfterProcessing() {
        return this.releasedAfterProcessing;
    }

    @Override
    public void setReleasedAfterProcessing(boolean releasedAfterProcessing) {
        this.releasedAfterProcessing = releasedAfterProcessing;
    }

    @Override
    public void close() {
        this.release();
    }
}

