/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.opencv.data;

import org.opencv.core.Mat;
import org.opencv.core.Size;
import org.weasis.opencv.data.ImageCV;
import org.weasis.opencv.data.ImageSize;

public interface PlanarImage
extends ImageSize,
AutoCloseable {
    public int channels();

    public int dims();

    public int depth();

    public long elemSize();

    public long elemSize1();

    public void release();

    public Size size();

    public int type();

    public int height();

    public int width();

    public double[] get(int var1, int var2);

    public int get(int var1, int var2, byte[] var3);

    public int get(int var1, int var2, short[] var3);

    public int get(int var1, int var2, int[] var3);

    public int get(int var1, int var2, float[] var3);

    public int get(int var1, int var2, double[] var3);

    public void assignTo(Mat var1);

    public boolean isHasBeenReleased();

    public boolean isReleasedAfterProcessing();

    public void setReleasedAfterProcessing(boolean var1);

    @Override
    public void close();

    default public Mat toMat() {
        PlanarImage planarImage = this;
        if (planarImage instanceof Mat) {
            Mat mat = (Mat)((Object)planarImage);
            return mat;
        }
        throw new IllegalAccessError("Not implemented yet");
    }

    default public ImageCV toImageCV() {
        if (this instanceof Mat) {
            PlanarImage planarImage = this;
            if (planarImage instanceof ImageCV) {
                ImageCV img = (ImageCV)planarImage;
                return img;
            }
            ImageCV dstImg = new ImageCV();
            this.assignTo(dstImg);
            return dstImg;
        }
        throw new IllegalAccessError("Not implemented yet");
    }
}

