/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.opencv.op.tile;

import org.opencv.core.Mat;
import org.opencv.core.Rect;
import org.weasis.core.util.annotations.Generated;
import org.weasis.opencv.op.tile.TiledProcessor;

@Generated
public class TiledAlgorithm {
    private final int mTileSize;
    private final int mPadding;
    private final int mBorderType;

    TiledAlgorithm(int tileSize, int padding, int borderType) {
        this.mTileSize = tileSize;
        this.mPadding = padding;
        this.mBorderType = borderType;
    }

    void process(Mat sourceImage, Mat resultImage) {
        if (sourceImage.rows() != resultImage.rows() || sourceImage.cols() != resultImage.cols()) {
            throw new IllegalStateException("");
        }
        int rows = sourceImage.rows() / this.mTileSize + (sourceImage.rows() % this.mTileSize != 0 ? 1 : 0);
        int cols = sourceImage.cols() / this.mTileSize + (sourceImage.cols() % this.mTileSize != 0 ? 1 : 0);
        Mat tileInput = new Mat();
        Mat tileOutput = new Mat();
        for (int rowTile = 0; rowTile < rows; ++rowTile) {
            for (int colTile = 0; colTile < cols; ++colTile) {
                Rect srcTile = new Rect(colTile * this.mTileSize - this.mPadding, rowTile * this.mTileSize - this.mPadding, this.mTileSize + 2 * this.mPadding, this.mTileSize + 2 * this.mPadding);
                Rect dstTile = new Rect(colTile * this.mTileSize, rowTile * this.mTileSize, this.mTileSize, this.mTileSize);
                this.copySourceTile(sourceImage, tileInput, srcTile);
                this.processTileImpl(tileInput, tileOutput);
                this.copyTileToResultImage(tileOutput, resultImage, dstTile);
            }
        }
    }

    private void copyTileToResultImage(Mat tileOutput, Mat resultImage, Rect dstTile) {
        Rect srcTile = new Rect(this.mPadding, this.mPadding, this.mTileSize, this.mTileSize);
        int x = dstTile.x;
        int y = dstTile.y;
        if (x >= resultImage.cols()) {
            dstTile.width -= x - resultImage.cols();
            srcTile.width -= x - resultImage.cols();
        }
        if (y >= resultImage.rows()) {
            dstTile.height -= y - resultImage.rows();
            srcTile.height -= y - resultImage.rows();
        }
        Mat tileView = tileOutput.submat(srcTile);
        Mat dstView = resultImage.submat(dstTile);
        assert (tileView.rows() == dstView.rows());
        assert (tileView.cols() == dstView.cols());
        tileView.copyTo(dstView);
    }

    private void processTileImpl(Mat tileInput, Mat tileOutput) {
    }

    private void copySourceTile(Mat sourceImage, Mat tileInput, Rect tile) {
        TiledProcessor.copyTileFromSource(sourceImage, tileInput, tile, this.mBorderType, tile.x, tile.y);
    }
}

