/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.opencv.op.tile;

import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.weasis.core.util.annotations.Generated;

@Generated
public class TiledProcessor {
    public Mat blur(Mat input, int numberOfTimes) {
        Mat destImage = input.clone();
        for (int i = 0; i < numberOfTimes; ++i) {
            Mat sourceImage = destImage.clone();
            this.process(sourceImage, destImage, 256);
        }
        return destImage;
    }

    public void process(Mat sourceImage, Mat resultImage, int tileSize) {
        if (sourceImage.rows() != resultImage.rows() || sourceImage.cols() != resultImage.cols()) {
            throw new IllegalStateException("");
        }
        int rowTiles = sourceImage.rows() / tileSize + (sourceImage.rows() % tileSize != 0 ? 1 : 0);
        int colTiles = sourceImage.cols() / tileSize + (sourceImage.cols() % tileSize != 0 ? 1 : 0);
        Mat tileInput = new Mat(tileSize, tileSize, sourceImage.type());
        Mat tileOutput = new Mat(tileSize, tileSize, sourceImage.type());
        int boderType = 4;
        int mPadding = 3;
        for (int rowTile = 0; rowTile < rowTiles; ++rowTile) {
            for (int colTile = 0; colTile < colTiles; ++colTile) {
                Rect srcTile = new Rect(colTile * tileSize - mPadding, rowTile * tileSize - mPadding, tileSize + 2 * mPadding, tileSize + 2 * mPadding);
                Rect dstTile = new Rect(colTile * tileSize, rowTile * tileSize, tileSize, tileSize);
                TiledProcessor.copyTileFromSource(sourceImage, tileInput, srcTile, boderType, 0, 0);
                this.processTileImpl(tileInput, tileOutput);
                this.copyTileToResultImage(tileOutput, resultImage, new Rect(mPadding, mPadding, tileSize, tileSize), dstTile);
            }
        }
    }

    private void copyTileToResultImage(Mat tileOutput, Mat resultImage, Rect srcTile, Rect dstTile) {
        Point br = dstTile.br();
        if (br.x >= (double)resultImage.cols()) {
            dstTile.width = (int)((double)dstTile.width - (br.x - (double)resultImage.cols()));
            srcTile.width = (int)((double)srcTile.width - (br.x - (double)resultImage.cols()));
        }
        if (br.y >= (double)resultImage.rows()) {
            dstTile.height = (int)((double)dstTile.height - (br.y - (double)resultImage.rows()));
            srcTile.height = (int)((double)srcTile.height - (br.y - (double)resultImage.rows()));
        }
        Mat tileView = tileOutput.submat(srcTile);
        Mat dstView = resultImage.submat(dstTile);
        assert (tileView.rows() == dstView.rows());
        assert (tileView.cols() == dstView.cols());
        tileView.copyTo(dstView);
    }

    private void processTileImpl(Mat tileInput, Mat tileOutput) {
        Imgproc.blur(tileInput, tileOutput, new Size(7.0, 7.0));
    }

    static void copyTileFromSource(Mat sourceImage, Mat tileInput, Rect tile, int mBorderType, int borderX, int borderY) {
        int tx = 0;
        int ty = 0;
        int bx = 0;
        int by = 0;
        if (tile.x < 0) {
            tx = -tile.x;
            tile.x = 0;
        }
        if (tile.y < 0) {
            ty = -tile.y;
            tile.y = 0;
        }
        if (borderX >= sourceImage.cols()) {
            bx = borderX - sourceImage.cols() + 1;
            tile.width -= bx;
        }
        if (borderY >= sourceImage.rows()) {
            by = borderY - sourceImage.rows() + 1;
            tile.height -= by;
        }
        if (tx > 0 || ty > 0 || bx > 0 || by > 0) {
            Rect paddedTile = new Rect(tile.tl(), tile.br());
            assert (paddedTile.x >= 0);
            assert (paddedTile.y >= 0);
            assert (paddedTile.br().x < (double)sourceImage.cols());
            assert (paddedTile.br().y < (double)sourceImage.rows());
            Core.copyMakeBorder(sourceImage.submat(paddedTile), tileInput, ty, by, tx, bx, mBorderType);
        } else {
            sourceImage.submat(tile).copyTo(tileInput);
        }
    }
}

