/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.opencv.seg;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.weasis.core.util.StringUtil;
import org.weasis.opencv.op.lut.ColorLut;
import org.weasis.opencv.seg.Region;

public class RegionAttributes
implements Comparable<RegionAttributes> {
    private final int id;
    private String label;
    private String description;
    private String type;
    private Color color;
    private boolean filled;
    private float lineThickness;
    private boolean visible;
    private float interiorOpacity;
    protected long numberOfPixels;

    public RegionAttributes(int id, String label) {
        this(id, label, null);
    }

    public RegionAttributes(int id, String label, Color color) {
        if (!StringUtil.hasText(label)) {
            throw new IllegalArgumentException("Label cannot be null or empty");
        }
        this.setLabel(label);
        this.id = id;
        this.description = null;
        this.type = null;
        this.color = color;
        this.filled = true;
        this.lineThickness = 1.0f;
        this.visible = true;
        this.interiorOpacity = 1.0f;
        this.numberOfPixels = -1L;
    }

    public int getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean isFilled() {
        return this.filled;
    }

    public void setFilled(boolean filled) {
        this.filled = filled;
    }

    public float getLineThickness() {
        return this.lineThickness;
    }

    public void setLineThickness(float lineThickness) {
        this.lineThickness = lineThickness;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public float getInteriorOpacity() {
        return this.interiorOpacity;
    }

    public void setInteriorOpacity(float interiorOpacity) {
        this.interiorOpacity = Math.max(0.0f, Math.min(interiorOpacity, 1.0f));
    }

    public long getNumberOfPixels() {
        return this.numberOfPixels;
    }

    public String getPrefix() {
        return this.getLabel().split("[ _-]")[0];
    }

    public void addPixels(Region region) {
        if (region == null || region.getNumberOfPixels() < 0L) {
            return;
        }
        if (this.numberOfPixels < 0L) {
            this.resetPixelCount();
        }
        this.numberOfPixels += region.getNumberOfPixels();
    }

    public void resetPixelCount() {
        this.numberOfPixels = 0L;
    }

    public static <E extends RegionAttributes> Map<String, List<E>> groupRegions(Collection<E> regions) {
        HashMap<String, List<E>> map = new HashMap<String, List<E>>();
        for (RegionAttributes region : regions) {
            String prefix = region.getPrefix();
            List list = map.computeIfAbsent(prefix, l -> new ArrayList());
            int index = Collections.binarySearch(list, region, RegionAttributes::compareTo);
            if (index < 0) {
                list.add(-(index + 1), region);
                continue;
            }
            list.add(index, region);
        }
        return map;
    }

    public static Color getColor(int[] colorRgb, int contourID) {
        return RegionAttributes.getColor(colorRgb, contourID, 1.0f);
    }

    public static Color getColor(int[] colorRgb, int contourID, float opacity) {
        Color rgbColor;
        int opacityInt = (int)(opacity * 255.0f);
        if (colorRgb == null || colorRgb.length < 3) {
            byte[][] lut = ColorLut.MULTICOLOR.getByteLut().lutTable();
            int lutIndex = contourID % 256;
            rgbColor = new Color(lut[0][lutIndex] & 0xFF, lut[1][lutIndex] & 0xFF, lut[2][lutIndex] & 0xFF, opacityInt);
        } else {
            rgbColor = new Color(colorRgb[0], colorRgb[1], colorRgb[2], opacityInt);
        }
        return rgbColor;
    }

    @Override
    public int compareTo(RegionAttributes o) {
        return StringUtil.collator.compare(this.getLabel(), o.getLabel());
    }
}

