/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.conf.api.hl7;

import org.dcm4che3.conf.api.ConfigurationCache;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.ConfigurationNotFoundException;
import org.dcm4che3.conf.api.hl7.HL7Configuration;
import org.dcm4che3.conf.api.hl7.IHL7ApplicationCache;
import org.dcm4che3.net.hl7.HL7Application;

public class HL7ApplicationCache
extends ConfigurationCache<HL7Configuration, HL7Application>
implements IHL7ApplicationCache {
    public HL7ApplicationCache(HL7Configuration conf) {
        super((Object)conf);
    }

    protected HL7Application find(HL7Configuration conf, String key) throws ConfigurationException {
        return conf.findHL7Application(key);
    }

    @Override
    public HL7Application findHL7Application(String hl7AppFacility) throws ConfigurationException {
        HL7Application hl7App = (HL7Application)this.get(hl7AppFacility);
        if (hl7App == null) {
            throw new ConfigurationNotFoundException("Unknown HL7 Application: " + hl7AppFacility);
        }
        return hl7App;
    }
}

