/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.conf.ldap.audit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchResult;
import org.dcm4che3.conf.api.ConfigurationChanges;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.ldap.LdapDicomConfigurationExtension;
import org.dcm4che3.conf.ldap.LdapUtils;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DeviceExtension;
import org.dcm4che3.net.audit.AuditLogger;
import org.dcm4che3.net.audit.AuditLoggerDeviceExtension;
import org.dcm4che3.net.audit.AuditSuppressCriteria;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapAuditLoggerConfiguration
extends LdapDicomConfigurationExtension {
    private static final Logger LOG = LoggerFactory.getLogger(LdapAuditLoggerConfiguration.class);

    protected void storeChilds(ConfigurationChanges diffs, String deviceDN, Device device) throws NamingException {
        AuditLoggerDeviceExtension auditLoggerExt = (AuditLoggerDeviceExtension)device.getDeviceExtension(AuditLoggerDeviceExtension.class);
        if (auditLoggerExt == null) {
            return;
        }
        for (AuditLogger auditLogger : auditLoggerExt.getAuditLoggers()) {
            this.store(diffs, deviceDN, auditLogger);
        }
    }

    private void store(ConfigurationChanges diffs, String deviceDN, AuditLogger logger) throws NamingException {
        String appDN = this.auditLoggerDN(logger.getCommonName(), deviceDN);
        ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)appDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
        this.config.createSubcontext(appDN, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), logger, deviceDN, new BasicAttributes(true)));
        for (AuditSuppressCriteria criteria : logger.getAuditSuppressCriteriaList()) {
            String dn = LdapUtils.dnOf((String)"cn", (String)criteria.getCommonName(), (String)appDN);
            ConfigurationChanges.ModifiedObject ldapObj1 = ConfigurationChanges.addModifiedObjectIfVerbose((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
            this.config.createSubcontext(dn, this.storeTo(ldapObj1, criteria, new BasicAttributes(true)));
        }
    }

    private String auditLoggerDN(String name, String deviceDN) {
        return LdapUtils.dnOf((String)"cn", (String)name, (String)deviceDN);
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, AuditLogger logger, String deviceDN, Attributes attrs) {
        attrs.put(new BasicAttribute("objectclass", "dcmAuditLogger"));
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"cn", (Object)logger.getCommonName(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditFacility", (int)logger.getFacility().ordinal(), (int)10);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditSuccessSeverity", (int)logger.getSuccessSeverity().ordinal(), (int)5);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditMinorFailureSeverity", (int)logger.getMinorFailureSeverity().ordinal(), (int)4);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditSeriousFailureSeverity", (int)logger.getSeriousFailureSeverity().ordinal(), (int)3);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditMajorFailureSeverity", (int)logger.getMajorFailureSeverity().ordinal(), (int)2);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditSourceID", (Object)logger.getAuditSourceID(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditEnterpriseSiteID", (Object)logger.getAuditEnterpriseSiteID(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditSourceTypeCode", (Object[])logger.getAuditSourceTypeCodes(), (Object[])new String[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditApplicationName", (Object)logger.getApplicationName(), null);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditMessageID", (Object)logger.getMessageID(), (Object)"IHE+RFC-3881");
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditMessageEncoding", (Object)logger.getEncoding(), (Object)"UTF-8");
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditMessageSchemaURI", (Object)logger.getSchemaURI(), (Object)"http://www.dcm4che.org/DICOM/audit-message.rnc");
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditMessageBOM", (boolean)logger.isIncludeBOM(), (boolean)true);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditMessageFormatXML", (boolean)logger.isFormatXML(), (boolean)false);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditTimestampInUTC", (boolean)logger.isTimestampInUTC(), (boolean)false);
        LdapUtils.storeConnRefs((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (Collection)logger.getConnections(), (String)deviceDN);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditRecordRepositoryDeviceReference", (Object)this.config.deviceRef(logger.getAuditRecordRepositoryDeviceNameNotNull()), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditIncludeInstanceUID", (boolean)logger.isIncludeInstanceUID(), (boolean)false);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditLoggerSpoolDirectoryURI", (Object)logger.getSpoolDirectoryURI(), null);
        LdapUtils.storeNotDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditLoggerRetryInterval", (int)logger.getRetryInterval(), (int)0);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dicomInstalled", (Object)logger.getInstalled(), null);
        return attrs;
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, AuditSuppressCriteria criteria, BasicAttributes attrs) {
        attrs.put(new BasicAttribute("objectclass", "dcmAuditSuppressCriteria"));
        attrs.put(new BasicAttribute("cn", criteria.getCommonName()));
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditEventID", (Object[])criteria.getEventIDsAsStringArray(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditEventTypeCode", (Object[])criteria.getEventTypeCodesAsStringArray(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditEventActionCode", (Object[])criteria.getEventActionCodes(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditEventOutcomeIndicator", (Object[])criteria.getEventOutcomeIndicators(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditUserID", (Object[])criteria.getUserIDs(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditAlternativeUserID", (Object[])criteria.getAlternativeUserIDs(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditUserRoleIDCode", (Object[])criteria.getUserRoleIDCodesAsStringArray(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditNetworkAccessPointID", (Object[])criteria.getNetworkAccessPointIDs(), (Object[])new String[0]);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmAuditUserIsRequestor", (Object)criteria.getUserIsRequestor(), null);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dcmParticipantObjectTypeCodes", (Object[])criteria.getParticipantObjectTypeCodes(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"getParticipantObjectTypeCodeRoles", (Object[])criteria.getParticipantObjectTypeCodeRoles(), (Object[])new String[0]);
        LdapUtils.storeNotEmpty((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"getParticipantObjectDataLifeCycle", (Object[])criteria.getParticipantObjectDataLifeCycle(), (Object[])new String[0]);
        return attrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadChilds(Device device, String deviceDN) throws NamingException {
        NamingEnumeration ne = this.config.search(deviceDN, "(objectclass=dcmAuditLogger)");
        try {
            if (!ne.hasMore()) {
                return;
            }
            AuditLoggerDeviceExtension ext = new AuditLoggerDeviceExtension();
            device.addDeviceExtension((DeviceExtension)ext);
            do {
                ext.addAuditLogger(this.loadAuditLogger((SearchResult)ne.next(), deviceDN, device));
            } while (ne.hasMore());
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    private AuditLogger loadAuditLogger(SearchResult sr, String deviceDN, Device device) throws NamingException {
        Attributes attrs = sr.getAttributes();
        AuditLogger auditLogger = new AuditLogger(LdapUtils.stringValue((Attribute)attrs.get("cn"), null));
        this.loadFrom(auditLogger, attrs);
        for (String connDN : LdapUtils.stringArray((Attribute)attrs.get("dicomNetworkConnectionReference"), (String[])new String[0])) {
            auditLogger.addConnection(LdapUtils.findConnection((String)connDN, (String)deviceDN, (Device)device));
        }
        String arrDeviceDN = LdapUtils.stringValue((Attribute)attrs.get("dcmAuditRecordRepositoryDeviceReference"), null);
        if (deviceDN.equals(arrDeviceDN)) {
            auditLogger.setAuditRecordRepositoryDevice(device);
        } else {
            this.loadAuditRecordRepositoryDevice(auditLogger, arrDeviceDN);
        }
        this.loadAuditSuppressCriteria(auditLogger, this.auditLoggerDN(auditLogger.getCommonName(), deviceDN));
        return auditLogger;
    }

    private void loadAuditRecordRepositoryDevice(AuditLogger auditLogger, String arrDeviceDN) {
        try {
            auditLogger.setAuditRecordRepositoryDevice(this.config.loadDevice(arrDeviceDN));
        }
        catch (ConfigurationException e) {
            LOG.info("Failed to load Audit Record Repository {} referenced by Audit Logger", (Object)arrDeviceDN, (Object)e);
            auditLogger.setAuditRecordRepositoryDeviceName(LdapUtils.cutAttrValueFromDN((String)arrDeviceDN, (String)"dicomDeviceName"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAuditSuppressCriteria(AuditLogger auditLogger, String auditLoggerDN) throws NamingException {
        NamingEnumeration ne = this.config.search(auditLoggerDN, "(objectclass=dcmAuditSuppressCriteria)");
        try {
            while (ne.hasMore()) {
                SearchResult sr = (SearchResult)ne.next();
                Attributes attrs = sr.getAttributes();
                AuditSuppressCriteria criteria = new AuditSuppressCriteria((String)attrs.get("cn").get());
                criteria.setEventIDsAsStringArray(LdapUtils.stringArray((Attribute)attrs.get("dcmAuditEventID"), (String[])new String[0]));
                criteria.setEventTypeCodesAsStringArray(LdapUtils.stringArray((Attribute)attrs.get("dcmAuditEventTypeCode"), (String[])new String[0]));
                criteria.setEventActionCodes(LdapUtils.stringArray((Attribute)attrs.get("dcmAuditEventActionCode"), (String[])new String[0]));
                criteria.setEventOutcomeIndicators(LdapUtils.stringArray((Attribute)attrs.get("dcmAuditEventOutcomeIndicator"), (String[])new String[0]));
                criteria.setUserIDs(LdapUtils.stringArray((Attribute)attrs.get("dcmAuditUserID"), (String[])new String[0]));
                criteria.setAlternativeUserIDs(LdapUtils.stringArray((Attribute)attrs.get("dcmAuditAlternativeUserID"), (String[])new String[0]));
                criteria.setUserRoleIDCodesAsStringArray(LdapUtils.stringArray((Attribute)attrs.get("dcmAuditUserRoleIDCode"), (String[])new String[0]));
                criteria.setNetworkAccessPointIDs(LdapUtils.stringArray((Attribute)attrs.get("dcmAuditNetworkAccessPointID"), (String[])new String[0]));
                criteria.setUserIsRequestor(LdapUtils.booleanValue((Attribute)attrs.get("dcmAuditUserIsRequestor"), null));
                criteria.setParticipantObjectTypeCodes(LdapUtils.stringArray((Attribute)attrs.get("dcmParticipantObjectTypeCodes"), (String[])new String[0]));
                criteria.setParticipantObjectTypeCodeRoles(LdapUtils.stringArray((Attribute)attrs.get("dcmParticipantObjectTypeCodeRoles"), (String[])new String[0]));
                criteria.setParticipantObjectDataLifeCycle(LdapUtils.stringArray((Attribute)attrs.get("dcmParticipantObjectDataLifeCycle"), (String[])new String[0]));
                auditLogger.addAuditSuppressCriteria(criteria);
            }
        }
        finally {
            LdapUtils.safeClose((NamingEnumeration)ne);
        }
    }

    private void loadFrom(AuditLogger logger, Attributes attrs) throws NamingException {
        logger.setFacility(AuditLogger.Facility.values()[LdapUtils.intValue((Attribute)attrs.get("dcmAuditFacility"), (int)10)]);
        logger.setSuccessSeverity(AuditLogger.Severity.values()[LdapUtils.intValue((Attribute)attrs.get("dcmAuditSuccessSeverity"), (int)5)]);
        logger.setMinorFailureSeverity(AuditLogger.Severity.values()[LdapUtils.intValue((Attribute)attrs.get("dcmAuditMinorFailureSeverity"), (int)4)]);
        logger.setSeriousFailureSeverity(AuditLogger.Severity.values()[LdapUtils.intValue((Attribute)attrs.get("dcmAuditSeriousFailureSeverity"), (int)3)]);
        logger.setMajorFailureSeverity(AuditLogger.Severity.values()[LdapUtils.intValue((Attribute)attrs.get("dcmAuditMajorFailureSeverity"), (int)2)]);
        logger.setAuditSourceID(LdapUtils.stringValue((Attribute)attrs.get("dcmAuditSourceID"), null));
        logger.setAuditEnterpriseSiteID(LdapUtils.stringValue((Attribute)attrs.get("dcmAuditEnterpriseSiteID"), null));
        logger.setAuditSourceTypeCodes(LdapUtils.stringArray((Attribute)attrs.get("dcmAuditSourceTypeCode"), (String[])new String[0]));
        logger.setApplicationName(LdapUtils.stringValue((Attribute)attrs.get("dcmAuditApplicationName"), null));
        logger.setMessageID(LdapUtils.stringValue((Attribute)attrs.get("dcmAuditMessageID"), (String)"IHE+RFC-3881"));
        logger.setEncoding(LdapUtils.stringValue((Attribute)attrs.get("dcmAuditMessageEncoding"), (String)"UTF-8"));
        logger.setSchemaURI(LdapUtils.stringValue((Attribute)attrs.get("dcmAuditMessageSchemaURI"), (String)"http://www.dcm4che.org/DICOM/audit-message.rnc"));
        logger.setIncludeBOM(LdapUtils.booleanValue((Attribute)attrs.get("dcmAuditMessageBOM"), (boolean)true));
        logger.setFormatXML(LdapUtils.booleanValue((Attribute)attrs.get("dcmAuditMessageFormatXML"), (boolean)false));
        logger.setTimestampInUTC(LdapUtils.booleanValue((Attribute)attrs.get("dcmAuditTimestampInUTC"), (boolean)false));
        logger.setIncludeInstanceUID(LdapUtils.booleanValue((Attribute)attrs.get("dcmAuditIncludeInstanceUID"), (boolean)false));
        logger.setSpoolDirectoryURI(LdapUtils.stringValue((Attribute)attrs.get("dcmAuditLoggerSpoolDirectoryURI"), null));
        logger.setRetryInterval(LdapUtils.intValue((Attribute)attrs.get("dcmAuditLoggerRetryInterval"), (int)0));
        logger.setInstalled(LdapUtils.booleanValue((Attribute)attrs.get("dicomInstalled"), null));
    }

    protected void mergeChilds(ConfigurationChanges diffs, Device prev, Device device, String deviceDN) throws NamingException {
        AuditLoggerDeviceExtension prevAuditLoggerExt = (AuditLoggerDeviceExtension)prev.getDeviceExtension(AuditLoggerDeviceExtension.class);
        AuditLoggerDeviceExtension auditLoggerExt = (AuditLoggerDeviceExtension)device.getDeviceExtension(AuditLoggerDeviceExtension.class);
        if (prevAuditLoggerExt != null) {
            for (String appName : prevAuditLoggerExt.getAuditLoggerNames()) {
                if (auditLoggerExt != null && auditLoggerExt.containsAuditLogger(appName)) continue;
                String dn = this.auditLoggerDN(appName, deviceDN);
                this.config.destroySubcontextWithChilds(dn);
                ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
            }
        }
        if (auditLoggerExt == null) {
            return;
        }
        for (AuditLogger logger : auditLoggerExt.getAuditLoggers()) {
            String appName = logger.getCommonName();
            if (prevAuditLoggerExt == null || !prevAuditLoggerExt.containsAuditLogger(appName)) {
                this.store(diffs, deviceDN, logger);
                continue;
            }
            this.merge(diffs, prevAuditLoggerExt.getAuditLogger(appName), logger, deviceDN);
        }
    }

    private void merge(ConfigurationChanges diffs, AuditLogger prevLogger, AuditLogger logger, String deviceDN) throws NamingException {
        String appDN = this.auditLoggerDN(logger.getCommonName(), deviceDN);
        ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)appDN, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
        this.config.modifyAttributes(appDN, this.storeDiffs(ldapObj, prevLogger, logger, deviceDN, new ArrayList<ModificationItem>()));
        ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        this.mergeAuditSuppressCriteria(diffs, prevLogger, logger, appDN);
    }

    private void mergeAuditSuppressCriteria(ConfigurationChanges diffs, AuditLogger prevLogger, AuditLogger logger, String auditLoggerDN) throws NamingException {
        String dn;
        String cn;
        for (AuditSuppressCriteria prevCriteria : prevLogger.getAuditSuppressCriteriaList()) {
            cn = prevCriteria.getCommonName();
            if (logger.findAuditSuppressCriteriaByCommonName(cn) != null) continue;
            dn = LdapUtils.dnOf((String)"cn", (String)cn, (String)auditLoggerDN);
            this.config.destroySubcontext(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        }
        for (AuditSuppressCriteria criteria : logger.getAuditSuppressCriteriaList()) {
            ConfigurationChanges.ModifiedObject ldapObj;
            cn = criteria.getCommonName();
            dn = LdapUtils.dnOf((String)"cn", (String)cn, (String)auditLoggerDN);
            AuditSuppressCriteria prev = prevLogger.findAuditSuppressCriteriaByCommonName(cn);
            if (prev == null) {
                ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
                this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), criteria, new BasicAttributes(true)));
                continue;
            }
            ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeDiffs(ldapObj, prev, criteria, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, AuditLogger a, AuditLogger b, String deviceDN, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditFacility", (int)a.getFacility().ordinal(), (int)b.getFacility().ordinal(), (int)10);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditSuccessSeverity", (int)a.getSuccessSeverity().ordinal(), (int)b.getSuccessSeverity().ordinal(), (int)5);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditMinorFailureSeverity", (int)a.getMinorFailureSeverity().ordinal(), (int)b.getMinorFailureSeverity().ordinal(), (int)4);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditSeriousFailureSeverity", (int)a.getSeriousFailureSeverity().ordinal(), (int)b.getSeriousFailureSeverity().ordinal(), (int)3);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditMajorFailureSeverity", (int)a.getMajorFailureSeverity().ordinal(), (int)b.getMajorFailureSeverity().ordinal(), (int)2);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditSourceID", (Object)a.getAuditSourceID(), (Object)b.getAuditSourceID(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditEnterpriseSiteID", (Object)a.getAuditEnterpriseSiteID(), (Object)b.getAuditEnterpriseSiteID(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditSourceTypeCode", (Object[])a.getAuditSourceTypeCodes(), (Object[])b.getAuditSourceTypeCodes(), (Object[])new String[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditApplicationName", (Object)a.getApplicationName(), (Object)b.getApplicationName(), null);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditMessageID", (Object)a.getMessageID(), (Object)b.getMessageID(), (Object)"IHE+RFC-3881");
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditMessageEncoding", (Object)a.getEncoding(), (Object)b.getEncoding(), (Object)"UTF-8");
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditMessageSchemaURI", (Object)a.getSchemaURI(), (Object)b.getSchemaURI(), (Object)"http://www.dcm4che.org/DICOM/audit-message.rnc");
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditMessageBOM", (boolean)a.isIncludeBOM(), (boolean)b.isIncludeBOM(), (boolean)true);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditMessageFormatXML", (boolean)a.isFormatXML(), (boolean)b.isFormatXML(), (boolean)false);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditTimestampInUTC", (boolean)a.isTimestampInUTC(), (boolean)b.isTimestampInUTC(), (boolean)false);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomNetworkConnectionReference", (List)a.getConnections(), (List)b.getConnections(), (String)deviceDN);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditRecordRepositoryDeviceReference", (Object)this.config.deviceRef(a.getAuditRecordRepositoryDeviceNameNotNull()), (Object)this.config.deviceRef(b.getAuditRecordRepositoryDeviceNameNotNull()), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditIncludeInstanceUID", (boolean)a.isIncludeInstanceUID(), (boolean)b.isIncludeInstanceUID(), (boolean)false);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditLoggerSpoolDirectoryURI", (Object)a.getSpoolDirectoryURI(), (Object)b.getSpoolDirectoryURI(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditLoggerRetryInterval", (int)a.getRetryInterval(), (int)b.getRetryInterval(), (int)0);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomInstalled", (Object)a.getInstalled(), (Object)b.getInstalled(), null);
        return mods;
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, AuditSuppressCriteria a, AuditSuppressCriteria b, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditEventID", (Object[])a.getEventIDsAsStringArray(), (Object[])b.getEventIDsAsStringArray(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditEventTypeCode", (Object[])a.getEventTypeCodesAsStringArray(), (Object[])b.getEventTypeCodesAsStringArray(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditEventActionCode", (Object[])a.getEventActionCodes(), (Object[])b.getEventActionCodes(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditEventOutcomeIndicator", (Object[])a.getEventOutcomeIndicators(), (Object[])b.getEventOutcomeIndicators(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditUserID", (Object[])a.getUserIDs(), (Object[])b.getUserIDs(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditAlternativeUserID", (Object[])a.getAlternativeUserIDs(), (Object[])b.getAlternativeUserIDs(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditUserRoleIDCode", (Object[])a.getUserRoleIDCodesAsStringArray(), (Object[])b.getUserRoleIDCodesAsStringArray(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditNetworkAccessPointID", (Object[])a.getNetworkAccessPointIDs(), (Object[])b.getNetworkAccessPointIDs(), (Object[])new String[0]);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmAuditUserIsRequestor", (Object)a.getUserIsRequestor(), (Object)b.getUserIsRequestor(), null);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmParticipantObjectTypeCodes", (Object[])a.getParticipantObjectTypeCodes(), (Object[])b.getParticipantObjectTypeCodes(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmParticipantObjectTypeCodeRoles", (Object[])a.getParticipantObjectTypeCodeRoles(), (Object[])b.getParticipantObjectTypeCodeRoles(), (Object[])new String[0]);
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dcmParticipantObjectDataLifeCycle", (Object[])a.getParticipantObjectDataLifeCycle(), (Object[])b.getParticipantObjectDataLifeCycle(), (Object[])new String[0]);
        return mods;
    }
}

