/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.conf.ldap.audit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import org.dcm4che3.conf.api.ConfigurationChanges;
import org.dcm4che3.conf.ldap.LdapDicomConfigurationExtension;
import org.dcm4che3.conf.ldap.LdapUtils;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.DeviceExtension;
import org.dcm4che3.net.audit.AuditRecordRepository;

public class LdapAuditRecordRepositoryConfiguration
extends LdapDicomConfigurationExtension {
    private static final String CN_AUDIT_RECORD_REPOSITORY = "cn=Audit Record Repository,";

    protected void storeChilds(ConfigurationChanges diffs, String deviceDN, Device device) throws NamingException {
        AuditRecordRepository arr = (AuditRecordRepository)device.getDeviceExtension(AuditRecordRepository.class);
        if (arr != null) {
            this.store(diffs, deviceDN, arr);
        }
    }

    private void store(ConfigurationChanges diffs, String deviceDN, AuditRecordRepository arr) throws NamingException {
        String dn = CN_AUDIT_RECORD_REPOSITORY + deviceDN;
        ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.C);
        this.config.createSubcontext(dn, this.storeTo((ConfigurationChanges.ModifiedObject)ConfigurationChanges.nullifyIfNotVerbose((ConfigurationChanges)diffs, (Object)ldapObj), arr, deviceDN, new BasicAttributes(true)));
    }

    private Attributes storeTo(ConfigurationChanges.ModifiedObject ldapObj, AuditRecordRepository arr, String deviceDN, Attributes attrs) {
        attrs.put(new BasicAttribute("objectclass", "dcmAuditRecordRepository"));
        LdapUtils.storeConnRefs((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (Collection)arr.getConnections(), (String)deviceDN);
        LdapUtils.storeNotNullOrDef((ConfigurationChanges.ModifiedObject)ldapObj, (Attributes)attrs, (String)"dicomInstalled", (Object)arr.getInstalled(), null);
        return attrs;
    }

    protected void loadChilds(Device device, String deviceDN) throws NamingException {
        Attributes attrs;
        try {
            attrs = this.config.getAttributes(CN_AUDIT_RECORD_REPOSITORY + deviceDN);
        }
        catch (NameNotFoundException e) {
            return;
        }
        AuditRecordRepository arr = new AuditRecordRepository();
        this.loadFrom(arr, attrs);
        for (String connDN : LdapUtils.stringArray((Attribute)attrs.get("dicomNetworkConnectionReference"), (String[])new String[0])) {
            arr.addConnection(LdapUtils.findConnection((String)connDN, (String)deviceDN, (Device)device));
        }
        device.addDeviceExtension((DeviceExtension)arr);
    }

    private void loadFrom(AuditRecordRepository arr, Attributes attrs) throws NamingException {
        arr.setInstalled(LdapUtils.booleanValue((Attribute)attrs.get("dicomInstalled"), null));
    }

    protected void mergeChilds(ConfigurationChanges diffs, Device prev, Device device, String deviceDN) throws NamingException {
        AuditRecordRepository prevARR = (AuditRecordRepository)prev.getDeviceExtension(AuditRecordRepository.class);
        AuditRecordRepository arr = (AuditRecordRepository)device.getDeviceExtension(AuditRecordRepository.class);
        if (arr == null && prevARR == null) {
            return;
        }
        String dn = CN_AUDIT_RECORD_REPOSITORY + deviceDN;
        if (arr == null) {
            this.config.destroySubcontextWithChilds(dn);
            ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.D);
        } else if (prevARR == null) {
            this.store(diffs, deviceDN, arr);
        } else {
            ConfigurationChanges.ModifiedObject ldapObj = ConfigurationChanges.addModifiedObject((ConfigurationChanges)diffs, (String)dn, (ConfigurationChanges.ChangeType)ConfigurationChanges.ChangeType.U);
            this.config.modifyAttributes(dn, this.storeDiffs(ldapObj, prevARR, arr, deviceDN, new ArrayList<ModificationItem>()));
            ConfigurationChanges.removeLastIfEmpty((ConfigurationChanges)diffs, (ConfigurationChanges.ModifiedObject)ldapObj);
        }
    }

    private List<ModificationItem> storeDiffs(ConfigurationChanges.ModifiedObject ldapObj, AuditRecordRepository a, AuditRecordRepository b, String deviceDN, ArrayList<ModificationItem> mods) {
        LdapUtils.storeDiff((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomNetworkConnectionReference", (List)a.getConnections(), (List)b.getConnections(), (String)deviceDN);
        LdapUtils.storeDiffObject((ConfigurationChanges.ModifiedObject)ldapObj, mods, (String)"dicomInstalled", (Object)a.getInstalled(), (Object)b.getInstalled(), null);
        return mods;
    }
}

