/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.dcmr;

import java.util.HashMap;
import java.util.Map;
import org.dcm4che3.data.Code;

public class AcquisitionModality {
    public static final Code Autorefraction;
    public static final Code BoneMineralDensitometry;
    public static final Code UltrasoundBoneDensitometry;
    public static final Code CardiacElectrophysiology;
    public static final Code ComputedRadiography;
    public static final Code ComputedTomography;
    public static final Code DigitalRadiography;
    public static final Code Electrocardiography;
    public static final Code Endoscopy;
    public static final Code ExternalCameraPhotography;
    public static final Code GeneralMicroscopy;
    public static final Code HemodynamicWaveform;
    public static final Code IntraOralRadiography;
    public static final Code IntravascularOpticalCoherence;
    public static final Code IntravascularUltrasound;
    public static final Code Keratometry;
    public static final Code Lensometry;
    public static final Code MagneticResonance;
    public static final Code Mammography;
    public static final Code NuclearMedicine;
    public static final Code OphthalmicAxialMeasurements;
    public static final Code OpticalCoherenceTomography;
    public static final Code OphthalmicMapping;
    public static final Code OphthalmicPhotography;
    public static final Code OphthalmicRefraction;
    public static final Code OphthalmicTomography;
    public static final Code OphthalmicVisualField;
    public static final Code OpticalSurfaceScanner;
    public static final Code PanoramicXRay;
    public static final Code PositronEmissionTomography;
    public static final Code Radiofluoroscopy;
    public static final Code RadiographicImaging;
    public static final Code SlideMicroscopy;
    public static final Code SubjectiveRefraction;
    public static final Code Ultrasound;
    public static final Code VisualAcuity;
    public static final Code XRayAngiography;
    private static final Map<String, Code> MODALITIES;

    public static Code codeOf(String modality) {
        return MODALITIES.get(modality);
    }

    public static Code addCode(Code code) {
        return MODALITIES.put(code.getCodeValue(), code);
    }

    public static Code removeCode(String modality) {
        return MODALITIES.remove(modality);
    }

    static {
        Code[] codes;
        Autorefraction = new Code("AR", "DCM", null, "Autorefraction");
        BoneMineralDensitometry = new Code("BMD", "DCM", null, "Bone Mineral Densitometry");
        UltrasoundBoneDensitometry = new Code("BDUS", "DCM", null, "Ultrasound Bone Densitometry");
        CardiacElectrophysiology = new Code("EPS", "DCM", null, "Cardiac Electrophysiology");
        ComputedRadiography = new Code("CR", "DCM", null, "Computed Radiography");
        ComputedTomography = new Code("CT", "DCM", null, "Computed Tomography");
        DigitalRadiography = new Code("DX", "DCM", null, "Digital Radiography");
        Electrocardiography = new Code("ECG", "DCM", null, "Electrocardiography");
        Endoscopy = new Code("ES", "DCM", null, "Endoscopy");
        ExternalCameraPhotography = new Code("XC", "DCM", null, "External-camera Photography");
        GeneralMicroscopy = new Code("GM", "DCM", null, "General Microscopy");
        HemodynamicWaveform = new Code("HD", "DCM", null, "Hemodynamic Waveform");
        IntraOralRadiography = new Code("IO", "DCM", null, "Intra-oral Radiography");
        IntravascularOpticalCoherence = new Code("IVOCT", "DCM", null, "Intravascular Optical Coherence Tomography");
        IntravascularUltrasound = new Code("IVUS", "DCM", null, "Intravascular Ultrasound");
        Keratometry = new Code("KER", "DCM", null, "Keratometry");
        Lensometry = new Code("LEN", "DCM", null, "Lensometry");
        MagneticResonance = new Code("MR", "DCM", null, "Magnetic Resonance");
        Mammography = new Code("MG", "DCM", null, "Mammography");
        NuclearMedicine = new Code("NM", "DCM", null, "Nuclear Medicine");
        OphthalmicAxialMeasurements = new Code("OAM", "DCM", null, "Ophthalmic Axial Measurements");
        OpticalCoherenceTomography = new Code("OCT", "DCM", null, "Optical Coherence Tomography");
        OphthalmicMapping = new Code("OPM", "DCM", null, "Ophthalmic Mapping");
        OphthalmicPhotography = new Code("OP", "DCM", null, "Ophthalmic Photography");
        OphthalmicRefraction = new Code("OPR", "DCM", null, "Ophthalmic Refraction");
        OphthalmicTomography = new Code("OPT", "DCM", null, "Ophthalmic Tomography");
        OphthalmicVisualField = new Code("OPV", "DCM", null, "Ophthalmic Visual Field");
        OpticalSurfaceScanner = new Code("OSS", "DCM", null, "Optical Surface Scanner");
        PanoramicXRay = new Code("PX", "DCM", null, "Panoramic X-Ray");
        PositronEmissionTomography = new Code("PT", "DCM", null, "Positron emission tomography");
        Radiofluoroscopy = new Code("RF", "DCM", null, "Radiofluoroscopy");
        RadiographicImaging = new Code("RG", "DCM", null, "Radiographic imaging");
        SlideMicroscopy = new Code("SM", "DCM", null, "Slide Microscopy");
        SubjectiveRefraction = new Code("SRF", "DCM", null, "Subjective Refraction");
        Ultrasound = new Code("US", "DCM", null, "Ultrasound");
        VisualAcuity = new Code("VA", "DCM", null, "Visual Acuity");
        XRayAngiography = new Code("XA", "DCM", null, "X-Ray Angiography");
        MODALITIES = new HashMap<String, Code>(50);
        for (Code code : codes = new Code[]{Autorefraction, BoneMineralDensitometry, UltrasoundBoneDensitometry, CardiacElectrophysiology, ComputedRadiography, ComputedTomography, DigitalRadiography, Electrocardiography, Endoscopy, ExternalCameraPhotography, GeneralMicroscopy, HemodynamicWaveform, IntraOralRadiography, IntravascularOpticalCoherence, IntravascularUltrasound, Keratometry, Lensometry, MagneticResonance, Mammography, NuclearMedicine, OphthalmicAxialMeasurements, OpticalCoherenceTomography, OphthalmicMapping, OphthalmicPhotography, OphthalmicRefraction, OphthalmicTomography, OphthalmicVisualField, OpticalSurfaceScanner, PanoramicXRay, PositronEmissionTomography, Radiofluoroscopy, RadiographicImaging, SlideMicroscopy, SubjectiveRefraction, Ultrasound, VisualAcuity, XRayAngiography}) {
            MODALITIES.put(code.getCodeValue(), code);
        }
    }
}

