/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.hl7;

import java.io.IOException;
import java.io.Writer;
import org.dcm4che3.hl7.Delimiter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HL7ContentHandler
extends DefaultHandler {
    private final Writer writer;
    private char[] delimiters = "|^~\\&".toCharArray();
    private final char[] escape = new char[]{'\\', '\u0000', '\\'};
    private boolean ignoreCharacters = true;

    public HL7ContentHandler(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        try {
            switch (qName.charAt(0)) {
                case 'f': {
                    if (!qName.equals("field")) break;
                    this.writer.write(this.delimiters[0]);
                    this.ignoreCharacters = false;
                    return;
                }
                case 'c': {
                    if (!qName.equals("component")) break;
                    this.writer.write(this.delimiters[1]);
                    this.ignoreCharacters = false;
                    return;
                }
                case 'r': {
                    if (!qName.equals("repeat")) break;
                    this.writer.write(this.delimiters[2]);
                    this.ignoreCharacters = false;
                    return;
                }
                case 'e': {
                    if (!qName.equals("escape")) break;
                    this.writer.write(this.delimiters[3]);
                    this.ignoreCharacters = false;
                    return;
                }
                case 's': {
                    if (!qName.equals("subcomponent")) break;
                    this.writer.write(this.delimiters[4]);
                    this.ignoreCharacters = false;
                    return;
                }
                case 'M': {
                    if (!qName.equals("MSH")) break;
                    this.startHeaderSegment(qName, atts);
                    return;
                }
                case 'B': {
                    if (!qName.equals("BHS")) break;
                    this.startHeaderSegment(qName, atts);
                    return;
                }
                case 'F': {
                    if (!qName.equals("FHS")) break;
                    this.startHeaderSegment(qName, atts);
                    return;
                }
                case 'h': {
                    if (!qName.equals("hl7")) break;
                    return;
                }
            }
            this.writer.write(qName);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    private void startHeaderSegment(String seg, Attributes atts) throws IOException {
        Delimiter[] values = Delimiter.values();
        for (int i = 0; i < values.length; ++i) {
            String value = atts.getValue(values[i].attribute());
            if (value == null) continue;
            this.delimiters[i] = value.charAt(0);
        }
        this.escape[0] = this.escape[2] = this.delimiters[3];
        this.writer.write(seg);
        this.writer.write(this.delimiters);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.ignoreCharacters = true;
        try {
            switch (qName.charAt(0)) {
                case 'f': {
                    if (!qName.equals("field")) break;
                    return;
                }
                case 'c': {
                    if (!qName.equals("component")) break;
                    return;
                }
                case 'r': {
                    if (!qName.equals("repeat")) break;
                    return;
                }
                case 'e': {
                    if (!qName.equals("escape")) break;
                    this.writer.write(this.delimiters[3]);
                    this.ignoreCharacters = false;
                    return;
                }
                case 's': {
                    if (!qName.equals("subcomponent")) break;
                    return;
                }
                case 'h': {
                    if (!qName.equals("hl7")) break;
                    this.writer.flush();
                    return;
                }
            }
            this.writer.write(13);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void characters(char[] cbuf, int start, int length) throws SAXException {
        if (this.ignoreCharacters) {
            return;
        }
        try {
            int off = start;
            int end = start + length;
            char[] delims = this.delimiters;
            block2: for (int i = start; i < end; ++i) {
                char c = cbuf[i];
                for (int j = 0; j < delims.length; ++j) {
                    if (c != delims[j]) continue;
                    this.writer.write(cbuf, off, i - off);
                    off = i + 1;
                    this.escape(j);
                    continue block2;
                }
            }
            this.writer.write(cbuf, off, end - off);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    private void escape(int delimIndex) throws IOException {
        this.escape[1] = "FSRET".charAt(delimIndex);
        this.writer.write(this.escape);
    }
}

