/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.imageio.codec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.dcm4che3.imageio.codec.CompressionRule;
import org.dcm4che3.imageio.codec.ImageDescriptor;

public class CompressionRules
implements Iterable<CompressionRule>,
Serializable {
    private static final long serialVersionUID = 5027417735779753342L;
    private final ArrayList<CompressionRule> list = new ArrayList();

    public void add(CompressionRule rule) {
        if (this.findByCommonName(rule.getCommonName()) != null) {
            throw new IllegalStateException("CompressionRule with cn: '" + rule.getCommonName() + "' already exists");
        }
        int index = Collections.binarySearch(this.list, rule);
        if (index < 0) {
            index = -(index + 1);
        }
        this.list.add(index, rule);
    }

    public void add(CompressionRules rules) {
        for (CompressionRule rule : rules) {
            this.add(rule);
        }
    }

    public boolean remove(CompressionRule ac) {
        return this.list.remove(ac);
    }

    public void clear() {
        this.list.clear();
    }

    public CompressionRule findByCommonName(String commonName) {
        for (CompressionRule rule : this.list) {
            if (!commonName.equals(rule.getCommonName())) continue;
            return rule;
        }
        return null;
    }

    public CompressionRule findCompressionRule(String aeTitle, ImageDescriptor imageDescriptor) {
        for (CompressionRule ac : this.list) {
            if (!ac.matchesCondition(aeTitle, imageDescriptor)) continue;
            return ac;
        }
        return null;
    }

    @Override
    public Iterator<CompressionRule> iterator() {
        return this.list.iterator();
    }
}

