/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.opencv;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.dcm4che3.image.PhotometricInterpretation;
import org.dcm4che3.imageio.codec.ImageDescriptor;
import org.dcm4che3.opencv.ExtendSegmentedInputImageStream;
import org.dcm4che3.opencv.FileStreamSegment;
import org.dcm4che3.opencv.ImageParameters;
import org.dcm4che3.opencv.MemoryStreamSegment;
import org.dcm4che3.opencv.SOFSegment;
import org.dcm4che3.opencv.StreamSegment;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfDouble;
import org.opencv.imgcodecs.Imgcodecs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weasis.opencv.data.ImageCV;
import org.weasis.opencv.data.PlanarImage;
import org.weasis.opencv.op.ImageConversion;

public class NativeImageReader
extends ImageReader
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeImageReader.class);
    private final boolean canEncodeSigned;
    private final ImageParameters params = new ImageParameters();
    private ImageInputStream iis;

    protected NativeImageReader(ImageReaderSpi originatingProvider, boolean canEncodeSigned) {
        super(originatingProvider);
        this.canEncodeSigned = canEncodeSigned;
    }

    @Override
    public void dispose() {
        this.resetInternalState();
    }

    @Override
    public void close() {
        this.dispose();
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        if (input != null && !(input instanceof ImageInputStream)) {
            throw new IllegalArgumentException("input is not an ImageInputStream!");
        }
        this.resetInternalState();
        this.iis = (ImageInputStream)input;
        try {
            this.buildImage(this.iis);
        }
        catch (IOException e) {
            LOGGER.error("Find image parameters", (Throwable)e);
        }
    }

    private void resetInternalState() {
        this.params.setBytesPerLine(0);
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        return 1;
    }

    @Override
    public int getWidth(int frameIndex) throws IOException {
        return this.params.getWidth();
    }

    @Override
    public int getHeight(int frameIndex) throws IOException {
        return this.params.getHeight();
    }

    protected static final ImageTypeSpecifier createImageType(ImageParameters params, ColorSpace colorSpace, byte[] redPalette, byte[] greenPalette, byte[] bluePalette, byte[] alphaPalette) throws IOException {
        return NativeImageReader.createImageType(params, NativeImageReader.createColorModel(params, colorSpace, redPalette, greenPalette, bluePalette, alphaPalette));
    }

    private static ColorModel createColorModel(ImageParameters params, ColorSpace colorSpace, byte[] redPalette, byte[] greenPalette, byte[] bluePalette, byte[] alphaPalette) {
        ColorModel colorModel;
        int nType = params.getDataType();
        int nBands = params.getSamplesPerPixel();
        int nBitDepth = params.getBitsPerSample();
        if (nBands == 1 && redPalette != null && greenPalette != null && bluePalette != null && redPalette.length == greenPalette.length && redPalette.length == bluePalette.length) {
            int paletteLength = redPalette.length;
            if (alphaPalette != null) {
                byte[] alphaTmp = alphaPalette;
                if (alphaPalette.length != paletteLength) {
                    alphaTmp = new byte[paletteLength];
                    if (alphaPalette.length > paletteLength) {
                        System.arraycopy(alphaPalette, 0, alphaTmp, 0, paletteLength);
                    } else {
                        System.arraycopy(alphaPalette, 0, alphaTmp, 0, alphaPalette.length);
                        for (int i = alphaPalette.length; i < paletteLength; ++i) {
                            alphaTmp[i] = -1;
                        }
                    }
                }
                colorModel = new IndexColorModel(nBitDepth, paletteLength, redPalette, greenPalette, bluePalette, alphaTmp);
            } else {
                colorModel = new IndexColorModel(nBitDepth, paletteLength, redPalette, greenPalette, bluePalette);
            }
        } else if (nType == 6) {
            byte[] comp = new byte[]{0, -1};
            colorModel = new IndexColorModel(1, 2, comp, comp, comp);
        } else {
            boolean hasAlpha;
            ColorSpace cs;
            if (colorSpace != null && (colorSpace.getNumComponents() == nBands || colorSpace.getNumComponents() == nBands - 1)) {
                cs = colorSpace;
                hasAlpha = colorSpace.getNumComponents() + 1 == nBands;
            } else {
                cs = ColorSpace.getInstance(nBands < 3 ? 1003 : 1000);
                hasAlpha = nBands % 2 == 0;
            }
            int[] bits = new int[nBands];
            for (int i = 0; i < nBands; ++i) {
                bits[i] = nBitDepth;
            }
            colorModel = new ComponentColorModel(cs, bits, hasAlpha, false, hasAlpha ? 3 : 1, nType);
        }
        return colorModel;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int frameIndex) throws IOException {
        ImageTypeSpecifier imageType = NativeImageReader.createImageType(this.params, null, null, null, null, null);
        return Collections.singletonList(imageType).iterator();
    }

    protected static final ImageTypeSpecifier createImageType(ImageParameters params, ColorModel colorModel) throws IOException {
        int nType = params.getDataType();
        int nWidth = params.getWidth();
        int nHeight = params.getHeight();
        int nBands = params.getSamplesPerPixel();
        int nBitDepth = params.getBitsPerSample();
        int nScanlineStride = params.getBytesPerLine() / ((nBitDepth + 7) / 8);
        if (nType < 0 || nType > 6) {
            throw new UnsupportedOperationException("Unsupported data type " + nType);
        }
        int[] bandOffsets = new int[nBands];
        for (int i = 0; i < nBands; ++i) {
            bandOffsets[i] = i;
        }
        PixelInterleavedSampleModel sampleModel = new PixelInterleavedSampleModel(nType, nWidth, nHeight, nBands, nScanlineStride, bandOffsets);
        return new ImageTypeSpecifier(colorModel, sampleModel);
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        return null;
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        PlanarImage img = this.getNativeImage(param);
        BufferedImage bufferedImage = ImageConversion.toBufferedImage((PlanarImage)img);
        if (img != null) {
            img.release();
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlanarImage getNativeImage(ImageReadParam param) throws IOException {
        int dcmFlags;
        StreamSegment seg = StreamSegment.getStreamSegment(this.iis, param);
        ImageDescriptor desc = seg.getImageDescriptor();
        int n = dcmFlags = this.canEncodeSigned && desc.isSigned() ? 1 : 0;
        if (this.ybr2rgb(desc.getPhotometricInterpretation())) {
            dcmFlags |= 2;
        }
        if (seg instanceof FileStreamSegment) {
            ImageCV imageCV;
            MatOfDouble positions = null;
            MatOfDouble lengths = null;
            try {
                positions = new MatOfDouble(ExtendSegmentedInputImageStream.getDoubleArray(seg.getSegPosition()));
                lengths = new MatOfDouble(ExtendSegmentedInputImageStream.getDoubleArray(seg.getSegLength()));
                imageCV = ImageCV.toImageCV((Mat)Imgcodecs.dicomJpgFileRead((String)((FileStreamSegment)seg).getFilePath(), (MatOfDouble)positions, (MatOfDouble)lengths, (int)dcmFlags, (int)-1));
            }
            catch (Throwable throwable) {
                NativeImageReader.closeMat(positions);
                NativeImageReader.closeMat(lengths);
                throw throwable;
            }
            NativeImageReader.closeMat((Mat)positions);
            NativeImageReader.closeMat((Mat)lengths);
            return imageCV;
        }
        if (seg instanceof MemoryStreamSegment) {
            ImageCV imageCV;
            Mat buf = null;
            try {
                ByteBuffer b = ((MemoryStreamSegment)seg).getCache();
                buf = new Mat(1, b.limit(), CvType.CV_8UC1);
                buf.put(0, 0, b.array());
                imageCV = ImageCV.toImageCV((Mat)Imgcodecs.dicomJpgMatRead((Mat)buf, (int)dcmFlags, (int)-1));
            }
            catch (Throwable throwable) {
                NativeImageReader.closeMat(buf);
                throw throwable;
            }
            NativeImageReader.closeMat(buf);
            return imageCV;
        }
        return null;
    }

    private boolean ybr2rgb(PhotometricInterpretation pmi) {
        if (this.params.getJpegMarker() == 65475) {
            return false;
        }
        switch (pmi) {
            case MONOCHROME1: 
            case MONOCHROME2: 
            case PALETTE_COLOR: 
            case YBR_ICT: 
            case YBR_RCT: {
                return false;
            }
            case RGB: {
                return this.params.isJFIF() && this.params.getJpegMarker() == 65472;
            }
        }
        return true;
    }

    public static void closeMat(Mat mat) {
        if (mat != null) {
            mat.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SOFSegment getSOFSegment(ImageInputStream iis) throws IOException {
        iis.mark();
        try {
            boolean jfif = false;
            int byte1 = iis.read();
            int byte2 = iis.read();
            if (byte1 != 255 || byte2 != 216) {
                SOFSegment sOFSegment = null;
                return sOFSegment;
            }
            block9: while (true) {
                byte1 = iis.read();
                byte2 = iis.read();
                if (byte1 != 255 || byte2 == 218) break;
                if (byte2 == 247) {
                    SOFSegment sOFSegment = NativeImageReader.getSOF(iis, jfif, (byte1 << 8) + byte2);
                    return sOFSegment;
                }
                if (byte2 >= 192 && byte2 <= 195) {
                    SOFSegment sOFSegment = NativeImageReader.getSOF(iis, jfif, (byte1 << 8) + byte2);
                    return sOFSegment;
                }
                if (byte2 >= 197 && byte2 <= 199) {
                    SOFSegment sOFSegment = NativeImageReader.getSOF(iis, jfif, (byte1 << 8) + byte2);
                    return sOFSegment;
                }
                if (byte2 >= 201 && byte2 <= 203) {
                    SOFSegment sOFSegment = NativeImageReader.getSOF(iis, jfif, (byte1 << 8) + byte2);
                    return sOFSegment;
                }
                if (byte2 >= 205 && byte2 <= 207) {
                    SOFSegment sOFSegment = NativeImageReader.getSOF(iis, jfif, (byte1 << 8) + byte2);
                    return sOFSegment;
                }
                if (byte2 == 224) {
                    jfif = true;
                }
                int length = iis.read() << 8;
                length += iis.read();
                length -= 2;
                while (true) {
                    if (length <= 0) continue block9;
                    length -= iis.skipBytes(length);
                }
                break;
            }
            SOFSegment sOFSegment = null;
            return sOFSegment;
        }
        finally {
            iis.reset();
        }
    }

    protected static SOFSegment getSOF(ImageInputStream iis, boolean jfif, int marker) throws IOException {
        NativeImageReader.readUnsignedShort(iis);
        int samplePrecision = NativeImageReader.readUnsignedByte(iis);
        int lines = NativeImageReader.readUnsignedShort(iis);
        int samplesPerLine = NativeImageReader.readUnsignedShort(iis);
        int componentsInFrame = NativeImageReader.readUnsignedByte(iis);
        return new SOFSegment(jfif, marker, samplePrecision, lines, samplesPerLine, componentsInFrame);
    }

    public ImageParameters buildImage(ImageInputStream iis) throws IOException {
        SOFSegment sof;
        if (iis != null && this.params.getBytesPerLine() < 1 && (sof = NativeImageReader.getSOFSegment(iis)) != null) {
            this.params.setJFIF(sof.isJFIF());
            this.params.setJpegMarker(sof.getMarker());
            this.params.setWidth(sof.getSamplesPerLine());
            this.params.setHeight(sof.getLines());
            this.params.setBitsPerSample(sof.getSamplePrecision());
            this.params.setSamplesPerPixel(sof.getComponents());
            this.params.setBytesPerLine(this.params.getWidth() * this.params.getSamplesPerPixel() * ((this.params.getBitsPerSample() + 7) / 8));
            return this.params;
        }
        return null;
    }

    private static final int readUnsignedByte(ImageInputStream iis) throws IOException {
        int ch = iis.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch;
    }

    private static final int readUnsignedShort(ImageInputStream iis) throws IOException {
        int ch2;
        int ch1 = iis.read();
        if ((ch1 | (ch2 = iis.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + ch2;
    }
}

