/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.opencv;

import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import org.dcm4che3.imageio.codec.BytesWithImageImageDescriptor;
import org.dcm4che3.imageio.codec.ImageDescriptor;
import org.dcm4che3.opencv.J2kImageWriteParam;
import org.dcm4che3.opencv.NativeImageReader;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfInt;
import org.opencv.imgcodecs.Imgcodecs;
import org.opencv.osgi.OpenCVNativeLoader;
import org.weasis.opencv.data.ImageCV;
import org.weasis.opencv.op.ImageConversion;

class NativeJ2kImageWriter
extends ImageWriter {
    NativeJ2kImageWriter(ImageWriterSpi originatingProvider) throws IOException {
        super(originatingProvider);
    }

    @Override
    public ImageWriteParam getDefaultWriteParam() {
        return new J2kImageWriteParam(this.getLocale());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        if (this.output == null) {
            throw new IllegalStateException("input cannot be null");
        }
        if (!(this.output instanceof ImageOutputStream)) {
            throw new IllegalArgumentException("input is not an ImageInputStream!");
        }
        ImageOutputStream stream = (ImageOutputStream)this.output;
        stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        J2kImageWriteParam j2kParams = (J2kImageWriteParam)param;
        if (!(stream instanceof BytesWithImageImageDescriptor)) {
            throw new IllegalArgumentException("stream does not implement BytesWithImageImageDescriptor!");
        }
        ImageDescriptor desc = ((BytesWithImageImageDescriptor)stream).getImageDescriptor();
        RenderedImage renderedImage = image.getRenderedImage();
        Mat buf = null;
        MatOfInt dicomParams = null;
        try {
            ImageCV mat = null;
            try {
                boolean signed = desc.isSigned();
                mat = ImageConversion.toMat((RenderedImage)renderedImage, (Rectangle)param.getSourceRegion(), (boolean)true, (boolean)signed);
                int cvType = mat.type();
                int channels = CvType.channels((int)cvType);
                int epi = channels == 1 ? 3 : 5;
                int dcmFlags = signed ? 1 : 0;
                int[] params = new int[16];
                params[0] = -1;
                params[1] = dcmFlags;
                params[2] = mat.width();
                params[3] = mat.height();
                params[4] = 3;
                params[5] = channels;
                params[6] = desc.getBitsCompressed();
                params[7] = 2;
                params[9] = epi;
                params[12] = j2kParams.getCompressionRatiofactor();
                dicomParams = new MatOfInt(params);
                buf = Imgcodecs.dicomJpgWrite((Mat)mat, (MatOfInt)dicomParams, (String)"");
                if (buf.empty()) {
                    throw new IIOException("Native JPEG2000 encoding error: null image");
                }
            }
            finally {
                if (mat != null) {
                    mat.release();
                }
            }
            byte[] bSrcData = new byte[buf.width() * buf.height() * (int)buf.elemSize()];
            buf.get(0, 0, bSrcData);
            stream.write(bSrcData);
        }
        catch (Throwable t) {
            try {
                throw new IIOException("Native JPEG2000 encoding error", t);
            }
            catch (Throwable throwable) {
                NativeImageReader.closeMat(dicomParams);
                NativeImageReader.closeMat(buf);
                throw throwable;
            }
        }
        NativeImageReader.closeMat((Mat)dicomParams);
        NativeImageReader.closeMat(buf);
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    static {
        OpenCVNativeLoader loader = new OpenCVNativeLoader();
        loader.init();
    }
}

