/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.opencv;

import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import org.dcm4che3.image.PhotometricInterpretation;
import org.dcm4che3.imageio.codec.BytesWithImageImageDescriptor;
import org.dcm4che3.imageio.codec.ImageDescriptor;
import org.dcm4che3.opencv.JPEGLSImageWriteParam;
import org.dcm4che3.opencv.NativeImageReader;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfInt;
import org.opencv.imgcodecs.Imgcodecs;
import org.opencv.osgi.OpenCVNativeLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weasis.opencv.data.ImageCV;
import org.weasis.opencv.op.ImageConversion;

class NativeJLSImageWriter
extends ImageWriter {
    private static final Logger LOGGER;

    NativeJLSImageWriter(ImageWriterSpi originatingProvider) throws IOException {
        super(originatingProvider);
    }

    @Override
    public ImageWriteParam getDefaultWriteParam() {
        return new JPEGLSImageWriteParam(this.getLocale());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        if (this.output == null) {
            throw new IllegalStateException("input cannot be null");
        }
        if (!(this.output instanceof ImageOutputStream)) {
            throw new IllegalArgumentException("input is not an ImageInputStream!");
        }
        ImageOutputStream stream = (ImageOutputStream)this.output;
        stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        JPEGLSImageWriteParam jpegParams = (JPEGLSImageWriteParam)param;
        if (!(stream instanceof BytesWithImageImageDescriptor)) {
            throw new IllegalArgumentException("stream does not implement BytesWithImageImageDescriptor!");
        }
        ImageDescriptor desc = ((BytesWithImageImageDescriptor)stream).getImageDescriptor();
        PhotometricInterpretation pi = desc.getPhotometricInterpretation();
        if (jpegParams.isCompressionLossless() && (PhotometricInterpretation.YBR_FULL_422 == pi || PhotometricInterpretation.YBR_PARTIAL_422 == pi || PhotometricInterpretation.YBR_PARTIAL_420 == pi || PhotometricInterpretation.YBR_ICT == pi || PhotometricInterpretation.YBR_RCT == pi)) {
            throw new IllegalArgumentException("True lossless encoder: Photometric interpretation is not supported: " + pi);
        }
        RenderedImage renderedImage = image.getRenderedImage();
        Mat buf = null;
        MatOfInt dicomParams = null;
        try {
            ImageCV mat = null;
            try {
                int dcmFlags;
                mat = ImageConversion.toMat((RenderedImage)renderedImage, (Rectangle)param.getSourceRegion(), (boolean)false);
                int jpeglsNLE = jpegParams.getNearLossless();
                int bitCompressed = desc.getBitsCompressed();
                int cvType = mat.type();
                int channels = CvType.channels((int)cvType);
                int epi = channels == 1 ? 3 : 5;
                boolean signed = desc.isSigned();
                int n = dcmFlags = signed ? 1 : 0;
                if (signed) {
                    LOGGER.warn("Force compression to JPEG-LS lossless as lossy is not adapted to signed data.");
                    jpeglsNLE = 0;
                    bitCompressed = 16;
                }
                if (bitCompressed == 8 && renderedImage.getSampleModel().getTransferType() != 0) {
                    bitCompressed = 12;
                }
                int[] params = new int[16];
                params[0] = -1;
                params[1] = dcmFlags;
                params[2] = mat.width();
                params[3] = mat.height();
                params[4] = 2;
                params[5] = channels;
                params[6] = bitCompressed;
                params[7] = 2;
                params[9] = epi;
                params[11] = jpeglsNLE;
                dicomParams = new MatOfInt(params);
                buf = Imgcodecs.dicomJpgWrite((Mat)mat, (MatOfInt)dicomParams, (String)"");
                if (buf.empty()) {
                    throw new IIOException("Native JPEG-LS encoding error: null image");
                }
            }
            finally {
                if (mat != null) {
                    mat.release();
                }
            }
            byte[] bSrcData = new byte[buf.width() * buf.height() * (int)buf.elemSize()];
            buf.get(0, 0, bSrcData);
            stream.write(bSrcData);
        }
        catch (Throwable t) {
            try {
                throw new IIOException("Native JPEG-LS encoding error", t);
            }
            catch (Throwable throwable) {
                NativeImageReader.closeMat(dicomParams);
                NativeImageReader.closeMat(buf);
                throw throwable;
            }
        }
        NativeImageReader.closeMat((Mat)dicomParams);
        NativeImageReader.closeMat(buf);
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    static {
        OpenCVNativeLoader loader = new OpenCVNativeLoader();
        loader.init();
        LOGGER = LoggerFactory.getLogger(NativeJLSImageWriter.class);
    }
}

