/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.opencv;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import org.dcm4che3.opencv.NativeJPEGImageReaderSpi;
import org.dcm4che3.opencv.NativeJPEGImageWriter;

public class NativeJPEGImageWriterSpi
extends ImageWriterSpi {
    public NativeJPEGImageWriterSpi() {
        this(NativeJPEGImageWriter.class);
    }

    public NativeJPEGImageWriterSpi(Class<? extends NativeJPEGImageWriter> writer) {
        super("Weasis Team", "1.0", NativeJPEGImageReaderSpi.NAMES, NativeJPEGImageReaderSpi.SUFFIXES, NativeJPEGImageReaderSpi.MIMES, writer.getName(), new Class[]{ImageOutputStream.class}, new String[]{NativeJPEGImageReaderSpi.class.getName()}, false, null, null, null, null, false, null, null, null, null);
    }

    @Override
    public boolean canEncodeImage(ImageTypeSpecifier type) {
        return NativeJPEGImageWriterSpi.checkCommonJpgRequirement(type);
    }

    public static boolean checkCommonJpgRequirement(ImageTypeSpecifier type) {
        int bitDepth;
        ColorModel colorModel = type.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            return true;
        }
        SampleModel sampleModel = type.getSampleModel();
        if (colorModel != null) {
            int[] componentSize = colorModel.getComponentSize();
            bitDepth = componentSize[0];
            for (int i = 1; i < componentSize.length; ++i) {
                if (componentSize[i] == bitDepth) continue;
                return false;
            }
        } else {
            int[] sampleSize = sampleModel.getSampleSize();
            bitDepth = sampleSize[0];
            for (int i = 1; i < sampleSize.length; ++i) {
                if (sampleSize[i] == bitDepth) continue;
                return false;
            }
        }
        if (bitDepth > 16) {
            return false;
        }
        int numBands = sampleModel.getNumBands();
        return numBands == 1 || numBands == 3 || numBands == 4;
    }

    @Override
    public String getDescription(Locale locale) {
        return "Natively-accelerated JPEG Image Writer (8/12/16 bits, IJG 6b based)";
    }

    @Override
    public ImageWriter createWriterInstance(Object extension) throws IOException {
        return new NativeJPEGImageWriter(this);
    }
}

