/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.mime;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.dcm4che3.mime.MultipartInputStream;

public class MultipartParser {
    private final String boundary;

    public MultipartParser(String boundary) {
        this.boundary = boundary;
    }

    public void parse(InputStream in, Handler handler) throws IOException {
        new MultipartInputStream(in, "--" + this.boundary).skipAll();
        int i = 1;
        while (true) {
            int ch2;
            int ch1;
            if (((ch1 = in.read()) | (ch2 = in.read())) < 0) {
                throw new EOFException();
            }
            if (ch1 == 45 && ch2 == 45) break;
            if (ch1 != 13 || ch2 != 10) {
                throw new IOException("missing CR/LF after boundary");
            }
            MultipartInputStream mis = new MultipartInputStream(in, "\r\n--" + this.boundary);
            handler.bodyPart(i, mis);
            mis.skipAll();
            ++i;
        }
    }

    public static interface Handler {
        public void bodyPart(int var1, MultipartInputStream var2) throws IOException;
    }
}

