/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net.audit;

import java.util.List;
import org.dcm4che3.audit.ActiveParticipant;
import org.dcm4che3.audit.AuditMessage;
import org.dcm4che3.audit.EventID;
import org.dcm4che3.audit.EventIdentification;
import org.dcm4che3.audit.EventTypeCode;
import org.dcm4che3.audit.ParticipantObjectIdentification;
import org.dcm4che3.audit.RoleIDCode;
import org.dcm4che3.data.Code;

public class AuditSuppressCriteria {
    private String commonName;
    private EventID[] eventIDs = new EventID[0];
    private EventTypeCode[] eventTypeCodes = new EventTypeCode[0];
    private String[] eventActionCodes = new String[0];
    private String[] eventOutcomeIndicators = new String[0];
    private String[] userIDs = new String[0];
    private String[] alternativeUserIDs = new String[0];
    private RoleIDCode[] roleIDCodes = new RoleIDCode[0];
    private String[] networkAccessPointIDs = new String[0];
    private Boolean userIsRequestor;
    private String[] participantObjectTypeCodes = new String[0];
    private String[] participantObjectTypeCodeRoles = new String[0];
    private String[] participantObjectDataLifeCycle = new String[0];

    public AuditSuppressCriteria() {
    }

    public AuditSuppressCriteria(String cn) {
        this.setCommonName(cn);
    }

    public void setCommonName(String commonName) {
        if (commonName.isEmpty()) {
            throw new IllegalArgumentException("cn must not be empty");
        }
        this.commonName = commonName;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public EventID[] getEventIDs() {
        return this.eventIDs;
    }

    public void setEventIDs(EventID ... eventIDs) {
        this.eventIDs = eventIDs;
    }

    public String[] getEventIDsAsStringArray() {
        return AuditSuppressCriteria.toStringArray(this.eventIDs);
    }

    public void setEventIDsAsStringArray(String[] ss) {
        this.setEventIDs(AuditSuppressCriteria.toEventIDArray(ss));
    }

    public EventTypeCode[] getEventTypeCodes() {
        return this.eventTypeCodes;
    }

    public void setEventTypeCodes(EventTypeCode ... eventTypeCodes) {
        this.eventTypeCodes = eventTypeCodes;
    }

    public String[] getEventTypeCodesAsStringArray() {
        return AuditSuppressCriteria.toStringArray(this.eventTypeCodes);
    }

    public void setEventTypeCodesAsStringArray(String ... ss) {
        this.setEventTypeCodes(AuditSuppressCriteria.toEventTypeCodeArray(ss));
    }

    public String[] getEventActionCodes() {
        return this.eventActionCodes;
    }

    public void setEventActionCodes(String ... eventActionCodes) {
        this.eventActionCodes = eventActionCodes;
    }

    public String[] getEventOutcomeIndicators() {
        return this.eventOutcomeIndicators;
    }

    public void setEventOutcomeIndicators(String ... eventOutcomeIndicators) {
        this.eventOutcomeIndicators = eventOutcomeIndicators;
    }

    public String[] getUserIDs() {
        return this.userIDs;
    }

    public void setUserIDs(String ... userIDs) {
        this.userIDs = userIDs;
    }

    public String[] getAlternativeUserIDs() {
        return this.alternativeUserIDs;
    }

    public void setAlternativeUserIDs(String ... altUserID) {
        this.alternativeUserIDs = altUserID;
    }

    public RoleIDCode[] getUserRoleIDCodes() {
        return this.roleIDCodes;
    }

    public void setUserRoleIDCodes(RoleIDCode ... roleIDCodes) {
        this.roleIDCodes = roleIDCodes;
    }

    public String[] getUserRoleIDCodesAsStringArray() {
        return AuditSuppressCriteria.toStringArray(this.roleIDCodes);
    }

    public void setUserRoleIDCodesAsStringArray(String ... ss) {
        this.setUserRoleIDCodes(AuditSuppressCriteria.toRoleIDCodeArray(ss));
    }

    public String[] getNetworkAccessPointIDs() {
        return this.networkAccessPointIDs;
    }

    public void setNetworkAccessPointIDs(String ... networkAccessPointIDs) {
        this.networkAccessPointIDs = networkAccessPointIDs;
    }

    public Boolean getUserIsRequestor() {
        return this.userIsRequestor;
    }

    public void setUserIsRequestor(Boolean userIsRequestor) {
        this.userIsRequestor = userIsRequestor;
    }

    public String[] getParticipantObjectTypeCodes() {
        return this.participantObjectTypeCodes;
    }

    public void setParticipantObjectTypeCodes(String[] participantObjectTypeCodes) {
        this.participantObjectTypeCodes = participantObjectTypeCodes;
    }

    public String[] getParticipantObjectTypeCodeRoles() {
        return this.participantObjectTypeCodeRoles;
    }

    public void setParticipantObjectTypeCodeRoles(String[] participantObjectTypeCodeRoles) {
        this.participantObjectTypeCodeRoles = participantObjectTypeCodeRoles;
    }

    public String[] getParticipantObjectDataLifeCycle() {
        return this.participantObjectDataLifeCycle;
    }

    public void setParticipantObjectDataLifeCycle(String[] participantObjectDataLifeCycle) {
        this.participantObjectDataLifeCycle = participantObjectDataLifeCycle;
    }

    public boolean match(AuditMessage msg) {
        if (!this.matchEventIdentification(msg.getEventIdentification())) {
            return false;
        }
        if (!this.matchActiveParticipants(msg.getActiveParticipant())) {
            return false;
        }
        return this.matchParticipantObjectIdentifications(msg.getParticipantObjectIdentification());
    }

    private boolean matchEventIdentification(EventIdentification eventIdentification) {
        if (!this.matchEventID(eventIdentification.getEventID())) {
            return false;
        }
        if (!this.matchEventTypeCodes(eventIdentification.getEventTypeCode())) {
            return false;
        }
        if (!this.isEmptyOrContains(this.eventActionCodes, eventIdentification.getEventActionCode())) {
            return false;
        }
        return this.isEmptyOrContains(this.eventOutcomeIndicators, eventIdentification.getEventOutcomeIndicator());
    }

    private boolean matchEventID(EventID o) {
        if (this.eventIDs.length == 0) {
            return true;
        }
        for (EventID eventyID : this.eventIDs) {
            if (!eventyID.getCsdCode().equals(o.getCsdCode()) || !this.equals(eventyID.getCodeSystemName(), o.getCodeSystemName()) || !this.equals(eventyID.getCodeSystem(), o.getCodeSystem())) continue;
            return true;
        }
        return false;
    }

    private boolean equals(Object o1, Object o2) {
        return o1 != null ? o1.equals(o2) : o2 == null;
    }

    private boolean matchEventTypeCodes(List<EventTypeCode> list) {
        if (this.eventTypeCodes.length == 0) {
            return true;
        }
        for (EventTypeCode o : list) {
            for (EventTypeCode eventTypeCode : this.eventTypeCodes) {
                if (!eventTypeCode.getCsdCode().equals(o.getCsdCode()) || !this.equals(eventTypeCode.getCodeSystemName(), o.getCodeSystemName()) || !this.equals(eventTypeCode.getCodeSystem(), o.getCodeSystem())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchActiveParticipants(List<ActiveParticipant> aps) {
        if (this.matchAnyActiveParticipant()) {
            return true;
        }
        for (ActiveParticipant ap : aps) {
            if (!this.matchActiveParticipant(ap)) continue;
            return true;
        }
        return false;
    }

    private boolean matchActiveParticipant(ActiveParticipant ap) {
        if (!this.isEmptyOrContains(this.userIDs, ap.getUserID())) {
            return false;
        }
        if (!this.isEmptyOrContains(this.alternativeUserIDs, ap.getAlternativeUserID())) {
            return false;
        }
        if (!this.isEmptyOrContains(this.networkAccessPointIDs, ap.getNetworkAccessPointID())) {
            return false;
        }
        if (!this.matchRoleIDCodes(ap.getRoleIDCode())) {
            return false;
        }
        return this.userIsRequestor == null || ap.isUserIsRequestor() == this.userIsRequestor.booleanValue();
    }

    private boolean matchRoleIDCodes(List<RoleIDCode> list) {
        if (this.roleIDCodes.length == 0) {
            return true;
        }
        for (RoleIDCode o : list) {
            for (RoleIDCode roleIDCode : this.roleIDCodes) {
                if (!roleIDCode.getCsdCode().equals(o.getCsdCode()) || !this.equals(roleIDCode.getCodeSystemName(), o.getCodeSystemName()) || !this.equals(roleIDCode.getCodeSystem(), o.getCodeSystem())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchAnyActiveParticipant() {
        return this.userIDs.length == 0 && this.alternativeUserIDs.length == 0 && this.roleIDCodes.length == 0 && this.networkAccessPointIDs.length == 0 && this.userIsRequestor == null;
    }

    private boolean matchParticipantObjectIdentifications(List<ParticipantObjectIdentification> pois) {
        if (this.matchAnyParticipantObjectIdentification()) {
            return true;
        }
        for (ParticipantObjectIdentification poi : pois) {
            if (!this.matchParticipantObjectIdentification(poi)) continue;
            return true;
        }
        return false;
    }

    private boolean matchParticipantObjectIdentification(ParticipantObjectIdentification poi) {
        if (!this.isEmptyOrContains(this.participantObjectTypeCodes, poi.getParticipantObjectTypeCode())) {
            return false;
        }
        if (!this.isEmptyOrContains(this.participantObjectTypeCodeRoles, poi.getParticipantObjectTypeCodeRole())) {
            return false;
        }
        return this.isEmptyOrContains(this.participantObjectDataLifeCycle, poi.getParticipantObjectDataLifeCycle());
    }

    private boolean matchAnyParticipantObjectIdentification() {
        return this.participantObjectTypeCodes.length == 0 && this.participantObjectTypeCodeRoles.length == 0 && this.participantObjectDataLifeCycle.length == 0;
    }

    private boolean isEmptyOrContains(String[] ss, String o) {
        if (ss.length == 0) {
            return true;
        }
        if (o == null) {
            return false;
        }
        for (String s : ss) {
            if (!o.equals(s)) continue;
            return true;
        }
        return false;
    }

    private static String[] toStringArray(EventID ... a) {
        String[] ss = new String[a.length];
        for (int i = 0; i < a.length; ++i) {
            ss[i] = new Code(a[i].getCsdCode(), a[i].getCodeSystemName(), null, a[i].getOriginalText()).toString();
        }
        return ss;
    }

    private static String[] toStringArray(EventTypeCode ... a) {
        String[] ss = new String[a.length];
        for (int i = 0; i < a.length; ++i) {
            ss[i] = new Code(a[i].getCsdCode(), a[i].getCodeSystemName(), null, a[i].getOriginalText()).toString();
        }
        return ss;
    }

    private static String[] toStringArray(RoleIDCode ... a) {
        String[] ss = new String[a.length];
        for (int i = 0; i < a.length; ++i) {
            ss[i] = new Code(a[i].getCsdCode(), a[i].getCodeSystemName(), null, a[i].getOriginalText()).toString();
        }
        return ss;
    }

    private static EventID[] toEventIDArray(String ... ss) {
        EventID[] a = new EventID[ss.length];
        for (int i = 0; i < ss.length; ++i) {
            Code code = new Code(ss[i]);
            a[i] = new EventID();
            a[i].setCsdCode(code.getCodeValue());
            a[i].setCodeSystemName(code.getCodingSchemeDesignator());
            a[i].setOriginalText(code.getCodeMeaning());
        }
        return a;
    }

    private static EventTypeCode[] toEventTypeCodeArray(String ... ss) {
        EventTypeCode[] a = new EventTypeCode[ss.length];
        for (int i = 0; i < ss.length; ++i) {
            Code code = new Code(ss[i]);
            a[i] = new EventTypeCode();
            a[i].setCsdCode(code.getCodeValue());
            a[i].setCodeSystemName(code.getCodingSchemeDesignator());
            a[i].setOriginalText(code.getCodeMeaning());
        }
        return a;
    }

    private static RoleIDCode[] toRoleIDCodeArray(String ... ss) {
        RoleIDCode[] a = new RoleIDCode[ss.length];
        for (int i = 0; i < ss.length; ++i) {
            Code code = new Code(ss[i]);
            a[i] = new RoleIDCode();
            a[i].setCsdCode(code.getCodeValue());
            a[i].setCodeSystemName(code.getCodingSchemeDesignator());
            a[i].setOriginalText(code.getCodeMeaning());
        }
        return a;
    }
}

