/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net.audit;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.concurrent.Executor;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.TCPProtocolHandler;
import org.dcm4che3.net.UDPProtocolHandler;
import org.dcm4che3.net.audit.AuditRecordRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum SyslogProtocolHandler implements TCPProtocolHandler,
UDPProtocolHandler
{
    INSTANCE;

    private static final int INIT_MSG_LEN = 8192;
    private static final int MAX_MSG_LEN = 0x1400000;
    private static final int MAX_MSG_PREFIX = 200;
    private static final int MSG_PROMPT_LEN = 8192;
    private static Logger LOG;
    private static volatile Executor executor;

    public static void setExecutor(Executor executor) {
        SyslogProtocolHandler.executor = executor;
    }

    public void onAccept(Connection conn, Socket s) {
        if (executor != null) {
            executor.execute(new SyslogReceiverTLS(conn, s));
        } else {
            conn.getDevice().execute((Runnable)new SyslogReceiverTLS(conn, s));
        }
    }

    public void onReceive(Connection conn, DatagramPacket packet) {
        if (executor != null) {
            executor.execute(new SyslogReceiverUDP(conn, packet));
        } else {
            conn.getDevice().execute((Runnable)new SyslogReceiverUDP(conn, packet));
        }
    }

    private static int readMessageLength(InputStream in, Socket s) throws IOException {
        int ch;
        try {
            ch = in.read();
        }
        catch (SocketTimeoutException e) {
            LOG.info("Timeout expired for connection to {}", (Object)s);
            return -1;
        }
        if (ch < 0) {
            return -1;
        }
        int len = 0;
        do {
            int d;
            if ((d = ch - 48) < 0 || d > 9) {
                LOG.warn("Illegal character code: {} in message length received from {}", (Object)ch, (Object)s);
                return -1;
            }
            len = (len << 3) + (len << 1) + d;
        } while ((ch = in.read()) > 0 && ch != 32);
        return len;
    }

    private static int readMessage(InputStream in, byte[] data, int len) throws IOException {
        int n;
        int count;
        for (n = 0; n < len && (count = in.read(data, n, len - n)) > 0; n += count) {
        }
        return n;
    }

    private static void onMessage(AuditRecordRepository arr, byte[] data, int offset, int length, Connection conn, InetAddress from) {
        int xmlOffset;
        if (LOG.isDebugEnabled()) {
            LOG.debug(SyslogProtocolHandler.prompt(data, 8192));
        }
        if ((xmlOffset = SyslogProtocolHandler.indexOfXML(data, offset, Math.min(200, length))) != -1) {
            int xmlLength = length - xmlOffset + offset;
            arr.onMessage(data, xmlOffset, xmlLength, conn, from);
        } else {
            LOG.warn("Ignore unexpected message from {}: {}", (Object)from, (Object)SyslogProtocolHandler.prompt(data, 200));
        }
    }

    private static int indexOfXML(byte[] buf, int offset, int maxIndex) {
        int xmlDeclIndex = -1;
        for (int index = offset; index <= maxIndex; ++index) {
            if (buf[index] != 60) continue;
            if (SyslogProtocolHandler.isAuditMessage(buf, index) || SyslogProtocolHandler.isIHEYr4(buf, index)) {
                return xmlDeclIndex == -1 ? index : xmlDeclIndex;
            }
            if (xmlDeclIndex != -1 || !SyslogProtocolHandler.isXMLDecl(buf, index)) continue;
            xmlDeclIndex = index;
        }
        return -1;
    }

    private static boolean isXMLDecl(byte[] buf, int index) {
        return index + 4 < buf.length && buf[index + 1] == 63 && buf[index + 2] == 120 && buf[index + 3] == 109 && buf[index + 4] == 108;
    }

    private static boolean isAuditMessage(byte[] buf, int index) {
        return index + 12 < buf.length && buf[index + 1] == 65 && buf[index + 2] == 117 && buf[index + 3] == 100 && buf[index + 4] == 105 && buf[index + 5] == 116 && buf[index + 6] == 77 && buf[index + 7] == 101 && buf[index + 8] == 115 && buf[index + 9] == 115 && buf[index + 10] == 97 && buf[index + 11] == 103 && buf[index + 12] == 101;
    }

    private static boolean isIHEYr4(byte[] buf, int index) {
        return index + 6 < buf.length && buf[index + 1] == 73 && buf[index + 2] == 72 && buf[index + 3] == 69 && buf[index + 4] == 89 && buf[index + 5] == 114 && buf[index + 6] == 52;
    }

    private static String prompt(byte[] data, int maxLen) {
        try {
            return data.length > maxLen ? new String(data, 0, maxLen, "UTF-8") + "..." : new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        LOG = LoggerFactory.getLogger(SyslogProtocolHandler.class);
    }

    private static class SyslogReceiverTLS
    implements Runnable {
        private final Connection conn;
        private final Socket s;
        private final AuditRecordRepository arr;

        public SyslogReceiverTLS(Connection conn, Socket s) {
            this.conn = conn;
            this.s = s;
            this.arr = (AuditRecordRepository)conn.getDevice().getDeviceExtensionNotNull(AuditRecordRepository.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int length;
                InputStream in = this.s.getInputStream();
                byte[] data = new byte[8192];
                this.s.setSoTimeout(this.conn.getIdleTimeout());
                while ((length = SyslogProtocolHandler.readMessageLength(in, this.s)) > 0) {
                    if (length > 0x1400000) {
                        LOG.warn("Message length: {} received from {} exceeds limit {}", new Object[]{length, this.s, 0x1400000});
                        break;
                    }
                    if (length > data.length) {
                        data = new byte[length];
                    }
                    if (SyslogProtocolHandler.readMessage(in, data, length) < length) {
                        LOG.warn("Connection closed by remote host {} during receive of message", (Object)this.s);
                        break;
                    }
                    LOG.info("Received Syslog message of {} bytes from {}", (Object)length, (Object)this.s);
                    SyslogProtocolHandler.onMessage(this.arr, data, 0, length, this.conn, this.s.getInetAddress());
                }
            }
            catch (IOException e) {
                LOG.warn("Exception on accepted connection {}:", (Object)this.s, (Object)e);
            }
            finally {
                this.conn.close(this.s);
            }
        }
    }

    private static class SyslogReceiverUDP
    implements Runnable {
        private final Connection conn;
        private final DatagramPacket packet;
        private final AuditRecordRepository arr;

        public SyslogReceiverUDP(Connection conn, DatagramPacket packet) {
            this.conn = conn;
            this.packet = packet;
            this.arr = (AuditRecordRepository)conn.getDevice().getDeviceExtensionNotNull(AuditRecordRepository.class);
        }

        @Override
        public void run() {
            LOG.info("Received UDP Syslog message of {} bytes from {}", (Object)this.packet.getLength(), (Object)this.packet.getAddress());
            SyslogProtocolHandler.onMessage(this.arr, this.packet.getData(), this.packet.getOffset(), this.packet.getLength(), this.conn, this.packet.getAddress());
        }
    }
}

