/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net.hl7;

import java.io.Closeable;
import java.io.IOException;
import org.dcm4che3.hl7.MLLPConnection;
import org.dcm4che3.net.hl7.HL7Application;
import org.dcm4che3.net.hl7.HL7ConnectionMonitor;
import org.dcm4che3.net.hl7.HL7DeviceExtension;
import org.dcm4che3.net.hl7.UnparsedHL7Message;

public class HL7Connection
implements Closeable {
    private final HL7Application hl7Application;
    private final MLLPConnection mllpConnection;
    private final HL7ConnectionMonitor monitor;

    public HL7Connection(HL7Application hl7Application, MLLPConnection mllpConnection) {
        this.hl7Application = hl7Application;
        this.mllpConnection = mllpConnection;
        this.monitor = ((HL7DeviceExtension)hl7Application.getDevice().getDeviceExtensionNotNull(HL7DeviceExtension.class)).getHL7ConnectionMonitor();
    }

    public void writeMessage(UnparsedHL7Message msg) throws IOException {
        try {
            this.mllpConnection.writeMessage(msg.data());
            if (this.monitor != null) {
                this.monitor.onMessageSent(this.hl7Application, this.mllpConnection.getSocket(), msg, null);
            }
        }
        catch (IOException e) {
            this.monitor.onMessageSent(this.hl7Application, this.mllpConnection.getSocket(), msg, e);
            throw e;
        }
    }

    public UnparsedHL7Message readMessage(UnparsedHL7Message msg) throws IOException {
        try {
            byte[] b = this.mllpConnection.readMessage();
            UnparsedHL7Message rsp = b != null ? new UnparsedHL7Message(b) : null;
            this.monitor.onMessageResponse(this.hl7Application, this.mllpConnection.getSocket(), msg, rsp, null);
            return rsp;
        }
        catch (IOException e) {
            this.monitor.onMessageResponse(this.hl7Application, this.mllpConnection.getSocket(), msg, null, e);
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        this.mllpConnection.close();
    }
}

