/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net.hl7;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import org.dcm4che3.hl7.HL7Exception;
import org.dcm4che3.hl7.HL7Message;
import org.dcm4che3.hl7.HL7Segment;
import org.dcm4che3.hl7.MLLPConnection;
import org.dcm4che3.hl7.MLLPRelease;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.TCPProtocolHandler;
import org.dcm4che3.net.hl7.HL7ConnectionMonitor;
import org.dcm4che3.net.hl7.HL7DeviceExtension;
import org.dcm4che3.net.hl7.UnparsedHL7Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum HL7ProtocolHandler implements TCPProtocolHandler
{
    INSTANCE;

    private static Logger LOG;

    public void onAccept(Connection conn, Socket s) throws IOException {
        conn.getDevice().execute((Runnable)new HL7Receiver(conn, s));
    }

    static {
        LOG = LoggerFactory.getLogger(HL7ProtocolHandler.class);
    }

    private static class HL7Receiver
    implements Runnable {
        final Connection conn;
        final Socket s;
        final HL7DeviceExtension hl7dev;

        HL7Receiver(Connection conn, Socket s) {
            this.conn = conn;
            this.s = s;
            this.hl7dev = (HL7DeviceExtension)conn.getDevice().getDeviceExtensionNotNull(HL7DeviceExtension.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int messageCount = 0;
            try {
                byte[] data;
                this.s.setSoTimeout(this.conn.getIdleTimeout());
                MLLPConnection mllp = new MLLPConnection(this.s, this.conn.getProtocol() == Connection.Protocol.HL7_MLLP2 ? MLLPRelease.MLLP2 : MLLPRelease.MLLP1);
                while ((data = mllp.readMessage()) != null) {
                    UnparsedHL7Message rsp;
                    block12: {
                        ++messageCount;
                        HL7ConnectionMonitor monitor = this.hl7dev.getHL7ConnectionMonitor();
                        UnparsedHL7Message msg = new UnparsedHL7Message(data);
                        if (monitor != null) {
                            monitor.onMessageReceived(this.conn, this.s, msg);
                        }
                        try {
                            rsp = this.hl7dev.onMessage(this.conn, this.s, msg);
                            if (monitor != null) {
                                monitor.onMessageProcessed(this.conn, this.s, msg, rsp, null);
                            }
                        }
                        catch (HL7Exception e) {
                            LOG.info("{}: failed to process {}:\n", new Object[]{this.s, msg, e});
                            rsp = new UnparsedHL7Message(HL7Message.makeACK((HL7Segment)msg.msh(), (HL7Exception)e).getBytes(null));
                            if (monitor == null) break block12;
                            monitor.onMessageProcessed(this.conn, this.s, msg, rsp, e);
                        }
                    }
                    mllp.writeMessage(rsp.data());
                }
            }
            catch (IOException e) {
                if (e instanceof SocketException && messageCount == 0) {
                    LOG.info("Exception on accepted connection {}: {}", (Object)this.s, (Object)e.toString());
                } else {
                    LOG.warn("Exception on accepted connection {}:", (Object)this.s, (Object)e);
                }
            }
            finally {
                this.conn.close(this.s);
            }
        }
    }
}

