/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.net.hl7;

import java.io.Serializable;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.dcm4che3.hl7.HL7Segment;

public class UnparsedHL7Message
implements Serializable {
    private static final AtomicInteger prevSerialNo = new AtomicInteger();
    private final int serialNo = prevSerialNo.incrementAndGet();
    private final byte[] data;
    private volatile transient byte[] unescapeXdddd;
    private volatile transient HL7Segment msh;
    private volatile transient int mshLength;

    public UnparsedHL7Message(byte[] data) {
        this.data = data;
    }

    public HL7Segment msh() {
        this.init();
        return this.msh;
    }

    public int getSerialNo() {
        return this.serialNo;
    }

    private void init() {
        if (this.msh == null) {
            ParsePosition pos = new ParsePosition(0);
            this.msh = HL7Segment.parseMSH((byte[])this.data, (int)this.data.length, (ParsePosition)pos);
            this.mshLength = pos.getIndex();
        }
    }

    public byte[] data() {
        return this.data;
    }

    public String toString() {
        if (this.mshLength == 0) {
            int mshlen;
            for (mshlen = 0; mshlen < this.data.length && this.data[mshlen] != 13; ++mshlen) {
            }
            this.mshLength = mshlen;
        }
        return new String(this.data, 0, this.mshLength);
    }

    public byte[] unescapeXdddd() {
        if (this.unescapeXdddd == null) {
            this.unescapeXdddd = UnparsedHL7Message.unescapeXdddd(this.data);
        }
        return this.unescapeXdddd;
    }

    private static byte[] unescapeXdddd(byte[] data) {
        int[] pos = UnparsedHL7Message.findEscapeXdddd(data);
        return pos.length == 0 ? data : UnparsedHL7Message.replaceXdddd(data, pos);
    }

    private static byte[] replaceXdddd(byte[] src, int[] pos) {
        byte[] dest = new byte[src.length - UnparsedHL7Message.calcLengthDecrement(pos)];
        int srcPos = 0;
        int destPos = 0;
        int i = 0;
        do {
            int length = pos[i] - srcPos - 2;
            System.arraycopy(src, srcPos, dest, destPos, length);
            srcPos += length;
            destPos += length;
            length = UnparsedHL7Message.replaceXdddd(src, pos[i], pos[++i], dest, destPos);
            srcPos += 3 + length;
            destPos += length / 2;
        } while (++i < pos.length);
        System.arraycopy(src, srcPos, dest, destPos, src.length - srcPos);
        return dest;
    }

    private static int replaceXdddd(byte[] src, int beginIndex, int endIndex, byte[] dest, int destPos) {
        int i = beginIndex;
        while (i < endIndex) {
            dest[destPos++] = (byte)UnparsedHL7Message.parseHex(src[i++], src[i++]);
        }
        return endIndex - beginIndex;
    }

    private static int calcLengthDecrement(int[] pos) {
        int i = pos.length;
        int l = 0;
        do {
            l += pos[--i];
            l -= pos[--i];
        } while (i > 0);
        return (l + pos.length * 3) / 2;
    }

    private static int[] findEscapeXdddd(byte[] data) {
        int[] pos = new int[]{};
        int x = 0;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == 88) {
                if (i <= 0 || data[i - 1] != data[6]) continue;
                x = i + 1;
                continue;
            }
            if (x <= 0 || data[i] != data[6]) continue;
            if (UnparsedHL7Message.validHexAndNoSeparator(data, x, i)) {
                pos = Arrays.copyOf(pos, pos.length + 2);
                pos[pos.length - 2] = x;
                pos[pos.length - 1] = i;
            }
            x = 0;
        }
        return pos;
    }

    private static boolean validHexAndNoSeparator(byte[] data, int beginIndex, int endIndex) {
        if ((endIndex - beginIndex & 1) != 0) {
            return false;
        }
        int i = beginIndex;
        while (i < endIndex) {
            int d;
            if ((d = UnparsedHL7Message.parseHex(data[i++], data[i++])) >= 0 && d != data[3] && d != data[4] && d != data[5] && d != data[6] && d != data[7]) continue;
            return false;
        }
        return true;
    }

    private static int parseHex(int ch1, int ch2) {
        return UnparsedHL7Message.parseHex(ch1) << 4 | UnparsedHL7Message.parseHex(ch2);
    }

    private static int parseHex(int ch) {
        int d = ch - 48;
        if (d > 9) {
            d = ch - 65;
            if (d > 5 && (d = ch - 97) > 5) {
                return -1;
            }
            if (d >= 0) {
                d += 10;
            }
        }
        return d;
    }
}

