/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.agfa2sr;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Code;
import org.dcm4che3.io.ContentHandlerAdapter;
import org.dcm4che3.io.DicomOutputStream;
import org.dcm4che3.tool.common.CLIUtils;
import org.dcm4che3.util.AttributesFormat;
import org.dcm4che3.util.StreamUtils;
import org.dcm4che3.util.UIDUtils;
import org.xml.sax.ContentHandler;

public class Agfa2SR {
    private static final ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.agfa2sr.messages");
    private static final String XML_1_0 = "1.0";
    private static final String XML_1_1 = "1.1";
    private static final byte[] START_OF_REPORT = new byte[]{60, 97, 103, 102, 97, 58, 68, 105, 97, 103, 110, 111, 115, 116, 105, 99, 82, 97, 100, 105, 111, 108, 111, 103, 121, 82, 101, 112, 111, 114, 116, 32};
    private static final byte[] END_OF_REPORT = new byte[]{60, 47, 97, 103, 102, 97, 58, 68, 105, 97, 103, 110, 111, 115, 116, 105, 99, 82, 97, 100, 105, 111, 108, 111, 103, 121, 82, 101, 112, 111, 114, 116, 62};
    private static final String START_OF_STUDY_IUID = "<StudyInstanceUID>";
    private static final String END_OF_STUDY_IUID = "</StudyInstanceUID>";
    private static final String DEFAULT_XSL = "agfa2sr.xsl";
    private static final String DEFAULT_DOC_TITLE = "(18748-4, LN, \"Diagnostic Imaging Report\")";
    private static final String DEFAULT_LANGUAGE = "(en, RFC5646, \"English\")";
    private static final String DEFAULT_VERIFYING_ORGANIZATION = "N/A";
    private static final String DEFAULT_FORMAT = "{0020000D}";
    private boolean indent;
    private boolean xml;
    private String xsltURL;
    private String xmlVersion;
    private Code languageCode;
    private Code docTitleCode;
    private String verifyingOrganization;
    private AttributesFormat format;
    private Attributes attrs;

    private static String toURL(String fileOrURL) {
        try {
            new URL(fileOrURL);
            return fileOrURL;
        }
        catch (MalformedURLException e) {
            URL resource = Thread.currentThread().getContextClassLoader().getResource(fileOrURL);
            return resource != null ? resource.toString() : Paths.get(fileOrURL, new String[0]).toUri().toString();
        }
    }

    public static void main(String[] args) {
        try {
            CommandLine cl = Agfa2SR.parseComandLine(args);
            Agfa2SR main = new Agfa2SR();
            String xsltURL1 = cl.getOptionValue("x", DEFAULT_XSL);
            main.xsltURL = xsltURL1.equalsIgnoreCase("none") ? null : Agfa2SR.toURL(xsltURL1);
            main.xml = cl.hasOption("xml");
            main.languageCode = new Code(cl.getOptionValue("lang", DEFAULT_LANGUAGE));
            main.docTitleCode = new Code(cl.getOptionValue("title", DEFAULT_DOC_TITLE));
            main.verifyingOrganization = cl.getOptionValue("verifying-org", DEFAULT_VERIFYING_ORGANIZATION);
            main.format = new AttributesFormat(cl.getOptionValue("p", DEFAULT_FORMAT));
            main.indent = cl.hasOption("I");
            main.xmlVersion = cl.hasOption("xml11") ? XML_1_1 : XML_1_0;
            main.attrs = new Attributes();
            CLIUtils.addAttributes((Attributes)main.attrs, (String[])cl.getOptionValues("s"));
            main.mconvert(Paths.get(Agfa2SR.fname(cl.getArgList()), new String[0]), cl.getOptionValue("d", "."));
        }
        catch (ParseException e) {
            System.err.println("agfa2sr: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("agfa2sr: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        CLIUtils.addCommonOptions((Options)opts);
        opts.addOption(Option.builder((String)"x").longOpt("xsl").hasArg().argName("xsl-file").desc(rb.getString("xsl")).build());
        opts.addOption(Option.builder().longOpt("title").hasArg().argName("code").desc(rb.getString("title")).build());
        opts.addOption(Option.builder().longOpt("lang").hasArg().argName("code").desc(rb.getString("lang")).build());
        opts.addOption(Option.builder().longOpt("org").hasArg().argName("name").desc(rb.getString("org")).build());
        opts.addOption(Option.builder((String)"d").hasArg().argName("out-dir").desc(rb.getString("out-dir")).build());
        opts.addOption(Option.builder((String)"p").hasArg().argName("pattern").desc(rb.getString("pattern")).build());
        opts.addOption(Option.builder((String)"s").hasArgs().argName("[seq.]attr=value").desc(rb.getString("set")).build());
        opts.addOption("I", "indent", false, rb.getString("indent"));
        opts.addOption(null, "xml", false, rb.getString("xml"));
        opts.addOption(null, "xml11", false, rb.getString("xml11"));
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, Agfa2SR.class);
    }

    private static String fname(List<String> argList) throws ParseException {
        int numArgs = argList.size();
        if (numArgs == 0) {
            throw new ParseException(rb.getString("missing"));
        }
        if (numArgs > 1) {
            throw new ParseException(rb.getString("too-many"));
        }
        return argList.get(0);
    }

    private void mconvert(Path srcPath, String outDir) throws Exception {
        Path dir = Paths.get(outDir, new String[0]);
        Files.createDirectories(dir, new FileAttribute[0]);
        Transformer t = this.newTransformer();
        int extracted = 0;
        int missingStudyIUIDs = 0;
        ArrayList<Exception> failures = new ArrayList<Exception>();
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(srcPath, new OpenOption[0]));){
            ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
            while (Agfa2SR.indexOf(in, START_OF_REPORT, null) >= 0) {
                block32: {
                    out.reset();
                    out.write(START_OF_REPORT);
                    int reportLength = Agfa2SR.indexOf(in, END_OF_REPORT, out);
                    if (reportLength < 0) {
                        System.out.printf("%nUnexpected EOF - missing </agfa:DiagnosticRadiologyReport>", new Object[0]);
                        break;
                    }
                    String report = new String(out.toByteArray(), StandardCharsets.UTF_8);
                    String siuid = Agfa2SR.cutStudyInstanceUID(report);
                    if (siuid == null) {
                        ++missingStudyIUIDs;
                        System.out.print('I');
                        continue;
                    }
                    try {
                        BufferedWriter w;
                        if (t == null) {
                            w = this.getWriter(outDir, siuid);
                            try {
                                w.write(report);
                                break block32;
                            }
                            finally {
                                if (w != null) {
                                    ((Writer)w).close();
                                }
                            }
                        }
                        t.setParameter("SeriesInstanceUID", UIDUtils.remapUID((String)siuid));
                        t.setParameter("SOPInstanceUID", UIDUtils.remapUID((String)(siuid + "1")));
                        if (this.xml) {
                            w = this.getWriter(outDir, siuid);
                            try {
                                t.transform(new StreamSource(new StringReader(report)), new StreamResult(w));
                                break block32;
                            }
                            finally {
                                if (w != null) {
                                    ((Writer)w).close();
                                }
                            }
                        }
                        Attributes attrs = new Attributes(this.attrs);
                        t.transform(new StreamSource(new StringReader(report)), new SAXResult((ContentHandler)new ContentHandlerAdapter(attrs)));
                        File file = new File(outDir, this.format.format((Object)attrs));
                        file.getParentFile().mkdirs();
                        try (DicomOutputStream dos = new DicomOutputStream(file);){
                            dos.writeDataset(attrs.createFileMetaInformation("1.2.840.10008.1.2.1"), attrs);
                        }
                    }
                    catch (Exception e) {
                        failures.add(e);
                        System.out.print('E');
                        continue;
                    }
                }
                ++extracted;
                System.out.print('.');
            }
        }
        System.out.println();
        if (missingStudyIUIDs > 0) {
            System.out.printf("Ignored %d reports with missing Study Instance UID.%n", missingStudyIUIDs);
        }
        if (!failures.isEmpty()) {
            System.out.printf("Failed to extract %d reports:%n", failures.size());
            failures.forEach(System.out::println);
        }
        System.out.printf("Extracted %d reports from %s into %s/.%n", extracted, srcPath.toAbsolutePath(), dir.toAbsolutePath());
    }

    private BufferedWriter getWriter(String outDir, String siuid) throws IOException {
        return Files.newBufferedWriter(Paths.get(outDir, siuid + ".xml"), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private static String cutStudyInstanceUID(String report) {
        int end;
        int start = report.indexOf(START_OF_STUDY_IUID);
        if (start >= 0 && (end = report.indexOf(END_OF_STUDY_IUID, start += START_OF_STUDY_IUID.length())) >= 0) {
            return report.substring(start, end).trim();
        }
        return null;
    }

    private Transformer newTransformer() throws Exception {
        if (this.xsltURL == null) {
            return null;
        }
        SAXTransformerFactory tf = (SAXTransformerFactory)TransformerFactory.newInstance();
        Transformer t = tf.newTemplates(new StreamSource(this.xsltURL)).newTransformer();
        t.setOutputProperty("indent", this.indent ? "yes" : "no");
        if (this.indent) {
            t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        }
        t.setOutputProperty("version", this.xmlVersion);
        t.setParameter("langCodeValue", this.languageCode.getCodeValue());
        t.setParameter("langCodingSchemeDesignator", this.languageCode.getCodingSchemeDesignator());
        t.setParameter("langCodeMeaning", this.languageCode.getCodeMeaning());
        t.setParameter("docTitleCodeValue", this.docTitleCode.getCodeValue());
        t.setParameter("docTitleCodingSchemeDesignator", this.docTitleCode.getCodingSchemeDesignator());
        t.setParameter("docTitleCodeMeaning", this.docTitleCode.getCodeMeaning());
        t.setParameter("VerifyingOrganization", this.verifyingOrganization);
        t.setParameter("SpecificCharacterSet", this.attrs.getString(524293, ""));
        t.setParameter("SOPClassUID", this.attrs.getString(524310, "1.2.840.10008.5.1.4.1.1.88.11"));
        t.setParameter("Manufacturer", this.attrs.getString(524400, ""));
        t.setParameter("SeriesNumber", this.attrs.getString(0x200011, "0"));
        t.setParameter("InstanceNumber", this.attrs.getString(2097171, "1"));
        return t;
    }

    private static int indexOf(InputStream in, byte[] pattern, OutputStream out) throws IOException {
        int len;
        int index = 0;
        int length = pattern.length;
        byte b0 = pattern[0];
        byte[] b = new byte[length];
        int off = 0;
        while (StreamUtils.readAvailable((InputStream)in, (byte[])b, (int)off, (int)(len = length - off)) == len) {
            if (out != null) {
                out.write(b, off, len);
            }
            if (Arrays.equals(b, pattern)) {
                return index;
            }
            int i = 0;
            while (++i < length && b[i] != b0) {
            }
            index += i;
            off = length - i;
            if (off <= 0) continue;
            System.arraycopy(b, i, b, 0, off);
        }
        return -1;
    }
}

