/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.common;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.UID;
import org.dcm4che3.data.VR;
import org.dcm4che3.io.BasicBulkDataDescriptor;
import org.dcm4che3.io.DicomEncodingOptions;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.SSLManagerFactory;
import org.dcm4che3.net.pdu.AAssociateRQ;
import org.dcm4che3.net.pdu.UserIdentityRQ;
import org.dcm4che3.tool.common.DetectEndOfOptionsPosixParser;
import org.dcm4che3.tool.common.FilesetInfo;
import org.dcm4che3.util.SafeClose;
import org.dcm4che3.util.StreamUtils;
import org.dcm4che3.util.StringUtils;
import org.slf4j.Logger;

public class CLIUtils {
    public static ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.common.messages");
    private static String[] IVR_LE_FIRST = new String[]{"1.2.840.10008.1.2", "1.2.840.10008.1.2.1", "1.2.840.10008.1.2.2"};
    private static String[] EVR_LE_FIRST = new String[]{"1.2.840.10008.1.2.1", "1.2.840.10008.1.2.2", "1.2.840.10008.1.2"};
    private static String[] EVR_BE_FIRST = new String[]{"1.2.840.10008.1.2.2", "1.2.840.10008.1.2.1", "1.2.840.10008.1.2"};
    private static String[] IVR_LE_ONLY = new String[]{"1.2.840.10008.1.2"};

    public static void addCommonOptions(Options opts) {
        opts.addOption("h", "help", false, rb.getString("help"));
        opts.addOption("V", "version", false, rb.getString("version"));
    }

    public static void addBindOption(Options opts, String defAET) {
        opts.addOption(Option.builder((String)"b").hasArg().argName("aet[@ip][:port]").desc(MessageFormat.format(rb.getString("bind"), defAET)).longOpt("bind").build());
    }

    public static void addBindClientOption(Options opts, String defAET) {
        opts.addOption(Option.builder((String)"b").hasArg().argName("aet[@ip]").desc(MessageFormat.format(rb.getString("bind-client"), defAET)).longOpt("bind").build());
    }

    public static void addConnectOption(Options opts) {
        opts.addOption(Option.builder((String)"c").hasArg().argName("aet@host:port").desc(rb.getString("connect")).longOpt("connect").build());
        opts.addOption(Option.builder().hasArg().argName("[user:password@]host:port").desc(rb.getString("proxy")).longOpt("proxy").build());
        CLIUtils.addUserIdentityOptions(opts);
        CLIUtils.addConnectTimeoutOption(opts);
        CLIUtils.addAcceptTimeoutOption(opts);
    }

    public static void addBindServerOption(Options opts) {
        opts.addOption(Option.builder((String)"b").hasArg().argName("[aet[@ip]:]port").desc(rb.getString("bind-server")).longOpt("bind").build());
        CLIUtils.addRequestTimeoutOption(opts);
    }

    private static void addUserIdentityOptions(Options opts) {
        OptionGroup group = new OptionGroup();
        group.addOption(Option.builder().hasArg().argName("name").desc(rb.getString("user")).longOpt("user").build());
        opts.addOption(Option.builder().hasArg().argName("assertion").desc(rb.getString("user-saml")).longOpt("user-saml").build());
        opts.addOption(Option.builder().hasArg().argName("token").desc(rb.getString("user-jwt")).longOpt("user-jwt").build());
        opts.addOptionGroup(group);
        opts.addOption(Option.builder().hasArg().argName("password").desc(rb.getString("user-pass")).longOpt("user-pass").build());
        opts.addOption(null, "user-rsp", false, rb.getString("user-rsp"));
    }

    public static void addAEOptions(Options opts) {
        opts.addOption(Option.builder().hasArg().argName("length").desc(rb.getString("max-pdulen-rcv")).longOpt("max-pdulen-rcv").build());
        opts.addOption(Option.builder().hasArg().argName("length").desc(rb.getString("max-pdulen-snd")).longOpt("max-pdulen-snd").build());
        opts.addOption(Option.builder().hasArg().argName("no").desc(rb.getString("max-ops-invoked")).longOpt("max-ops-invoked").build());
        opts.addOption(Option.builder().hasArg().argName("no").desc(rb.getString("max-ops-performed")).longOpt("max-ops-performed").build());
        opts.addOption(null, "not-async", false, rb.getString("not-async"));
        opts.addOption(null, "not-pack-pdv", false, rb.getString("not-pack-pdv"));
        opts.addOption(Option.builder().hasArg().argName("ms").desc(rb.getString("idle-timeout")).longOpt("idle-timeout").build());
        opts.addOption(Option.builder().hasArg().argName("ms").desc(rb.getString("release-timeout")).longOpt("release-timeout").build());
        opts.addOption(Option.builder().hasArg().argName("ms").desc(rb.getString("soclose-delay")).longOpt("soclose-delay").build());
        CLIUtils.addSocketOptions(opts);
        CLIUtils.addTLSOptions(opts);
    }

    public static void addAcceptedCallingAETs(Options opts) {
        opts.addOption(Option.builder().hasArgs().argName("aet").desc(rb.getString("accepted-calling-aets")).longOpt("accept").build());
    }

    public static void addRequestTimeoutOption(Options opts) {
        opts.addOption(Option.builder().hasArg().argName("ms").desc(rb.getString("request-timeout")).longOpt("request-timeout").build());
    }

    public static void addAcceptTimeoutOption(Options opts) {
        opts.addOption(Option.builder().hasArg().argName("ms").desc(rb.getString("accept-timeout")).longOpt("accept-timeout").build());
    }

    public static void addSocketOptions(Options opts) {
        opts.addOption(Option.builder().hasArg().argName("length").desc(rb.getString("sosnd-buffer")).longOpt("sosnd-buffer").build());
        opts.addOption(Option.builder().hasArg().argName("length").desc(rb.getString("sorcv-buffer")).longOpt("sorcv-buffer").build());
        opts.addOption(null, "tcp-delay", false, rb.getString("tcp-delay"));
    }

    public static void addConnectTimeoutOption(Options opts) {
        opts.addOption(Option.builder().hasArg().argName("ms").desc(rb.getString("connect-timeout")).longOpt("connect-timeout").build());
    }

    public static void addSendTimeoutOption(Options opts) {
        opts.addOption(Option.builder().hasArg().argName("ms").desc(rb.getString("send-timeout")).longOpt("send-timeout").build());
    }

    public static void addStoreTimeoutOption(Options opts) {
        opts.addOption(Option.builder().hasArg().argName("ms").desc(rb.getString("store-timeout")).longOpt("store-timeout").build());
    }

    public static void addResponseTimeoutOption(Options opts) {
        opts.addOption(Option.builder().hasArg().argName("ms").desc(rb.getString("response-timeout")).longOpt("response-timeout").build());
    }

    public static void addRetrieveTimeoutOption(Options opts) {
        OptionGroup group = new OptionGroup();
        group.addOption(Option.builder().hasArg().argName("ms").desc(rb.getString("retrieve-timeout")).longOpt("retrieve-timeout").build());
        group.addOption(Option.builder().hasArg().argName("ms").desc(rb.getString("retrieve-timeout-total")).longOpt("retrieve-timeout-total").build());
        opts.addOptionGroup(group);
    }

    public static void addTLSOptions(Options opts) {
        CLIUtils.addTLSCipherOptions(opts);
        opts.addOption(Option.builder().hasArg().argName("protocol").desc(rb.getString("tls-protocol")).longOpt("tls-protocol").build());
        opts.addOption(null, "tls1", false, rb.getString("tls1"));
        opts.addOption(null, "tls11", false, rb.getString("tls11"));
        opts.addOption(null, "tls12", false, rb.getString("tls12"));
        opts.addOption(null, "tls13", false, rb.getString("tls13"));
        opts.addOption(null, "ssl3", false, rb.getString("ssl3"));
        opts.addOption(null, "ssl2Hello", false, rb.getString("ssl2Hello"));
        opts.addOption(null, "tls-eia-https", false, rb.getString("tls-eia-https"));
        opts.addOption(null, "tls-eia-ldaps", false, rb.getString("tls-eia-ldaps"));
        opts.addOption(null, "tls-noauth", false, rb.getString("tls-noauth"));
        opts.addOption(Option.builder().hasArg().argName("file|url").desc(rb.getString("key-store")).longOpt("key-store").build());
        opts.addOption(Option.builder().hasArg().argName("storetype").desc(rb.getString("key-store-type")).longOpt("key-store-type").build());
        opts.addOption(Option.builder().hasArg().argName("password").desc(rb.getString("key-store-pass")).longOpt("key-store-pass").build());
        opts.addOption(Option.builder().hasArg().argName("password").desc(rb.getString("key-pass")).longOpt("key-pass").build());
        opts.addOption(Option.builder().hasArg().argName("file|url").desc(rb.getString("trust-store")).longOpt("trust-store").build());
        opts.addOption(Option.builder().hasArg().argName("storetype").desc(rb.getString("trust-store-type")).longOpt("trust-store-type").build());
        opts.addOption(Option.builder().hasArg().argName("password").desc(rb.getString("trust-store-pass")).longOpt("trust-store-pass").build());
    }

    public static void addTLSCipherOptions(Options opts) {
        opts.addOption(Option.builder().hasArg().argName("cipher").desc(rb.getString("tls-cipher")).longOpt("tls-cipher").build());
        opts.addOption(null, "tls", false, rb.getString("tls"));
        opts.addOption(null, "tls-null", false, rb.getString("tls-null"));
        opts.addOption(null, "tls-3des", false, rb.getString("tls-3des"));
        opts.addOption(null, "tls-aes", false, rb.getString("tls-aes"));
    }

    public static void addMLLP2Option(Options opts) {
        opts.addOption(null, "mllp2", false, rb.getString("mllp2"));
    }

    public static boolean isMLLP2(CommandLine cl) {
        return cl.hasOption("mllp2");
    }

    public static void addPriorityOption(Options opts) {
        OptionGroup group = new OptionGroup();
        group.addOption(Option.builder().longOpt("prior-high").desc(rb.getString("prior-high")).build());
        group.addOption(Option.builder().longOpt("prior-low").desc(rb.getString("prior-low")).build());
        opts.addOptionGroup(group);
    }

    public static CommandLine parseComandLine(String[] args, Options opts, ResourceBundle rb2, Class<?> clazz) throws ParseException {
        DetectEndOfOptionsPosixParser parser = new DetectEndOfOptionsPosixParser();
        CommandLine cl = parser.parse(opts, args);
        if (cl.hasOption("h")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(rb2.getString("usage"), rb2.getString("description"), opts, rb2.getString("example"));
            System.exit(0);
        }
        if (cl.hasOption("V")) {
            Package p = clazz.getPackage();
            String s = p.getName();
            System.out.println(s.substring(s.lastIndexOf(46) + 1) + ": " + p.getImplementationVersion());
            System.exit(0);
        }
        return cl;
    }

    public static void configureConnect(Connection conn, AAssociateRQ rq, CommandLine cl) throws ParseException {
        if (!cl.hasOption("c")) {
            throw new MissingOptionException(rb.getString("missing-connect-opt"));
        }
        String aeAtHostPort = cl.getOptionValue("c");
        String[] aeHostPort = CLIUtils.split(aeAtHostPort, '@', 0);
        if (aeHostPort[1] == null) {
            throw new ParseException(rb.getString("invalid-connect-opt"));
        }
        String[] hostPort = CLIUtils.split(aeHostPort[1], ':', 0);
        if (hostPort[1] == null) {
            throw new ParseException(rb.getString("invalid-connect-opt"));
        }
        rq.setCalledAET(aeHostPort[0]);
        conn.setHostname(hostPort[0]);
        conn.setPort(Integer.parseInt(hostPort[1]));
        conn.setHttpProxy(cl.getOptionValue("proxy"));
        if (cl.hasOption("user")) {
            rq.setUserIdentityRQ(cl.hasOption("user-pass") ? UserIdentityRQ.usernamePasscode((String)cl.getOptionValue("user"), (char[])cl.getOptionValue("user-pass").toCharArray(), (boolean)cl.hasOption("user-rsp")) : UserIdentityRQ.username((String)cl.getOptionValue("user"), (boolean)cl.hasOption("user-rsp")));
        } else if (cl.hasOption("user-saml")) {
            rq.setUserIdentityRQ(UserIdentityRQ.saml((String)cl.getOptionValue("user-saml"), (boolean)cl.hasOption("user-rsp")));
        } else if (cl.hasOption("user-jwt")) {
            rq.setUserIdentityRQ(UserIdentityRQ.jwt((String)cl.getOptionValue("user-jwt"), (boolean)cl.hasOption("user-rsp")));
        }
    }

    public static void configureBind(Connection conn, ApplicationEntity ae, CommandLine cl) throws ParseException {
        if (cl.hasOption("b")) {
            String aeAtHostPort = cl.getOptionValue("b");
            String[] aeAtHostAndPort = CLIUtils.split(aeAtHostPort, ':', 0);
            String[] aeHost = CLIUtils.split(aeAtHostAndPort[0], '@', 0);
            ae.setAETitle(aeHost[0]);
            if (aeHost[1] != null) {
                conn.setHostname(aeHost[1]);
            }
            if (aeAtHostAndPort[1] != null) {
                conn.setPort(Integer.parseInt(aeAtHostAndPort[1]));
            }
        }
    }

    public static void configureBindServer(Connection conn, ApplicationEntity ae, CommandLine cl) throws ParseException {
        if (!cl.hasOption("b")) {
            throw new MissingOptionException(rb.getString("missing-bind-opt"));
        }
        String aeAtHostPort = cl.getOptionValue("b");
        String[] aeAtHostAndPort = CLIUtils.split(aeAtHostPort, ':', 1);
        conn.setPort(Integer.parseInt(aeAtHostAndPort[1]));
        if (aeAtHostAndPort[0] != null) {
            String[] aeHost = CLIUtils.split(aeAtHostAndPort[0], '@', 0);
            ae.setAETitle(aeHost[0]);
            if (aeHost[1] != null) {
                conn.setHostname(aeHost[1]);
            }
        }
    }

    private static String[] split(String s, char delim, int defPos) {
        String[] s2 = new String[2];
        int pos = s.indexOf(delim);
        if (pos != -1) {
            s2[0] = s.substring(0, pos);
            s2[1] = s.substring(pos + 1);
        } else {
            s2[defPos] = s;
        }
        return s2;
    }

    public static int priorityOf(CommandLine cl) {
        return cl.hasOption("prior-high") ? 1 : (cl.hasOption("prior-low") ? 2 : 0);
    }

    public static int getIntOption(CommandLine cl, String opt, int defVal) {
        String optVal = cl.getOptionValue(opt);
        if (optVal == null) {
            return defVal;
        }
        return CLIUtils.parseInt(optVal);
    }

    private static int parseInt(String optVal) {
        return optVal.endsWith("H") ? Integer.parseInt(optVal.substring(0, optVal.length() - 1), 16) : Integer.parseInt(optVal);
    }

    public static int[] getIntsOption(CommandLine cl, String opt) {
        String[] optVals = cl.getOptionValues(opt);
        if (optVals == null) {
            return null;
        }
        int[] intVals = new int[optVals.length];
        for (int i = 0; i < optVals.length; ++i) {
            intVals[i] = CLIUtils.parseInt(optVals[i]);
        }
        return intVals;
    }

    public static void configure(Connection conn, CommandLine cl) throws ParseException, IOException {
        conn.setReceivePDULength(CLIUtils.getIntOption(cl, "max-pdulen-rcv", 16378));
        conn.setSendPDULength(CLIUtils.getIntOption(cl, "max-pdulen-snd", 16378));
        if (cl.hasOption("not-async")) {
            conn.setMaxOpsInvoked(1);
            conn.setMaxOpsPerformed(1);
        } else {
            conn.setMaxOpsInvoked(CLIUtils.getIntOption(cl, "max-ops-invoked", 0));
            conn.setMaxOpsPerformed(CLIUtils.getIntOption(cl, "max-ops-performed", 0));
        }
        conn.setPackPDV(!cl.hasOption("not-pack-pdv"));
        conn.setConnectTimeout(CLIUtils.getIntOption(cl, "connect-timeout", 0));
        conn.setRequestTimeout(CLIUtils.getIntOption(cl, "request-timeout", 0));
        conn.setAcceptTimeout(CLIUtils.getIntOption(cl, "accept-timeout", 0));
        conn.setReleaseTimeout(CLIUtils.getIntOption(cl, "release-timeout", 0));
        conn.setSendTimeout(CLIUtils.getIntOption(cl, "send-timeout", 0));
        conn.setStoreTimeout(CLIUtils.getIntOption(cl, "store-timeout", 0));
        conn.setResponseTimeout(CLIUtils.getIntOption(cl, "response-timeout", 0));
        if (cl.hasOption("retrieve-timeout")) {
            conn.setRetrieveTimeout(CLIUtils.getIntOption(cl, "retrieve-timeout", 0));
            conn.setRetrieveTimeoutTotal(false);
        } else if (cl.hasOption("retrieve-timeout-total")) {
            conn.setRetrieveTimeout(CLIUtils.getIntOption(cl, "retrieve-timeout-total", 0));
            conn.setRetrieveTimeoutTotal(true);
        }
        conn.setIdleTimeout(CLIUtils.getIntOption(cl, "idle-timeout", 0));
        conn.setSocketCloseDelay(CLIUtils.getIntOption(cl, "soclose-delay", 50));
        conn.setSendBufferSize(CLIUtils.getIntOption(cl, "sosnd-buffer", 0));
        conn.setReceiveBufferSize(CLIUtils.getIntOption(cl, "sorcv-buffer", 0));
        conn.setTcpNoDelay(!cl.hasOption("tcp-delay"));
        CLIUtils.configureTLS(conn, cl);
    }

    public static void configureAcceptedCallingAETitles(ApplicationEntity ae, CommandLine cl, Logger log) {
        Object[] aets = cl.getOptionValues("accept");
        if (aets != null) {
            ae.setAcceptedCallingAETitles((String[])aets);
            log.info("Accepted Calling AE titles are {}.", (Object)Arrays.toString(aets));
        }
    }

    public static boolean configureTLSCipher(Connection conn, CommandLine cl) throws ParseException {
        if (cl.hasOption("tls")) {
            conn.setTlsCipherSuites(new String[]{"SSL_RSA_WITH_NULL_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA"});
        } else if (cl.hasOption("tls-null")) {
            conn.setTlsCipherSuites(new String[]{"SSL_RSA_WITH_NULL_SHA"});
        } else if (cl.hasOption("tls-3des")) {
            conn.setTlsCipherSuites(new String[]{"SSL_RSA_WITH_3DES_EDE_CBC_SHA"});
        } else if (cl.hasOption("tls-aes")) {
            conn.setTlsCipherSuites(new String[]{"TLS_RSA_WITH_AES_128_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA"});
        } else if (cl.hasOption("tls-cipher")) {
            conn.setTlsCipherSuites(cl.getOptionValues("tls-cipher"));
        }
        return conn.isTls();
    }

    private static void configureTLS(Connection conn, CommandLine cl) throws ParseException, IOException {
        if (!CLIUtils.configureTLSCipher(conn, cl)) {
            return;
        }
        if (cl.hasOption("tls13")) {
            conn.setTlsProtocols(new String[]{"TLSv1.3"});
        } else if (cl.hasOption("tls12")) {
            conn.setTlsProtocols(new String[]{"TLSv1.2"});
        } else if (cl.hasOption("tls11")) {
            conn.setTlsProtocols(new String[]{"TLSv1.1"});
        } else if (cl.hasOption("tls1")) {
            conn.setTlsProtocols(new String[]{"TLSv1"});
        } else if (cl.hasOption("ssl3")) {
            conn.setTlsProtocols(new String[]{"SSLv3"});
        } else if (cl.hasOption("ssl2Hello")) {
            conn.setTlsProtocols(new String[]{"SSLv2Hello", "SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2"});
        } else if (cl.hasOption("tls-protocol")) {
            conn.setTlsProtocols(cl.getOptionValues("tls-protocol"));
        }
        if (cl.hasOption("tls-eia-https")) {
            conn.setTlsEndpointIdentificationAlgorithm(Connection.EndpointIdentificationAlgorithm.HTTPS);
        } else if (cl.hasOption("tls-eia-ldaps")) {
            conn.setTlsEndpointIdentificationAlgorithm(Connection.EndpointIdentificationAlgorithm.LDAPS);
        }
        conn.setTlsNeedClientAuth(!cl.hasOption("tls-noauth"));
        String keyStoreURL = cl.getOptionValue("key-store", "resource:key.p12");
        String keyStoreType = cl.getOptionValue("key-store-type", "PKCS12");
        String keyStorePass = cl.getOptionValue("key-store-pass", "secret");
        String keyPass = cl.getOptionValue("key-pass", keyStorePass);
        String trustStoreURL = cl.getOptionValue("trust-store", "resource:cacerts.p12");
        String trustStoreType = cl.getOptionValue("trust-store-type", "PKCS12");
        String trustStorePass = cl.getOptionValue("trust-store-pass", "secret");
        Device device = conn.getDevice();
        try {
            if (!keyStoreURL.isEmpty()) {
                device.setKeyManager(SSLManagerFactory.createKeyManager((String)keyStoreType, (String)keyStoreURL, (String)keyStorePass, (String)keyPass));
            }
            device.setTrustManager(SSLManagerFactory.createTrustManager((String)trustStoreType, (String)trustStoreURL, (String)trustStorePass));
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    public static Properties loadProperties(String url, Properties p) throws IOException {
        if (p == null) {
            p = new Properties();
        }
        InputStream in = StreamUtils.openFileOrURL((String)url);
        try {
            p.load(in);
        }
        finally {
            SafeClose.close((Closeable)in);
        }
        return p;
    }

    public static void addEncodingOptions(Options opts) {
        opts.addOption(null, "group-len", false, rb.getString("group-len"));
        OptionGroup sqlenGroup = new OptionGroup();
        sqlenGroup.addOption(Option.builder().longOpt("expl-seq-len").desc(rb.getString("expl-seq-len")).build());
        sqlenGroup.addOption(Option.builder().longOpt("undef-seq-len").desc(rb.getString("undef-seq-len")).build());
        opts.addOptionGroup(sqlenGroup);
        OptionGroup itemlenGroup = new OptionGroup();
        itemlenGroup.addOption(Option.builder().longOpt("expl-item-len").desc(rb.getString("expl-item-len")).build());
        itemlenGroup.addOption(Option.builder().longOpt("undef-item-len").desc(rb.getString("undef-item-len")).build());
        opts.addOptionGroup(itemlenGroup);
    }

    public static DicomEncodingOptions encodingOptionsOf(CommandLine cl) throws ParseException {
        if (cl.hasOption("expl-item-len") && cl.hasOption("undef-item-len") || cl.hasOption("expl-seq-len") && cl.hasOption("undef-seq-len")) {
            throw new ParseException(rb.getString("conflicting-enc-opts"));
        }
        return new DicomEncodingOptions(cl.hasOption("group-len"), !cl.hasOption("expl-seq-len"), cl.hasOption("undef-seq-len"), !cl.hasOption("expl-item-len"), cl.hasOption("undef-item-len"));
    }

    public static int[] toTags(String[] tagOrKeywords) {
        int[] tags = new int[tagOrKeywords.length];
        for (int i = 0; i < tags.length; ++i) {
            tags[i] = CLIUtils.toTag(tagOrKeywords[i]);
        }
        return tags;
    }

    public static int toTag(String tagOrKeyword) {
        try {
            return Integer.parseUnsignedInt(tagOrKeyword, 16);
        }
        catch (IllegalArgumentException e) {
            int tag = ElementDictionary.tagForKeyword((String)tagOrKeyword, null);
            if (tag == -1) {
                throw new IllegalArgumentException(tagOrKeyword);
            }
            return tag;
        }
    }

    public static void addFilesetInfoOptions(Options opts) {
        opts.addOption(Option.builder().longOpt("fs-desc").hasArg().argName("txtfile").desc(rb.getString("fs-desc")).build());
        opts.addOption(Option.builder().longOpt("fs-desc-cs").hasArg().argName("code").desc(rb.getString("fs-desc-cs")).build());
        opts.addOption(Option.builder().longOpt("fs-id").hasArg().argName("id").desc(rb.getString("fs-id")).build());
        opts.addOption(Option.builder().longOpt("fs-uid").hasArg().argName("uid").desc(rb.getString("fs-uid")).build());
    }

    public static void configure(FilesetInfo fsInfo, CommandLine cl) {
        fsInfo.setFilesetUID(cl.getOptionValue("fs-uid"));
        fsInfo.setFilesetID(cl.getOptionValue("fs-id"));
        if (cl.hasOption("fs-desc")) {
            fsInfo.setDescriptorFile(new File(cl.getOptionValue("fs-desc")));
        }
        fsInfo.setDescriptorFileCharset(cl.getOptionValue("fs-desc-cs"));
    }

    public static void addTransferSyntaxOptions(Options opts) {
        OptionGroup group = new OptionGroup();
        group.addOption(Option.builder().longOpt("explicit-vr").desc(rb.getString("explicit-vr")).build());
        group.addOption(Option.builder().longOpt("big-endian").desc(rb.getString("big-endian")).build());
        group.addOption(Option.builder().longOpt("implicit-vr").desc(rb.getString("implicit-vr")).build());
        opts.addOptionGroup(group);
    }

    public static String[] transferSyntaxesOf(CommandLine cl) {
        if (cl.hasOption("explicit-vr")) {
            return EVR_LE_FIRST;
        }
        if (cl.hasOption("big-endian")) {
            return EVR_BE_FIRST;
        }
        if (cl.hasOption("implicit-vr")) {
            return IVR_LE_ONLY;
        }
        return IVR_LE_FIRST;
    }

    public static void addAttributes(Attributes attrs, int[] tags, String ... ss) {
        Attributes item = attrs;
        for (int i = 0; i < tags.length - 1; ++i) {
            int tag = tags[i];
            Sequence sq = item.getSequence(tag);
            if (sq == null) {
                sq = item.newSequence(tag, 1);
            }
            if (sq.isEmpty()) {
                sq.add(new Attributes());
            }
            item = (Attributes)sq.get(0);
        }
        int tag = tags[tags.length - 1];
        VR vr = ElementDictionary.vrOf((int)tag, (String)item.getPrivateCreator(tag));
        if (ss.length == 0 || ss.length == 1 && ss[0].isEmpty()) {
            if (vr == VR.SQ) {
                item.newSequence(tag, 1).add(new Attributes(0));
            } else {
                item.setNull(tag, vr);
            }
        } else {
            item.setString(tag, vr, ss);
        }
    }

    public static void addAttributes(Attributes attrs, String[] optVals) {
        if (optVals != null) {
            for (String optVal : optVals) {
                int delim = optVal.indexOf(61);
                if (delim < 0) {
                    CLIUtils.addAttributes(attrs, CLIUtils.toTags(StringUtils.split((String)optVal, (char)'.')), new String[0]);
                    continue;
                }
                CLIUtils.addAttributes(attrs, CLIUtils.toTags(StringUtils.split((String)optVal.substring(0, delim), (char)'.')), optVal.substring(delim + 1));
            }
        }
    }

    public static void addEmptyAttributes(Attributes attrs, String[] optVals) {
        if (optVals != null) {
            for (int i = 0; i < optVals.length; ++i) {
                CLIUtils.addAttributes(attrs, CLIUtils.toTags(StringUtils.split((String)optVals[i], (char)'.')), new String[0]);
            }
        }
    }

    public static void addTagPaths(BasicBulkDataDescriptor desc, String[] optVals) {
        if (optVals != null) {
            for (int i = 0; i < optVals.length; ++i) {
                desc.addTagPath(CLIUtils.toTags(StringUtils.split((String)optVals[i], (char)'.')));
            }
        }
    }

    public static boolean updateAttributes(Attributes data, Attributes attrs, String uidSuffix) {
        if (attrs.isEmpty() && uidSuffix == null) {
            return false;
        }
        if (uidSuffix != null) {
            data.setString(0x20000D, VR.UI, data.getString(0x20000D) + uidSuffix);
            data.setString(0x20000E, VR.UI, data.getString(0x20000E) + uidSuffix);
            data.setString(524312, VR.UI, data.getString(524312) + uidSuffix);
        }
        data.update(Attributes.UpdatePolicy.OVERWRITE, attrs, null);
        return true;
    }

    public static String[] toUIDs(String s) {
        if (s.equals("*")) {
            return new String[]{"*"};
        }
        String[] uids = StringUtils.split((String)s, (char)',');
        for (int i = 0; i < uids.length; ++i) {
            uids[i] = CLIUtils.toUID(uids[i]);
        }
        return uids;
    }

    public static String toUID(String uid) {
        return (uid = uid.trim()).equals("*") || Character.isDigit(uid.charAt(0)) ? uid : UID.forName((String)uid);
    }
}

