/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.dcm2dcm;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PatternOptionBuilder;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Fragments;
import org.dcm4che3.data.VR;
import org.dcm4che3.imageio.codec.Compressor;
import org.dcm4che3.imageio.codec.Decompressor;
import org.dcm4che3.imageio.codec.Transcoder;
import org.dcm4che3.imageio.codec.TransferSyntaxType;
import org.dcm4che3.io.DicomEncodingOptions;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.io.DicomOutputStream;
import org.dcm4che3.tool.common.CLIUtils;
import org.dcm4che3.util.Property;
import org.dcm4che3.util.SafeClose;

public class Dcm2Dcm {
    private static ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.dcm2dcm.messages");
    private String tsuid;
    private TransferSyntaxType tstype;
    private boolean retainfmi;
    private boolean nofmi;
    private boolean legacy;
    private DicomEncodingOptions encOpts = DicomEncodingOptions.DEFAULT;
    private final List<Property> params = new ArrayList<Property>();
    private int maxThreads = 1;

    public final void setTransferSyntax(String uid) {
        this.tsuid = uid;
        this.tstype = TransferSyntaxType.forUID((String)uid);
        if (this.tstype == null) {
            throw new IllegalArgumentException("Unsupported Transfer Syntax: " + this.tsuid);
        }
    }

    public final void setRetainFileMetaInformation(boolean retainfmi) {
        this.retainfmi = retainfmi;
    }

    public final void setWithoutFileMetaInformation(boolean nofmi) {
        this.nofmi = nofmi;
    }

    public void setLegacy(boolean legacy) {
        this.legacy = legacy;
    }

    public final void setEncodingOptions(DicomEncodingOptions encOpts) {
        this.encOpts = encOpts;
    }

    public void addCompressionParam(String name, Object value) {
        this.params.add(new Property(name, value));
    }

    public void setMaxThreads(int maxThreads) {
        if (maxThreads <= 0) {
            throw new IllegalArgumentException("max-threads: " + maxThreads);
        }
        this.maxThreads = maxThreads;
    }

    private static Object toValue(String s) {
        try {
            return Double.valueOf(s);
        }
        catch (NumberFormatException e) {
            return s.equalsIgnoreCase("true") ? Boolean.TRUE : (s.equalsIgnoreCase("false") ? Boolean.FALSE : s);
        }
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        CLIUtils.addCommonOptions((Options)opts);
        CLIUtils.addEncodingOptions((Options)opts);
        OptionGroup tsGroup = new OptionGroup();
        tsGroup.addOption(Option.builder((String)"t").longOpt("transfer-syntax").hasArg().argName("uid").desc(rb.getString("transfer-syntax")).build());
        tsGroup.addOption(Option.builder().longOpt("jpeg").desc(rb.getString("jpeg")).build());
        tsGroup.addOption(Option.builder().longOpt("jpll").desc(rb.getString("jpll")).build());
        tsGroup.addOption(Option.builder().longOpt("jlsl").desc(rb.getString("jlsl")).build());
        tsGroup.addOption(Option.builder().longOpt("jlsn").desc(rb.getString("jlsn")).build());
        tsGroup.addOption(Option.builder().longOpt("j2kr").desc(rb.getString("j2kr")).build());
        tsGroup.addOption(Option.builder().longOpt("j2ki").desc(rb.getString("j2ki")).build());
        opts.addOptionGroup(tsGroup);
        OptionGroup fmiGroup = new OptionGroup();
        fmiGroup.addOption(Option.builder((String)"F").longOpt("no-fmi").desc(rb.getString("no-fmi")).build());
        fmiGroup.addOption(Option.builder((String)"f").longOpt("retain-fmi").desc(rb.getString("retain-fmi")).build());
        opts.addOptionGroup(fmiGroup);
        opts.addOption(Option.builder().hasArg().argName("N").type(PatternOptionBuilder.NUMBER_VALUE).desc(rb.getString("max-threads")).longOpt("max-threads").build());
        opts.addOption(Option.builder().hasArg().argName("max-error").type(PatternOptionBuilder.NUMBER_VALUE).desc(rb.getString("verify")).longOpt("verify").build());
        opts.addOption(Option.builder().hasArg().argName("size").type(PatternOptionBuilder.NUMBER_VALUE).desc(rb.getString("verify-block")).longOpt("verify-block").build());
        opts.addOption(Option.builder((String)"q").hasArg().argName("quality").type(PatternOptionBuilder.NUMBER_VALUE).desc(rb.getString("quality")).build());
        opts.addOption(Option.builder((String)"Q").hasArg().argName("compression").type(PatternOptionBuilder.NUMBER_VALUE).desc(rb.getString("compression")).build());
        opts.addOption(Option.builder((String)"N").hasArg().argName("near-lossless").type(PatternOptionBuilder.NUMBER_VALUE).desc(rb.getString("near-lossless")).build());
        opts.addOption(Option.builder((String)"C").hasArgs().argName("name=value").valueSeparator().desc(rb.getString("compression-param")).build());
        CommandLine cl = CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, Dcm2Dcm.class);
        return cl;
    }

    public static void main(String[] args) {
        try {
            List argList;
            int argc;
            String[] cparams;
            CommandLine cl = Dcm2Dcm.parseComandLine(args);
            Dcm2Dcm main = new Dcm2Dcm();
            main.setEncodingOptions(CLIUtils.encodingOptionsOf((CommandLine)cl));
            if (cl.hasOption("F")) {
                if (Dcm2Dcm.transferSyntaxOf(cl, null) != null) {
                    throw new ParseException(rb.getString("transfer-syntax-no-fmi"));
                }
                main.setTransferSyntax("1.2.840.10008.1.2");
                main.setWithoutFileMetaInformation(true);
            } else {
                main.setTransferSyntax(Dcm2Dcm.transferSyntaxOf(cl, "1.2.840.10008.1.2.1"));
                main.setRetainFileMetaInformation(cl.hasOption("f"));
            }
            main.setLegacy(cl.hasOption("legacy"));
            if (cl.hasOption("max-threads")) {
                main.setMaxThreads(((Number)cl.getParsedOptionValue("max-threads")).intValue());
            }
            if (cl.hasOption("verify")) {
                main.addCompressionParam("maxPixelValueError", cl.getParsedOptionValue("verify"));
            }
            if (cl.hasOption("verify-block")) {
                main.addCompressionParam("avgPixelValueBlockSize", cl.getParsedOptionValue("verify-block"));
            }
            if (cl.hasOption("q")) {
                main.addCompressionParam("compressionQuality", cl.getParsedOptionValue("q"));
            }
            if (cl.hasOption("Q")) {
                main.addCompressionParam("compressionRatiofactor", cl.getParsedOptionValue("Q"));
            }
            if (cl.hasOption("N")) {
                main.addCompressionParam("nearLossless", cl.getParsedOptionValue("N"));
            }
            if ((cparams = cl.getOptionValues("C")) != null) {
                int i = 0;
                while (i < cparams.length) {
                    main.addCompressionParam(cparams[i++], Dcm2Dcm.toValue(cparams[i++]));
                }
            }
            if ((argc = (argList = cl.getArgList()).size()) < 2) {
                throw new ParseException(rb.getString("missing"));
            }
            File dest = new File((String)argList.get(argc - 1));
            if ((argc > 2 || new File((String)argList.get(0)).isDirectory()) && !dest.isDirectory()) {
                throw new ParseException(MessageFormat.format(rb.getString("nodestdir"), dest));
            }
            main.mtranscode(argList.subList(0, argc - 1), dest);
        }
        catch (ParseException e) {
            System.err.println("dcm2dcm: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("dcm2dcm: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    private static String transferSyntaxOf(CommandLine cl, String def) {
        return cl.hasOption("ivrle") ? "1.2.840.10008.1.2" : (cl.hasOption("evrbe") ? "1.2.840.10008.1.2.2" : (cl.hasOption("defl") ? "1.2.840.10008.1.2.1.99" : (cl.hasOption("jpeg") ? "1.2.840.10008.1.2.4.50" : (cl.hasOption("jpll") ? "1.2.840.10008.1.2.4.70" : (cl.hasOption("jlsl") ? "1.2.840.10008.1.2.4.80" : (cl.hasOption("jlsn") ? "1.2.840.10008.1.2.4.81" : (cl.hasOption("j2kr") ? "1.2.840.10008.1.2.4.90" : (cl.hasOption("j2ki") ? "1.2.840.10008.1.2.4.91" : cl.getOptionValue("t", def)))))))));
    }

    private void mtranscode(List<String> srcList, File dest) throws InterruptedException {
        ExecutorService executorService = this.maxThreads > 1 ? Executors.newFixedThreadPool(this.maxThreads) : null;
        for (String src : srcList) {
            this.mtranscode(new File(src), dest, executorService);
        }
        if (executorService != null) {
            executorService.shutdown();
        }
    }

    private void mtranscode(File src, File dest, Executor executer) {
        File finalDest;
        if (src.isDirectory()) {
            dest.mkdir();
            for (File file : src.listFiles()) {
                this.mtranscode(file, new File(dest, file.getName()), executer);
            }
            return;
        }
        File file = finalDest = dest.isDirectory() ? new File(dest, src.getName()) : dest;
        if (executer != null) {
            executer.execute(() -> this.transcode(src, finalDest));
        } else {
            this.transcode(src, finalDest);
        }
    }

    private void transcode(File src, File dest) {
        try {
            if (this.legacy) {
                this.transcodeLegacy(src, dest);
            } else {
                this.transcodeWithTranscoder(src, dest);
            }
            System.out.println(MessageFormat.format(rb.getString("transcoded"), src, dest));
        }
        catch (Exception e) {
            System.out.println(MessageFormat.format(rb.getString("failed"), src, e.getMessage()));
            e.printStackTrace(System.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transcodeLegacy(File src, File dest) throws IOException {
        Attributes dataset;
        Attributes fmi;
        try (DicomInputStream dis = new DicomInputStream(src);){
            dis.setIncludeBulkData(DicomInputStream.IncludeBulkData.URI);
            fmi = dis.readFileMetaInformation();
            dataset = dis.readDataset();
        }
        Object pixeldata = dataset.getValue(2145386512);
        Compressor compressor = null;
        DicomOutputStream dos = null;
        try {
            String tsuid = this.tsuid;
            if (pixeldata != null) {
                if (this.tstype.isPixeldataEncapsulated()) {
                    tsuid = this.adjustTransferSyntax(tsuid, dataset.getInt(2621697, 8));
                    compressor = new Compressor(dataset, dis.getTransferSyntax());
                    compressor.compress(tsuid, this.params.toArray(new Property[this.params.size()]));
                } else if (pixeldata instanceof Fragments) {
                    Decompressor.decompress((Attributes)dataset, (String)dis.getTransferSyntax());
                }
            }
            if (this.nofmi) {
                fmi = null;
            } else if (this.retainfmi && fmi != null) {
                fmi.setString(131088, VR.UI, tsuid);
            } else {
                fmi = dataset.createFileMetaInformation(tsuid);
            }
            dos = new DicomOutputStream(dest);
            dos.setEncodingOptions(this.encOpts);
            dos.writeDataset(fmi, dataset);
        }
        catch (Throwable throwable) {
            SafeClose.close(compressor);
            SafeClose.close(dos);
            throw throwable;
        }
        SafeClose.close((Closeable)compressor);
        SafeClose.close((Closeable)dos);
    }

    public void transcodeWithTranscoder(File src, File dest) throws IOException {
        try (Transcoder transcoder = new Transcoder(src);){
            transcoder.setIncludeFileMetaInformation(!this.nofmi);
            transcoder.setRetainFileMetaInformation(this.retainfmi);
            transcoder.setEncodingOptions(this.encOpts);
            transcoder.setDestinationTransferSyntax(this.tsuid);
            transcoder.setCompressParams(this.params.toArray(new Property[this.params.size()]));
            transcoder.transcode((transcoder1, dataset) -> new FileOutputStream(dest));
        }
        catch (Exception e) {
            Files.deleteIfExists(dest.toPath());
            throw e;
        }
    }

    private String adjustTransferSyntax(String tsuid, int bitsStored) {
        switch (this.tstype) {
            case JPEG_BASELINE: {
                if (bitsStored <= 8) break;
                return "1.2.840.10008.1.2.4.51";
            }
            case JPEG_EXTENDED: {
                if (bitsStored > 8) break;
                return "1.2.840.10008.1.2.4.50";
            }
        }
        return tsuid;
    }
}

