/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.dcm2json;

import jakarta.json.Json;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.data.VR;
import org.dcm4che3.io.BasicBulkDataDescriptor;
import org.dcm4che3.io.BulkDataDescriptor;
import org.dcm4che3.io.DicomInputHandler;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.json.JSONWriter;
import org.dcm4che3.tool.common.CLIUtils;

public class Dcm2Json {
    private static ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.dcm2json.messages");
    private boolean indent = false;
    private DicomInputStream.IncludeBulkData includeBulkData = DicomInputStream.IncludeBulkData.URI;
    private boolean catBlkFiles = false;
    private String blkFilePrefix = "blk";
    private String blkFileSuffix;
    private File blkDirectory;
    private BasicBulkDataDescriptor bulkDataDescriptor = new BasicBulkDataDescriptor();
    private boolean encodeAsNumber;

    public final void setIndent(boolean indent) {
        this.indent = indent;
    }

    public final void setEncodeAsNumber(boolean encodeAsNumber) {
        this.encodeAsNumber = encodeAsNumber;
    }

    public final void setIncludeBulkData(DicomInputStream.IncludeBulkData includeBulkData) {
        this.includeBulkData = includeBulkData;
    }

    public final void setConcatenateBulkDataFiles(boolean catBlkFiles) {
        this.catBlkFiles = catBlkFiles;
    }

    public final void setBulkDataFilePrefix(String blkFilePrefix) {
        this.blkFilePrefix = blkFilePrefix;
    }

    public final void setBulkDataFileSuffix(String blkFileSuffix) {
        this.blkFileSuffix = blkFileSuffix;
    }

    public final void setBulkDataDirectory(File blkDirectory) {
        this.blkDirectory = blkDirectory;
    }

    public void setBulkDataNoDefaults(boolean excludeDefaults) {
        this.bulkDataDescriptor.excludeDefaults(excludeDefaults);
    }

    public void setBulkDataLengthsThresholdsFromStrings(String[] thresholds) {
        this.bulkDataDescriptor.setLengthsThresholdsFromStrings(thresholds);
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        CLIUtils.addCommonOptions((Options)opts);
        opts.addOption("I", "indent", false, rb.getString("indent"));
        opts.addOption("N", "encode-as-number", false, rb.getString("encode-as-number"));
        Dcm2Json.addBulkdataOptions(opts);
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, Dcm2Json.class);
    }

    private static void addBulkdataOptions(Options opts) {
        OptionGroup group = new OptionGroup();
        group.addOption(Option.builder((String)"B").longOpt("no-bulkdata").desc(rb.getString("no-bulkdata")).build());
        group.addOption(Option.builder((String)"b").longOpt("with-bulkdata").desc(rb.getString("with-bulkdata")).build());
        opts.addOptionGroup(group);
        opts.addOption(Option.builder((String)"d").longOpt("blk-file-dir").hasArg().argName("directory").desc(rb.getString("blk-file-dir")).build());
        opts.addOption(Option.builder().longOpt("blk-file-prefix").hasArg().argName("prefix").desc(rb.getString("blk-file-prefix")).build());
        opts.addOption(Option.builder().longOpt("blk-file-suffix").hasArg().argName("suffix").desc(rb.getString("blk-file-suffix")).build());
        opts.addOption("c", "cat-blk-files", false, rb.getString("cat-blk-files"));
        opts.addOption(null, "blk-nodefs", false, rb.getString("blk-nodefs"));
        opts.addOption(Option.builder(null).longOpt("blk").hasArgs().argName("[seq.]attr").desc(rb.getString("blk")).build());
        opts.addOption(Option.builder(null).longOpt("blk-vr").hasArgs().argName("vr[,...]=length").desc(rb.getString("blk-vr")).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block7: {
            try {
                CommandLine cl = Dcm2Json.parseComandLine(args);
                Dcm2Json main = new Dcm2Json();
                main.setIndent(cl.hasOption("I"));
                main.setEncodeAsNumber(cl.hasOption("N"));
                Dcm2Json.configureBulkdata(main, cl);
                String fname = Dcm2Json.fname(cl.getArgList());
                if (fname.equals("-")) {
                    main.parse(new DicomInputStream(System.in));
                    break block7;
                }
                try (DicomInputStream dis = new DicomInputStream(new File(fname));){
                    main.parse(dis);
                }
            }
            catch (ParseException e) {
                System.err.println("dcm2xml: " + e.getMessage());
                System.err.println(rb.getString("try"));
                System.exit(2);
            }
            catch (Exception e) {
                System.err.println("dcm2xml: " + e.getMessage());
                e.printStackTrace();
                System.exit(2);
            }
        }
    }

    private static void configureBulkdata(Dcm2Json dcm2json, CommandLine cl) throws Exception {
        if (cl.hasOption("b")) {
            dcm2json.setIncludeBulkData(DicomInputStream.IncludeBulkData.YES);
        }
        if (cl.hasOption("B")) {
            dcm2json.setIncludeBulkData(DicomInputStream.IncludeBulkData.NO);
        }
        if (cl.hasOption("blk-file-prefix")) {
            dcm2json.setBulkDataFilePrefix(cl.getOptionValue("blk-file-prefix"));
        }
        if (cl.hasOption("blk-file-suffix")) {
            dcm2json.setBulkDataFileSuffix(cl.getOptionValue("blk-file-suffix"));
        }
        if (cl.hasOption("d")) {
            File tempDir = new File(cl.getOptionValue("d"));
            dcm2json.setBulkDataDirectory(tempDir);
        }
        dcm2json.setConcatenateBulkDataFiles(cl.hasOption("c"));
        dcm2json.setBulkDataNoDefaults(cl.hasOption("blk-nodefs"));
        if (cl.hasOption("blk")) {
            CLIUtils.addTagPaths((BasicBulkDataDescriptor)dcm2json.bulkDataDescriptor, (String[])cl.getOptionValues("blk"));
        }
        if (cl.hasOption("blk-vr")) {
            dcm2json.setBulkDataLengthsThresholdsFromStrings(cl.getOptionValues("blk-vr"));
        }
    }

    private static String fname(List<String> argList) throws ParseException {
        int numArgs = argList.size();
        if (numArgs == 0) {
            throw new ParseException(rb.getString("missing"));
        }
        if (numArgs > 1) {
            throw new ParseException(rb.getString("too-many"));
        }
        return argList.get(0);
    }

    public void parse(DicomInputStream dis) throws IOException {
        dis.setIncludeBulkData(this.includeBulkData);
        dis.setBulkDataDescriptor((BulkDataDescriptor)this.bulkDataDescriptor);
        dis.setBulkDataDirectory(this.blkDirectory);
        dis.setBulkDataFilePrefix(this.blkFilePrefix);
        dis.setBulkDataFileSuffix(this.blkFileSuffix);
        dis.setConcatenateBulkDataFiles(this.catBlkFiles);
        JsonGenerator jsonGen = this.createGenerator(System.out);
        JSONWriter jsonWriter = new JSONWriter(jsonGen);
        if (this.encodeAsNumber) {
            jsonWriter.setJsonType(VR.DS, JsonValue.ValueType.NUMBER);
            jsonWriter.setJsonType(VR.IS, JsonValue.ValueType.NUMBER);
            jsonWriter.setJsonType(VR.SV, JsonValue.ValueType.NUMBER);
            jsonWriter.setJsonType(VR.UV, JsonValue.ValueType.NUMBER);
        }
        dis.setDicomInputHandler((DicomInputHandler)jsonWriter);
        dis.readDataset();
        jsonGen.flush();
    }

    private JsonGenerator createGenerator(OutputStream out) {
        HashMap<String, Object> conf = new HashMap<String, Object>(2);
        if (this.indent) {
            conf.put("jakarta.json.stream.JsonGenerator.prettyPrinting", null);
        }
        return Json.createGeneratorFactory(conf).createGenerator(out);
    }
}

