/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.dcmbenchmark;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.tool.common.CLIUtils;

public class DcmBenchMark {
    private static ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.dcmbenchmark.messages");

    public static void main(String[] args) {
        try {
            CommandLine cl = DcmBenchMark.parseComandLine(args);
            File file = new File(DcmBenchMark.fname(cl.getArgList()));
            int samples = DcmBenchMark.getOptionInt(cl, "n", 10);
            int measurements = DcmBenchMark.getOptionInt(cl, "m", 10);
            boolean pixelData = cl.hasOption("p");
            boolean accumulate = cl.hasOption("a");
            boolean gc = cl.hasOption("g");
            System.out.println("N\tTime (ns)\tMemory (bytes)");
            Runtime rt = Runtime.getRuntime();
            LinkedList<Attributes> list = new LinkedList<Attributes>();
            for (int i = 1; i <= measurements; ++i) {
                long start = System.nanoTime();
                for (int j = 0; j < samples; ++j) {
                    try (DicomInputStream dis = new DicomInputStream(file);){
                        list.add(pixelData ? dis.readDataset() : dis.readDatasetUntilPixelData());
                        continue;
                    }
                }
                long end = System.nanoTime();
                if (gc) {
                    rt.gc();
                }
                if (!accumulate) {
                    list.clear();
                }
                System.out.printf("%d\t%d\t%d%n", i * samples, end - start, rt.totalMemory() - rt.freeMemory());
            }
        }
        catch (ParseException e) {
            System.err.println("dcmbenchmark: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (IOException e) {
            System.err.println("dcmbenchmark: " + e.getMessage());
            System.exit(2);
        }
    }

    private static int getOptionInt(CommandLine cl, String opt, int def) throws ParseException {
        String v = cl.getOptionValue(opt);
        try {
            return v != null ? Integer.parseInt(v) : def;
        }
        catch (NumberFormatException e) {
            throw new ParseException(e.getMessage());
        }
    }

    private static String fname(List<String> argList) throws ParseException {
        int numArgs = argList.size();
        if (numArgs == 0) {
            throw new ParseException(rb.getString("missing"));
        }
        if (numArgs > 1) {
            throw new ParseException(rb.getString("too-many"));
        }
        return argList.get(0);
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        CLIUtils.addCommonOptions((Options)opts);
        opts.addOption(Option.builder((String)"n").hasArg().argName("no").desc(rb.getString("samples")).build());
        opts.addOption(Option.builder((String)"m").hasArg().argName("no").desc(rb.getString("measurements")).build());
        opts.addOption(Option.builder((String)"a").desc(rb.getString("accumulate")).build());
        opts.addOption(Option.builder((String)"p").desc(rb.getString("pixelData")).build());
        opts.addOption(Option.builder((String)"g").desc(rb.getString("gc")).build());
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, DcmBenchMark.class);
    }
}

