/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.dcmldap;

import java.io.Closeable;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.Hashtable;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.conf.api.ConfigurationException;
import org.dcm4che3.conf.api.DicomConfiguration;
import org.dcm4che3.conf.ldap.LdapDicomConfiguration;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.Device;
import org.dcm4che3.tool.common.CLIUtils;
import org.dcm4che3.util.StringUtils;

public class DcmLdap
implements Closeable {
    private static ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.dcmldap.messages");
    private static final String DEFAULT_LDAP_URI = "ldap://localhost:389/dc=dcm4che,dc=org";
    private static final String DEFAULT_BIND_DN = "cn=admin,dc=dcm4che,dc=org";
    private static final String DEFAULT_PASSWORD = "secret";
    private final LdapDicomConfiguration conf;
    private String deviceName;
    private String deviceDesc;
    private String deviceType;
    private String aeTitle;
    private String aeDesc;
    private Connection conn;

    public DcmLdap(Hashtable<?, ?> env) throws ConfigurationException {
        this.conf = new LdapDicomConfiguration(env);
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public void setDeviceDescription(String deviceDesc) {
        this.deviceDesc = deviceDesc;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public void setAEDescription(String aeDesc) {
        this.aeDesc = aeDesc;
    }

    public void setAETitle(String aeTitle) {
        this.aeTitle = aeTitle;
    }

    public void setConnection(Connection conn) {
        this.conn = conn;
    }

    @Override
    public void close() {
        this.conf.close();
    }

    public void createNetworkAE() throws ConfigurationException {
        Device device = new Device(this.deviceName != null ? this.deviceName : this.aeTitle.toLowerCase());
        device.setDescription(this.deviceDesc);
        if (this.deviceType != null) {
            device.setPrimaryDeviceTypes(new String[]{this.deviceType});
        }
        device.addConnection(this.conn);
        ApplicationEntity ae = new ApplicationEntity(this.aeTitle);
        device.addApplicationEntity(ae);
        ae.setDescription(this.aeDesc);
        ae.addConnection(this.conn);
        this.conf.persist(device, EnumSet.of(DicomConfiguration.Option.REGISTER));
    }

    public void addNetworkAE() throws ConfigurationException {
        Device device = this.conf.findDevice(this.deviceName);
        device.addConnection(this.conn);
        ApplicationEntity ae = new ApplicationEntity(this.aeTitle);
        device.addApplicationEntity(ae);
        ae.setDescription(this.aeDesc);
        ae.addConnection(this.conn);
        this.conf.merge(device, EnumSet.of(DicomConfiguration.Option.REGISTER));
    }

    public void removeNetworkAE() throws ConfigurationException {
        ApplicationEntity ae = this.conf.findApplicationEntity(this.aeTitle);
        Device device = ae.getDevice();
        device.removeApplicationEntity(this.aeTitle);
        for (Connection conn : ae.getConnections()) {
            device.removeConnection(conn);
        }
        if (device.getApplicationAETitles().isEmpty()) {
            this.conf.removeDevice(device.getDeviceName(), EnumSet.of(DicomConfiguration.Option.REGISTER));
        } else {
            this.conf.merge(device, EnumSet.of(DicomConfiguration.Option.REGISTER));
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            OptionGroup cmdGroup = new OptionGroup();
            CommandLine cl = DcmLdap.parseComandLine(args, cmdGroup);
            Operation op = Operation.valueOf(cmdGroup.getSelected());
            try (DcmLdap main = new DcmLdap(DcmLdap.ldapEnv(cl));){
                op.configure(main, cl);
                op.perform(main);
            }
        }
        catch (ParseException e) {
            System.err.println("dcmldap: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
    }

    private static Hashtable<?, ?> ldapEnv(CommandLine cl) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.ldap.attributes.binary", "dicomVendorData");
        env.put("java.naming.provider.url", cl.getOptionValue("H", DEFAULT_LDAP_URI));
        env.put("java.naming.security.principal", cl.getOptionValue("D", DEFAULT_BIND_DN));
        env.put("java.naming.security.credentials", cl.getOptionValue("w", DEFAULT_PASSWORD));
        return env;
    }

    private static CommandLine parseComandLine(String[] args, OptionGroup cmdGroup) throws ParseException {
        Options opts = new Options();
        CLIUtils.addCommonOptions((Options)opts);
        cmdGroup.addOption(Option.builder((String)"c").hasArg().argName("aet@host:port").desc(rb.getString("create")).build());
        cmdGroup.addOption(Option.builder((String)"a").hasArg().argName("aet@host:port").desc(rb.getString("add")).build());
        cmdGroup.addOption(Option.builder((String)"d").hasArg().argName("aet").desc(rb.getString("delete")).build());
        opts.addOptionGroup(cmdGroup);
        opts.addOption(Option.builder((String)"H").hasArg().argName("ldapuri").desc(rb.getString("ldapuri")).build());
        opts.addOption(Option.builder((String)"D").hasArg().argName("binddn").desc(rb.getString("binddn")).build());
        opts.addOption(Option.builder((String)"w").hasArg().argName("passwd").desc(rb.getString("passwd")).build());
        opts.addOption(Option.builder().longOpt("dev").hasArg().argName("name").desc(rb.getString("dev")).build());
        opts.addOption(Option.builder().longOpt("dev-desc").hasArg().argName("string").desc(rb.getString("dev-desc")).build());
        opts.addOption(Option.builder().longOpt("dev-type").hasArg().argName("string").desc(rb.getString("dev-type")).build());
        opts.addOption(Option.builder().longOpt("ae-desc").hasArg().argName("string").desc(rb.getString("ae-desc")).build());
        opts.addOption(Option.builder().longOpt("conn").hasArg().argName("cn").desc(rb.getString("conn-cn")).build());
        CLIUtils.addTLSCipherOptions((Options)opts);
        CommandLine cl = CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, DcmLdap.class);
        String selected = cmdGroup.getSelected();
        if (selected == null) {
            throw new ParseException(rb.getString("missing"));
        }
        if (selected.equals("a") && !cl.hasOption("dev")) {
            throw new ParseException(rb.getString("missing-dev"));
        }
        return cl;
    }

    private static enum Operation {
        c{

            @Override
            void perform(DcmLdap main) throws ConfigurationException {
                main.createNetworkAE();
            }
        }
        ,
        a{

            @Override
            void perform(DcmLdap main) throws ConfigurationException {
                main.addNetworkAE();
            }
        }
        ,
        d{

            @Override
            public void configure(DcmLdap main, CommandLine cl) {
                main.setAETitle(cl.getOptionValue("d"));
            }

            @Override
            void perform(DcmLdap main) throws ConfigurationException {
                main.removeNetworkAE();
            }
        };


        void configure(DcmLdap main, CommandLine cl) throws ParseException {
            Connection conn;
            String aeAtHostPort = cl.getOptionValue(this.name());
            String[] aeHostPort = StringUtils.split((String)aeAtHostPort, (char)'@');
            if (aeHostPort.length < 2) {
                throw this.invalidConn();
            }
            String[] hostPort = StringUtils.split((String)aeHostPort[1], (char)':');
            if (hostPort.length < 2) {
                throw this.invalidConn();
            }
            try {
                conn = new Connection(cl.getOptionValue("conn"), hostPort[0], Integer.parseInt(hostPort[1]));
            }
            catch (NumberFormatException e) {
                throw this.invalidConn();
            }
            CLIUtils.configureTLSCipher((Connection)conn, (CommandLine)cl);
            if (conn.getCommonName() == null) {
                conn.setCommonName(conn.isTls() ? "dicom-tls" : "dicom");
            }
            main.setDeviceName(cl.getOptionValue("dev"));
            main.setDeviceDescription(cl.getOptionValue("dev-desc"));
            main.setDeviceType(cl.getOptionValue("dev-type"));
            main.setAETitle(aeHostPort[0]);
            main.setAEDescription(cl.getOptionValue("ae-desc"));
            main.setConnection(conn);
        }

        ParseException invalidConn() {
            return new ParseException(MessageFormat.format(rb.getString("invalid-conn"), this.name()));
        }

        abstract void perform(DcmLdap var1) throws ConfigurationException;
    }
}

