/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.dcmqrscp;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.io.DicomOutputStream;
import org.dcm4che3.media.DicomDirReader;
import org.dcm4che3.media.DicomDirWriter;
import org.dcm4che3.media.RecordFactory;
import org.dcm4che3.media.RecordType;
import org.dcm4che3.net.ApplicationEntity;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.AssociationStateException;
import org.dcm4che3.net.Commands;
import org.dcm4che3.net.Connection;
import org.dcm4che3.net.Device;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.net.DimseRQHandler;
import org.dcm4che3.net.PDVInputStream;
import org.dcm4che3.net.QueryOption;
import org.dcm4che3.net.TransferCapability;
import org.dcm4che3.net.pdu.AAssociateRQ;
import org.dcm4che3.net.pdu.ExtendedNegotiation;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.service.AbstractDicomService;
import org.dcm4che3.net.service.BasicCEchoSCP;
import org.dcm4che3.net.service.BasicCFindSCP;
import org.dcm4che3.net.service.BasicCGetSCP;
import org.dcm4che3.net.service.BasicCMoveSCP;
import org.dcm4che3.net.service.BasicCStoreSCP;
import org.dcm4che3.net.service.DicomService;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.net.service.DicomServiceRegistry;
import org.dcm4che3.net.service.InstanceLocator;
import org.dcm4che3.net.service.QueryRetrieveLevel2;
import org.dcm4che3.net.service.QueryTask;
import org.dcm4che3.net.service.RetrieveTask;
import org.dcm4che3.tool.common.CLIUtils;
import org.dcm4che3.tool.common.FilesetInfo;
import org.dcm4che3.tool.dcmqrscp.InstanceQueryTask;
import org.dcm4che3.tool.dcmqrscp.PatientQueryTask;
import org.dcm4che3.tool.dcmqrscp.RetrieveTaskImpl;
import org.dcm4che3.tool.dcmqrscp.SendStgCmtResult;
import org.dcm4che3.tool.dcmqrscp.SeriesQueryTask;
import org.dcm4che3.tool.dcmqrscp.StudyQueryTask;
import org.dcm4che3.util.AttributesFormat;
import org.dcm4che3.util.SafeClose;
import org.dcm4che3.util.StringUtils;
import org.dcm4che3.util.TagUtils;
import org.dcm4che3.util.UIDUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DcmQRSCP {
    static final Logger LOG = LoggerFactory.getLogger(DcmQRSCP.class);
    private static final EnumSet<QueryRetrieveLevel2> PATIENT_ROOT_LEVELS = EnumSet.of(QueryRetrieveLevel2.PATIENT, QueryRetrieveLevel2.STUDY, QueryRetrieveLevel2.SERIES, QueryRetrieveLevel2.IMAGE);
    private static final EnumSet<QueryRetrieveLevel2> STUDY_ROOT_LEVELS = EnumSet.of(QueryRetrieveLevel2.STUDY, QueryRetrieveLevel2.SERIES, QueryRetrieveLevel2.IMAGE);
    private static final EnumSet<QueryRetrieveLevel2> PATIENT_STUDY_ONLY_LEVELS = EnumSet.of(QueryRetrieveLevel2.PATIENT, QueryRetrieveLevel2.STUDY);
    private static ResourceBundle rb = ResourceBundle.getBundle("org.dcm4che3.tool.dcmqrscp.messages");
    private final Device device = new Device("dcmqrscp");
    private final ApplicationEntity ae = new ApplicationEntity("*");
    private final Connection conn = new Connection();
    private File storageDir;
    private File dicomDir;
    private AttributesFormat filePathFormat;
    private RecordFactory recFact;
    private String availability;
    private boolean relationalLenient;
    private boolean stgCmtOnSameAssoc;
    private boolean sendPendingCGet;
    private int sendPendingCMoveInterval;
    private int delayCFind;
    private int delayCStore;
    private int errorCFind;
    private int errorCMove;
    private int errorCGet;
    private boolean ignoreCaseOfPN;
    private boolean matchNoValue;
    private final FilesetInfo fsInfo = new FilesetInfo();
    private DicomDirReader ddReader;
    private DicomDirWriter ddWriter;
    private HashMap<String, Connection> remoteConnections = new HashMap();

    public DcmQRSCP() throws IOException {
        this.device.addConnection(this.conn);
        this.device.addApplicationEntity(this.ae);
        this.ae.setAssociationAcceptor(true);
        this.ae.addConnection(this.conn);
        this.device.setDimseRQHandler((DimseRQHandler)this.createServiceRegistry());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeTo(Association as, Attributes fmi, PDVInputStream data, File file) throws IOException {
        LOG.info("{}: M-WRITE {}", (Object)as, (Object)file);
        file.getParentFile().mkdirs();
        DicomOutputStream out = new DicomOutputStream(file);
        try {
            out.writeFileMetaInformation(fmi);
            data.copyTo((OutputStream)out);
        }
        finally {
            SafeClose.close((Closeable)out);
        }
    }

    private File getDestinationFile(Attributes attrs) {
        File file = new File(this.storageDir, this.filePathFormat.format((Object)attrs));
        while (file.exists()) {
            file = new File(file.getParentFile(), TagUtils.toHexString((int)new Random().nextInt()));
        }
        return file;
    }

    private static void renameTo(Association as, File from, File dest) throws IOException {
        LOG.info("{}: M-RENAME {}", new Object[]{as, from, dest});
        dest.getParentFile().mkdirs();
        if (!from.renameTo(dest)) {
            throw new IOException("Failed to rename " + from + " to " + dest);
        }
    }

    private static Attributes parse(File file) throws IOException {
        DicomInputStream in = new DicomInputStream(file);
        try {
            in.setIncludeBulkData(DicomInputStream.IncludeBulkData.NO);
            Attributes attributes = in.readDatasetUntilPixelData();
            return attributes;
        }
        finally {
            SafeClose.close((Closeable)in);
        }
    }

    private static void deleteFile(Association as, File file) {
        if (file.delete()) {
            LOG.info("{}: M-DELETE {}", (Object)as, (Object)file);
        } else {
            LOG.warn("{}: M-DELETE {} failed!", (Object)as, (Object)file);
        }
    }

    private DicomServiceRegistry createServiceRegistry() {
        DicomServiceRegistry serviceRegistry = new DicomServiceRegistry();
        serviceRegistry.addDicomService((DicomService)new BasicCEchoSCP());
        serviceRegistry.addDicomService((DicomService)new CStoreSCPImpl());
        serviceRegistry.addDicomService((DicomService)new StgCmtSCPImpl());
        serviceRegistry.addDicomService((DicomService)new CFindSCPImpl("1.2.840.10008.5.1.4.1.2.1.1", PATIENT_ROOT_LEVELS));
        serviceRegistry.addDicomService((DicomService)new CFindSCPImpl("1.2.840.10008.5.1.4.1.2.2.1", STUDY_ROOT_LEVELS));
        serviceRegistry.addDicomService((DicomService)new CFindSCPImpl("1.2.840.10008.5.1.4.1.2.3.1", PATIENT_STUDY_ONLY_LEVELS));
        serviceRegistry.addDicomService((DicomService)new CGetSCPImpl("1.2.840.10008.5.1.4.1.2.1.3", PATIENT_ROOT_LEVELS));
        serviceRegistry.addDicomService((DicomService)new CGetSCPImpl("1.2.840.10008.5.1.4.1.2.2.3", STUDY_ROOT_LEVELS));
        serviceRegistry.addDicomService((DicomService)new CGetSCPImpl("1.2.840.10008.5.1.4.1.2.3.3", PATIENT_STUDY_ONLY_LEVELS));
        serviceRegistry.addDicomService((DicomService)new CGetSCPImpl("1.2.840.10008.5.1.4.1.2.5.3", EnumSet.of(QueryRetrieveLevel2.IMAGE)));
        serviceRegistry.addDicomService((DicomService)new CMoveSCPImpl("1.2.840.10008.5.1.4.1.2.1.2", PATIENT_ROOT_LEVELS));
        serviceRegistry.addDicomService((DicomService)new CMoveSCPImpl("1.2.840.10008.5.1.4.1.2.2.2", STUDY_ROOT_LEVELS));
        serviceRegistry.addDicomService((DicomService)new CMoveSCPImpl("1.2.840.10008.5.1.4.1.2.3.2", PATIENT_STUDY_ONLY_LEVELS));
        return serviceRegistry;
    }

    public final Device getDevice() {
        return this.device;
    }

    public final void setDicomDirectory(File dicomDir) {
        File storageDir = dicomDir.getParentFile();
        if (storageDir.mkdirs()) {
            System.out.println("M-WRITE " + storageDir);
        }
        this.storageDir = storageDir;
        this.dicomDir = dicomDir;
    }

    public final File getStorageDirectory() {
        return this.storageDir;
    }

    public final AttributesFormat getFilePathFormat() {
        return this.filePathFormat;
    }

    public void setFilePathFormat(String pattern) {
        this.filePathFormat = new AttributesFormat(pattern);
    }

    public final File getDicomDirectory() {
        return this.dicomDir;
    }

    public boolean isWriteable() {
        return this.storageDir.canWrite();
    }

    public final void setInstanceAvailability(String availability) {
        this.availability = availability;
    }

    public final String getInstanceAvailability() {
        return this.availability;
    }

    public boolean isIgnoreCaseOfPN() {
        return this.ignoreCaseOfPN;
    }

    public void setIgnoreCaseOfPN(boolean ignoreCaseOfPN) {
        this.ignoreCaseOfPN = ignoreCaseOfPN;
    }

    public boolean isMatchNoValue() {
        return this.matchNoValue;
    }

    public void setMatchNoValue(boolean matchNoValue) {
        this.matchNoValue = matchNoValue;
    }

    public boolean isRelationalLenient() {
        return this.relationalLenient;
    }

    public void setRelationalLenient(boolean relationalLenient) {
        this.relationalLenient = relationalLenient;
    }

    public boolean isStgCmtOnSameAssoc() {
        return this.stgCmtOnSameAssoc;
    }

    public void setStgCmtOnSameAssoc(boolean stgCmtOnSameAssoc) {
        this.stgCmtOnSameAssoc = stgCmtOnSameAssoc;
    }

    public final void setSendPendingCGet(boolean sendPendingCGet) {
        this.sendPendingCGet = sendPendingCGet;
    }

    public final boolean isSendPendingCGet() {
        return this.sendPendingCGet;
    }

    public final void setSendPendingCMoveInterval(int sendPendingCMoveInterval) {
        this.sendPendingCMoveInterval = sendPendingCMoveInterval;
    }

    public final int getSendPendingCMoveInterval() {
        return this.sendPendingCMoveInterval;
    }

    public int getDelayCFind() {
        return this.delayCFind;
    }

    public void setDelayCFind(int delayCFind) {
        this.delayCFind = delayCFind;
    }

    public int getDelayCStore() {
        return this.delayCStore;
    }

    public void setDelayCStore(int delayCStore) {
        this.delayCStore = delayCStore;
    }

    public int getErrorCFind() {
        return this.errorCFind;
    }

    public void setErrorCFind(int errorCFind) {
        this.errorCFind = errorCFind;
    }

    public int getErrorCMove() {
        return this.errorCMove;
    }

    public void setErrorCMove(int errorCMove) {
        this.errorCMove = errorCMove;
    }

    public int getErrorCGet() {
        return this.errorCGet;
    }

    public void setErrorCGet(int errorCGet) {
        this.errorCGet = errorCGet;
    }

    public final void setRecordFactory(RecordFactory recFact) {
        this.recFact = recFact;
    }

    public final RecordFactory getRecordFactory() {
        return this.recFact;
    }

    private static CommandLine parseComandLine(String[] args) throws ParseException {
        Options opts = new Options();
        CLIUtils.addFilesetInfoOptions((Options)opts);
        CLIUtils.addBindServerOption((Options)opts);
        CLIUtils.addConnectTimeoutOption((Options)opts);
        CLIUtils.addAcceptTimeoutOption((Options)opts);
        CLIUtils.addAEOptions((Options)opts);
        CLIUtils.addAcceptedCallingAETs((Options)opts);
        CLIUtils.addCommonOptions((Options)opts);
        CLIUtils.addSendTimeoutOption((Options)opts);
        CLIUtils.addStoreTimeoutOption((Options)opts);
        CLIUtils.addResponseTimeoutOption((Options)opts);
        DcmQRSCP.addDicomDirOption(opts);
        DcmQRSCP.addTransferCapabilityOptions(opts);
        DcmQRSCP.addInstanceAvailabilityOption(opts);
        DcmQRSCP.addMatchingOptions(opts);
        DcmQRSCP.addStgCmtOptions(opts);
        DcmQRSCP.addSendingPendingOptions(opts);
        DcmQRSCP.addDelayCFindOptions(opts);
        DcmQRSCP.addDelayCStoreOptions(opts);
        DcmQRSCP.addRemoteConnectionsOption(opts);
        DcmQRSCP.addRoleSelectLenientOption(opts);
        DcmQRSCP.addRelationalLenientOption(opts);
        DcmQRSCP.addErrorStatusOption(opts, "cfind-error");
        DcmQRSCP.addErrorStatusOption(opts, "cmove-error");
        DcmQRSCP.addErrorStatusOption(opts, "cget-error");
        return CLIUtils.parseComandLine((String[])args, (Options)opts, (ResourceBundle)rb, DcmQRSCP.class);
    }

    private static void addErrorStatusOption(Options opts, String option) {
        opts.addOption(Option.builder().hasArg().argName("code").desc(rb.getString(option)).longOpt(option).build());
    }

    private static Options addRoleSelectLenientOption(Options opts) {
        return opts.addOption(null, "role-select-lenient", false, rb.getString("role-select-lenient"));
    }

    private static Options addRelationalLenientOption(Options opts) {
        return opts.addOption(null, "relational-lenient", false, rb.getString("relational-lenient"));
    }

    private static void addInstanceAvailabilityOption(Options opts) {
        opts.addOption(Option.builder().hasArg().argName("code").desc(rb.getString("availability")).longOpt("availability").build());
    }

    private static void addMatchingOptions(Options opts) {
        opts.addOption(null, "match-pn-icase", false, rb.getString("match-pn-icase"));
        opts.addOption(null, "match-no-value", false, rb.getString("match-no-value"));
    }

    private static void addStgCmtOptions(Options opts) {
        opts.addOption(null, "stgcmt-same-assoc", false, rb.getString("stgcmt-same-assoc"));
    }

    private static void addSendingPendingOptions(Options opts) {
        opts.addOption(null, "pending-cget", false, rb.getString("pending-cget"));
        opts.addOption(Option.builder().hasArg().argName("s").desc(rb.getString("pending-cmove")).longOpt("pending-cmove").build());
    }

    private static void addDelayCFindOptions(Options opts) {
        opts.addOption(Option.builder().hasArg().argName("ms").desc(rb.getString("delay-cfind")).longOpt("delay-cfind").build());
    }

    private static void addDelayCStoreOptions(Options opts) {
        opts.addOption(Option.builder().hasArg().argName("ms").desc(rb.getString("delay-cstore")).longOpt("delay-cstore").build());
    }

    private static void addDicomDirOption(Options opts) {
        opts.addOption(Option.builder().hasArg().argName("file").desc(rb.getString("dicomdir")).longOpt("dicomdir").build());
        opts.addOption(Option.builder().hasArg().argName("pattern").desc(rb.getString("filepath")).longOpt("filepath").build());
        opts.addOption(Option.builder().longOpt("record-config").hasArg().argName("file|url").desc(rb.getString("record-config")).build());
    }

    private static void addTransferCapabilityOptions(Options opts) {
        opts.addOption(null, "all-storage", false, rb.getString("all-storage"));
        opts.addOption(null, "no-storage", false, rb.getString("no-storage"));
        opts.addOption(null, "no-query", false, rb.getString("no-query"));
        opts.addOption(null, "no-retrieve", false, rb.getString("no-retrieve"));
        opts.addOption(null, "relational", false, rb.getString("relational"));
        opts.addOption(Option.builder().hasArg().argName("file|url").desc(rb.getString("storage-sop-classes")).longOpt("storage-sop-classes").build());
        opts.addOption(Option.builder().hasArg().argName("file|url").desc(rb.getString("query-sop-classes")).longOpt("query-sop-classes").build());
        opts.addOption(Option.builder().hasArg().argName("file|url").desc(rb.getString("retrieve-sop-classes")).longOpt("retrieve-sop-classes").build());
    }

    private static void addRemoteConnectionsOption(Options opts) {
        opts.addOption(Option.builder().hasArg().argName("file|url").desc(rb.getString("ae-config")).longOpt("ae-config").build());
    }

    public static void main(String[] args) {
        try {
            CommandLine cl = DcmQRSCP.parseComandLine(args);
            DcmQRSCP main = new DcmQRSCP();
            CLIUtils.configure((FilesetInfo)main.fsInfo, (CommandLine)cl);
            CLIUtils.configureBindServer((Connection)main.conn, (ApplicationEntity)main.ae, (CommandLine)cl);
            CLIUtils.configure((Connection)main.conn, (CommandLine)cl);
            CLIUtils.configureAcceptedCallingAETitles((ApplicationEntity)main.ae, (CommandLine)cl, (Logger)LOG);
            DcmQRSCP.configureDicomFileSet(main, cl);
            DcmQRSCP.configureTransferCapability(main, cl);
            DcmQRSCP.configureInstanceAvailability(main, cl);
            DcmQRSCP.configureMatching(main, cl);
            DcmQRSCP.configureStgCmt(main, cl);
            DcmQRSCP.configureSendPending(main, cl);
            DcmQRSCP.configureDelayCFind(main, cl);
            DcmQRSCP.configureDelayCStore(main, cl);
            DcmQRSCP.configureRemoteConnections(main, cl);
            DcmQRSCP.configureRoleSelectLenient(main, cl);
            DcmQRSCP.configureRelationalLenient(main, cl);
            main.setErrorCFind(CLIUtils.getIntOption((CommandLine)cl, (String)"cfind-error", (int)0));
            main.setErrorCMove(CLIUtils.getIntOption((CommandLine)cl, (String)"cmove-error", (int)0));
            main.setErrorCGet(CLIUtils.getIntOption((CommandLine)cl, (String)"cget-error", (int)0));
            ExecutorService executorService = Executors.newCachedThreadPool();
            ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
            main.device.setScheduledExecutor(scheduledExecutorService);
            main.device.setExecutor((Executor)executorService);
            main.device.bindConnections();
        }
        catch (ParseException e) {
            System.err.println("dcmqrscp: " + e.getMessage());
            System.err.println(rb.getString("try"));
            System.exit(2);
        }
        catch (Exception e) {
            System.err.println("dcmqrscp: " + e.getMessage());
            e.printStackTrace();
            System.exit(2);
        }
    }

    private static void configureRelationalLenient(DcmQRSCP main, CommandLine cl) {
        main.setRelationalLenient(cl.hasOption("relational-lenient"));
    }

    private static void configureRoleSelectLenient(DcmQRSCP main, CommandLine cl) {
        main.device.setRoleSelectionNegotiationLenient(cl.hasOption("role-select-lenient"));
    }

    private static void configureDicomFileSet(DcmQRSCP main, CommandLine cl) throws Exception {
        if (!cl.hasOption("dicomdir")) {
            throw new MissingOptionException(rb.getString("missing-dicomdir"));
        }
        main.setDicomDirectory(new File(cl.getOptionValue("dicomdir")));
        main.setFilePathFormat(cl.getOptionValue("filepath", "DICOM/{0020000D,hash}/{0020000E,hash}/{00080018,hash}"));
        RecordFactory recFact = new RecordFactory();
        if (cl.hasOption("record-config")) {
            recFact.loadConfiguration(cl.getOptionValue("record-config"));
        }
        main.setRecordFactory(recFact);
    }

    private static void configureInstanceAvailability(DcmQRSCP main, CommandLine cl) {
        main.setInstanceAvailability(cl.getOptionValue("availability"));
    }

    private static void configureMatching(DcmQRSCP main, CommandLine cl) {
        main.setIgnoreCaseOfPN(cl.hasOption("match-pn-icase"));
        main.setMatchNoValue(cl.hasOption("match-no-value"));
    }

    private static void configureStgCmt(DcmQRSCP main, CommandLine cl) {
        main.setStgCmtOnSameAssoc(cl.hasOption("stgcmt-same-assoc"));
    }

    private static void configureSendPending(DcmQRSCP main, CommandLine cl) {
        main.setSendPendingCGet(cl.hasOption("pending-cget"));
        if (cl.hasOption("pending-cmove")) {
            main.setSendPendingCMoveInterval(Integer.parseInt(cl.getOptionValue("pending-cmove")));
        }
    }

    private static void configureDelayCFind(DcmQRSCP main, CommandLine cl) {
        if (cl.hasOption("delay-cfind")) {
            main.setDelayCFind(Integer.parseInt(cl.getOptionValue("delay-cfind")));
        }
    }

    private static void configureDelayCStore(DcmQRSCP main, CommandLine cl) {
        if (cl.hasOption("delay-cstore")) {
            main.setDelayCStore(Integer.parseInt(cl.getOptionValue("delay-cstore")));
        }
    }

    private static void configureTransferCapability(DcmQRSCP main, CommandLine cl) throws IOException {
        boolean storage;
        ApplicationEntity ae = main.ae;
        EnumSet<QueryOption> queryOptions = cl.hasOption("relational") ? EnumSet.of(QueryOption.RELATIONAL) : EnumSet.noneOf(QueryOption.class);
        boolean bl = storage = !cl.hasOption("no-storage") && main.isWriteable();
        if (storage && cl.hasOption("all-storage")) {
            TransferCapability tc = new TransferCapability(null, "*", TransferCapability.Role.SCP, new String[]{"*"});
            tc.setQueryOptions(queryOptions);
            ae.addTransferCapability(tc);
        } else {
            Properties p;
            ae.addTransferCapability(new TransferCapability(null, "1.2.840.10008.1.1", TransferCapability.Role.SCP, new String[]{"1.2.840.10008.1.2"}));
            Properties storageSOPClasses = CLIUtils.loadProperties((String)cl.getOptionValue("storage-sop-classes", "resource:storage-sop-classes.properties"), null);
            if (storage) {
                DcmQRSCP.addTransferCapabilities(ae, storageSOPClasses, TransferCapability.Role.SCP, null);
            }
            if (!cl.hasOption("no-retrieve")) {
                DcmQRSCP.addTransferCapabilities(ae, storageSOPClasses, TransferCapability.Role.SCU, null);
                p = CLIUtils.loadProperties((String)cl.getOptionValue("retrieve-sop-classes", "resource:retrieve-sop-classes.properties"), null);
                DcmQRSCP.addTransferCapabilities(ae, p, TransferCapability.Role.SCP, queryOptions);
            }
            if (!cl.hasOption("no-query")) {
                p = CLIUtils.loadProperties((String)cl.getOptionValue("query-sop-classes", "resource:query-sop-classes.properties"), null);
                DcmQRSCP.addTransferCapabilities(ae, p, TransferCapability.Role.SCP, queryOptions);
            }
        }
        if (storage) {
            main.openDicomDir();
        } else {
            main.openDicomDirForReadOnly();
        }
    }

    private static void addTransferCapabilities(ApplicationEntity ae, Properties p, TransferCapability.Role role, EnumSet<QueryOption> queryOptions) {
        for (String cuid : p.stringPropertyNames()) {
            String ts = p.getProperty(cuid);
            TransferCapability tc = new TransferCapability(null, CLIUtils.toUID((String)cuid), role, CLIUtils.toUIDs((String)ts));
            tc.setQueryOptions(queryOptions);
            ae.addTransferCapability(tc);
        }
    }

    private static void configureRemoteConnections(DcmQRSCP main, CommandLine cl) throws Exception {
        String file = cl.getOptionValue("ae-config", "resource:ae.properties");
        Properties aeConfig = CLIUtils.loadProperties((String)file, null);
        for (Map.Entry<Object, Object> entry : aeConfig.entrySet()) {
            String aet = (String)entry.getKey();
            String value = (String)entry.getValue();
            try {
                String[] hostPortCiphers = StringUtils.split((String)value, (char)':');
                String[] ciphers = new String[hostPortCiphers.length - 2];
                System.arraycopy(hostPortCiphers, 2, ciphers, 0, ciphers.length);
                Connection remote = new Connection();
                remote.setHostname(hostPortCiphers[0]);
                remote.setPort(Integer.parseInt(hostPortCiphers[1]));
                remote.setTlsCipherSuites(ciphers);
                main.addRemoteConnection(aet, remote);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid entry in " + file + ": " + aet + "=" + value);
            }
        }
    }

    final DicomDirReader getDicomDirReader() {
        return this.ddReader;
    }

    final DicomDirWriter getDicomDirWriter() {
        return this.ddWriter;
    }

    private void openDicomDir() throws IOException {
        if (!this.dicomDir.exists()) {
            DicomDirWriter.createEmptyDirectory((File)this.dicomDir, (String)UIDUtils.createUIDIfNull((String)this.fsInfo.getFilesetUID()), (String)this.fsInfo.getFilesetID(), (File)this.fsInfo.getDescriptorFile(), (String)this.fsInfo.getDescriptorFileCharset());
        }
        this.ddWriter = DicomDirWriter.open((File)this.dicomDir);
        this.ddReader = this.ddWriter;
    }

    private void openDicomDirForReadOnly() throws IOException {
        this.ddReader = new DicomDirReader(this.dicomDir);
    }

    public void addRemoteConnection(String aet, Connection remote) {
        this.remoteConnections.put(aet, remote);
    }

    Connection getRemoteConnection(String dest) {
        return this.remoteConnections.get(dest);
    }

    public List<InstanceLocator> calculateMatches(Attributes keys) throws DicomServiceException {
        try {
            ArrayList<InstanceLocator> list = new ArrayList<InstanceLocator>();
            String[] patIDs = keys.getStrings(0x100020);
            String[] studyIUIDs = keys.getStrings(0x20000D);
            String[] seriesIUIDs = keys.getStrings(0x20000E);
            String[] sopIUIDs = keys.getStrings(524312);
            DicomDirReader ddr = this.ddReader;
            Attributes patRec = ddr.findPatientRecord(patIDs);
            while (patRec != null) {
                Attributes studyRec = ddr.findStudyRecord(patRec, studyIUIDs);
                while (studyRec != null) {
                    Attributes seriesRec = ddr.findSeriesRecord(studyRec, seriesIUIDs);
                    while (seriesRec != null) {
                        Attributes instRec = ddr.findLowerInstanceRecord(seriesRec, true, sopIUIDs);
                        while (instRec != null) {
                            String cuid = instRec.getString(267536);
                            String iuid = instRec.getString(267537);
                            String tsuid = instRec.getString(267538);
                            String[] fileIDs = instRec.getStrings(267520);
                            String uri = ddr.toFile(fileIDs).toURI().toString();
                            list.add(new InstanceLocator(cuid, iuid, tsuid, uri));
                            if (sopIUIDs != null && sopIUIDs.length == 1) break;
                            instRec = ddr.findNextInstanceRecord(instRec, true, sopIUIDs);
                        }
                        if (seriesIUIDs != null && seriesIUIDs.length == 1) break;
                        seriesRec = ddr.findNextSeriesRecord(seriesRec, seriesIUIDs);
                    }
                    if (studyIUIDs != null && studyIUIDs.length == 1) break;
                    studyRec = ddr.findNextStudyRecord(studyRec, studyIUIDs);
                }
                if (patIDs != null && patIDs.length == 1) break;
                patRec = ddr.findNextPatientRecord(patRec, patIDs);
            }
            return list;
        }
        catch (IOException e) {
            throw new DicomServiceException(42753, (Throwable)e);
        }
    }

    public Attributes calculateStorageCommitmentResult(String calledAET, Attributes actionInfo) throws DicomServiceException {
        Sequence requestSeq = actionInfo.getSequence(528793);
        int size = requestSeq.size();
        String[] sopIUIDs = new String[size];
        Attributes eventInfo = new Attributes(6);
        eventInfo.setString(524372, VR.AE, calledAET);
        eventInfo.setString(8913200, VR.SH, this.ddReader.getFileSetID());
        eventInfo.setString(8913216, VR.SH, this.ddReader.getFileSetUID());
        eventInfo.setString(528789, VR.UI, actionInfo.getString(528789));
        Sequence successSeq = eventInfo.newSequence(528793, size);
        Sequence failedSeq = eventInfo.newSequence(528792, size);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(size * 4 / 3);
        for (int i = 0; i < sopIUIDs.length; ++i) {
            Attributes item = (Attributes)requestSeq.get(i);
            sopIUIDs[i] = item.getString(528725);
            map.put(sopIUIDs[i], item.getString(528720));
        }
        DicomDirReader ddr = this.ddReader;
        try {
            Attributes patRec = ddr.findPatientRecord(new String[0]);
            while (patRec != null) {
                Attributes studyRec = ddr.findStudyRecord(patRec, new String[0]);
                while (studyRec != null) {
                    Attributes seriesRec = ddr.findSeriesRecord(studyRec, new String[0]);
                    while (seriesRec != null) {
                        Attributes instRec = ddr.findLowerInstanceRecord(seriesRec, true, sopIUIDs);
                        while (instRec != null) {
                            String iuid = instRec.getString(267537);
                            String cuid = (String)map.remove(iuid);
                            if (cuid.equals(instRec.getString(267536))) {
                                successSeq.add(DcmQRSCP.refSOP(iuid, cuid, 0));
                            } else {
                                failedSeq.add(DcmQRSCP.refSOP(iuid, cuid, 281));
                            }
                            instRec = ddr.findNextInstanceRecord(instRec, true, sopIUIDs);
                        }
                        seriesRec = ddr.findNextSeriesRecord(seriesRec, new String[0]);
                    }
                    studyRec = ddr.findNextStudyRecord(studyRec, new String[0]);
                }
                patRec = ddr.findNextPatientRecord(patRec, new String[0]);
            }
        }
        catch (IOException e) {
            LOG.info("Failed to M-READ " + this.dicomDir, (Throwable)e);
            throw new DicomServiceException(272, (Throwable)e);
        }
        for (Map.Entry entry : map.entrySet()) {
            failedSeq.add(DcmQRSCP.refSOP((String)entry.getKey(), (String)entry.getValue(), 274));
        }
        if (failedSeq.isEmpty()) {
            eventInfo.remove(528792);
        }
        return eventInfo;
    }

    boolean addDicomDirRecords(Association as, Attributes ds, Attributes fmi, File f) throws IOException {
        Attributes instRec;
        Attributes seriesRec;
        Attributes studyRec;
        Attributes patRec;
        DicomDirWriter ddWriter = this.getDicomDirWriter();
        RecordFactory recFact = this.getRecordFactory();
        String pid = ds.getString(0x100020, null);
        String styuid = ds.getString(0x20000D, null);
        String seruid = ds.getString(0x20000E, null);
        String iuid = fmi.getString(131075, null);
        if (pid == null) {
            pid = styuid;
            ds.setString(0x100020, VR.LO, pid);
        }
        if ((patRec = ddWriter.findPatientRecord(new String[]{pid})) == null) {
            patRec = recFact.createRecord(RecordType.PATIENT, null, ds, null, null);
            ddWriter.addRootDirectoryRecord(patRec);
        }
        if ((studyRec = ddWriter.findStudyRecord(patRec, new String[]{styuid})) == null) {
            studyRec = recFact.createRecord(RecordType.STUDY, null, ds, null, null);
            ddWriter.addLowerDirectoryRecord(patRec, studyRec);
        }
        if ((seriesRec = ddWriter.findSeriesRecord(studyRec, new String[]{seruid})) == null) {
            seriesRec = recFact.createRecord(RecordType.SERIES, null, ds, null, null);
            ddWriter.addLowerDirectoryRecord(studyRec, seriesRec);
        }
        if ((instRec = ddWriter.findLowerInstanceRecord(seriesRec, false, new String[]{iuid})) != null) {
            return false;
        }
        instRec = recFact.createRecord(ds, fmi, ddWriter.toFileIDs(f));
        ddWriter.addLowerDirectoryRecord(seriesRec, instRec);
        ddWriter.commit();
        return true;
    }

    private static Attributes refSOP(String iuid, String cuid, int failureReason) {
        Attributes attrs = new Attributes(3);
        attrs.setString(528720, VR.UI, cuid);
        attrs.setString(528725, VR.UI, iuid);
        if (failureReason != 0) {
            attrs.setInt(528791, VR.US, new int[]{failureReason});
        }
        return attrs;
    }

    private final class CStoreSCPImpl
    extends BasicCStoreSCP {
        CStoreSCPImpl() {
            super(new String[]{"*"});
        }

        protected void store(Association as, PresentationContext pc, Attributes rq, PDVInputStream data, Attributes rsp) throws IOException {
            String cuid = rq.getString(2);
            String iuid = rq.getString(4096);
            String tsuid = pc.getTransferSyntax();
            File file = new File(DcmQRSCP.this.storageDir, iuid);
            try {
                Attributes fmi = as.createFileMetaInformation(iuid, cuid, tsuid);
                DcmQRSCP.this.storeTo(as, fmi, data, file);
                Attributes attrs = DcmQRSCP.parse(file);
                File dest = DcmQRSCP.this.getDestinationFile(attrs);
                DcmQRSCP.renameTo(as, file, dest);
                file = dest;
                if (DcmQRSCP.this.addDicomDirRecords(as, attrs, fmi, file)) {
                    LOG.info("{}: M-UPDATE {}", (Object)as, (Object)DcmQRSCP.this.dicomDir);
                } else {
                    LOG.info("{}: ignore received object", (Object)as);
                    DcmQRSCP.deleteFile(as, file);
                }
            }
            catch (Exception e) {
                DcmQRSCP.deleteFile(as, file);
                throw new DicomServiceException(272, (Throwable)e);
            }
        }
    }

    private final class StgCmtSCPImpl
    extends AbstractDicomService {
        public StgCmtSCPImpl() {
            super(new String[]{"1.2.840.10008.1.20.1"});
        }

        public void onDimseRQ(Association as, PresentationContext pc, Dimse dimse, Attributes rq, Attributes actionInfo) throws IOException {
            if (dimse != Dimse.N_ACTION_RQ) {
                throw new DicomServiceException(529);
            }
            int actionTypeID = rq.getInt(4104, 0);
            if (actionTypeID != 1) {
                throw new DicomServiceException(291).setActionTypeID(actionTypeID);
            }
            Attributes rsp = Commands.mkNActionRSP((Attributes)rq, (int)0);
            String callingAET = as.getCallingAET();
            String calledAET = as.getCalledAET();
            Connection remoteConnection = DcmQRSCP.this.getRemoteConnection(callingAET);
            if (remoteConnection == null) {
                throw new DicomServiceException(272, "Unknown Calling AET: " + callingAET);
            }
            Attributes eventInfo = DcmQRSCP.this.calculateStorageCommitmentResult(calledAET, actionInfo);
            try {
                as.writeDimseRSP(pc, rsp, null);
                DcmQRSCP.this.device.execute((Runnable)new SendStgCmtResult(as, eventInfo, DcmQRSCP.this.stgCmtOnSameAssoc, remoteConnection));
            }
            catch (AssociationStateException e) {
                LOG.warn("{} << N-ACTION-RSP failed: {}", (Object)as, (Object)e.getMessage());
            }
        }
    }

    private final class CFindSCPImpl
    extends BasicCFindSCP {
        private final EnumSet<QueryRetrieveLevel2> qrLevels;

        public CFindSCPImpl(String sopClass, EnumSet<QueryRetrieveLevel2> qrLevels) {
            super(new String[]{sopClass});
            this.qrLevels = qrLevels;
        }

        protected QueryTask calculateMatches(Association as, PresentationContext pc, Attributes rq, Attributes keys) throws DicomServiceException {
            QueryRetrieveLevel2 level = QueryRetrieveLevel2.validateQueryIdentifier((Attributes)keys, this.qrLevels, (boolean)this.relational(as, rq), (boolean)DcmQRSCP.this.relationalLenient);
            if (DcmQRSCP.this.errorCFind != 0) {
                throw new DicomServiceException(DcmQRSCP.this.errorCFind);
            }
            switch (level) {
                case PATIENT: {
                    return new PatientQueryTask(as, pc, rq, keys, DcmQRSCP.this);
                }
                case STUDY: {
                    return new StudyQueryTask(as, pc, rq, keys, DcmQRSCP.this);
                }
                case SERIES: {
                    return new SeriesQueryTask(as, pc, rq, keys, DcmQRSCP.this);
                }
                case IMAGE: {
                    return new InstanceQueryTask(as, pc, rq, keys, DcmQRSCP.this);
                }
            }
            throw new AssertionError();
        }

        private boolean relational(Association as, Attributes rq) {
            String cuid = rq.getString(2);
            ExtendedNegotiation extNeg = as.getAAssociateAC().getExtNegotiationFor(cuid);
            return QueryOption.toOptions((ExtendedNegotiation)extNeg).contains(QueryOption.RELATIONAL);
        }
    }

    private final class CGetSCPImpl
    extends BasicCGetSCP {
        private final EnumSet<QueryRetrieveLevel2> qrLevels;
        private final boolean withoutBulkData;

        public CGetSCPImpl(String sopClass, EnumSet<QueryRetrieveLevel2> qrLevels) {
            super(new String[]{sopClass});
            this.qrLevels = qrLevels;
            this.withoutBulkData = qrLevels.size() == 1;
        }

        protected RetrieveTask calculateMatches(Association as, PresentationContext pc, Attributes rq, Attributes keys) throws DicomServiceException {
            QueryRetrieveLevel2.validateRetrieveIdentifier((Attributes)keys, this.qrLevels, (boolean)this.relational(as, rq), (boolean)DcmQRSCP.this.relationalLenient);
            if (DcmQRSCP.this.errorCGet != 0) {
                throw new DicomServiceException(DcmQRSCP.this.errorCGet);
            }
            List<InstanceLocator> matches = DcmQRSCP.this.calculateMatches(keys);
            if (matches.isEmpty()) {
                return null;
            }
            RetrieveTaskImpl retrieveTask = new RetrieveTaskImpl(Dimse.C_GET_RQ, as, pc, rq, matches, as, this.withoutBulkData, DcmQRSCP.this.delayCStore);
            retrieveTask.setSendPendingRSP(DcmQRSCP.this.isSendPendingCGet());
            return retrieveTask;
        }

        private boolean relational(Association as, Attributes rq) {
            String cuid = rq.getString(2);
            ExtendedNegotiation extNeg = as.getAAssociateAC().getExtNegotiationFor(cuid);
            return QueryOption.toOptions((ExtendedNegotiation)extNeg).contains(QueryOption.RELATIONAL);
        }
    }

    private final class CMoveSCPImpl
    extends BasicCMoveSCP {
        private final EnumSet<QueryRetrieveLevel2> qrLevels;

        public CMoveSCPImpl(String sopClass, EnumSet<QueryRetrieveLevel2> qrLevels) {
            super(new String[]{sopClass});
            this.qrLevels = qrLevels;
        }

        protected RetrieveTask calculateMatches(Association as, PresentationContext pc, Attributes rq, Attributes keys) throws DicomServiceException {
            QueryRetrieveLevel2.validateRetrieveIdentifier((Attributes)keys, this.qrLevels, (boolean)this.relational(as, rq), (boolean)DcmQRSCP.this.relationalLenient);
            if (DcmQRSCP.this.errorCMove != 0) {
                throw new DicomServiceException(DcmQRSCP.this.errorCMove);
            }
            String moveDest = rq.getString(1536);
            Connection remote = DcmQRSCP.this.getRemoteConnection(moveDest);
            if (remote == null) {
                throw new DicomServiceException(43009, "Move Destination: " + moveDest + " unknown");
            }
            List<InstanceLocator> matches = DcmQRSCP.this.calculateMatches(keys);
            if (matches.isEmpty()) {
                return null;
            }
            AAssociateRQ aarq = this.makeAAssociateRQ(as.getLocalAET(), moveDest, matches);
            Association storeas = this.openStoreAssociation(as, remote, aarq);
            RetrieveTaskImpl retrieveTask = new RetrieveTaskImpl(Dimse.C_MOVE_RQ, as, pc, rq, matches, storeas, false, DcmQRSCP.this.delayCStore);
            retrieveTask.setSendPendingRSPInterval(DcmQRSCP.this.getSendPendingCMoveInterval());
            return retrieveTask;
        }

        private Association openStoreAssociation(Association as, Connection remote, AAssociateRQ aarq) throws DicomServiceException {
            try {
                return as.getApplicationEntity().connect(as.getConnection(), remote, aarq);
            }
            catch (Exception e) {
                throw new DicomServiceException(42754, (Throwable)e);
            }
        }

        private AAssociateRQ makeAAssociateRQ(String callingAET, String calledAET, List<InstanceLocator> matches) {
            AAssociateRQ aarq = new AAssociateRQ();
            aarq.setCalledAET(calledAET);
            aarq.setCallingAET(callingAET);
            for (InstanceLocator match : matches) {
                if (!aarq.addPresentationContextFor(match.cuid, match.tsuid)) continue;
                if (!"1.2.840.10008.1.2.1".equals(match.tsuid)) {
                    aarq.addPresentationContextFor(match.cuid, "1.2.840.10008.1.2.1");
                }
                if ("1.2.840.10008.1.2".equals(match.tsuid)) continue;
                aarq.addPresentationContextFor(match.cuid, "1.2.840.10008.1.2");
            }
            return aarq;
        }

        private boolean relational(Association as, Attributes rq) {
            String cuid = rq.getString(2);
            ExtendedNegotiation extNeg = as.getAAssociateAC().getExtNegotiationFor(cuid);
            return QueryOption.toOptions((ExtendedNegotiation)extNeg).contains(QueryOption.RELATIONAL);
        }
    }
}

