/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.dcmqrscp;

import java.io.IOException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.tool.dcmqrscp.DcmQRSCP;
import org.dcm4che3.tool.dcmqrscp.SeriesQueryTask;
import org.dcm4che3.util.StringUtils;

class InstanceQueryTask
extends SeriesQueryTask {
    protected final String[] sopIUIDs;
    protected Attributes instRec;

    public InstanceQueryTask(Association as, PresentationContext pc, Attributes rq, Attributes keys, DcmQRSCP qrscp) throws DicomServiceException {
        super(as, pc, rq, keys, qrscp);
        this.sopIUIDs = StringUtils.maskNull((String[])keys.getStrings(524312));
        this.wrappedFindNextInstance();
    }

    @Override
    public boolean hasMoreMatches() throws DicomServiceException {
        return this.instRec != null;
    }

    @Override
    public Attributes nextMatch() throws DicomServiceException {
        Attributes ret = new Attributes(this.patRec.size() + this.studyRec.size() + this.seriesRec.size() + this.instRec.size());
        Attributes.unifyCharacterSets((Attributes[])new Attributes[]{this.patRec, this.studyRec, this.seriesRec, this.instRec});
        ret.addAll(this.patRec);
        ret.addAll(this.studyRec, true);
        ret.addAll(this.seriesRec, true);
        ret.addAll(this.instRec, true);
        this.wrappedFindNextInstance();
        return ret;
    }

    private void wrappedFindNextInstance() throws DicomServiceException {
        try {
            this.findNextInstance();
        }
        catch (IOException e) {
            throw new DicomServiceException(49152, (Throwable)e);
        }
    }

    protected boolean findNextInstance() throws IOException {
        if (this.seriesRec == null) {
            return false;
        }
        this.instRec = this.instRec == null ? this.ddr.findLowerInstanceRecord(this.seriesRec, this.keys, this.recFact, this.ignoreCaseOfPN, this.matchNoValue) : (this.sopIUIDs.length == 1 ? null : this.ddr.findNextInstanceRecord(this.instRec, this.keys, this.recFact, this.ignoreCaseOfPN, this.matchNoValue));
        while (this.instRec == null && super.findNextSeries()) {
            this.instRec = this.ddr.findLowerInstanceRecord(this.seriesRec, this.keys, this.recFact, this.ignoreCaseOfPN, this.matchNoValue);
        }
        return this.instRec != null;
    }
}

