/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.dcmqrscp;

import java.io.IOException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;
import org.dcm4che3.media.DicomDirReader;
import org.dcm4che3.media.RecordFactory;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.service.BasicQueryTask;
import org.dcm4che3.net.service.DicomServiceException;
import org.dcm4che3.tool.dcmqrscp.DcmQRSCP;
import org.dcm4che3.util.StringUtils;

class PatientQueryTask
extends BasicQueryTask {
    protected final String[] patIDs;
    protected final DicomDirReader ddr;
    protected final RecordFactory recFact;
    protected final String availability;
    protected final boolean ignoreCaseOfPN;
    protected final boolean matchNoValue;
    protected final int delayCFind;
    protected Attributes patRec;

    public PatientQueryTask(Association as, PresentationContext pc, Attributes rq, Attributes keys, DcmQRSCP qrscp) throws DicomServiceException {
        super(as, pc, rq, keys);
        this.patIDs = StringUtils.maskNull((String[])keys.getStrings(0x100020));
        this.ddr = qrscp.getDicomDirReader();
        this.recFact = qrscp.getRecordFactory();
        this.availability = qrscp.getInstanceAvailability();
        this.ignoreCaseOfPN = qrscp.isIgnoreCaseOfPN();
        this.matchNoValue = qrscp.isMatchNoValue();
        this.delayCFind = qrscp.getDelayCFind();
        this.wrappedFindNextPatient();
    }

    public boolean hasMoreMatches() throws DicomServiceException {
        return this.patRec != null;
    }

    public Attributes nextMatch() throws DicomServiceException {
        Attributes tmp = this.patRec;
        this.wrappedFindNextPatient();
        return tmp;
    }

    protected Attributes adjust(Attributes match) throws DicomServiceException {
        Attributes adjust = super.adjust(match);
        adjust.remove(267312);
        if (this.keys.contains(524310)) {
            adjust.setString(524310, VR.UI, match.getString(267536));
        }
        if (this.keys.contains(524312)) {
            adjust.setString(524312, VR.UI, match.getString(267537));
        }
        adjust.setString(524370, VR.CS, this.keys.getString(524370));
        adjust.setString(524372, VR.AE, this.as.getCalledAET());
        if (this.availability != null) {
            adjust.setString(524374, VR.CS, this.availability);
        }
        adjust.setString(8913200, VR.SH, this.ddr.getFileSetID());
        adjust.setString(8913216, VR.UI, this.ddr.getFileSetUID());
        match.setString(524310, VR.UI, match.getString(267536));
        match.setString(524312, VR.UI, match.getString(267537));
        if (this.delayCFind > 0) {
            try {
                Thread.sleep(this.delayCFind);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return adjust;
    }

    private void wrappedFindNextPatient() throws DicomServiceException {
        try {
            this.findNextPatient();
        }
        catch (IOException e) {
            throw new DicomServiceException(49152, (Throwable)e);
        }
    }

    protected boolean findNextPatient() throws IOException {
        this.patRec = this.patRec == null ? this.ddr.findPatientRecord(this.keys, this.recFact, this.ignoreCaseOfPN, this.matchNoValue) : (this.patIDs.length == 1 ? null : this.ddr.findNextPatientRecord(this.patRec, this.keys, this.recFact, this.ignoreCaseOfPN, this.matchNoValue));
        return this.patRec != null;
    }
}

