/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che3.tool.dcmqrscp;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.net.Association;
import org.dcm4che3.net.DataWriter;
import org.dcm4che3.net.DataWriterAdapter;
import org.dcm4che3.net.Dimse;
import org.dcm4che3.net.pdu.PresentationContext;
import org.dcm4che3.net.service.BasicRetrieveTask;
import org.dcm4che3.net.service.InstanceLocator;
import org.dcm4che3.util.SafeClose;

class RetrieveTaskImpl
extends BasicRetrieveTask {
    private final boolean withoutBulkData;
    private final int delayCStore;

    public RetrieveTaskImpl(Dimse rq, Association rqas, PresentationContext pc, Attributes rqCmd, List<InstanceLocator> matches, Association storeas, boolean withoutBulkData, int delayCStore) {
        super(rq, rqas, pc, rqCmd, matches, storeas);
        this.withoutBulkData = withoutBulkData;
        this.delayCStore = delayCStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataWriter createDataWriter(InstanceLocator inst, String tsuid) throws IOException {
        Attributes attrs;
        DicomInputStream in = new DicomInputStream(inst.getFile());
        try {
            if (this.withoutBulkData) {
                in.setIncludeBulkData(DicomInputStream.IncludeBulkData.NO);
                attrs = in.readDatasetUntilPixelData();
            } else {
                in.setIncludeBulkData(DicomInputStream.IncludeBulkData.URI);
                attrs = in.readDataset();
            }
        }
        finally {
            SafeClose.close((Closeable)in);
        }
        if (this.delayCStore > 0) {
            try {
                Thread.sleep(this.delayCStore);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return new DataWriterAdapter(attrs);
    }
}

